package com.tsi.sig.server.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * 긴급차량 서비스 교차로 신호 정보
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EvpsSignalDto implements KafkaEvpsData {

    /**
     * 긴급차량 서비스 ID
     */
    private String serviceId;

    /**
     * 수집시각
     */
    private String clctDt;

    @Builder.Default
    private List<SignalInfo> signalList = new ArrayList<>();

}