package com.tsi.sig.server.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;


@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class NodeInfo {

    /**
     * 교차로 순서(1,...,N)
     */
    private Integer seqNo;

    /**
     * 교차로 ID
     */
    private Long nodeId;

    /**
     * 교차로명
     */
    private String nodeNm;

    /**
     * 위치 위도
     */
    private double lat;

    /**
     * 위치 경로
     */
    private double lng;

    @Builder.Default
    private List<PhaseInfo> phaseList = new ArrayList<>();
}
