package com.tsi.sig.server.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PhaseInfo {

    /**
     * 링번호(1:A링, 2:B링)
     */
    private Integer ring;

    /**
     * 맵 번호(0:일반제, 1~5:시차제, 6:전용맵)
     */
    private Integer planClass;

    /**
     * 현시번호(1~8)
     */
    private Integer phaseNo;

    /**
     * 이동류번호(1-16, 17, 18)
     */
    private Integer flowNo;

    /**
     * 시작점 위치 위도
     */
    private Double headLat;

    /**
     * 시작점 위치 경로
     */
    private Double headLng;

    /**
     * 중심점 위치 위도
     */
    private Double midLat;

    /**
     * 중심점 위치 경로
     */
    private Double midLng;

    /**
     * 끝점 위치 위도
     */
    private Double endLat;

    /**
     * 끝점 위치 경로
     */
    private Double endLng;

    /**
     * 시작점 각도
     */
    private Integer headAngle;

    /**
     * 종점 각도
     */
    private Integer endAngle;
}
