package com.tsi.sig.server.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SignalInfo {

    /**
     * 교차로 순서(1,...,N)
     */
    private Integer seqNo;

    /**
     * 교차로 ID
     */
    private Long nodeId;

    /**
     * 목적지 남은거리(m)
     */
    private Integer remDist;

    /**
     * 교차로운영상태(0:통신이상, 1:정상, 2:점멸, 3:소등, 4:수동진행, 5:현시유지)
     */
    private Integer state;

    /**
     * 현재 운영중인 맵 번호(0:일반제, 1~5:시차제, 6:전용맵)
     */
    private Integer planClass;

    /**
     * A링 현시번호(1-8)
     */
    private Integer aRingPhase;

    /**
     * B링 현시번호(1-8)
     */
    private Integer bRingPhase;

    /**
     * 유지현시번호(1-8)
     */
    private Integer holdPhase;
}

