package com.tsi.sig.server.service;

import com.tsi.sig.server.mapper.LoginMapper;
import com.tsi.sig.server.objects.UserVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class LoginServiceImpl implements UserDetailsService {
    private final LoginMapper loginMapper;

    public void loginFail(String username) throws UsernameNotFoundException {
        this.loginMapper.loginFail(username);
        int failCnt = this.loginMapper.findUserId(username).getFailCnt();
        if (failCnt > 4) {
            this.loginMapper.fullFail(username);
        }

    }

    public void initFailCnt(String username) throws UsernameNotFoundException {
        this.loginMapper.initFailCnt(username);
    }

    public UserVO loadUserByUsername(String username) throws UsernameNotFoundException {
        UserVO vo = this.loginMapper.findUserId(username);
        return vo;
    }

    public LoginServiceImpl(final LoginMapper loginMapper) {
        this.loginMapper = loginMapper;
    }
}
