﻿//var oneWs = new SockJS("https://"+window.location.hostname+":7443/oneTopic.do");
// var oneWs = new SockJS("http://"+window.location.host+"/oneTopic.do");
//var oneWs = new SockJS("http://"+window.location.hostname+":8443/oneTopic.do");

var _CvibNodeArr = [];
var _CvibNode;
const urlParams = new URL(location.href).searchParams;
// setInterval(()=>getCvibList(urlParams.get("nodeId")), 1000);
let param = urlParams.get("nodeId");
let _DetailInterval = null;

$(()=>{
    getCvibList(param);
})


function getCvibList(paramId) {
    let start = new Date().getTime();
    clearTimeout(_DetailInterval);
    $.ajax({
        method: 'POST',
        // url : 'http://tsihub.koroad.or.kr:7443/getCvibDetail.do',
        url : '/getCvibDetail.do',
        headers:
            {'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')}
        ,
        data : {
            nodeId : paramId
        },
        success: (res) => {
            let end = new Date().getTime();
            let differ = end - start;
            if ((differ) >= 1000) {
                differ = 1000;
            }
            recvDetailData(res);
            _DetailInterval = setTimeout(() => getCvibList(paramId), 1000 - differ);
        },
        error: (err) => {
            console.log(err);
        }
    })
}

//
// oneWs.onopen = function (message) {
//     wsOpen(message);
// }
// oneWs.onmessage = function (message) {
//     wsOnMessage(message);
// }
// oneWs.close = function (message) {
//     wsClose(message);
// }
// oneWs.onerror = function (message) {
//     wsError(message);
//     console.log("oneTopic.error: " + message)
// }

/*
  웹소켓 접속시 nodeid 를 보낸다.
 */
// function doClose() {
//     console.log("oneTopic.close")
//     oneWs.close();
// }
//
// function wsOpen(message) {
//     console.log("oneTopic.send: " +  nodeId)
//     _Level = 1;
//     oneWs.send(nodeId);
// };
function recvDetailData(recv) {
    if (!recv) return;
    recv.turns.sort(dirCodeSort);

    let {
        nodeId, localDate, errCenter, errCont, errScu, oprBlink, oprInd,
        oprManual, oprTrans, oprTurnoff, dataCount, counter, commStatus
    } = recv;
    if (!commStatus) {
        errCenter  = 2;
        errCont    = 2;
        errScu     = 2;
        oprBlink   = 2;
        oprTrans   = 2;
        oprInd     = 2;
        oprManual  = 2;
        oprTurnoff = 2;
        dataCount  = "-";
        localDate  = "-";
        counter    = "-";
    }
    errCenter  = transStatusCodeToWord(errCenter, 0);
    errCont    = transStatusCodeToWord(errCont, 0);
    errScu     = transStatusCodeToWord(errScu, 0);
    oprBlink   = transStatusCodeToWord(oprBlink, 1);
    oprTrans   = transStatusCodeToWord(oprTrans, 1);
    oprInd     = transStatusCodeToWord(oprInd, 1);
    oprManual  = transStatusCodeToWord(oprManual, 1);
    oprTurnoff = transStatusCodeToWord(oprTurnoff, 1);

    let light = []			// 신호등정보 [직진,좌,보행]
    let dirAdd = [];			//연등지
    let timeFlag = [];			//시간정보신뢰성
    let walker = [];			//보행자
    let unprotected = [];			//비보호 상태
    let stts = [];			//신호등상태
    let dispTm = [];						//표출시간
    let remainTm = [];						//잔여시간
    let dirCode = []; 						//방향코드


    let cvibSttsArr = [];

    for (let i = 0; i <= 80; i = i + 10) {
        cvibSttsArr[i] = '9_9_9_9';
    } // 직진_좌회전_보행_유턴


    for (let turn of recv.turns) {
        //( recv[ii].light == 2 && recv[ii].stts == 3 && recv[ii].unprotected == 1 ) ? stts.push(1) : stts.push(recv[ii].stts);
        stts.push(turn.stts)
        light.push(turn.light);
        dirAdd.push(turn.dirAdd);
        timeFlag.push(turn.timeFlag);
        walker.push(turn.walker);
        unprotected.push(turn.unprotected);
        dispTm.push(turn.dispTm);
        remainTm.push(turn.remainTm);
        dirCode.push(turn.dirCode);
        cvibSttsArr[turn.dirCode] = setCvibSttsFnc(turn.unprotected, turn.light, turn.dirCode, turn.stts, cvibSttsArr[turn.dirCode]);
    }
    // if(_CvibNodeArr.length > 0){
    //     _CvibNode.emptyCvibCircleImg();
    //     _CvibNode.emptyCvibInfoImg();
    // }

    _CvibNode = new CvibInfo(nodeId, nodeName, nodeLat, nodeLng, nodeAddr1,
        nodeAddr2, nodeAddr3, localDate, errCenter, errCont, errScu, oprBlink, oprInd, oprManual, oprTrans, oprTurnoff, dataCount, counter,
        cvibSttsArr[10], cvibSttsArr[20], cvibSttsArr[30], cvibSttsArr[40], cvibSttsArr[50], cvibSttsArr[60], cvibSttsArr[70], cvibSttsArr[80],
        light, dirAdd, timeFlag, walker, unprotected, stts, dispTm, remainTm, dirCode);

//    console.log(_CvibNode);
    // if (_Level == 0 || _Level == 1 && map != null || map != undefined) {
    _CvibNode.emptyCvibCircleImg();
    _CvibNode.emptyCvibInfoImg();
    _CvibNode.setCircle();
    _CvibNode.setCvibInfo();
    // }
    if (cvibDetailInfoTimeId == null) {
        showCvibDetailInfo();
    }
    if (cvibPopTimeId == null && map == null || map == undefined) {
        drawCvibInfo();
    } else {
        clearTimeout(cvibPopTimeId);
    }
}

function setCvibSttsFnc(unprotected, light, dirCode, stts, cvibStts) {
    if (cvibStts === undefined || cvibStts === "" || cvibStts === null) {
        cvibStts = '9_9_9_9';
    }

    if (light === 1) {
        var temp = cvibStts.substring(1);
        cvibStts = stts + temp;

    } else if (light === 2) {
        var tempS = cvibStts.substring(0, 2);
        var tempE = cvibStts.substring(3);
        //stts =(unprotected == 0) ? stts : 1;
        cvibStts = tempS + stts + tempE;
    } else if (light === 3) {

        var tempS = cvibStts.substring(0, 4);
        var tempE = cvibStts.substring(5);
        cvibStts = tempS + stts + tempE;
    } else if (light === 7) {
        var temp = cvibStts.substring(0, 6);
        cvibStts = temp + stts;
    }
    return cvibStts;

}

function dirCodeSort(a, b) {
    return a.dirCode > b.dirCode ? 1 : a.dirCode === b.dirCode ? 0 : -1;
}


function transStatusCodeToWord(value, option) {
    const wordArr = [['정상', '이상', '-'], ['OFF', 'ON', '-']];
    if (value !== undefined && !isNaN(Number(value))) {
        return wordArr[option][value];
    }
    return wordArr[option][2];
}