<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ page session="false" %>
<!doctype html>
<html lang="ko" style="background-color: #2c2c2c;">
<head>

    <link rel="stylesheet" type="text/css" href="/css/common.css">
    <link rel="stylesheet" type="text/css" href="/css/main_new.css">
    <link rel="stylesheet" href="/css/themes/default/style.css">

    <%@ include file="/WEB-INF/jsp/common.jsp" %>
    <title>상세 정보</title>
</head>
<body class="sang">
<div class="bottomMenu" id="bottomMenu">
    <div class="bottomBody" id="cvibBottomBody">
        <table id="cvibBottomBodyTable">
            <thead>
                <tr>
                    <th style="width:10%;">센터명</th>
                    <th style="width:7%;">제어기번호</th>
                    <th style="width:15%;">교차로명</th>
                    <th style="width:5%;">전이</th>
                    <th style="width:5%;">감응</th>
                    <th style="width:5%;">소등</th>
                    <th style="width:5%;">점멸</th>
                    <th style="width:5%;">수동</th>
                    <th style="width:7%;">SCU통신이상</th>
                    <th style="width:7%;">센터통신이상</th>
                    <th style="width:7%;">모순이상</th>
                    <th style="width:7%;">주기카운터</th>
                    <th style="width:15%;">교차로시각</th>
                </tr>
            </thead>
            <tbody id="cvibBottomInfo"></tbody>
        </table>
        <table id="evpBottomBodyTable" style="display: none;">
            <thead>
                <tr>
                    <th style="width:10%">수집시각</th>
                    <th style="width:10%">지역센터명</th>
                    <th style="width:15%">서비스 ID</th>
                    <th style="width:15%">서비스명</th>
                    <th style="width:10%">긴급차량번호</th>
                    <th style="width:10%">X 좌표</th>
                    <th style="width:10%">Y 좌표</th>
                    <th style="width:10%">속도(km/h)</th>
                    <th style="width:10%">남은거리(m)</th>
                </tr>
            </thead>
            <tbody id="evpBottomInfo"></tbody>
        </table>
    </div>
</div>
<script src="/js/common/hashmap.js"></script>
<script src="/js/common/common-all.js"></script>
<script src="/js/common/common.js"></script>

<script>

    function goPanToInt(intNm, lng, lat) {
        if (parent._Level > 3) parent.map.setLevel(1);
        parent.map.panTo(new parent.kakao.maps.LatLng(lat, lng));

        setTimeout(
            function () {
                parent.getSignalInfo();
                parent.customOverlayFnc(intNm, lng, lat);
            }, 100 * 2
        );
    }

    /* function showOnlineList() {
        $('#onlineToggle').attr('src','/images/online_on.png');
        $('#offlineToggle').attr('src','/images/offline_off.png');
        $('#cvibBottomHead').hide();
        $('#cvibBottomBody').hide();
        $('#bottomHead').show();
        $('#bottomBody').show();
    } */

    function showOfflineList() {
        $('#offlineToggle').attr('src', '/images/offline_on.png');
        $('#onlineToggle').attr('src', '/images/online_off.png');
        $('#bottomHead').hide();
        $('#bottomBody').hide();
        $('#cvibBottomHead').show();
        $('#cvibBottomBody').show();
    }

    function moveLocation(serviceId, el) {
        const treeFrame = $('#iframeTreeList', parent.document);
        if (!treeFrame.contents().find('#play').hasClass('on')) {
            return;
        }


        $('tr.on').removeClass('on');
        $(el).addClass('on');
        const map = treeFrame.get(0).contentWindow._historyMap.get(serviceId.toString());
        const idx = $(el).index();
        //$('#cvibBottomBody').scrollTop(32 * idx);
        if (map) {
           const obj  = map.get('obj');
           const draw = map.get('draw');

           const {cur_lat, cur_lng} = obj.event_list[idx];
           let position = window.parent.getKakaoPosition(cur_lat, cur_lng);
           draw.car.moveMarker(position);
           treeFrame.get(0).contentWindow.setSigState(obj.phase_list[idx], draw);
        }

    }
</script>
</body>
</html>
