<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ page session="false" %>
<!doctype html>
<html lang="ko">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="Description" content="사이트설명">
    <meta name="Keywords" content="키워드">

    <%@ include file="/WEB-INF/jsp/common.jsp" %>

    <link rel="stylesheet" type="text/css" href="/css/common.css">
    <link rel="stylesheet" type="text/css" href="/css/main_new.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css">
    <script src="js/common/jquery-1.9.1.js"></script>

    <title>${nodeId} 신호정보</title>
    <script src="https://cdn.jsdelivr.net/npm/sockjs-client@1/dist/sockjs.min.js"></script>
    <script src="/js/cvib.js"></script>
    <script src="/js/common/cvibDetail_new.js"></script>
<%--    <script src="/js/common/oneTopicDetailSocket.js"></script>--%>
</head>
<body class="sang" style="overflow: auto;">
<div class="popContainer">
    <div class="cvibInfoTop">
        <ul class="tabs">
            <li><a href="javascript:showCvibDetailInfo()" class="tab" id="cTab1"></a></li>
            <li><a href="javascript:showCvibEventHistory()" class="tab" id="cTab2"></a></li>
            <li class="regionIntNm"><strong id="regionIntNm"></strong></li>
        </ul>
    </div>
    <div class="cvibMapAndInfo">
        <!--  픽셀  북 : 450 80  -->
        <div class="crossLoadMap">
            <c:choose>
                <c:when test="${node.nodetype eq 4}">
                    <div style="float:left;background-image: url(images/cvib/CrossLoadBG.png); width:100%; height: 100%; background-repeat: no-repeat;background-position: center;background-size: 500px;"></div>
                    <div id='cvibMap'></div>
                </c:when>
                <c:otherwise>
                    <div id="map" class="detailMap"></div>
                </c:otherwise>
            </c:choose>

        </div>

        <div class="crossLoadInfo">

            <div class="bottomInfo">
                <div class="bottomInfoBottom">
                    <div class="bottomInfoBody">
                        <table>
                            <colgroup>
                                <col width="7%">
                                <col width="8%">
                                <col width="9%">
                                <col width="9%">
                                <col width="10%">
                                <col width="6%">
                                <col width="10%">
                                <col width="10%">
                            </colgroup>
                            <thead>
                            <tr>
                                <td colspan="2">방향정보</td>
                                <td colspan="4">출력정보</td>
                                <td colspan="2">기타</td>
                            </tr>
                            <tr>
                                <td>보행자</td>
                                <td>방향코드</td>
                                <td>시간신뢰성</td>
                                <td>출력형태</td>
                                <td>신호등상태</td>
                                <td>비보호</td>
                                <td>잔여시간</td>
                                <td>표출시간</td>
                            </tr>
                            </thead>
                            <tbody id="bottomInfoBottom"></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="bottomInfo">
        <div class="bottomInfoTop">
            <table>
                <colgroup>
                    <col width="9%">
                    <col width="9%">
                    <col width="6%">
                    <col width="6%">
                    <col width="6%">
                    <col width="6%">
                    <col width="6%">
                    <col width="6%">
                    <col width="6%">
                    <col width="6%">
                    <col width="8%">
                    <col width="8%">
                    <col width="18%">
                </colgroup>
                <thead>
                    <tr>
                        <th colspan="2">교차로정보</th>
                        <th colspan="5">운영정보</th>
                        <th colspan="3">고장정보</th>
                        <th colspan="3">기타</th>
                    </tr>
                    <tr>
                        <th>지역센터</th>
                        <th>번호</th>
                        <th>전이</th>
                        <th>감응</th>
                        <th>소등</th>
                        <th>점멸</th>
                        <th>수동</th>
                        <th>SCU</th>
                        <th>센터</th>
                        <th>모순</th>
                        <th>신호주기</th>
                        <th>정보개수</th>
                        <th>교차로시각</th>
                    </tr>
                </thead>
                <tbody id="bottomInfoTop">
                <tr>
                    <td id="regionCd"></td>
                    <td id="intNo"></td>
                    <td id="oprTrans"></td>
                    <td id="oprInd"></td>
                    <td id="oprTurnoff"></td>
                    <td id="oprBlink"></td>
                    <td id="oprManual"></td>
                    <td id="errScu"></td>
                    <td id="errCenter"></td>
                    <td id="errCont"></td>
                    <td id="cycleCounter"></td>
                    <td id="dataCount"></td>
                    <td id="intTime"></td>
                </tr>
                </tbody>
            </table>
        </div>

    </div>
</div>

<script src="/js/common/common-all.js"></script>
<%--<script src="/js/signal.js"></script>--%>
<script src="/js/signal_new.js"></script>
<script src="/js/cvib.js"></script>

<script>
    var screenWidth = window.innerWidth;
    var nodeName = "${node.name}";
    var nodeLat = ${node.lat};
    var nodeLng = ${node.lng};
    var nodeAddr1 = "${node.addr1}";
    var nodeAddr2 = "${node.addr2}";
    var nodeAddr3 = "${node.addr3}";
    var nodeId = ${nodeId};
    var cvibPopTimeId = null;
    var cvibDetailInfoTimeId = null;
    var lunprotectedArr = [];
    var uunprotectedArr = [];

    function drawCvibInfo() {
        if (cvibPopTimeId != null) clearTimeout(cvibPopTimeId);
        var cvibMap = '';
        var cwlightpos, sigFixedLeft, sigFixedTop, walkerFixedL, walkerFixedT,walkerPos;
        walkerPos = [180,270,0,90];
        if (screenWidth > 1000) {
            cwlightpos = [180, 270, 0, 90, 45, 315, 225, 135];
            sigFixedLeft = [13, 1, 19.5, 31, 0, 0, 0, 0];
            sigFixedTop = [88, 36, 4, 56, 0, 0, 0, 0];

            walkerFixedL = [8, 9, 28, 27.2, 0, 0, 0, 0];
            walkerFixedT = [68, 13, 14, 70, 0, 0, 0, 0];
        } else {
            cwlightpos = [180, 270, 0, 90, 45, 315, 225, 135];
            sigFixedLeft = [40, 25, 50, 65, 0, 0, 0, 0];
            sigFixedTop = [90, 35, 3, 58, 0, 0, 0, 0];
            walkerFixedL = [350, 360, 600, 600, 0, 0, 0, 0];
            walkerFixedT = [340, 100, 100, 340, 0, 0, 0, 0];
        }
        var dataCount = _CvibNode.dataCount;
        var leftUnprotect = false;

        /*

        */
        for (var ii = 0; ii < _CvibNode.dataCount; ii++) {
            if (_CvibNode.dirCode[ii] > 40) break;
            if (_CvibNode.light[ii] == 2 && _CvibNode.unprotected[ii] == 1) {
                var dirCodeIndex = (_CvibNode.dirCode[ii] / 10) - 1;
                lunprotectedArr[dirCodeIndex] = _CvibNode.unprotected[ii];
            }
            if (_CvibNode.stts[ii] == 7 && _CvibNode.unprotected[ii] == 1) {
                var dirCodeIndex = (_CvibNode.dirCode[ii] / 10) - 1;
                uunprotectedArr[dirCodeIndex] = _CvibNode.unprotected[ii];
            }
        }

        /*
                  방향코드 50이상 북 동 남 서 로 방향 맞춰주기
                  50[4] 반대 70[6] [넣을곳 방향코드 40[3] 있으면 30[2]] --
                  60[5] 반대 80[7] [넣을곳 방향코드 10[0] 있으면 40[3]]
                  70[6] 반대 50[4] [넣을곳 방향코드 20[1] 있으면 10[0]]
                  80[7] 반대 60[5] [넣을곳 방향코드 30[2] 있으면 20[1]]
       */
        for (var ii = 4; ii < _CvibNode.lightPosArr.length; ii++) {
            if (_CvibNode.lightStsArr[ii] == "9_9_9_9") continue;
            var dirCodeIndex = ii + 1 //  0 -> 1
            var opDirCode = (ii + 1) * 10;  //인덱스를 방향코드로 10 20 30 같이

            for (var i = 0; i < dataCount; i++) {
                if (_CvibNode.dirCode[i] > 40) {
                    var index = (_CvibNode.dirCode[i] / 10) - 1;
                    if (_CvibNode.light[i] == 2 || _CvibNode.unprotected[i] == 1) {
                        lunprotectedArr[index] = _CvibNode.unprotected[i];
                    }
                    if (_CvibNode.light == 7 || _CvibNode.unprotected[i] == 1) {
                        uunprotectedArr[index] = _CvibNode.unprotected[i];
                    }
                }
            }
            if (ii < 6) {
                if (_CvibNode.lightStsArr[3] == "9_9_9_9") {
                    _CvibNode.lightStsArr[3] = _CvibNode.lightStsArr[ii];

                    lunprotectedArr[3] = lunprotectedArr[ii];
                    uunprotectedArr[3] = uunprotectedArr[ii];
                } else {
                    if (ii < 5) {

                        _CvibNode.lightStsArr[2] = _CvibNode.lightStsArr[ii];
                        lunprotectedArr[2] = lunprotectedArr[ii];
                        uunprotectedArr[2] = uunprotectedArr[ii];
                    } else {
                        _CvibNode.lightStsArr[0] = _CvibNode.lightStsArr[ii];
                        lunprotectedArr[0] = lunprotectedArr[ii];
                        uunprotectedArr[0] = uunprotectedArr[ii];
                    }
                }
            } else {
                if (_CvibNode.lightStsArr[1] == "9_9_9_9") {
                    _CvibNode.lightStsArr[1] = _CvibNode.lightStsArr[ii];
                    lunprotectedArr[1] = lunprotectedArr[ii];
                    uunprotectedArr[1] = uunprotectedArr[ii];
                } else {
                    if (ii < 7) {
                        _CvibNode.lightStsArr[0] = _CvibNode.lightStsArr[ii];
                        lunprotectedArr[0] = lunprotectedArr[ii];
                        uunprotectedArr[0] = uunprotectedArr[ii];
                    } else {
                        _CvibNode.lightStsArr[2] = _CvibNode.lightStsArr[ii];
                        lunprotectedArr[2] = lunprotectedArr[ii];
                        uunprotectedArr[2] = uunprotectedArr[ii];
                    }
                }
            }
            lunprotectedArr[ii] = null;
            uunprotectedArr[ii] = null;
            _CvibNode.lightStsArr[ii] = "9_9_9_9";

        }


        for (var ii = 0; ii < _CvibNode.lightPosArr.length; ii++) {

            if (lunprotectedArr[ii] == null || lunprotectedArr[ii] == undefined || lunprotectedArr[ii] == 0) continue;
            var dirCodeTemp = (ii + 1) * 10;
            var dirLocation = getdirLocation(dirCodeTemp);
            cvibMap += unprotectedLeft(dirCodeTemp, dirLocation);
            leftUnprotect = true;
        }


        //     var dirLocation = getdirLocation(_CvibNode.dirCode[i]);
        //     if (_CvibNode.light[i] == 7 && _CvibNode.stts[i] == 3) {
        //         cvibMap += utunDraw(_CvibNode.dirCode[i], _CvibNode.unprotected[i], dirLocation);
        //         leftUnprotect = false;
        //     }
        //     if (_CvibNode.light[i] == 2 && _CvibNode.stts[i] == 3 && _CvibNode.unprotected[i] == 1) {
        //         cvibMap += unprotectedLeft(_CvibNode.dirCode[i], dirLocation);
        //         leftUnprotect = true;
        //     }
        // }


        for (var ii = 0; ii < _CvibNode.lightPosArr.length; ii++) {
            var overlayId = _CvibNode.lightPosArr[ii];
            var walkerOverlay = walkerPos[ii];
            var overlaycwId = cwlightpos[ii];
            var lightImg = _CvibNode.lightStsArr[ii].substring(0, 3);
            //var cwLightCode = _CvibNode.lightStsArr[ii].substring(4);
            //CrossWalkON OFF
            var cwlightImg = '';
            var tempcwlight = _CvibNode.lightStsArr[ii].substring(4, 5);

            if (tempcwlight == '3' || tempcwlight == '6') {
                cwlightImg = 'ON'
            } else if (tempcwlight == '0') {
                cwlightImg = '';
            } else {
                cwlightImg = 'OFF';
            }

            //신호등
            if (lightImg != '9_9') {
                if (leftUnprotect && lightImg == '3_3') {
                    cvibMap += '<img src="images/cvib/CvibLight_3_9.gif" width="100px" heigtht="27px" style="transform:rotate(' + overlaycwId + 'deg); position: absolute; left:' + sigFixedLeft[ii] + '%; top:' + sigFixedTop[ii] + '%"  >'
                } else {
                    cvibMap += '<img src="images/cvib/CvibLight_' + lightImg + '.gif" width="100px" heigtht="27px" style="transform:rotate(' + overlaycwId + 'deg); position: absolute; left:' + sigFixedLeft[ii] + '%; top:' + sigFixedTop[ii] + '%"  >'
                }
            }
            //보행자 신호등
            if (tempcwlight != '9' && tempcwlight != '0') {
                cvibMap += '<img class="cvibwalker" src="images/cvib/CrossWalk' + cwlightImg + '.gif" style="transform:rotate(' + walkerOverlay + 'deg); position: absolute; left:' + walkerFixedL[ii] + '%; top:' + walkerFixedT[ii] + '%;" width="50px" heigtht="27px;">';
            } else if (cwlightImg == '') {
                cvibMap += '<img class="cvibwalker" src="images/cvib/CrossWalk.png" style="transform:rotate(' + walkerOverlay + 'deg); position: absolute; left:' + walkerFixedL[ii] + '%; top:' + walkerFixedT[ii] + '%;" width="50px" heigtht="27px;">';
            }
        }
        $('#cvibMap').empty().html(cvibMap);

    }

    function showCvibDetailInfo() {

        //if (cvibDetailInfoTimeId != null) clearTimeout(cvibDetailInfoTimeId);

        $('#cTab1 img').attr('src', 'images/cvibTab_on.png');
        $('#cTab2 img').attr('src', 'images/tab05_off.png');

        $('.bottomEvent').hide();
        $('.bottomInfoTop').show();
        $('.bottomInfoBottom').show();
        $('.cvibLoading').hide();

        $('#regionCd').text(_CvibNode.addr1);
        $('#intNo').text(_CvibNode.nodeId);
        $('#oprTrans').text(_CvibNode.oprTrans);
        $('#oprInd').text(_CvibNode.oprInd);
        $('#oprTurnoff').text(_CvibNode.oprTurnoff);
        $('#oprBlink').text(_CvibNode.oprBlink);
        $('#oprManual').text(_CvibNode.oprManual);
        $('#errScu').text(_CvibNode.errScu);
        $('#errCenter').text(_CvibNode.errCenter);
        $('#errCont').text(_CvibNode.errCont);
        $('#cycleCounter').text(_CvibNode.counter);
        $('#dataCount').text(_CvibNode.dataCount);
        $('#intTime').text(_CvibNode.date);


        var bottom = '';
        for (var ii = 0; ii < _CvibNode.dataCount; ii++) {
            var lightTxt = '';
            var outputTxt = '';
            var dirCodeTxt = '';

            if (_CvibNode.light[ii] === 1) outputTxt = '직진';
            else if (_CvibNode.light[ii] === 2) outputTxt = '좌회전';
            else if (_CvibNode.light[ii] === 3) outputTxt = '보행';
            else if (_CvibNode.light[ii] === 4) outputTxt = '자전거';
            else if (_CvibNode.light[ii] === 5) outputTxt = '우회전';
            else if (_CvibNode.light[ii] === 6) outputTxt = '버스';
            else if (_CvibNode.light[ii] === 7) outputTxt = '유턴';
            else outputTxt = '';

            outputTxt += '(' + _CvibNode.light[ii] + ')';

            if (_CvibNode.stts[ii] === 1) lightTxt = '적색 점등(' + _CvibNode.stts[ii] + ')';
            else if (_CvibNode.stts[ii] === 2) lightTxt = '황색 점등(' + _CvibNode.stts[ii] + ')';
            else if (_CvibNode.stts[ii] === 3) lightTxt = '녹색 점등(' + _CvibNode.stts[ii] + ')';
            else if (_CvibNode.stts[ii] === 4) lightTxt = '적색점멸 점등(' + _CvibNode.stts[ii] + ')';
            else if (_CvibNode.stts[ii] === 5) lightTxt = '황색점멸 점등(' + _CvibNode.stts[ii] + ')';
            else if (_CvibNode.stts[ii] === 6) lightTxt = '녹색점멸 점등(' + _CvibNode.stts[ii] + ')';
            else lightTxt = '소등(' + _CvibNode.stts[ii] + ')';

            if (_CvibNode.dirCode[ii] === 10) dirCodeTxt = '북';
            else if (_CvibNode.dirCode[ii] === 20) dirCodeTxt = '동';
            else if (_CvibNode.dirCode[ii] === 30) dirCodeTxt = '남';
            else if (_CvibNode.dirCode[ii] === 40) dirCodeTxt = '서';
            else if (_CvibNode.dirCode[ii] === 50) dirCodeTxt = '북동';
            else if (_CvibNode.dirCode[ii] === 60) dirCodeTxt = '남동';
            else if (_CvibNode.dirCode[ii] === 70) dirCodeTxt = '남서';
            else if (_CvibNode.dirCode[ii] === 80) dirCodeTxt = '북서';
            else if (_CvibNode.dirCode[ii] === 99) dirCodeTxt = '보조등';
            else dirCodeTxt = '미지정';


            bottom += '<tr>';
            bottom += '<td>' + _CvibNode.walker[ii] + '</td>';
            bottom += '<td>' + dirCodeTxt + '</td>';
            bottom += '<td>' + _CvibNode.timeFlag[ii] + '</td>';
            bottom += '<td>' + outputTxt + '</td>';
            bottom += '<td class="cvibLightsBack_' + _CvibNode.stts[ii] + '">' + lightTxt + '</td>';
            bottom += '<td>' + _CvibNode.unprotected[ii] + '</td>'
            bottom += '<td>' + _CvibNode.remainTm[ii] + '</td>';
            bottom += '<td>' + _CvibNode.dispTm[ii] + '</td>';
            bottom += '</tr>';
        }

        $('#bottomInfoBottom').empty().html(bottom);

    }

    function getdirLocation(dircode) {
        var dirlocation = 0;

        switch (dircode) {
            case 10:
                dirlocation = 180;
                break;
            case 20:
                dirlocation = 270;
                break;
            case 30:
                dirlocation = 0;
                break;
            case 40:
                dirlocation = 90;
                break;
            case 50:
                dirlocation = 45;
                break;
            case 60:
                dirlocation = 315;
                break;
            case 70:
                dirlocation = 225;
                break;
            case 80:
                dirlocation = 135;
                break;
        }

        return dirlocation;
    }

    function utunDraw(dircode, unprotected, dirLocation) {

        var unprotectX;
        var unprotectY;

        if (window.innerWidth > 1000) {
            switch (dirCode) {
                case 10:
                    unprotectX = 17.5;
                    unprotectY = 77;
                    break;
                case 20:
                    unprotectX = 6.5;
                    unprotectY = 41;
                    break;
                case 30:
                    unprotectX = 20;
                    unprotectY = 12;
                    break;
                case 40:
                    unprotectX = 30;
                    unprotectY = 49;
                    break;
            }
        } else {
            switch (dirCode) {
                case 10:
                    unprotectX = 47;
                    unprotectY = 64;

                    break;
                case 20:
                    unprotectX = 33;
                    unprotectY = 37;
                    break;
                case 30:
                    unprotectX = 50;
                    unprotectY = 15;
                    break;
                case 40:
                    unprotectX = 64;
                    unprotectY = 43;

                    break;
            }
        }
        var imgUrl = '';
        if (unprotected == 1) { //비보호유턴
            imgUrl = 'images/cvib/unproUTUN120.png'
        } else { // 유턴 *
            imgUrl = 'images/cvib/UTUN.png'
        }


        return '<img src="' + imgUrl + '" width="45px" heigtht="45px" style="transform:rotate(' + dirLocation + 'deg); position: fixed; left:' + unprotectX + '%; top:' + unprotectY + '%">';
    }

    function unprotectedLeft(dirCode, dirLocation) {
        var unprotectX;
        var unprotectY;

        if (window.innerWidth > 1000) {
            switch (dirCode) {
                case 10:
                    unprotectX = 17.5;
                    unprotectY = 77;
                    break;
                case 20:
                    unprotectX = 6.5;
                    unprotectY = 41;
                    break;
                case 30:
                    unprotectX = 20;
                    unprotectY = 12;
                    break;
                case 40:
                    unprotectX = 30;
                    unprotectY = 49;
                    break;
            }
        } else {
            switch (dirCode) {
                case 10:
                    unprotectX = 46.5;
                    unprotectY = 79;

                    break;
                case 20:
                    unprotectX = 32;
                    unprotectY = 41;
                    break;
                case 30:
                    unprotectX = 50;
                    unprotectY = 11;
                    break;
                case 40:
                    unprotectX = 64;
                    unprotectY = 49;
                    break;
            }
        }


        return '<img src="images/cvib/unprotected.png" width="40px" heigtht="40px" style="transform:rotate(' + dirLocation + 'deg); position: absolute; left:' + unprotectX + '%; top:' + unprotectY + '%">';
    }


</script>

<script>
    _Level = 1;
    $('#regionIntNm').html('[' + nodeAddr1 + ']' + nodeName);
    var map;
    var mapContainer;
    <c:if test="${node.nodetype ne 4}">
    mapContainer = document.getElementById('map'); // 지도를 표시할 div
    var mapOption = {
        draggable: false,
        center: new kakao.maps.LatLng(nodeLat, nodeLng),
        level: _Level
    };
    map = new kakao.maps.Map(mapContainer, mapOption); // 지도생성
    </c:if>
    console.log('test');
    /**
     Map 매칭 방안에 따른 방향 코드-신호등정보(미지정(0), 북(1), 동(2), 남(3), 서(4), 북동(5), 남동(6), 남서(7), 북서(8))'
     출력형태 : 미지정(0), 직진(1), 좌회전(2), 보행(3), 자전거(4), 우회전(5), 버스(6), 유턴(7)'
     신호등상태: 소등(0), 적색점등(1), 황색점등(2), 녹색점등(3), 적색점멸(4), 황색점멸(5), 녹색점멸(6)'
     **/

</script>

</body>
</html>
