<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ page session="false" %>
<!doctype html>
<html lang="ko">
<head>

    <%@ include file="/WEB-INF/jsp/common.jsp" %>

    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="Description" content="사이트설명">
    <meta name="Keywords" content="키워드">

    <link rel="stylesheet" type="text/css" href="/css/common.css">
    <link rel="stylesheet" type="text/css" href="/css/reset.css">
    <link rel="stylesheet" type="text/css" href="/css/login.css">            <!-- 해당 페이지 전용 -->

    <title>SIGINFO_MAP</title>
</head>
<body>
<div id="login">
    <div class="login_box">
        <h1><img src="images/login/t_intro.gif" alt="돌발정보관리시스템 및 교통안전데이터관리시스템 통합 로그인"></h1>
        <form id="loginForm">
            <fieldset>
                <legend class="hidden">로그인 경로 선택</legend>
                <p class="mb10">
                    <label class="title" for="uesrname"><img src="images/login/t_id.png" alt="아이디"></label>
                    <input type="text" name="userId" id="uesrname" class="tbox09">
                </p>
                <p>
                    <label class="title" for="password"><img src="images/login/t_password.png" alt="비밀번호"></label>
                    <input type="password" name="userPswd" id="password" class="tbox09">
                </p>

<%--                <input name="${_csrf.parameterName}" type="hidden" value="${_csrf.token}">--%>
                <input type="image" src="images/login/btn_login.gif" class="btn_login" alt="들어가기"
                       onclick="loginValidation(); return false;">

            </fieldset>
        </form>
    </div>
    <div class="footer"><img src="images/login/index_footer.gif"
                             alt="이 사이트는 1280pixel의 화면 폭 사이즈에 최적화 되어 있습니다. Copyright(c) 2013 National Police Agency.">
    </div>
</div>

<script src="/js/common/common-all.js"></script><!-- 공통 -->
<script>

    <c:if test="${param.error == 1}">
    alert("아이디와 비밀번호를 다시확인해주세요.");
    </c:if>

    function loginValidation() {
        var formObj = $("#loginForm");
        if ($('#uesrname').val() == "") {
            alert("아이디를 입력해 주세요.");
            $('#uesrname').val("");
            $('#uesrname').focus();
            return;
        } else if ($('#password').val() == "") {
            alert("비밀번호를 입력해주세요.");
            $('#password').val("");
            $('#password').focus();
            return;
        }

        formObj.attr("action", "/login.do");
        formObj.attr("method", "POST");

        formObj.submit();
    }



</script>

</body>
</html>
