<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!doctype html>
<html lang="ko">
<head>

    <%@ include file="/WEB-INF/jsp/common.jsp" %>
    <sec:authorize access="hasAuthority('B')">
        <script>
            alert("기반정보 관리자 계정입니다. 다른 계정으로 로그인하십시요")
            location.href=('/logout.do')
        </script>
    </sec:authorize>
    <sec:authorize access="!isAuthenticated()">
        <script>
            alert("로그인 정보가 없습니다. 로그인해주세요")
            location.href=('/logout.do')
        </script>
    </sec:authorize>
    <meta name="_csrf" content="${_csrf.token}">
    <meta name="_csrf_header" content="${_csrf.headerName}">
    <meta http-equiv="X-UA-Compatible" content="IE=10; IE=9; IE=8; IE=7; IE=EDGE">
    <meta name="Description" content="신호관제">
    <meta name="Keywords" content="신호관제">
    <link rel="icon" href="data:;base64,iVBORw0KGgo=">
    <link rel="stylesheet" type="text/css" href="/css/common.css?v=1">
    <link rel="stylesheet" type="text/css" href="/css/main.css?v=1">
    <link rel="stylesheet" type=iframe"text/css" href="/css/themes/default/style.css">
    <link rel="icon" type="text/css" href="data:;base64,iVBORw0KGgo=">

    <script src="https://cdn.jsdelivr.net/npm/sockjs-client@1/dist/sockjs.min.js"></script>
    <script src="/js/common/moment.js"></script>
    <script src="/js/common/hashmap.js"></script>
    <script src="/js/common/common-all.js"></script>
    <script src="/js/common/common.js"></script>
    <script src="/js/common/jstree.min.js"></script>

    <script src="/js/map.js"></script>
<%--    <script src="/js/signal.js"></script>--%>
    <script src="/js/signal_new.js"></script>

    <script src="/js/cvib.js"></script>

    <title>CVIM_MAP</title>
</head>
<body class="sang">
<input type="hidden" name="min_x" id="min_x" value="">
<input type="hidden" name="min_y" id="min_y" value="">
<input type="hidden" name="max_x" id="max_x" value="">
<input type="hidden" name="max_y" id="max_y" value="">
<input type="hidden" name="regionCd" id="regionCd" value="">
<input type="hidden" name="regionId" id="regionId" value="">
<input type="hidden" name="intNo" id="intNo" value="">
<input type="hidden" name="intNm" id="intNm" value="">
<input type="hidden" name="intLcType" id="intLcType" value="">
<input type="hidden" name="intLampType" id="intLampType" value="">
<input type="hidden" name="groupNo" id="groupNo" value="">
<input type="hidden" name="mainIntNo" id="mainIntNo" value="">
<input type="hidden" name="treeXCoord" id="treeXCoord" value="">
<input type="hidden" name="treeYCoord" id="treeYCoord" value="">
<input type="hidden" name="XCoord" id="XCoord" value="126.978087">
<input type="hidden" name="YCoord" id="YCoord" value="37.560684">
<input type="hidden" name="sigunguCd" id="sigunguCd" value="">
<input type="hidden" name="intMainphase" id="intMainphase" value="">
<input type="hidden" name="networkType" id="networkType" value="">
<input type="hidden" name="modemIp" id="modemIp" value="">

<div class="headMenu">
    <h1><a href="main.do" title="로고"><img src="images/logo3.png" alt="로고" style="width: 310px;margin: 3px;"></a></h1>
    <h2 style="width: calc(100% - 340px); display: flex; justify-content: flex-end; height: 100%; align-items: center;">
        <a href="logout.do" title="로그아웃"><img src="images/logout.png" alt="로그아웃"></a>
    </h2>

    <ul>

    </ul>
</div>
<div id="container" class="container">
    <iframe src="/getTreeListFrame.do" id="iframeTreeList" class="iframeTreeList" title="리스트 목록"></iframe>
    <div id="mapWrapper">
        <div id="map" class="map">
            <div class="wideMap">
<%--                <img alt="지도확대축소" src="images/drop_down.png" width="30" height="17">--%>
            </div>
            <div class="upDownMap">
<%--                <img alt="지도확대축소" src="images/drop_down.png" width="30" height="17">--%>
            </div>
            <!-- 검색값-->
            <div class="bg_white" id="menu_wrap">
                <div class="option">
                    <p></p>
                    키워드 :
                    <input id="keyword" type="text" size="15" maxlength="50" value="">
                    <label style="display: none;" for="keyword"></label>
                    <button type="submit" class="searchBtn" onclick="searchPlaces();" autocomplete="false">검색하기</button>
                    <p></p>
                </div>
                <hr>
                <ul id="placesList"></ul>
            </div>
            <!-- 검색값끝-->
            <!-- 로드뷰 -->
            <div class="mapToggle">
                <ul style="width:100%; display:block;">
                    <li class="toggleBtn" style="float:left;"><a href="javascript:void(0)" class="place"><img id="place"
                                                                                                              class="road_off"
                                                                                                              src="/images/find_location_off.png"
                                                                                                              alt="위치찾기"></a>
                    </li>
                    <li class="toggleBtn" style="margin-left: 5px;float:left;"><a href="javascript:findLocation()" class="coord" id="coordControl"><img id="coord"
                                                                                                              class="coord_off"
                                                                                                              src="/images/find_coord_off.png"
                                                                                                              alt="좌표검색"></a>
                    </li>
                    <li class="toggleBtn" style="margin-left:5px;float:left;"><a href="javascript:getRoadView();"
                                                                                 class="road" id="roadviewControl"><img
                            id="road" class="road_off" src="/images/road_view.gif" alt="로드뷰오프"></a></li>
                    <li class="toggleBtn" style="margin-left:5px; float:left;"><a href="javascript:getDrawRoad();"
                                                                                  class="draw"><img id="draw"
                                                                                                    class="road_off"
                                                                                                    src="/images/distance.png"
                                                                                                    alt="거리재기"></a>
                    </li>
                    <li class="toggleBtn" style="margin-left:5px; float:left;"><a href="javascript:getDrawArea();"
                                                                                  class="area"><img id="area"
                                                                                                    class="road_off"
                                                                                                    src="/images/area.png"
                                                                                                    alt="면적재기"></a>
                    </li>
                    <%-- <li class="toggleBtn" style="margin-left:5px; float:left;"><a href="javascript:toggleSiginfo();"
                                                                                   class="toggle_siginfo"><img
                             id="toggle_siginfo" class="road_off" src="/images/toggle_siginfo_off.png"
                             alt="신호정보토글"/></a></li>--%>
                    <li class="toggleBtn" style="margin-left:5px; float:left;"><a href="javascript:getMyLocation();"
                                                                                  class="mylocation"><img
                                                                                                          class="mylocation"
                                                                                                          src="/images/position.png"
                                                                                                          alt="현재위치"></a>
                    </li>
                    <li class="toggleBtn" style="margin-left:5px; float:left;"><a href="javascript:refreshNodeList();"
                                                                                  class="refresh"><img
                            class="refresh"
                            src="/images/refresh.png"
                            alt="새로고침"></a>
                    </li>
<%--                    <li class="toggleBtn" style="margin-left:5px; float:left;"><a href="javascript:emergencyHistory();"--%>
<%--                                                                                  class="refresh"><img--%>
<%--                            class="refresh"--%>
<%--                            src="/images/refresh.png"--%>
<%--                            alt="테스트"/></a>--%>
<%--                    </li>--%>
                </ul>
            </div>
            <!-- <img src="images/bg_traffic04.png" alt="범례" class="bumImage" /> -->
            <div class="coordBox">
                <div class="coord-unit">
                    <div>X 좌표 : </div>
                    <input type="text" id="lctn_x_coord" name="x_coord" autocomplete="false">
                    <label style="display: none;" for="lctn_x_coord"></label>
                </div>
                <div class="coord-unit">
                    <div>Y 좌표 : </div>
                    <input type="text" id="lctn_y_coord" name="y_coord" autocomplete="false">
                    <label style="display: none;" for="lctn_y_coord"></label>
                </div>
                <div class="coord-btn" onclick="moveToPosition()">이동</div>
            </div>
        </div>
        <div class="evp_legend"><img alt="긴급차량우선신호 범례" src="/images/evp_legend.png" width="178" height="50"></div>
    </div>
    <!-- 로드뷰 -->
    <div id="rvWrapper">
        <div id="roadview" class="roadview">
            <div id="roadviewClose" title="로드뷰닫기" onclick="closeRoadview()"><span class="img"></span></div>
        </div>
    </div>
    <!-- //로드뷰-->
    <iframe src="/getBottomListFrame.do" id="iframeBottomList" class="iframeBottomList" onload="getSignalInfo()" title="상세 목록"></iframe>
    <!-- 모바일인경우 현재위치버튼 변경 -->
    <div class="mylocationMob" style="display:none;position:absolute;bottom:calc(25% + 35px);left:335px;z-index:10;">
        <a href="javascript:getMyLocation();" class="mylocationMobA">
            <img id="position" class="road_off" src="/images/position_m.png" alt="현재위치" style="width:75px;height:75px">
        </a>
    </div>
</div>

<%--<script src="/js/common/webSocket.js"></script>--%>
<script src="/js/common/cvibStatus.js"></script>
<script>
    function modalClose() {
        $('.modal-box').hide();
        $('#iframeModal').remove();

    }

    $('.modal-box').draggable({
        containment : "body",
        handle : ".modal-title-box",
    });
    var centerPopId = null;
    var eventPopId = null;
    var signalPopId = null;

    /**
     * 좌표 검색
     */
    function findLocation() {
        $('#lctn_x_coord').val('');
        $('#lctn_y_coord').val('');
        const $coordBox = $('.coordBox');
        $coordBox.toggleClass('on');
        var coordImage = "find_coord_";
        var onOff = 'off';
        if ($coordBox.hasClass('on')) {
            onOff = 'on';
        }
        coordImage += onOff;
        coordImage += ".png";

        $('#coord').attr('src', BTN_IMAGE_PATH + coordImage);
    }

    /********************************************************************************
     * 위치검색
     *********************************************************************************/

    $(".toggleBtn > a").click(function () {

        var obj = $(this).attr("class");
        var iconBtn = $("#" + obj).attr("class");

        $("#" + obj).toggleClass('road_on road_off');

        if (obj == "center") {
            if (iconBtn == "road_on") {
                $("#center").attr("src", BTN_IMAGE_PATH + "btn_02.png");
                if (centerPopId != null) centerPopId.close();
            } else {
                $("#center").attr("src", BTN_IMAGE_PATH + "btn_02_on.png");
                var url = 'updateCenter.do';
                var options = 'scrollbars=no,toolbar=no,location=no,resizable=no,status=no,menubar=no,width=908px,height=435px,left=400,top=0';
                centerPopId = window.open(url, 'updateCenter', options);
            }
        }
        if (obj == "event") {
            if (iconBtn == "road_on") {
                $("#event").attr("src", BTN_IMAGE_PATH + "btn_03.png");
                if (eventPopId != null) eventPopId.close();
            } else {
                $("#event").attr("src", BTN_IMAGE_PATH + "btn_03_on.png");
                var url = 'openEventHistory.do';
                var options = 'scrollbars=no,toolbar=no,location=no,resizable=no,status=no,menubar=no,width=908px,height=845px,left=200,top=0';
                eventPopId = window.open(url, 'openEventHistory', options);
            }
        }
        if (obj == "ims") {
            if (iconBtn == "road_on") {
                $("#ims").attr("src", BTN_IMAGE_PATH + "btn_04.png");
                markerRemove("ims");
            } else {
                $("#ims").attr("src", BTN_IMAGE_PATH + "btn_04_on.png");
                getIMS();
            }
        }
        if (obj == "addSignal") {
            if (iconBtn == "road_on") {
                $("#addSignal").attr("src", BTN_IMAGE_PATH + "btn_05.png");
                if (signalPopId != null) signalPopId.close();
            } else {
                $("#addSignal").attr("src", BTN_IMAGE_PATH + "btn_05_on.png");
                var regionCd = $('#regionCd').val();
                var intNo = $('#intNo').val();
                var url = 'updateSignal.do?regionCd=' + regionCd + '&intNo=' + intNo;
                var options = 'scrollbars=no,toolbar=no,location=no,resizable=no,status=no,menubar=no,width=908px,height=880px,left=200,top=0';
                signalPopId = window.open(url, 'addSignal', options);
            }
        }

        //서울 신호좌표데이터 각도데이터로 변경

        if (obj == "addPhase") {
            transAngle();
        }

        //위치검색
        if (obj == "place") {
            if (iconBtn == "road_on") {
                markerRemove('search');
                markerRemove('infowindow');
                $("#place").attr("src", BTN_IMAGE_PATH + "find_location_off.png");
                $("#keyword").val("");
                $("#menu_wrap").css("display", "none");
            } else {
                $("#menu_wrap").css("display", "block");
                $("#keyword").focus();

                $("#place").attr("src", BTN_IMAGE_PATH + "find_location_on.png");
                $("#road").attr("src", BTN_IMAGE_PATH + "road_view.gif");
                $("#draw").attr("src", BTN_IMAGE_PATH + "distance.png");
                $("#area").attr("src", BTN_IMAGE_PATH + "area.png");
                $("#toggle_siginfo").attr("src", BTN_IMAGE_PATH + "toggle_siginfo_off.png");
                $("#area").removeClass("road_on").addClass("road_off");
                $("#draw").removeClass("road_on").addClass("road_off");
                $("#toggle_siginfo").removeClass("road_on").addClass("road_off");
            }
        }

        //로드뷰
        if (obj == "road") {
            if (iconBtn == "road_on") {
                $("#road").attr("src", BTN_IMAGE_PATH + "road_view.gif");
            } else {
                $("#road").attr("src", BTN_IMAGE_PATH + "road_viewon.gif");
                $("#draw").attr("src", BTN_IMAGE_PATH + "distance.png");
                $("#area").attr("src", BTN_IMAGE_PATH + "area.png");
                $("#toggle_siginfo").attr("src", BTN_IMAGE_PATH + "toggle_siginfo_off.png");
                $("#area").removeClass("road_on").addClass("road_off");
                $("#draw").removeClass("road_on").addClass("road_off");
                $("#toggle_siginfo").removeClass("road_on").addClass("road_off");
            }
        }

        //거리재기
        if (obj == "draw") {
            if (iconBtn == "road_on") {
                $("#draw").attr("src", BTN_IMAGE_PATH + "distance.png");
            } else {
                $("#road").attr("src", BTN_IMAGE_PATH + "road_view.gif");
                $("#draw").attr("src", BTN_IMAGE_PATH + "distanceon.png");
                $("#area").attr("src", BTN_IMAGE_PATH + "area.png");
                $("#toggle_siginfo").attr("src", BTN_IMAGE_PATH + "toggle_siginfo_off.png");
                $("#area").removeClass("road_on").addClass("road_off");
                $("#road").removeClass("road_on").addClass("road_off");
                $("#toggle_siginfo").removeClass("road_on").addClass("road_off");
            }
        }

        //면적재기
        if (obj == "area") {
            if (iconBtn == "road_on") {
                $("#area").attr("src", BTN_IMAGE_PATH + "area.png");
            } else {
                $("#road").attr("src", BTN_IMAGE_PATH + "road_view.gif");
                $("#draw").attr("src", BTN_IMAGE_PATH + "distance.png");
                $("#area").attr("src", BTN_IMAGE_PATH + "areaon.png");
                $("#toggle_siginfo").attr("src", BTN_IMAGE_PATH + "toggle_siginfo_off.png");
                $("#draw").removeClass("road_on").addClass("road_off");
                $("#road").removeClass("road_on").addClass("road_off");
                $("#toggle_siginfo").removeClass("road_on").addClass("road_off");
            }
        }

        //신호정보 토글
        if (obj == "toggle_siginfo") {
            if (iconBtn == "road_on") {
                $("#toggle_siginfo").attr("src", BTN_IMAGE_PATH + "toggle_siginfo_off.png");
            } else {
                $("#area").attr("src", BTN_IMAGE_PATH + "area.png");
                $("#draw").attr("src", BTN_IMAGE_PATH + "distance.png");
                $("#road").attr("src", BTN_IMAGE_PATH + "road_view.gif");
                $("#toggle_siginfo").attr("src", BTN_IMAGE_PATH + "toggle_siginfo_on.png");
                $("#road").removeClass("road_on").addClass("road_off");
                $("#draw").removeClass("road_on").addClass("road_off");
                $("#area").removeClass("road_on").addClass("road_off");
            }
        }

    });

    $("#keyword").keydown(function (key) {
        if (key.keyCode == 13) {
            searchPlaces();
        }
    });

    //메뉴창 숨기기

    var UserAgent = window.navigator.userAgent;
    var wideFlag = false;
    var upDownFlag = false;

    $('.wideMap').click(function () {
        const isRoadView = $('.road_on')[0];
        if (wideFlag === false) {
            // $('.wideMap img').attr('src', '/images/arrow_right.png');
            //$('.wideMap img').attr('src', '/images/drop_up.png');
            $('.wideMap').addClass('on');
            $('.iframeTreeList').hide();
            const widthVal = isRoadView ? 'calc(60% - 10px)' : 'calc(100% - 10px)';
            $('#mapWrapper').css({
                width: widthVal,
                margin: '5px 0 0 5px'
            });
            $('.iframeBottomList').css({
                width: 'calc(100% - 10px)',
                margin: '0 0 0 5px'
            });

            if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null)
                $('.mylocationMob').css('left', '25px');
            wideFlag = true;
        } else if (wideFlag === true) {

            // $('.wideMap img').attr('src', '/images/arrow_left.png');
            // $('.wideMap img').attr('src', '/images/drop_down.png');
            $('.wideMap').removeClass('on');
            $('.iframeTreeList').show();
            const widthVal = isRoadView ? 'calc(60% - 290px)' : 'calc(100% - 290px)';
            $('#mapWrapper').css({
                width: widthVal,
                margin: '5px 0 0 287px'
            });
            $('.iframeBottomList').css({
                width: 'calc(100% - 287px)',
                margin: '0 0 0 2px'
            });

            if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null)
                $('.mylocationMob').css('left', '287px');
            wideFlag = false;
        }
        map.relayout();
    });

    $('.upDownMap').click(function () {
        if (upDownFlag == false) {
            //확대
            // $('.upDownMap img').attr('src', 'images/arrow_up.png');
            // $('.upDownMap img').attr('src', 'images/drop_up.png');
            $('.upDownMap').addClass('on');
            $('.iframeBottomList').hide();
            $('#mapWrapper').css('height', 'calc(100% - 12px)');
            $('.evp_legend').css('bottom', '10px');
            if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null)
            $('.mylocationMob').css('bottom', '35px');
            upDownFlag = true;
        } else if (upDownFlag == true) {
            //축소
            // $('.upDownMap img').attr('src', 'images/arrow_down.png').slide;
            // $('.upDownMap img').attr('src', 'images/drop_down.png').slide;
            $('.upDownMap').removeClass('on');
            $('.iframeBottomList').show();
            $('#mapWrapper').css('height', 'calc(100% - 230px)');
            if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null)
            $('.mylocationMob').css('bottom', 'calc(25% + 35px)');
            $('.evp_legend').css('bottom', '228px');
            upDownFlag = false;
        }
        map.relayout();
    });

    /********************************************************************************
     * header display
     *********************************************************************************/

    var headFlag = false;
    $("#hline").click(function () {
        if (headFlag == false) {
            $('.headMenu').slideUp();
            $('.container').css('height', '100%');
            headFlag = true;
        } else {
            $('.headMenu').slideDown();
            $('.container').css('height', 'calc(100% - 66px)');
            headFlag = false;
        }

    });

    function closeTopMenu(obj) {
        mapZoomBound();
        $('#' + obj).attr("class", "road_off");
        if (obj == "center") {
            $("#center").attr("src", BTN_IMAGE_PATH + "btn_02.png");
            setTimeout(function () {
                location.reload(true);
            }, 100 * 1);
        }
        if (obj == "event") $("#event").attr("src", BTN_IMAGE_PATH + "btn_03.png");
        if (obj == "addSignal") {
            $("#addSignal").attr("src", BTN_IMAGE_PATH + "btn_05.png");
            setTimeout(function () {
                location.reload(true);
            }, 100 * 1);
        }
    }

    //모바일 인경우 현재위치버튼 변경
    if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null) {
        $('.mylocation').hide();
        $('.mylocationMob').show();
    }

    $(window).bind("beforeunload", function (e) {
        if (siginfoPhaseDetailWin != null) siginfoPhaseDetailWin.close();
        if (signalPopId != null) signalPopId.close();
    });

    function refreshNodeList() {
        requestService('refreshNodeList.do', null, (res)=>{
            console.log(res);
            if (res) {
                if (res.success) {
                    alert('리스트 목록이 새로고침 되었습니다.');
                    location.reload(true);
                }
                else if(res.errorMsg) {
                    alert('리스트 목록 새로고침 중 오류가 발생하였습니다.<br>' + res.errorMsg);
                }
            }
        }, true)
    }

</script>
</body>
</html>
