<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!doctype html>
<html lang="ko">
<head>
    <%@ include file="/WEB-INF/jsp/common.jsp" %>
    <sec:authorize access="hasAuthority('B')">
        <script>
            alert("기반정보 관리자 계정입니다. 다른 계정으로 로그인하십시요")
            location.href=('/logout.do')
        </script>
    </sec:authorize>
    <sec:authorize access="!isAuthenticated()">
        <script>
            alert("로그인 정보가 없습니다. 로그인해주세요")
            location.href=('/logout.do')
        </script>
    </sec:authorize>
    <meta name="_csrf" content="${_csrf.token}">
    <meta name="_csrf_header" content="${_csrf.headerName}">
    <meta http-equiv="X-UA-Compatible" content="IE=10; IE=9; IE=8; IE=7; IE=EDGE">
    <meta name="Description" content="신호관제">
    <meta name="Keywords" content="신호관제">
    <link rel="icon" href="data:;base64,iVBORw0KGgo=">
    <link rel="stylesheet" type="text/css" href="/css/common.css?v=2">
    <link rel="stylesheet" type="text/css" href="/css/main_new.css?v=3">
    <link rel="stylesheet" type=iframe"text/css" href="/css/themes/default/style.css?v=2">
    <link rel="icon" type="text/css" href="data:;base64,iVBORw0KGgo=">

    <script src="https://cdn.jsdelivr.net/npm/sockjs-client@1/dist/sockjs.min.js?v=2"></script>
    <script src="/js/common/moment.js?v=2"></script>
    <script src="/js/common/hashmap.js?v=2"></script>
    <script src="/js/common/common-all.js?v=2"></script>
    <script src="/js/common/common.js?v=2"></script>
    <script src="/js/common/jstree.min.js?v=2"></script>

    <script src="/js/map.js?v=2"></script>
    <script src="/js/signal.js?v=2"></script>

    <script src="/js/cvib.js?v=2"></script>

    <title>CVIM_MAP</title>
</head>
<body class="sang">
<input type="hidden" name="min_x" id="min_x" value="">
<input type="hidden" name="min_y" id="min_y" value="">
<input type="hidden" name="max_x" id="max_x" value="">
<input type="hidden" name="max_y" id="max_y" value="">
<input type="hidden" name="regionCd" id="regionCd" value="">
<input type="hidden" name="regionId" id="regionId" value="">
<input type="hidden" name="intNo" id="intNo" value="">
<input type="hidden" name="intNm" id="intNm" value="">
<input type="hidden" name="intLcType" id="intLcType" value="">
<input type="hidden" name="intLampType" id="intLampType" value="">
<input type="hidden" name="groupNo" id="groupNo" value="">
<input type="hidden" name="mainIntNo" id="mainIntNo" value="">
<input type="hidden" name="treeXCoord" id="treeXCoord" value="">
<input type="hidden" name="treeYCoord" id="treeYCoord" value="">
<input type="hidden" name="XCoord" id="XCoord" value="126.978087">
<input type="hidden" name="YCoord" id="YCoord" value="37.560684">
<input type="hidden" name="sigunguCd" id="sigunguCd" value="">
<input type="hidden" name="intMainphase" id="intMainphase" value="">
<input type="hidden" name="networkType" id="networkType" value="">
<input type="hidden" name="modemIp" id="modemIp" value="">

<div class="headMenu">
    <h1><a href="main.do" title="로고"><img src="images/logo3.png" alt="로고" style="width: 310px;margin: 3px;"></a></h1>
    <h2 style="width: calc(100% - 340px); display: flex; justify-content: flex-end; height: 100%; align-items: center;">
        <a href="logout.do" title="로그아웃"><img src="images/logout.png" alt="로그아웃"></a>
    </h2>

    <ul>

    </ul>
</div>
<div id="container" class="container">
    <iframe src="/getTreeListFrame.do" id="iframeTreeList" class="iframeTreeList" title="리스트 목록"></iframe>
    <div id="mapWrapper">
        <div id="map" class="map">
            <div class="wideMap">
<%--                <img alt="지도확대축소" src="images/drop_down.png" width="30" height="17">--%>
            </div>
            <div class="upDownMap">
<%--                <img alt="지도확대축소" src="images/drop_down.png" width="30" height="17">--%>
            </div>
<%--            <div class="evp_legend"><img alt="긴급차량우선신호 범례" src="/images/evp_legend.png" width="178" height="50"></div>--%>
            <!-- 검색값-->
            <div class="bg_white" id="menu_wrap">
                <div class="option">
                    <p></p>
                    키워드 :
                    <input id="keyword" type="text" size="15" maxlength="50" value="">
                    <label style="display: none;" for="keyword"></label>
                    <button type="submit" class="searchBtn" onclick="searchPlaces();" autocomplete="false">검색하기</button>
                    <p></p>
                </div>
                <hr>
                <ul id="placesList"></ul>
            </div>
            <!-- 검색값끝-->
            <!-- 로드뷰 -->
            <div class="mapToggle">
                <ul style="width:100%; display:block;">
                    <li class="toggleBtn" style="float:left;">
                        <a href="javascript:void(0)" class="place" title="위치찾기">
                            <img id="place" class="road_off" src="/images/find_location_off.png" alt="위치찾기">
                        </a>
                    </li>
                    <li class="toggleBtn" style="margin-left: 5px;float:left;" title="좌표검색">
                        <a href="javascript:void(0)" class="coord" id="coordControl">
                            <img id="coord" class="road_off" src="/images/find_coord_off.png" alt="좌표검색">
                        </a>
                    </li>
                    <li class="toggleBtn" style="margin-left:5px;float:left;" title="로드뷰 보기">
                        <a href="javascript:void(0);" class="road" id="roadviewControl">
                            <img id="road" class="road_off" src="/images/road_view.gif" alt="로드뷰 보기">
                        </a>
                    </li>
                    <li class="toggleBtn" style="margin-left:5px; float:left;" title="거리재기">
                        <a href="javascript:void(0);" class="draw">
                            <img id="draw" class="road_off" src="/images/distance.png" alt="거리재기">
                        </a>
                    </li>
                    <li class="toggleBtn" style="margin-left:5px; float:left;" title="면적재기">
                        <a href="javascript:void(0);" class="area">
                            <img id="area" class="road_off" src="/images/area.png" alt="면적재기">
                        </a>
                    </li>
                    <li class="toggleBtn" style="margin-left:5px; float:left;" title="현재위치">
                        <a href="javascript:getMyLocation();" class="mylocation">
                            <img class="mylocation" src="/images/position.png" alt="현재위치">
                        </a>
                    </li>
                    <li class="toggleBtn" style="margin-left:5px; float:left;" title="리스트 새로고침">
                        <a href="javascript:refreshNodeList();" class="refresh">
                            <img class="refresh" src="/images/refresh.png" alt="새로고침">
                        </a>
                    </li>
                </ul>
            </div>
            <div class="coordBox">
                <div class="coord-unit">
                    <div>좌표 : </div>
                    <input type="text" id="lctn_coord" name="coord" autocomplete="false" onkeyup="moveToPosition(event)">
                    <label style="display: none;" for="lctn_coord"></label>
                </div>
                <div class="coord-btn" onclick="moveToPosition()">이동</div>
            </div>
        </div>
    </div>
    <!-- 로드뷰 -->
    <div id="rvWrapper">
        <div id="roadview" class="roadview">
            <div id="roadviewClose" title="로드뷰닫기" onclick="closeRoadview()"><span class="img"></span></div>
        </div>
    </div>
    <!-- //로드뷰-->
    <iframe src="/getBottomListFrame.do" id="iframeBottomList" class="iframeBottomList" onload="getSignalInfo()" title="상세 목록"></iframe>
    <!-- 모바일인경우 현재위치버튼 변경 -->
    <div class="mylocationMob" style="display:none;position:absolute;bottom:calc(25% + 35px);left:335px;z-index:10;">
        <a href="javascript:getMyLocation();" class="mylocationMobA">
            <img id="position" class="road_off" src="/images/position_m.png" alt="현재위치" style="width:75px;height:75px">
        </a>
    </div>
    <div class="modal-box">
        <div class="modal-title-box" ondblclick="resizePop()">
            <div>신호정보(<span class="modal-title"></span>)</div>
            <div class="modal-close" onclick="modalClose()">x</div>
        </div>
        <div class="modal-container"></div>
    </div>
    <div class="error-box">
        <div class="error-content">
            <div class="modal-title-box">
                <div>장애이력 조회</div>
                <div class="modal-close" onclick="errorClose()">x</div>
            </div>
            <div class="search-box">
                <div>지역 </div>
                <select id="region_cd">
                    <option>전체</option>
                    <c:forEach items="${region_list}" var="obj">
                        <option value="${obj.regionId}">${obj.regionName}</option>
                    </c:forEach>
                </select>
                &nbsp;
                <div>교차로 검색</div>
                <input type="text" id="int_no">
                </input>
                &nbsp;
                <div>검색기간</div>
                <input type="date" id="fromDt">
                <div>~</div>
                <input type="date" id="toDt">
                &nbsp;
                <input type="radio" name="error-type" id="error-stat" checked onchange="toggleTable('stat')"><label for="error-stat">장애 이력</label>
                <input type="radio" name="error-type" id="error-cnt" onchange="toggleTable('cnt')"><label for="error-cnt" >장애 발생 건수</label>
                <div class="button" onclick="searchErrorStatistics()"><i class="fa fa-search"></i>조회</div>
            </div>
            <div class="modal-title-box">
                <div>검색 결과</div>
            </div>
            <div class="table-box">
                <div class="table-content">
                    <table class="error-stat-table on">
                        <colgroup>
                            <col width="20%">
                            <col width="40%">
                            <col width="20%">
                            <col width="10%">
                            <col width="10%">
                        </colgroup>
                        <thead>
                        <tr>
                            <th>지역명</th>
                            <th>교차로명</th>
                            <th>이벤트 발생시각</th>
                            <th>상태</th>
                            <th>서버 ID</th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                    <table class="error-cnt-table">
                        <thead>
                        <tr>
                            <th>지역명</th>
                            <th>교차로명</th>
                            <th>이벤트 발생 건수</th>
                            <th>상태</th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
                <div class="error-stat pagination on">
                    <button class="prev unactive">«</button>
                    <button class="active">1</button>
                    <button class="next unactive">»</button>
                </div>
                <div class="error-cnt pagination">
                    <button class="prev unactive">«</button>
                    <button class="active">1</button>
                    <button class="next unactive">»</button>
                </div>
            </div>
            <div class="showLoading"><img src="/css/themes/classic/throbber.gif" alt="로딩 이미지"></div>
        </div>
    </div>
</div>

<%--<script src="/js/common/webSocket.js"></script>--%>
<script src="/js/common/cvibStatus.js?v=2"></script>
<script>
    const yesterday = new Date(new Date().setDate(new Date().getDate() - 1));
    const yesterdayVal = yesterday.getFullYear() + '-' +
        (yesterday.getMonth() + 1).toString().padStart(2, '0') + '-' +
        yesterday.getDate().toString().padStart(2, '0');
    let _errorStatMap = new Map();
    let _errorCntMap = new Map();
    $('#fromDt').val(yesterdayVal);
    $('#toDt').val(yesterdayVal);

    function resizePop() {
        $('.modal-box').toggleClass('on');
    }

    function toggleTable(type) {
        $('.table-box table.on').removeClass('on');
        $('.pagination.on').removeClass('on');
        $('.error-' + type + '-table').addClass('on');
        $('.error-' + type).addClass('on');
    }

    function errorClose() {
        $('.error-box').hide();
        $('#errorStatistics').removeClass('on');
    }

    function modalClose() {
        let iframe = document.querySelector('#iframeModal');
        iframe.src = 'about:blank';
        iframe.remove();
        const box = $('.modal-box');
        box.hide();
        box.removeClass('on');
    }


    function searchErrorStatistics() {
        const isStat = $('#error-stat').is(':checked');
        const url = isStat ? 'getNodeStatistics.do' : 'getNodeStatusCntStat.do';
        const fromDt = $('#fromDt').val();
        const toDt = $('#toDt').val();
        let regionId = $('#region_cd').val()
        let nodeId = $('#int_no').val();

        if (!fromDt || !toDt) {
            return alert('검색 기간을 선택 해주세요.');
        }

        if (fromDt > toDt) {
            return alert('검색 시작일이 종료일보다 클 수 없습니다.');
        }

        const loading = $('.error-box .showLoading');
        const param = { fromDt, toDt, regionId, nodeId };
        loading.css('display', 'flex');
        requestService(url, param, (res)=>{
            isStat ? errorStatPaging(res) : errorCntPaging(res);
            loading.css('display', 'none');
        }, true, ()=> loading.css('display', 'none'));
    }


    function errorStatPaging(res) {
        _errorStatMap.clear();
        const rowsPerPage = 20;

        if (res && res.length) {
            let str = '';
            res.forEach((obj, idx)=>{
                if (idx % rowsPerPage === 0 && idx > 0) {
                    let selPage = idx / rowsPerPage;
                    _errorStatMap.set(selPage, str);
                    str = '';
                }

                str += `<tr>
                            <td>\${obj.regionNm}</td>
                            <td>[\${obj.nodeid}] \${obj.name}</td>
                            <td>\${obj.eventDt}</td>
                            <td>\${obj.status}</td>
                            <td>\${obj.serverid}</td>
                        </tr>`;
            });
            if (str) {
                _errorStatMap.set(Number(_errorStatMap.size) + 1, str);
            }

            let pageSize = _errorStatMap.size;

            const isNext = pageSize > 10;
            if (isNext) {
                pageSize = 10;
            }

            makePageStr(false, isNext, 1, pageSize, 1, 'stat');
        }
        else {
            makePageStr(false, false, 1, 1, 1, 'stat');
        }
    }


    function beforeErrorStat(el, type) {
        if ($(el).hasClass('unactive')) return;
        const firstPage = Number($(el).next().text());
        if (!isNaN(firstPage)) {
            const startPage = firstPage - 10;
            const endPage = firstPage - 1;
            makePageStr(startPage !== 1, true, startPage, endPage, endPage, type);
        }
    }

    function makePageStr(isBefore, isNext, start, end, active, type) {
        const map = type === 'stat' ? _errorStatMap : _errorCntMap;
        let str = `<button class="prev \${isBefore ? '' : 'unactive'}" onclick="beforeErrorStat(this, '\${type}')">«</button>`;
        for (let ii = start; ii <= end; ii++) {
            str += `<button class="\${active === ii ? 'active' : ''}" onclick="showErrorStatPage(\${ii}, this, '\${type}')">\${ii}</button>`;
        }
        str += `<button class="next \${isNext ? '' : 'unactive'}" onclick="nextErroStat(this, '\${type}')">»</button>`;
        let statistics = map.get(active);
        if (!statistics) {
            statistics = '<tr class="empty-box"><td colspan="'+$('.error-box table.on thead th').length+'">표출할 정보가 없습니다.</td></tr>'
        }
        $('.error-box table.on tbody').html(statistics);
        $('.error-box .pagination.on').html(str);
    }

    function nextErroStat(el, type) {
        if ($(el).hasClass('unactive')) return;
        const beforePage = $(el).prev().text();
        let lastPage = Number(beforePage) + 10;
        const map = type === 'stat' ? _errorStatMap : _errorCntMap;
        let isNext = map.size > lastPage;
        if (!isNext) {
            lastPage = map.size;
        }
        const firstPage = Number(beforePage) + 1;
        makePageStr(true, isNext, firstPage, lastPage, firstPage, type);
    }

    function showErrorStatPage(page, el, type) {
        const beforePage = $('.error-box .pagination.on .active');
        if (page === Number(beforePage.text())) return;
        beforePage.removeClass('active');
        $(el).addClass('active');
        const map = type === 'stat' ? _errorStatMap : _errorCntMap;
        $('.error-box table.on tbody').html(map.get(page));
    }


    function errorCntPaging(res) {
        _errorCntMap.clear();
        const rowsPerPage = 20;

        if (res && res.length) {
            let str = '';
            res.forEach((obj, idx)=>{
                if (idx % rowsPerPage === 0 && idx > 0) {
                    let selPage = idx / rowsPerPage;
                    _errorCntMap.set(selPage, str);
                    str = '';
                }

                let dataCnt = Number(obj.dataCnt).toLocaleString();
                str += `<tr>
                            <td>\${obj.regionNm}</td>
                            <td>[\${obj.nodeid}] \${obj.name}</td>
                            <td>\${dataCnt}</td>
                            <td>\${obj.status}</td>
                        </tr>`

            });
            if (str) {
                _errorCntMap.set(Number(_errorCntMap.size) + 1, str);
            }

            let pageSize = _errorCntMap.size;

            const isNext = pageSize > 10;
            if (isNext) {
                pageSize = 10;
            }

            makePageStr(false, isNext, 1, pageSize, 1, 'cnt');
        }
        else {
            makePageStr(false, false, 1, 1, 1, 'cnt');
        }
    }

    var centerPopId = null;
    var eventPopId = null;
    var signalPopId = null;

    /**
     * 좌표 검색
     */
    function findLocation() {

        // var coordImage = "find_coord_";
        // var onOff = 'off';
        // if ($coordBox.hasClass('on')) {
        //     onOff = 'on';
        // }
        // coordImage += onOff;
        // coordImage += ".png";

        // $('#coord').attr('src', BTN_IMAGE_PATH + coordImage);
    }

    /********************************************************************************
     * 위치검색
     *********************************************************************************/

    $(".toggleBtn > a").click(function () {
        drawingAreaStop();
        drawingStop();
        roadViewClose();
        markerRemove('search');
        markerRemove('infowindow');
        const menuWrap  = $("#menu_wrap");
        const keyword   = $("#keyword");
        const coordinates = $('#lctn_coord');
        const $coordBox = $('.coordBox');
        $coordBox.removeClass('on');
        keyword.val("");
        coordinates.val("");
        menuWrap.css("display", "none");

        const objClass = $(this).attr("class");
        const obj = $("#" + objClass);
        const iconClass = obj.attr("class");
        $('.road_on:not(#'+ objClass + ')').attr('class', 'road_off');

        obj.toggleClass('road_on road_off');
        if (iconClass === 'road_off'){
            switch (objClass) {
                case "place" :
                    menuWrap.css("display", "block");
                    keyword.focus();
                    break;
                case "coord" :
                    $coordBox.toggleClass('on');
                    coordinates.focus();
                    break;
                case "road" :
                    getRoadView();
                    break;
                case "draw" :
                    getDrawRoad();
                    break;
                case "area" :
                    getDrawArea();
                    break;
            }
        }
    });

    $("#keyword").keydown(function (key) {
        if (key.keyCode == 13) {
            searchPlaces();
        }
    });

    //메뉴창 숨기기

    var UserAgent = window.navigator.userAgent;
    var wideFlag = false;
    var upDownFlag = false;

    $('.wideMap').click(function () {
        const isRoadView = $('.road_on')[0];
        if (wideFlag === false) {
            // $('.wideMap img').attr('src', '/images/arrow_right.png');
            //$('.wideMap img').attr('src', '/images/drop_up.png');
            $('.wideMap').addClass('on');
            $('.iframeTreeList').hide();
            const widthVal = isRoadView ? 'calc(60% - 10px)' : 'calc(100% - 10px)';
            $('#mapWrapper').css({
                width: widthVal,
                margin: '5px 0 0 5px'
            });
            $('.iframeBottomList').css({
                width: 'calc(100% - 10px)',
                margin: '0 0 0 5px'
            });

            if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null)
                $('.mylocationMob').css('left', '25px');
            wideFlag = true;
        } else if (wideFlag === true) {

            // $('.wideMap img').attr('src', '/images/arrow_left.png');
            // $('.wideMap img').attr('src', '/images/drop_down.png');
            $('.wideMap').removeClass('on');
            $('.iframeTreeList').show();
            const widthVal = isRoadView ? 'calc(60% - 290px)' : 'calc(100% - 290px)';
            $('#mapWrapper').css({
                width: widthVal,
                margin: '5px 0 0 287px'
            });
            $('.iframeBottomList').css({
                width: 'calc(100% - 287px)',
                margin: '0 0 0 2px'
            });

            if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null)
                $('.mylocationMob').css('left', '287px');
            wideFlag = false;
        }
        map.relayout();
    });

    $('.upDownMap').click(function () {
        if (upDownFlag == false) {
            //확대
            // $('.upDownMap img').attr('src', 'images/arrow_up.png');
            // $('.upDownMap img').attr('src', 'images/drop_up.png');
            $('.upDownMap').addClass('on');
            $('.iframeBottomList').hide();
            $('#mapWrapper').css('height', 'calc(100% - 8px)');
            $('.evp_legend').css('bottom', '6px');
            if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null)
            $('.mylocationMob').css('bottom', '35px');
            upDownFlag = true;
        } else if (upDownFlag == true) {
            //축소
            // $('.upDownMap img').attr('src', 'images/arrow_down.png').slide;
            // $('.upDownMap img').attr('src', 'images/drop_down.png').slide;
            $('.upDownMap').removeClass('on');
            $('.iframeBottomList').show();
            $('#mapWrapper').css('height', 'calc(100% - 230px)');
            if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null)
            $('.mylocationMob').css('bottom', 'calc(25% + 35px)');
            $('.evp_legend').css('bottom', '228px');
            upDownFlag = false;
        }
        map.relayout();
    });

    /********************************************************************************
     * header display
     *********************************************************************************/

    var headFlag = false;
    $("#hline").click(function () {
        if (headFlag == false) {
            $('.headMenu').slideUp();
            $('.container').css('height', '100%');
            headFlag = true;
        } else {
            $('.headMenu').slideDown();
            $('.container').css('height', 'calc(100% - 66px)');
            headFlag = false;
        }

    });

    function closeTopMenu(obj) {
        mapZoomBound();
        $('#' + obj).attr("class", "road_off");
        if (obj == "center") {
            $("#center").attr("src", BTN_IMAGE_PATH + "btn_02.png");
            setTimeout(function () {
                location.reload(true);
            }, 100 * 1);
        }
        if (obj == "event") $("#event").attr("src", BTN_IMAGE_PATH + "btn_03.png");
        if (obj == "addSignal") {
            $("#addSignal").attr("src", BTN_IMAGE_PATH + "btn_05.png");
            setTimeout(function () {
                location.reload(true);
            }, 100 * 1);
        }
    }

    //모바일 인경우 현재위치버튼 변경
    if (UserAgent.match(/iPhone|iPod|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || UserAgent.match(/LG|SAMSUNG|Samsung/) != null) {
        $('.mylocation').hide();
        $('.mylocationMob').show();
    }

    $(window).bind("beforeunload", function (e) {
        if (siginfoPhaseDetailWin != null) siginfoPhaseDetailWin.close();
        if (signalPopId != null) signalPopId.close();
    });

    function refreshNodeList() {
        requestService('refreshNodeList.do', null, (res)=>{
            console.log(res);
            if (res) {
                if (res.success) {
                    alert('리스트 목록이 새로고침 되었습니다.');
                    location.reload(true);
                }
                else if(res.errorMsg) {
                    alert('리스트 목록 새로고침 중 오류가 발생하였습니다.<br>' + res.errorMsg);
                }
            }
        }, true)
    }


    function errorHistory() {
        $('#fromDt').val(yesterdayVal);
        $('#toDt').val(yesterdayVal);
        $('#region_cd').val('전체').trigger('change');
        $('.error-box .error-cnt-table tbody').empty();
        $('.error-box .error-stat-table tbody').empty();
        $('#error-stat').click();
        $('.error-box').css('display', 'flex');
        $('#errorStatistics').addClass('on');
    }
</script>
</body>
</html>
