/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.List;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.InternalMapping;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.util.Strings;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ConstantMapping;
import org.modelmapper.spi.PropertyInfo;

class ConstantMappingImpl
extends MappingImpl
implements ConstantMapping {
    private final Object constant;

    private ConstantMappingImpl(ConstantMappingImpl mapping, List<? extends PropertyInfo> mergedMutators) {
        super(mapping, mergedMutators);
        this.constant = mapping.constant;
    }

    ConstantMappingImpl(Object constant, List<Mutator> destinationMutators, ExplicitMappingBuilder.MappingOptions options) {
        super(destinationMutators, options);
        this.constant = constant;
    }

    @Override
    public Object getConstant() {
        return this.constant;
    }

    public String toString() {
        return String.format("ConstantMapping[%s -> %s]", this.constant, Strings.joinWithFirstType(this.getDestinationProperties()));
    }

    @Override
    public InternalMapping createMergedCopy(List<? extends PropertyInfo> mergedAccessors, List<? extends PropertyInfo> mergedMutators) {
        return new ConstantMappingImpl(this, mergedMutators);
    }

    @Override
    public Class<?> getSourceType() {
        return this.constant == null ? Object.class : Types.deProxy(this.constant.getClass());
    }
}

