const _menuHandleMap = new Map();
let _menuData        = [];
let _dxMenu          = null;
const _menuDataAll = [
    {
        id: 1,
        name: "교통상황관리",
        icon: "/images/op/menu/010000.png",
        items: [
            {
                id: "0",
                name: "통합모니터링",
                icon: "/images/op/menu/010100.png",
                always: true,
            },
            {
                beginGroup: true,
                id: "1",
                name: "현재소통정보조회",
                page: "/application/op/01.traffic-manager/01.traffic-current/current-traffic.html",
                option: "width = 1700, height = 950, top = 40, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/010200.png",
            },
            {
                id: "2",
                name: "소통정보제보 관리",
                page: "/application/op/01.traffic-manager/02.syop-traf/syop-traf.html",
                option: "width = 1400, height = 800, top = 140, left = 300, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/010300.png",
            },
            {
                beginGroup: true,
                id: "3",
                name: "돌발상황정보 관리",
                page: "/application/op/01.traffic-manager/03.incident/incident.html",
                option: "width = 1700, height = 950, top = 15, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/010400.png",
            },
            {
                beginGroup: true,
                id: "4",
                name: "반복정체구간 관리",
                page: "/application/op/01.traffic-manager/04.rept-cngs/rept-cngs.html",
                option: "width = 1400, height = 850, top = 65, left = 250, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/010500.png",
            },
        ],
    },
    {
        id: 2,
        name: "시설물관리",
        icon: "/images/op/menu/020000.png",
        items: [
            {
                id: "1",
                name: "시설물정보 관리",
                page: "/application/op/02.facility/01.manager/manager.html",
                option: "width = 1500, height = 700, top = 150, left = 200, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/020100.png",
            },
            {
                id: "2",
                name: "시설물업체 관리",
                page: "/application/op/02.facility/02.company/company.html",
                option: "width = 1500, height = 700, top = 150, left = 200, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/020200.png",
            },
            {
                id: "3",
                name: "시설물장애 관리",
                page: "/application/op/02.facility/03.fail-hs/fail-hs.html",
                option: "width = 1500, height = 800, top = 100, left = 200, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/020300.png",
            },
            {
                beginGroup: true,
                visible  : false,
                id: "4",
                name: "주차장 관리",
                page: "/application/op/02.facility/04.parking/manager.html",
                option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/020400.png",
            },
        ],
    },
    {
        id: 3,
        name: "이력조회",
        icon: "/images/op/menu/030000.png",
        items: [
            {
                id: "1",
                name: "운영자접속 이력",
                page: "/application/op/03.history/01.user-cnns-hs/user-cnns-hs.html",
                option: "width = 540, height = 790, top = 100, left = 600, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/030100.png",
            },
            {
                id: "2",
                name: "프로세스상태 이력",
                page: "/application/op/03.history/02.unit-syst-stts-hs/unit-syst-stts-hs.html",
                option: "width = 1100, height = 850, top = 75, left = 350, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/030200.png",
            },
            {
                beginGroup: true,
                id: "3",
                name: "수집데이터 이력",
                page: "/application/op/03.history/03.clct-hs/clct-hs.html",
                option: "width = 1500, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/030300.png",
            },
            {
                id: "4",
                name: "가공데이터 이력",
                page: "/application/op/03.history/04.traf-hs/traf-hs.html",
                option: "width = 1500, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/030400.png",
            },
            {
                id: "5",
                name: "수집데이터 분석",
                page: "/application/op/03.history/05.clct-analysis/clct-analysis.html",
                option: "width = 1500, height = 850, top = 75, left = 210, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/030500.png",
            },
        ],
    },
    {
        id: 4,
        name: "통계-분석",
        icon: "/images/op/menu/040000.png",
        items: [
            {
                id: "1",
                name: "통계",
                icon: "/images/op/menu/040100.png",
                items: [
                    {
                        id: "1",
                        name: "소통정보 통계",
                        page: "/application/op/04-1.statistics/01.traffic/traffic.html",
                        option: "width = 1400, height = 850, top = 75, left = 250, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/040100.png",
                    },
                    {
                        id: "2",
                        name: "간선도로 소통정보 통계",
                        page: "/application/op/04-1.statistics/02.atrd-traffic/atrd-traffic.html",
                        option: "width = 1400, height = 850, top = 75, left = 250, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/040200.png",
                    },
                    {
                        id: "3",
                        name: "간선도로 통계",
                        page: "/application/op/04-1.statistics/03.atrd/atrd.html",
                        option: "width = 1400, height = 850, top = 75, left = 250, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/040300.png",
                    },
                    {
                        id: "4",
                        name: "돌발상황 통계",
                        page: "/application/op/04-1.statistics/04.incident/incident.html",
                        option: "width = 1400, height = 850, top = 75, left = 300, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/040400.png",
                    },
                    {
                        id: "5",
                        name: "시설물통신단절 통계",
                        page: "/application/op/04-1.statistics/05.fclt-stts/fclt-stts.html",
                        option: "width = 1200, height = 850, top = 75, left = 350, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/040500.png",
                    },
                    {
                        id: "6",
                        name: "프로세스상태 통계",
                        page: "/application/op/04-1.statistics/06.unit-syst-stts/unit-syst-stts.html",
                        option: "width = 1200, height = 850, top = 75, left = 350, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/040600.png",
                    },
                ],
            },
            {
                id: "2",
                name: "분석",
                icon: "/images/op/menu/040700.png",
                items: [
                    {
                        id: "7",
                        name: "교통정보수집결과 분석",
                        page: "/application/op/04-2.analysis/01.clct-result/clct-result.html",
                        option: "width = 1450, height = 850, top = 75, left = 250, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/040700.png",
                    },
                    {
                        id: "8",
                        name: "교통정보가공결과 분석",
                        page: "/application/op/04-2.analysis/02.prcn-result/prcn-result.html",
                        option: "width = 1550, height = 850, top = 75, left = 200, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/040800.png",
                    },
                    {
                        id: "9",
                        name: "교통정보 제공결과 분석",
                        page: "/application/op/04-2.analysis/03.offr-result/offr-result.html",
                        option: "width = 1450, height = 850, top = 75, left = 250, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/040900.png",
                    },
                    {
                        id: "10",
                        name: "소통정보이력 분석",
                        page: "/application/op/04-2.analysis/04.traf-hs/traf-hs.html",
                        option: "width = 1450, height = 850, top = 75, left = 250, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/041000.png",
                    },
                    {
                        id: "11",
                        name: "패턴데이터 분석",
                        page: "/application/op/04-2.analysis/05.ptrn-data/ptrn-data.html",
                        option: "width = 1550, height = 850, top = 75, left = 200, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/041100.png",
                    },
                ],
            },
            {
                beginGroup: true,
                id: "3",
                name: "보고서",
                page: "/application/op/04-3.report/report.html",
                option: "width = 1450, height = 850, top = 75, left = 250, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/041200.png",
            },
        ],
    },
    {
        id: 5,
        name: "CCTV",
        icon: "/images/op/menu/050000.png",
        items: [
            {
                id: "1",
                name: "CCTV 기본정보 관리",
                page: "/application/op/05.cctv/01.manager/manager.html",
                option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/050100.png",
            },
            {
                beginGroup: true,
                id: "2",
                name: "CCTV 상태이력",
                page: "/application/op/05.cctv/02.history/history.html",
                option: "width = 1250, height = 850, top = 75, left = 350, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/050200.png",
            },
            {
                beginGroup: true,
                id: "3",
                name: "CCTV 상태 모니터링",
                page: "/application/op/05.cctv/03.monitoring-stts/stts.html",
                option: "width = 1250, height = 850, top = 75, left = 350, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/050300.png",
            },
            {
                id: "4",
                name: "CCTV 영상 모니터링",
                page: "/application/op/05.cctv/04.monitoring-camera/monitoring.html",
                option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/050400.png",
            },
            {
                beginGroup: true,
                id: "5",
                name: "CCTV 제어",
                page: "/application/op/05.cctv/05.control/control.html",
                option: "width = 1420, height = 850, top = 75, left = 265, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/050500.png",
            },
            {
                beginGroup: true,
                id: "6",
                name: "CCTV 프리셋 제어 스케줄 관리",
                page: "/application/op/05.cctv/06.pset-scnr/pset-scnr.html",
                option: "width = 950, height = 850, top = 75, left = 500, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/050600.png",
                handle: null,
            },
            {
                beginGroup: true,
                id: "7",
                name: "좌회전감응카메라 영상 모니터링",
                page: "/application/op/05.cctv/07.left-turn-sens-monitoring/monitoring.html",
                option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/050400.png",
                handle: null,
            },
        ],
    },
    {
        id: 6,
        name: "VMS",
        icon: "/images/op/menu/060000.png",
        items: [
            {
                id: "1",
                name: "시스템",
                icon: "/images/op/menu/060200.png",
                items: [
                    {
                        id: "1",
                        name: "현시 모니터링",
                        page: "/application/op/06.vms/01.system/01.monitoring/01.phase/phase.html",
                        option: "width = 1850, height = 850, top = 75, left = 30, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/060200.png",
                    },
                    {
                        id: "2",
                        name: "시나리오 모니터링",
                        page: "/application/op/06.vms/01.system/01.monitoring/02.scenario/scenario.html",
                        option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/060300.png",
                    },
                    {
                        id: "3",
                        name: "상태 모니터링",
                        page: "/application/op/06.vms/01.system/01.monitoring/03.stts/stts.html",
                        option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/060400.png",
                    },
                    {
                        id: "4",
                        name: "모듈상태 모니터링",
                        page: "/application/op/06.vms/01.system/01.monitoring/04.module/module.html",
                        option: "width = 1850, height = 850, top = 75, left = 30, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/060500.png",
                    },
                    {
                        id: "5",
                        name: "영상 모니터링",
                        page: "/application/op/06.vms/01.system/01.monitoring/05.camera/camera.html",
                        option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/060600.png",
                    },
                    {
                        beginGroup: true,
                        id: "6",
                        name: "VMS 제어",
                        page: "/application/op/06.vms/01.system/02.control/control.html",
                        option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/060700.png",
                    },
                ],
            },
            {
                id: "2",
                name: "정보관리",
                icon: "/images/op/menu/060100.png",
                items: [
                    {
                        id: "1",
                        name: "VMS 기본정보 관리",
                        page: "/application/op/06.vms/02.manager/01.info/info.html",
                        option: "width = 1500, height = 900, top = 50, left = 200, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/060100.png",
                    },
                    {
                        beginGroup: true,
                        id: "2",
                        name: "정보제공구간 관리",
                        page: "/application/op/06.vms/02.manager/02.vms-ifsc/01.vms-ifsc/vms-ifsc.html",
                        option: "width = 1500, height = 800, top = 100, left = 200, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/060800.png",
                    },
                    {
                        id: "3",
                        name: "정보제공구간 설정",
                        page: "/application/op/06.vms/02.manager/02.vms-ifsc/02.vms-ifsc-rltn/vms-ifsc-rltn.html",
                        option: "width = 1500, height = 800, top = 100, left = 200, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/060900.png",
                    },
                    {
                        beginGroup: true,
                        id: "4",
                        name: "심볼 이미지 관리",
                        page: "/application/op/06.vms/02.manager/03.symbl-vmp/01.symbl-vmp0/symbl-vmp0.html",
                        option: "width = 1200, height = 800, top = 100, left = 350, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061000.png",
                    },
                    {
                        id: "5",
                        name: "소통정보 이미지 관리",
                        page: "/application/op/06.vms/02.manager/03.symbl-vmp/03.symbl-vmp2/symbl-vmp2.html",
                        option: "width = 1200, height = 800, top = 100, left = 350, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061100.png",
                    },
                    {
                        id: "6",
                        name: "소통정보 배경 이미지 관리",
                        page: "/application/op/06.vms/02.manager/03.symbl-vmp/02.symbl-vmp1/symbl-vmp1.html",
                        option: "width = 1400, height = 800, top = 100, left = 250, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061200.png",
                    },
                ],
            },
            {
                id: "3",
                name: "폼관리",
                icon: "/images/op/menu/061300.png",
                items: [
                    {
                        id: "1",
                        name: "문자식/도형식 폼관리",
                        page: "/application/op/06.vms/03.form/manage.html",
                        option: "width = 1600, height = 900, top = 50, left = 150, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061300.png",
                    },
                ],
            },
            {
                id: "4",
                name: "스케줄관리",
                icon: "/images/op/menu/061400.png",
                items: [
                    {
                        id: "1",
                        name: "자동 스케줄 관리",
                        page: "/application/op/06.vms/04.schedule/01.auto/auto.html",
                        option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061400.png",
                    },
                    {
                        id: "2",
                        name: "고정 스케줄 관리",
                        page: "/application/op/06.vms/04.schedule/02.fixed/fixed.html",
                        option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061500.png",
                    },
                    {
                        id: "3",
                        name: "기본 스케줄 관리",
                        page: "/application/op/06.vms/04.schedule/03.default/default.html",
                        option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061600.png",
                    },
                    {
                        beginGroup: true,
                        id: "4",
                        name: "휘도설정 스케줄 관리",
                        page: "/application/op/06.vms/04.schedule/04.lum-set-sch/lum-set-sch.html",
                        option: "width = 950, height = 850, top = 75, left = 500, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061700.png",
                    },
                ],
            },
            {
                id: "5",
                name: "이력조회",
                icon: "/images/op/menu/061800.png",
                items: [
                    {
                        id: "1",
                        name: "VMS 상태이력",
                        page: "/application/op/06.vms/05.history/01.stts/stts.html",
                        option: "width = 1650, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061800.png",
                    },
                    {
                        id: "2",
                        name: "VMS 제공이력",
                        page: "/application/op/06.vms/05.history/02.dspl/dspl.html",
                        option: "width = 1650, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/061900.png",
                    },
                    {
                        id: "3",
                        name: "VMS 제어이력",
                        page: "/application/op/06.vms/05.history/03.ctrl/ctrl.html",
                        option: "width = 1650, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                        icon: "/images/op/menu/062000.png",
                    },
                ],
            },
        ],
    },

    {
        id: 7,
        name: "VDS",
        icon: "/images/op/menu/070000.png",
        items: [
            {
                id: "1",
                name: "VDS-제어기 관리",
                page: "/application/op/07.vds/01.manager-info/info.html",
                option: "width = 1650, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/070100.png",
            },
            {
                id: "2",
                name: "VDS-검지기 관리",
                page: "/application/op/07.vds/02.manager-dtct/dtct.html",
                option: "width = 1650, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/070200.png",
            },
            {
                beginGroup: true,
                id: "3",
                name: "VDS 상태 모니터링",
                page: "/application/op/07.vds/03.stts/stts.html",
                option: "width = 1750, height = 850, top = 75, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/070400.png",
            },
            {
                id: "4",
                name: "VDS 제어",
                page: "/application/op/07.vds/04.control/control.html",
                option: "width = 1200, height = 850, top = 75, left = 375, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/070300.png",
            },
            {
                beginGroup: true,
                id: "5",
                name: "VDS-제이기 상태 이력",
                page: "/application/op/07.vds/05.history-stts/stts.html",
                option: "width = 1650, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/070400.png",
            },
            {
                id: "6",
                name: "VDS-검지기 원시수집 이력",
                page: "/application/op/07.vds/06.history-dtct-clct-hs/dtct-clct-hs.html",
                option: "width = 1650, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/070500.png",
            },
            {
                id: "7",
                name: "VDS-검지기 소통정보 통계",
                page: "/application/op/07.vds/07.statistics-dtct-traf/dtct-traf.html",
                option: "width = 1500, height = 850, top = 75, left = 200, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/070600.png",
            },
            {
                beginGroup: true,
                id: "8",
                name: "VDS-검지기 교통량 통계",
                page: "/application/op/07.vds/08.statistics-dtct-tfvl/dtct-tfvl.html",
                option: "width = 1600, height = 850, top = 75, left = 150, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/070700.png",
            },
        ],
    },

    {
        id: 8,
        name: "기초데이터관리",
        icon: "/images/op/menu/080000.png",
        items: [
            {
                beginGroup: true,
                id: "1",
                name: "노드",
                page: "/application/op/08.database/01.node/node.html",
                option: "width = 1700, height = 950, top = 40, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/080100.png",
            },
            {
                id: "2",
                name: "링크",
                page: "/application/op/08.database/02.link/link.html",
                option: "width = 1700, height = 950, top = 40, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/080200.png",
            },
            {
                id: "3",
                name: "정보제공구간",
                page: "/application/op/08.database/03.ifsc/ifsc.html",
                option: "width = 1700, height = 950, top = 40, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/080300.png",
            },
            {
                id: "4",
                name: "도로",
                page: "/application/op/08.database/04.road/road.html",
                option: "width = 1700, height = 950, top = 40, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/080400.png",
            },
            {
                id: "5",
                name: "간선도로 관리",
                page: "/application/op/08.database/05.atrd/atrd.html",
                option: "width = 1700, height = 950, top = 40, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/080500.png",
            },
            {
                beginGroup: true,
                id: "6",
                name: "가공파라미터 관리",
                page: "/application/op/08.database/06.clct-syst-stup/clct-syst-stup.html",
                option: "width = 1700, height = 950, top = 40, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/080600.png",
            },
            {
                id: "7",
                name: "소통등급 관리",
                page: "/application/op/08.database/07.cmtr-grad-clsf/cmtr-grad-clsf.html",
                option: "width = 900, height = 600, top = 180, left = 510, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/080700.png",
            },
            {
                id: "8",
                name: "휴일 관리",
                page: "/application/op/08.database/08.legl-hldy-infr/legl-hldy-infr.html",
                option: "width = 540, height = 690, top = 150, left = 690, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/080800.png",
            },
            {
                beginGroup: true,
                id: "9",
                name: "운영코드 관리",
                page: "/application/op/08.database/09.clsf-cd/clsf-cd.html",
                option: "width = 1700, height = 900, top = 40, left = 100, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/080900.png",
            },
            {
                id: "10",
                name: "운영자 관리",
                page: "/application/op/08.database/10.user-infr/user-infr.html",
                option: "width = 1500, height = 690, top = 150, left = 200, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/081000.png",
            },
            {
                id: "11",
                name: "프로세스 관리",
                page: "/application/op/08.database/11.unit-syst/unit-syst.html",
                option: "width = 1550, height = 690, top = 150, left = 175, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/081100.png",
            },
            {
                id: "12",
                name: "연계 기관 관리",
                page: "/application/op/08.database/12.cnct-intn/cnct-intn.html",
                option: "width = 1400, height = 690, top = 150, left = 250, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/081200.png",
            },
            {
                beginGroup: true,
                id: "13",
                name: "운영자 그룹 메뉴 관리",
                page: "/application/op/08.database/13.grop-menu-athr/grop-menu-athr.html",
                option: "width = 800, height = 700, top = 150, left = 500, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/081300.png",
            },
            {
                beginGroup: true,
                id: "14",
                name: "홈페이지 운영자 관리",
                page: "/application/op/08.database/14.web-user-infr/web-user-infr.html",
                option: "width = 1300, height = 800, top = 95, left = 300, resizable=yes, scrollbars=no",
                icon: "/images/op/menu/081000.png",
            },
        ],
    },
    {
        id     :  "14",
        name   : '테마변경',
        visible: false,
        items: [{
            id     : '1',
            name  : 'Blue Dark',
            theme : 'dx.material.blue.dark.compact.css'
        },
            {
                id     : '2',
                name  : 'Blue Light',
                theme : 'dx.material.blue.light.compact.css'
            },
            {
                id     : '3',
                name  : 'Lime Dark',
                theme : 'dx.material.lime.dark.compact.css'
            },
            {
                id     : '4',
                name  : 'Lime Light',
                theme : 'dx.material.lime.light.compact.css'
            },
            {
                id     : '5',
                name  : 'Orange Dark',
                theme : 'dx.material.orange.dark.compact.css'
            },{
                id     : '6',
                name  : 'Orange Light',
                theme : 'dx.material.orange.light.compact.css'
            },{
                id     : '7',
                name  : 'Purple Dark',
                theme : 'dx.material.purple.dark.compact.css'
            },{
                id     : '8',
                name  : 'Purple Light',
                theme : 'dx.material.purple.light.compact.css'
            },{
                id    : '9',
                name  : 'Teal Dark',
                theme : 'dx.material.teal.dark.compact.css'
            },{
                id    : '10',
                name  : 'Teal Light',
                theme : 'dx.material.teal.light.compact.css'
            },],
    }
];
$(() => {
    getPostDataAsync("/api/auth/userinfo.do", (jsonData)=>{
        window.$userId = jsonData.user_id;
        const uri = `/api/auth/menu-auth/${encodeURIComponent(window.$userId)}`;
        getDataAsync(uri, fetchMenuAuth);
    });

    _dxMenu = $("#menu")
        .dxMenu({
            dataSource: _menuData,
            hideSubmenuOnMouseLeave: true,
            showFirstSubmenuMode: {
                name: "onHover",
                delay: { show: 0, hide: 100 },
            },
            displayExpr: "name",
            submenuDirection: "auto",
            visible: true,
            onItemClick(data) {
                const item = data.itemData;
                if (item.theme) {
                    $(".main-css").attr("href", "./css/" + item.theme);
                }

                if (item.name === "통합모니터링") {
                    document.location.reload();
                    return;
                }
                if (item.name === '문자식/도형식 폼관리') {
                    formMenuClick();
                    return;
                }
                if (item.page) {
                    let handle = _menuHandleMap.get(item.page);
                    if (handle) {
                        if (handle.window) {
                            if (item.page === handle.location.pathname) {
                                handle.focus();
                                return;
                            }
                        }
                    }
                    handle = window.open(item.page, item.name, item.option);
                    _menuHandleMap.set(item.page, handle);
                    if (!_menuHandleMap.get('opened')) {
                        _menuHandleMap.set('opened', new Array());
                    }
                    const openedArr = _menuHandleMap.get('opened');
                    openedArr.push(handle);
                    if (openedArr.length > 5) {
                        openedArr[0].close();
                        openedArr.shift();
                    }
                    handle.focus();
                }
            },
        })
        .dxMenu("instance");
    });
function fetchMenuAuth(jsonData) {
    const menuAuth = jsonData;
    const menuAuthMap = new Map();
    menuAuth.forEach((auth) => {
        if (auth.athr_yn === "Y") {
            menuAuthMap.set(auth.menu_id, auth);
        }
    });
    assignMenuAuth(menuAuthMap);
    menuAuthMap.clear();
}
// function assignMenuAuth(menuMap) {
//     let isAuth;
//     let enableGroup;
//     let enableMenu;
//     _menuDataAll.forEach((group) => {
//         enableGroup = true;
//         if (group.items) {
//             let groupEnableCnt = 0;
//             group.items.forEach((menu) => {
//                 enableMenu = true;
//                 if (menu.items) {
//                     let enableCnt = 0;
//                     // SubMenu
//                     menu.items.forEach((subMenu) => {
//                         isAuth = menuMap.get(subMenu.page);
//                         //isAuth가 있거나 혹은 항상 있어야 하는 거일때만 SubMenu 활성화
//                         subMenu.enable = isAuth ? true : subMenu.always === true;
//                         //비활성화 개수 체크
//                         !subMenu.enable ? enableCnt++ : enableCnt;
//                     });
//                     //전체 비활성화일 경우 메뉴 비활성화
//                     enableMenu = !(enableCnt === menu.items.length);
//                 } else {
//                     isAuth = menuMap.get(menu.page);
//                     //isAuth가 있거나 혹은 항상 있어야 하는 거일때만 menu 활성화
//                     enableMenu = isAuth ? true : menu.always === true;
//                 }
//                 //menu 상태 설정
//                 menu.enable = enableMenu;
//                 //menu 비활성화 개수 체크
//                 !menu.enable ? groupEnableCnt++ : groupEnableCnt;
//             });
//             //menu가 모드 비활성화일 경우 그룹 비활성화
//             enableGroup = !(group.items.length === groupEnableCnt);
//         }
//         if (group.always === true) {
//             enableGroup = true;
//         }
//         group.enable = enableGroup;
//     });
//
//     _menuData = [];
//     _menuDataAll.forEach((group) => {
//         if (group.enable === false) {
//             return;
//         }
//
//         let groupMenu = JSON.parse(JSON.stringify(group));
//         groupMenu.items = [];
//         if (group.items) {
//             group.items.forEach((menu) => {
//                 if (menu.enable === false) {
//                     return;
//                 }
//                 let firstMenu = JSON.parse(JSON.stringify(menu));
//                 if (menu.items) {
//                     firstMenu.items = [];
//                     menu.items.forEach((subMenu) => {
//                         if (subMenu.enable) {
//                             firstMenu.items.push(subMenu);
//                         }
//                     });
//                 }
//                 groupMenu.items.push(firstMenu);
//             });
//         }
//         _menuData.push(groupMenu);
//     });
//     _dxMenu.option('dataSource', _menuData);
// }

function assignMenuAuth(menuMap) {
    let isAuth;
    let enableGroup;
    let enableMenu;
    _menuDataAll.forEach((group) => {
        enableGroup = true;
        if (group.items) {
            let groupEnableCnt = 0;
            group.items.forEach((menu) => {
                enableMenu = true;
                if (menu.items) {
                    let enableCnt = 0;
                    // SubMenu
                    menu.items.forEach((subMenu) => {
                        isAuth = menuMap.get(subMenu.page);
                        //isAuth가 있거나 혹은 항상 있어야 하는 거일때만 SubMenu 활성화
                        subMenu.enable = isAuth ? true : subMenu.always === true;
                        //비활성화 개수 체크
                        !subMenu.enable ? enableCnt++ : enableCnt;
                    });
                    //전체 비활성화일 경우 메뉴 비활성화
                    enableMenu = !(enableCnt === menu.items.length);
                } else {
                    isAuth = menuMap.get(menu.page);
                    //isAuth가 있거나 혹은 항상 있어야 하는 거일때만 menu 활성화
                    enableMenu = isAuth ? true : menu.always === true;
                }
                //menu 상태 설정
                menu.enable = enableMenu;
                //menu 비활성화 개수 체크
                !menu.enable ? groupEnableCnt++ : groupEnableCnt;
            });
            //menu가 모드 비활성화일 경우 그룹 비활성화
            enableGroup = !(group.items.length === groupEnableCnt);
        }
        if (group.always === true) {
            enableGroup = true;
        }
        group.enable = enableGroup;
    });

    _menuData = [];
    _menuDataAll.forEach((group) => {
        if (group.enable === false) {
            return;
        }

        let groupMenu = JSON.parse(JSON.stringify(group));
        groupMenu.items = [];
        if (group.items) {
            group.items.forEach((menu) => {
                if (menu.enable === false) {
                    return;
                }
                let firstMenu = JSON.parse(JSON.stringify(menu));
                if (menu.items) {
                    firstMenu.items = [];
                    menu.items.forEach((subMenu) => {
                        if (subMenu.enable) {
                            firstMenu.items.push(subMenu);
                        }
                    });
                }
                groupMenu.items.push(firstMenu);
            });
        }
        _menuData.push(groupMenu);
    });
    _dxMenu.option('dataSource', _menuData);
}

function formMenuClick(){
    const userId = window.$userId;
    const randKey = new Date().getTime() / 1000;
    const url = "its.vmsFormEdit://" + userId + " " + randKey + " " + window.origin;
    const launcher = new CsAppLauncher({
        onIgnored: function () {
            console.log("browser failed to respond to the deep link");
            confirmMessage("VMS 폼 편집을 사용하시려면 프로그램을 설치하셔야 합니다<br>설치 프로그램을 다운로드 하시겠습니까?").done((yes)=>{
                if (yes === true) {
                    vmsFormEditDownload();
                }
            })
        },
        onFallback: function () {
            console.log("dialog hidden or user returned to tab");
        },
        onReturn: function () {
            console.log("user returned to the page from the native app");
        },
    });
    launcher.openURL(url);
}

