import { currDt } from "/js/utils/common.js";
import { requestGet, apiGet } from "/js/utils/restApi.js";
import { TMapMngr } from "/js/vworld/map-mngr.js";
import { LayerType, LayerIndex } from "/js/vworld/map-const.js";
import { TWebSocket } from "/js/websocket/websocket.js";
import * as BIS from "./main-bis.js";
import { _errorSwitch, getErrorColor } from "./main.js";
export let _mapManager    = null;
let _webSocket            = null;
let _timerFetchFcltStts   = null; // 시설물 상태정보 요청 타이머
let _timerFetchTraffic    = null; // 교통정보 요청 타이머
let _timerFetchIncdData   = null; // 돌발정보 요청 타이머
const requestFetchFcltStts = () => {
    if (_timerFetchFcltStts) window.clearTimeout(_timerFetchFcltStts);
    _timerFetchFcltStts = window.setTimeout(() => fetchFcltStts(), 60 * 1000);
};
const requestFetchTraffic = () => {
    if (_timerFetchTraffic) window.clearTimeout(_timerFetchTraffic);
    _timerFetchTraffic = window.setTimeout(() => fetchTraffic(), 2 * 60 * 1000);
};
const requestFetchIncdData = () => {
    if (_timerFetchIncdData) window.clearTimeout(_timerFetchIncdData);
    _timerFetchIncdData = window.setTimeout(() => fetchIncdData(), 2 * 60 * 1000);
};
let _timerFetchDbmsStts = null; // 데이터베이스 상태정보 요청 타이머
const requestFetchDbmsStts = () => {
    if (_timerFetchDbmsStts) window.clearTimeout(_timerFetchDbmsStts);
    _timerFetchDbmsStts = window.setTimeout(() => fetchDbmsStts(), 5 * 60 * 1000);
};
let _timerFetchUnitStts = null; // 프로세스 상태정보 요청 타이머
const requestFetchUnitStts = () => {
    if (_timerFetchUnitStts) window.clearTimeout(_timerFetchUnitStts);
    _timerFetchUnitStts = window.setTimeout(() => fetchUnitStts(), 1 * 60 * 1000);
};

// 웹소켓 초기화
function websocketConnect(clientType) {
    _webSocket = new TWebSocket(clientType, onSocketReceived, onSocketDisconnected, onSocketError, onSocketConnected);
    _webSocket.connect();
}
function onSocketConnected(AClientType, AMessage) {
    console.log(`${currDt()}: onSocketConnected, ${AClientType}, `, AMessage);
}
function onSocketReceived(AClientType, AMessage) {
    console.log(`${currDt()}: onSocketReceived, ${AClientType}, `, AMessage);
    const command = AMessage.command;
    const jsonData = AMessage.data;
    if (command === "itsFcltStts" || command === "bisFcltStts") {
        updateFcltStts(jsonData);
        if (command === "itsFcltStts") {
            requestFetchFcltStts();
        }
    } else if (command === "itsUnitStts" || command === "bisUnitStts") {
        updateUnitStts(jsonData); //ITS 프로세스
        if (command === "bisUnitStts") {
            requestFetchUnitStts();
        }
    } else if (command === "traffic") {
        // 소통정보 가공완료
        requestFetchTraffic();
    } else if (command === "form-save") {
        // VMS 메시지 생성 저장
    }
}

function onSocketDisconnected(AClientType, AMessage) {
    console.log(`${currDt()}: onSocketDisconnected, ${AClientType}, `, AMessage);
}
function onSocketError(AClientType, AMessage) {
    console.log(`${currDt()}: onSocketError, ${AClientType}, `, AMessage);
}

// function FcltStts(type) {
//     this.type = type;
//     this.total = 0;
//     this.normal = 0;
//     this.error = 0;
//     this.collect = 0;
// }
// const sttsMap = new Map();
// sttsMap.set("CCTV", new FcltStts("CCTV"));
// sttsMap.set("VMS", new FcltStts("VMS"));
// sttsMap.set("VDS", new FcltStts("VDS"));
// sttsMap.set("RSE", new FcltStts("RSE"));
// sttsMap.set("BIT", new FcltStts("BIT"));

export function doMap() {
    // 지도객체 먼저 생성 하여야 함
    _mapManager = new TMapMngr("map", "tooltip");
    onMapMoveEndFunc();
    _mapManager.showLayer(LayerIndex.Cctv, false);
    _mapManager.showLayer(LayerIndex.Vms, false);
    _mapManager.showLayer(LayerIndex.Vds, false);
    _mapManager.showLayer(LayerIndex.Rse, false);
    _mapManager.showLayer(LayerIndex.Bit, false);

    _mapManager.onMapMoveEndFunc = onMapMoveEndFunc; // 지도 이동/줌 변경 이벤트 반환
    _mapManager.onMouseClickFunc = onMouseClickFunc; // 객체 마우스 클릭 이벤트 반환
    _mapManager.onContextMenuFunc = onContextMenuFunc; // 객체 컨텍스트 이벤트 반환
    _mapManager.onSelectObjFunc = onSelectObjFunc; // 객체 선택 이벤트 반환
    _mapManager.onFcltDragEndFunc = onFcltDragEndFunc; // 객체(시설물) 편집시 객체 이동후 좌표 반환

    BIS.initBisMap(); // BIS 용 지도 초기화

    websocketConnect("wall");

    loadingData();
}

function onMapMoveEndFunc(AZoom, ACenterX, ACenterY, ALeft, ABottom, ARight, ATop) {
    //console.log(_mapManager.currZoom) // mapLevel
    //console.log(`${currDt()}: onMapMoveEndFunc, ${AZoom}, ${ACenterX}, ${ACenterY}, ${ALeft}, ${ABottom}, ${ARight}, ${ATop}`);
}
function onMouseClickFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY, X, Y) {
    //console.log(`${currDt()}: onMouseClickFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}, ${X}, ${Y}`);
    const obj = _mapManager.findLayerObject(ALyrIdx, ANmbr);
    if (!obj) {
        return;
    }
    if (ALyrName === "BUS") {
        BIS.busVehicleBottomEvent(obj.order, false);
    } else if (ALyrName === "VMS") {
        fetchVmsDsplMsg(obj.NMBR, obj.NAME, obj.LAT, obj.LNG);
    } else if (ALyrName === "CCTV") {
        //cctvMarkerClick(obj.NAME, obj.strmRtmpAddr, obj.LAT, obj.LNG); // 실무용
        cctvMarkerClick(obj.NAME, obj.strmHttpAddr, obj.LAT, obj.LNG); //개발용
    } else if (ALyrName === "BIT") {
        BIS.leftBitListClick(obj.NMBR, obj.NAME, obj.LAT, obj.LNG, obj.COMM);
    }
}
function onContextMenuFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY, X, Y) {
    console.log(`${currDt()}: onContextMenuFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}, ${X}, ${Y}`);
}
function onSelectObjFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY, X, Y) {
    console.log(`${currDt()}: onSelectObjFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}, ${X}, ${Y}`);
}
function onFcltDragEndFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY) {
    console.log(`${currDt()}: onFcltDragEndFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}`);
}

let _timerFetchWeatherStts = null;
const requestFetchWeatherStts = () => {
    if (_timerFetchWeatherStts) window.clearTimeout(_timerFetchWeatherStts);
    _timerFetchWeatherStts = window.setTimeout(() => fetchWeatherStts(), 1 * 60 * 1000)
}

function loadingData() {
    fetchBaseData(); //vertex, traffic(clock)
    fetchFcltData();
    fetchIncdData(); // 돌발정보 요청
    fetchUnitStts();
    fetchDbmsStts();
    fetchWeatherStts();
}

/**
 * Promise.all 사용해서 하나라도 오류가 발생하면 다음 함수가 실행되지 않도록 한다.
 * 개별 오류 catch 하면 다음 작업에서 계속 오류가 발생(객체를 찾지 못함)하기 때문에
 * 아예 다음작업이 수행되지 않도록 catch 를 한번 만 잡는다.
 * 즉, 오류가 발생하면 그냥 오류 발생 후 다음 작업이 진행되지 않도록 한다.
 */
async function fetchBaseData() {
    if (_timerFetchTraffic) window.clearTimeout(_timerFetchTraffic);
    //console.time("***** fetchBaseData: ");
    const ifsc = apiGet("/api/database/ifsc/list"); // 링크정보 요청
    const road = apiGet("/api/database/road/list"); // 도로정보 요청
    Promise.all([ifsc, road])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            //console.log(`${currDt()}: BaseData, IFSC(${values[0].length}), ROAD(${values[1].length})`);

            _mapManager.makeTrafficObject(LayerType.IFSC, values[0]);
            _mapManager.makeTrafficObject(LayerType.ROAD, values[1]);

            fetchTraffic();
            fetchBaseVrtx();
        })
        .catch((err) => {
            console.error(`${currDt()}: Error in fetchBaseData ${err}`);
        })
        .finally
        //() => console.timeEnd("***** fetchBaseData: ")
        ();
}


const gradMap = new Map();
gradMap.set("1", {
    text : '좋음',
    color : '#03a9f4',
});
gradMap.set("2", {
    text : '보통',
    color : '#15B337',
});
gradMap.set("3", {
    text : '보통',
    color : '#FFAA00',
});
gradMap.set("4", {
    text : '매우나쁨',
    color : '#ff0000',
});

function atmpInterval(jsonData){
    const data  = jsonData;
    const empty = $('.atmp-empty'); 
    const stts  = $('.atmp-status'); 
    empty.css('display', 'none');
    stts.css('display', 'flex');
    if (data) {
        let   name      = data.atmpsttnnm;
              name      = name ? name : '-';
        let   pm10Val   = data.pm10_val;
              pm10Val   = pm10Val ? pm10Val : '-';
        let   pm25Val   = data.pm25_val;
              pm25Val   = pm25Val ? pm25Val : '-';
        const pm10      = gradMap.get(data.pm10_1hh_grad);
        const pm25      = gradMap.get(data.pm25_1hh_grad);
        const pm10Color = pm10? pm10.color : 'white';
        const pm25Color = pm25? pm25.color : 'white';
        const pm10Text  = pm10? pm10.text  : ''; 
        const pm25Text  = pm25? pm25.text  : '';
        const pm10Div   = $('.pm10_val');
        const pm10Grad  = $('.pm10_grad');
        const pm25Div   = $('.pm25_val');
        const pm25Grad  = $('.pm25_grad') ;
        const nameDiv   = $('.atmpsttnnm');
        const pm10Title = $('.pm10_title');
        const pm25Title = $('.pm25_title');
        nameDiv.text(name);
        pm10Title.html('미세먼지 : ');
        pm10Div.html(pm10Val + ' ㎍/㎥ ');
        pm10Grad.html(pm10Text);
        pm25Title.text('초미세먼지 : ');
        pm25Div.text(pm25Val + ' ㎍/㎥');
        pm25Grad.text(pm25Text);
        const pm10Arr = [
            pm10Div,
            pm10Grad,
        ]
        const pm25Arr = [
            pm25Div,
            pm25Grad,
        ]

        for (let obj of pm10Arr) {
            obj.css('color', pm10Color);
        }

        for (let obj of pm25Arr) {
            obj.css('color', pm25Color);
        }
    }
    else {
        empty.css('display', 'flex');
        stts.css('display', 'none');
    }
}


async function fetchTraffic() {
    //console.time("***** fetchTraffic: ");
    const ifsc = apiGet("/api/manage/main/traffic/ifsc"); // 링크소통정보 요청
    const road = apiGet("/api/manage/main/traffic/road"); // 도로소통정보 요청
    Promise.all([ifsc, road])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            //console.log(`${currDt()}: Traffic, IFSC(${values[0].length}), ROAD(${values[1].length})`);

            _mapManager.updateTrafficObject(LayerType.IFSC, values[0]);
            _mapManager.updateTrafficObject(LayerType.ROAD, values[1]);
        })
        .catch((err) => {
            console.error(`Error in fetchTraffic ${err}`);
        })
        .finally
        //() => console.timeEnd("***** fetchTraffic: ")
        ();

    requestGet("/api/its/common/congest-traffic", recvCongestTraffic);
    //requestGet("/api/its/common/weather/frcs/status", recvWeatherInfo);
    //requestGet("/api/its/common/weather/atmp/status", recvAtmpInfo);
}

async function fetchWeatherStts() {
    const frcs = apiGet("/api/its/common/weather/frcs/status"); // 링크소통정보 요청
    const atmp = apiGet("/api/its/common/weather/atmp/status"); // 도로소통정보 요청
    Promise.all([frcs, atmp])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            recvWeatherInfo(values[0]);
            recvAtmpInfo(values[1]);
        })
        .catch((err) => {
            console.error(`Error in fetchTraffic ${err}`);
        })
    requestFetchWeatherStts();
}

let atmpTimer = null;
function recvAtmpInfo(jsonData) {
    if (atmpTimer) {
        window.clearInterval(atmpTimer);
    }
    let cnt = 0;
    let data = jsonData[cnt++];
    atmpInterval(data);

    atmpTimer = setInterval(() => {
        if (cnt === jsonData.length) {
            cnt = 0;
        }
        const data = jsonData[cnt++];
        atmpInterval(data);
    }, 6000);
}

let _rollingCongestTimer = null;
function recvCongestTraffic(jsonData) {
    if (_rollingCongestTimer) window.clearTimeout(_rollingCongestTimer);
    let tHtml = "";
    jsonData.forEach((obj) => {
        tHtml += "<li>";
        tHtml += '	<strong class="traffic-info">[' + obj.atrd_nm + "]</strong>";
        tHtml += '	<div style="float:right">';
        if (obj.cmtr_grad_cd == "LTC1") tHtml += '<strong class="traffic-condition1">' + obj.cmmn_cd_kor_nm + " [" + obj.sped + "km/h]</strong>";
        if (obj.cmtr_grad_cd == "LTC2") tHtml += '<strong class="traffic-condition2">' + obj.cmmn_cd_kor_nm + " [" + obj.sped + "km/h]</strong>";
        if (obj.cmtr_grad_cd == "LTC3") tHtml += '<strong class="traffic-condition3">' + obj.cmmn_cd_kor_nm + " [" + obj.sped + "km/h]</strong>";
        tHtml += "	</div>";
        tHtml += '	<div class="traffic-location">';
        tHtml += '    <font style="width:160px;display:block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;float:left">' + obj.strt_nm + "</font>";
        tHtml += '    <font style="position:absolute;width:10px"> → </font>';
        tHtml +=
            '    <font style="position:relative;width:180px;display:block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;left:19px;float:left">' +
            obj.end_nm +
            "</font>";
        tHtml += '    <font style="position:absolute;width:50px;right:10px">' + obj.sect_lngt + "km</font>";
        tHtml += "  </div>";
        tHtml += "</li>";
    });

    setHtml(".traffic-list", tHtml);

    // 요청시간을 기준으로 교통정보 요청 타이머 리셋
    requestFetchTraffic();
    // 우측하단 정체정보 롤링 호출
    trafficRolling();
}

function trafficRolling() {
    let liNum; // li태그 size의 수
    let rollingNum; // 화면에 보여지는 li 갯수 (1묶음 3개)
    let visualNum; //
    liNum = $(".traffic-con").children(".traffic-list").children("li").length;

    if (liNum % 3 == 0) {
        rollingNum = liNum / 3;
    } else if (liNum % 3 == 1) {
        rollingNum = parseInt(liNum / 3) + 1;
    } else if (liNum % 3 == 2) {
        rollingNum = parseInt(liNum / 3) + 2;
    }

    function visualTime() {
        if (visualNum < rollingNum - 2) {
            visualNum += 2;
        } else if (visualNum < rollingNum - 1) {
            visualNum++;
        } else {
            visualNum = 0;
        }
        $(".traffic-list").animate({ top: -96 * visualNum + "px" }, 600, "swing");
        _rollingCongestTimer = window.setTimeout(() => visualTime(), 3 * 1000);
    }
    visualTime();
    //setInterval(visualTime, 3 * 1000);
}

// function recvWeatherInfo(jsonData) {
//     let imgUrl = null;
//     let str = "";
//     let cnt = 0;
//     if (jsonData.length == 0) {
//         imgUrl = "정보없음";
//         str += "<span style='font-size: 20px;'> " + imgUrl + "</span>";
//         setHtml(".weather", str);
//     }
//     const data = jsonData[cnt++];
//     if (data) {
//         if      (data.wtcd_kor_cd == "DB01") imgUrl = "맑음";
//         else if (data.wtcd_kor_cd == "DB02") imgUrl = "구름조금";
//         else if (data.wtcd_kor_cd == "DB03") imgUrl = "구름많음";
//         else if (data.wtcd_kor_cd == "DB04") imgUrl = "흐림";
//         else if (data.wtcd_kor_cd == "DB05") imgUrl = "비";
//         else if (data.wtcd_kor_cd == "DB06") imgUrl = "비/눈";
//         else if (data.wtcd_kor_cd == "DB07") imgUrl = "눈";
//         else imgUrl = "정보없음";
//         str += "<li style='height:100%;''>";
//         str += "<span style='font-size: 20px;'>" + data.vilg_frcs_zone_nm + "</span> ";
//         str += "<span style='font-size: 21px;'>" + data.prst_tmpr + "℃ </span>";
//             //str += "<span style='font-size: 20px;'> , " + imgUrl + "</span>";
//         str += '<img src="/images/application_wall/weather/' + data.wtcd_kor_cd + '.png" style="padding-left:2px;padding-top:3px" alt="날씨이미지" />';
//         str += "</li>";
//     }
//     else {
//         str += "<span> 0℃ </span>";
//         str += '<img src="/images/application_wall/weather/DB99.png" style="padding-left:10px;padding-top:5px" alt="날씨이미지" />';
//     }

//     jsonData.forEach((el) => {
//         if (el.length != 0) {
//             if (el.wtcd_kor_cd == "DB01") imgUrl = "맑음";
//             else if (el.wtcd_kor_cd == "DB02") imgUrl = "구름조금";
//             else if (el.wtcd_kor_cd == "DB03") imgUrl = "구름많음";
//             else if (el.wtcd_kor_cd == "DB04") imgUrl = "흐림";
//             else if (el.wtcd_kor_cd == "DB05") imgUrl = "비";
//             else if (el.wtcd_kor_cd == "DB06") imgUrl = "비/눈";
//             else if (el.wtcd_kor_cd == "DB07") imgUrl = "눈";
//             else imgUrl = "정보없음";

//             str += "<li style='height:100%;''>";
//             str += "<span style='font-size: 20px;'>" + el.vilg_frcs_zone_nm + "</span> ";
//             str += "<span style='font-size: 21px;'>" + el.prst_tmpr + "℃ </span>";
//             //str += "<span style='font-size: 20px;'> , " + imgUrl + "</span>";
//             str += '<img src="/images/application_wall/weather/' + el.wtcd_kor_cd + '.png" style="padding-left:2px;padding-top:3px" alt="날씨이미지" />';
//             str += "</li>";
//         } else {
//             str += "<span> 0℃ </span>";
//             str += '<img src="/images/application_wall/weather/DB99.png" style="padding-left:10px;padding-top:5px" alt="날씨이미지" />';
//         }
//     });

//     setHtml(".weather", str);
// }


let _weatherTimer = null;
function recvWeatherInfo(jsonData) {
    if (_weatherTimer) {
        window.clearInterval(_weatherTimer);
    }
    let cnt = 0;
    const data = jsonData[cnt++];
    weatherInterval(data);

    _weatherTimer = setInterval(() => {
        weatherInterval(jsonData[cnt++]);
        if (cnt === jsonData.length) {
            cnt = 0;
        }
    }, 6000);
}

function weatherInterval(data) {
    const empty = $('.weather-empty');
    const stts  = $('.weather-status');
    
    stts.css('display', 'flex');
    empty.css('display', 'none');
    
    if (data) {
        //지역명, 온도, 날씨 코드 유효성 체크 후 넣어 준다.
        let name = data.vilg_frcs_zone_nm;
            name = name ? data.vilg_frcs_zone_nm : '-';
        let tmpr = data.prst_tmpr;
            tmpr = tmpr ? tmpr : '0';
        let img  = data.wtcd_kor_cd;
            img  = img ? img : 'DB99';
        $('.weather-text').text(name + ' ' + tmpr + "℃ " );
        $('.weather-img').prop('src',"/images/application_wall/weather/" + img + ".png");
    }
    else {
        empty.css('display', 'flex');
        stts.css('display', 'none');
    }
}

// .weather에 li값이 없을경우 weatherRolling()을 호출하면 값이 없어서 무의미. 그래서 settime 걸어줌
// let wetherLiNum = $(".weather").children("li").length;
// if (wetherLiNum == 0) {
//     setTimeout(weatherRolling, 1 * 1000);
// } else {
//     weatherRolling();
// }
// function weatherRolling() {
//     let liNum; // li태그 size의 수
//     let visualNum = 0; //화면에 보여지는 li 갯수 (1묶음 1개)
//     liNum = $(".weather").children("li").length;

//     function visualTime() {
//                // weather.animate({ opacity: 0 }, 500);
//         if (visualNum < liNum - 1) {
//             visualNum++;
//         } else if (visualNum == liNum - 1) {
//             visualNum = 0;
//         }
//        // weather.css({top: - 32 * visualNum + "px"});

//        // weather.animate({ opacity: 1 }, 500);
//        $(".weather").animate({ top: -32 * visualNum + "px" }, 600, "swing");
//     }

//     setInterval(visualTime, 6 * 1000);
// }

async function fetchBaseVrtx() {
    //console.time("***** fetchBaseVrtx: ");

    // 버텍스를 표출할 레벨을 설정한다.
    _mapManager.setLayerVisible(LayerIndex.Ifsc1, 17, 18, 19);
    _mapManager.setLayerVisible(LayerIndex.Ifsc2, 14, 15, 16);
    _mapManager.setLayerVisible(LayerIndex.Road1, 10, 11);
    _mapManager.setLayerVisible(LayerIndex.Road2, 12, 13);

    const ifsc3 = apiGet("/api/manage/main/map/vrtx/ifsc/3"); // 버텍스정보 요청(3 => 15)
    const ifsc4 = apiGet("/api/manage/main/map/vrtx/ifsc/4"); // 버텍스정보 요청(4 => 14)
    const road5 = apiGet("/api/manage/main/map/vrtx/road/5"); // 버텍스정보 요청(5 => 13)
    const road6 = apiGet("/api/manage/main/map/vrtx/road/6"); // 버텍스정보 요청(6 => 10, 11, 12)
    Promise.all([ifsc3, ifsc4, road5, road6])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            //console.log(`${currDt()}: FcltData, IFSC3(${values[0].length}), IFSC4(${values[1].length}), ROAD5(${values[2].length}), ROAD6(${values[3].length})`);

            _mapManager.makeLayer(LayerIndex.Ifsc1, values[0]);
            _mapManager.makeLayer(LayerIndex.Ifsc2, values[1]);
            _mapManager.makeLayer(LayerIndex.Road1, values[2]);
            _mapManager.makeLayer(LayerIndex.Road2, values[3]);

            //fetchFcltStts();
        })
        .catch((err) => {
            console.error(`Error in fetchBaseVrtx ${err}`);
        })
        .finally
        //() => console.timeEnd("***** fetchBaseVrtx: ")
        ();
}

async function fetchFcltData() {
    //console.time("***** fetchFcltData: ");
    console.log("LayerIndex.Cctv = " + LayerIndex.Cctv);
    const cctv = apiGet("/api/cctv/common/cctv-list"); // CCTV
    const vms = apiGet("/api/vms/common/vms-list"); // VMS
    const vds = apiGet("/api/vds/common/vds-list"); // VDS
    //const rse = apiGet("/api/utis/rse"); // RSE
    const bit = apiGet("/api/bis/bit"); // BIT
    Promise.all([cctv, vms, vds, bit])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            //console.log(`${currDt()}: FcltData, CCTV(${values[0].length}), VMS(${values[1].length}), VDS(${values[2].length}), RSE(${values[3].length}), BIT(${values[4].length})`);
            _mapManager.makeLayer(LayerIndex.Cctv, values[0]);
            _mapManager.makeLayer(LayerIndex.Vms,  values[1]);
            _mapManager.makeLayer(LayerIndex.Vds,  values[2]);
            //_mapManager.makeLayer(LayerIndex.VdsDet, values[2]);
            //_mapManager.makeLayer(LayerIndex.Rse, values[3]);
            _mapManager.makeLayer(LayerIndex.Bit, values[3]);
            fetchFcltStts();
        })
        .catch((err) => {
            console.error(`Error in fetchFcltData ${err}`);
        })
        .finally
        //() => console.timeEnd("***** fetchFcltData: ")
        ();
}

export let _fcltData = null;
// 시설물현황 상태정보 요청(타이머 또는 웹소켓에 의해 실행됨)
async function fetchFcltStts() {
    //console.time("***** fetchFcltStts: ");

    if (_timerFetchFcltStts) window.clearTimeout(_timerFetchFcltStts);
    const its = apiGet("/api/common/stts/total"); // ITS 상태정보 요청
    const bit = apiGet("/api/bis/stts/bit/total"); // BIT 상태정보 요청

    Promise.all([its, bit])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            //console.log(`${currDt()}: FcltStts, ITS(${values[0].fclt_list.length}), BIT(${values[1].fclt_list.length})`);
            _fcltData = [values[0], values[1]];
            updateFcltStts(values[0]);
            updateFcltStts(values[1]);
        })
        .catch((err) => {
            console.error(`Error in fetchFcltStts ${err}`);
        })
        .finally
        //() => console.timeEnd("***** fetchFcltStts: ")
        ();

    // 요청시간을 기준으로 상태정보 요청 타이머 리셋
    requestFetchFcltStts();
}

export function updateFcltStts(jsonData) {
    jsonData.fclt_list.forEach((el) => {
        let lyrInfo = null;
        //const stts = sttsMap.get(el.fclt_type);
        let toNumber = false;
        if (el.fclt_type === "CCTV") {
            lyrInfo = _mapManager.getLayer(LayerIndex.Cctv);
            toNumber = true;
        } else if (el.fclt_type === "VMS") {
            lyrInfo = _mapManager.getLayer(LayerIndex.Vms);
            toNumber = true;
        } else if (el.fclt_type === "VDS") {
            lyrInfo = _mapManager.getLayer(LayerIndex.Vds);
        } else if (el.fclt_type === "RSE") {
            lyrInfo = _mapManager.getLayer(LayerIndex.Rse);
        } else if (el.fclt_type === "BIT") {
            lyrInfo = _mapManager.getLayer(LayerIndex.Bit);
        }
        if (lyrInfo) {
            // stts.total = el.total_cnt;
            // stts.normal = el.normal_cnt;
            // stts.error = el.error_cnt;
            // stts.collect = el.col_err_cnt;
            const error    = $("#" + el.fclt_type + "_error");
            const colError = $("#" + el.fclt_type + "_colerr");
            if (!_errorSwitch) {
                setHtml("#" + el.fclt_type + "_total", el.total_cnt);
                setHtml("#" + el.fclt_type + "_normal", el.normal_cnt);
                setHtml("#" + el.fclt_type + "_error", el.error_cnt);
                setHtml("#" + el.fclt_type + "_colerr", el.col_err_cnt);
                error.css('color', getErrorColor(el.error_cnt));
                colError.css('color', getErrorColor(el.col_err_cnt));
            }
            else {
                setHtml("#" + el.fclt_type + "_total", el.total_cnt);
                setHtml("#" + el.fclt_type + "_normal", el.total_cnt);
                setHtml("#" + el.fclt_type + "_error", 0);
                setHtml("#" + el.fclt_type + "_colerr", 0);
                error.css('color', 'white');
                colError.css('color', 'white');
            }
            
            el.fclt_objs.forEach((obj) => {
                const fclt = lyrInfo.findObject(toNumber ? Number(obj.fclt_nmbr) : obj.fclt_nmbr);
                if (fclt) {
                    if (_errorSwitch) {
                        fclt.updateStts("CMS0", obj.updt_dt);
                    }
                    else {
                        fclt.updateStts(obj.stts_cd, obj.updt_dt);
                    }
                } else {
                    console.warn(`fetchFcltStts: Not Found Object, ${obj.fclt_type}, ${obj.fclt_nmbr}, ${obj.fclt_id}`);
                }
            });
        } else {
            console.error(currDt(), " Unknown Fclt Type: ", el.fclt_type);
        }
    });
}

// 돌발정보 수신
function recvIncdData(AJsonData) {
    //console.log(`${currDt()}: recvIncdData: ${AJsonData.length} EA.`);
    _mapManager.makeLayer(LayerIndex.Incd, AJsonData); // 레이어 생성
    //console.timeEnd("***** recvIncdData: ");
}
// 돌발정보요청
function fetchIncdData() {
    if (_timerFetchIncdData) window.clearTimeout(_timerFetchIncdData);
    //console.time("***** fetchIncdData: ");
    requestGet("/api/manage/main/syst-opr/incd-ocrr", recvIncdData);

    // 요청시간을 기준으로 돌발정보 요청 타이머 리셋
    requestFetchIncdData();
}

export let _itsData = null;
export let _bisData = null;
// 센터프로세스 상태정보 요청(타이머 또는 웹소켓에 의해 실행됨)
export async function fetchUnitStts() {
    if (_timerFetchUnitStts) window.clearTimeout(_timerFetchUnitStts);
    //console.time("***** fetchUnitStts: ");

    const its = apiGet("/api/common/stts/process/its"); // 센터프로세스 ITS
    const bis = apiGet("/api/bis/stts/process"); // 센터프로세스 BIT

    $("#windowPopList").empty();

    Promise.all([its, bis])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            _itsData = values[0];
            _bisData = values[1];
            //console.log(`${currDt()}: UnitStts, ITS(${values[0].length}), BIS(${values[1].length})`);
            updateUnitStts(_itsData); //ITS 프로세스
            updateUnitStts(_bisData); //BIS 프로세스
            
        })
        .catch((err) => {
            console.error(`Error in fetchUnitStts ${err}`);
        })
        .finally
        //() => console.timeEnd("***** fetchUnitStts: ")
        ();

    $("#windowPopClose")
        .off()
        .on("click", function () {});
    $("#windowPopClose").on("click", function () {
        $("#windowPop").css("visibility", "hidden");
        $("#windowPopList").empty();
        let stop = document.getElementsByName("windowPopCheckValue")[0].checked;
        if (stop) {
            _windowPopFlag = false;
            console.log("_windowPopFlag=" + _windowPopFlag);
        }
    });

    // 요청시간을 기준으로 상태정보 요청 타이머 리셋
    requestFetchUnitStts();
}

export function updateUnitStts(jsonData) {
    jsonData.forEach((obj) => {
        const runStts = obj.run_sts.slice(-1);
        let comStts = obj.com_sts.slice(-1);
        //let dbStts = obj.db_sts.slice(-1);
        if (runStts == "1") {
            comStts = "1";
            //dbStts = "1";
        }
        if (_errorSwitch) {
            comStts = "0";
        }
        const comImg = "<img class='ballImg' src='/images/application_wall/stts" + comStts + ".png'>";
        //const dbImg = "<img src='/images/application_wall/stts" + dbStts + ".png'>";
        setHtml(".A" + obj.syst_id + "_server", comImg);

        if (comStts == null || comStts == "1" || comStts == "2") {
            if (
                obj.syst_id == "CTV01" ||
                obj.syst_id == "EXT01" ||
                obj.syst_id == "MOCT01" ||
                obj.syst_id == "UTP01" ||
                obj.syst_id == "VDS01" ||
                obj.syst_id == "VMS01" ||
                obj.syst_id == "WEB01" ||
                obj.syst_id == "10901" ||
                obj.syst_id == "11001" ||
                obj.syst_id == "11101" ||
                obj.syst_id == "11201" ||
                obj.syst_id == "80101" ||
                obj.syst_id == "80102" ||
                obj.syst_id == "90101" ||
                obj.syst_id == "90102" ||
                obj.syst_id == "90103" ||
                obj.syst_id == "90104" ||
                obj.syst_id == "90105" ||
                obj.syst_id == "90201" ||
                obj.syst_id == "90202" ||
                obj.syst_id == "90203" ||
                obj.syst_id == "90204" ||
                obj.syst_id == "90205"
            ) {
                windowPop(obj.syst_id);
            }
        }
    });
}

// DBMS 프로세스 상태정보 요청(타이머 또는 웹소켓에 의해 실행됨)
export async function fetchDbmsStts() {
    if (_timerFetchDbmsStts) window.clearTimeout(_timerFetchDbmsStts);
    //console.time("***** fetchDbmsStts: ");

    const dbms = apiGet("/api/common/stts/dbms"); // DBMS STTS

    Promise.all([dbms])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            //console.log(`${currDt()}: DbmsStts, ${values[0].length}`);
            updateDbmsStts(values[0]); //ITS 프로세스
        })
        .catch((err) => {
            console.error(`Error in fetchDbmsStts ${err}`);
        })
        .finally
        //() => console.timeEnd("***** fetchDbmsStts: ")
        ();

    // 요청시간을 기준으로 상태정보 요청 타이머 리셋
    requestFetchDbmsStts();
}
function updateDbmsStts(jsonData) {
    jsonData.forEach((obj) => {
        const useSession = $("." + obj.db_svr_id + "_USE_SESN");
        setHtml(useSession, obj.use_sesn + " %");
    });
}

function setHtml(tagClass, tagValue) {
    const tag = $(tagClass);
    if (tag) {
        tag.html(tagValue);
    } else {
        console.error(`Not found tag: ${tagClass}`);
    }
}
export function setInnerText(tagId, tagData) {
    const tag = document.getElementById(tagId);
    if (tag) {
        tag.innerText = tagData;
    }
}

let _windowPopFlag = true;
function windowPop(SYST_ID) {
    let id;
    if (SYST_ID === "CTV01") id = "CCTV서버";
    else if (SYST_ID === "EXT01") id = "기상청";
    else if (SYST_ID === "MOCT01") id = "민간정보연계";
    else if (SYST_ID == "UTP01") id = "교통정보가공";
    else if (SYST_ID === "VDS01") id = "VDS서버";
    else if (SYST_ID === "VMS01") id = "VMS서버";
    else if (SYST_ID === "WEB01") id = "인터넷";
    else if (SYST_ID === "10901") id = "BIS자료구축";
    else if (SYST_ID === "11001") id = "BIS예측정보";
    else if (SYST_ID === "11101") id = "BIS패턴처리";
    else if (SYST_ID === "11201") id = "BIS통계처리";
    else if (SYST_ID === "80101") id = "위치가공1";
    else if (SYST_ID === "80102") id = "위치가공2";
    else if (SYST_ID === "90101") id = "정보제공1";
    else if (SYST_ID === "90102") id = "정보제공2";
    else if (SYST_ID === "90103") id = "정보제공3";
    else if (SYST_ID === "90104") id = "정보제공4";
    else if (SYST_ID === "90105") id = "정보제공5";
    else if (SYST_ID === "90201") id = "BIT통신1";
    else if (SYST_ID === "90202") id = "BIT통신2";
    else if (SYST_ID === "90203") id = "BIT통신3";
    else if (SYST_ID === "90204") id = "BIT통신4";
    else if (SYST_ID === "90205") id = "BIT통신5";

    const d = new Date();
    const mTime =
        d.getFullYear() +
        "/" +
        (d.getMonth() + 1 > 9 ? (d.getMonth() + 1).toString() : "0" + (d.getMonth() + 1)) +
        "/" +
        (d.getDate() > 9 ? d.getDate().toString() : "0" + d.getDate().toString()) +
        " " +
        (d.getHours() > 9 ? d.getHours().toString() : "0" + d.getHours().toString()) +
        ":" +
        (d.getMinutes() > 9 ? d.getMinutes().toString() : "0" + d.getMinutes().toString()) +
        ":" +
        (d.getSeconds() > 9 ? d.getSeconds().toString() : "0" + d.getSeconds().toString());

    let windowPopList = '<tr id ="windowPopListValue">' + "   <td>" + mTime + "</td>" + "   <td>" + id + "</td>" + "   <td> 이상 </td>" + "</tr>";

    if (_windowPopFlag) {
        $("#windowPopList").append(windowPopList);
        $("#windowPop").css("visibility", "visible");
    }
}

/**
 * VMS marker click 시 popup 표출
 */
function fetchVmsDsplMsg(vmsNmbr, name, x, y) {
    // 기존 VMS 표출창이 열려 있으면 닫는다.
    initVmsMsgDsplMsg(name, x, y);
    requestGet("/api/vms/common/vms-form/dspl-prst?id=" + vmsNmbr, recvVmsDsplMsg);
}
let _timerVmsMsgDslp = null;
let _vmsDsplMsgArr = [];
let _vmsDsplMsgPhase = 0;
const _vmsWidthReserved = 10;
function initVmsMsgDsplMsg(name, x, y) {
    if (_timerVmsMsgDslp) window.clearTimeout(_timerVmsMsgDslp);
    _timerVmsMsgDslp = null;
    _vmsDsplMsgArr = [];
    _vmsDsplMsgPhase = 0;

    let divWidth;
    let iwContent;
    divWidth = 225 + _vmsWidthReserved;
    iwContent =
        '<div class="map_popup_vms" style="width:' +
        divWidth +
        'px;background-image:url(/images/application_wall/vmsview.png);">' +
        "<dl>" +
        "<dt>" +
        '<p style="color:#c8c8c8;font-family:굴림,Gulim">' +
        name +
        "</p>" +
        '<p style="float:right;color:#000"><a href="#" id="vmsImg"><img src="/images/application_wall/xbtn.png"/></a></p>' +
        "</dt>" +
        "<dd>" +
        '<p style="color:#c8c8c8;font-family:굴림,Gulim;background-image:url(/images/application_wall/vmsnodata.png);width:220px;height:50px;padding-top:25px" align="center">데이터 없음</p>' +
        "</dd>" +
        "</dl>" +
        "</div>";
    $("#vmsOverlay").html(iwContent);
    BIS._vmsOverlay.setPosition([x, y]);

    $("#vmsImg").on("click", function () {
        if (_timerVmsMsgDslp) window.clearTimeout(_timerVmsMsgDslp);
        _timerVmsMsgDslp = null;
        _vmsDsplMsgArr = [];
        _vmsDsplMsgPhase = 0;

        BIS._vmsOverlay.setPosition(undefined);
        $("#vmsOverlay").empty();
    });
}
function recvVmsDsplMsg(jsonData) {
    if (jsonData.length == 0) {
        return;
    }
    const vmsNmbr = jsonData[0].vms_ctlr_nmbr;
    const imgWidth = jsonData[0].vms_wdth;
    const imgHeight = jsonData[0].vms_hght;
    const divWidth = imgWidth + _vmsWidthReserved;

    _vmsDsplMsgArr = jsonData[0].msgs;
    let iwContent =
        '<div class="map_popup_vms" style="width:' +
        divWidth +
        'px;background-image:url(/images/application_wall/vmsview.png);" id="vms' +
        vmsNmbr +
        '">' +
        "<dl>" +
        "<dt>" +
        '<p style="color:#c8c8c8;font-family:굴림,Gulim">' +
        jsonData[0].vms_nm +
        "</p>" +
        '<p style="float:right;color:#000"><a href="#" id="vmsImg"><img src="/images/application_wall/xbtn.png"/></a></p>' +
        "</dt>" +
        "<dd>";
    iwContent += '<p><img id="vmsPhaseImg" src="data:image/png;base64,' + _vmsDsplMsgArr[0].vms_dspl_msg_imag + '" height="' + imgHeight + '" class="vmsPic"/></p>';
    iwContent += "</dd>" + "</dl>" + "</div>";
    $("#vmsOverlay").html(iwContent);

    $("#vmsImg").on("click", function () {
        if (_timerVmsMsgDslp) window.clearTimeout(_timerVmsMsgDslp);
        _timerVmsMsgDslp = null;
        _vmsDsplMsgArr = [];
        _vmsDsplMsgPhase = 0;

        BIS._vmsOverlay.setPosition(undefined);
        $("#vmsOverlay").empty();
    });
    displayVmsDsplMsg();
}
function displayVmsDsplMsg() {
    if (_timerVmsMsgDslp) window.clearTimeout(_timerVmsMsgDslp);
    if (_vmsDsplMsgPhase >= _vmsDsplMsgArr.length) {
        _vmsDsplMsgPhase = 0;
    }
    const vmsMsg = _vmsDsplMsgArr[_vmsDsplMsgPhase++];
    const vmsImg = "data:image/png;base64," + vmsMsg.vms_dspl_msg_imag;
    $("#vmsPhaseImg").attr("src", vmsImg);
    _timerVmsMsgDslp = window.setTimeout(() => displayVmsDsplMsg(), 3 * 1000);
}

/**
 * CCTV marker click 시 popup 표출
 */
function cctvMarkerClick(ISTL_LCTN_NM, STRM_RTMP_ADDR, x, y) {
    cctvPopupInfoBox(ISTL_LCTN_NM, STRM_RTMP_ADDR, x, y);
}
let videojsCheck = false;
function cctvPopupInfoBox(ISTL_LCTN_NM, STRM_RTMP_ADDR, x, y) {
    $("#cctvOverlay").empty();
    BIS._cctvOverlay.setPosition(undefined);

    if (videojsCheck) {
        videojs("video").dispose();
        BIS._cctvOverlay.setPosition(undefined);
    }
    videojsCheck = true;

    let coordHtml =
        '<div id="map_popup_cctv" class="map_popup_cctv" style="z-index:10">' +
        "<dl>" +
        '<dt style="padding:5px 0 5px 0">' +
        '<p style="color:#c8c8c8;padding-left:5px;font-size:15px;font-family:굴림,Gulim">' +
        ISTL_LCTN_NM +
        "</p>" +
        '<p class="fr black" style="position:absolute;top:10px;left:180px;color:#c8c8c8;font-size:12px;font-family:굴림,Gulim">남은시간 : <span id="restTime">30</span>&nbsp;초&nbsp;</p>' +
        '<a href="#" style="position:absolute;top:5px;right:5px" id="cctvImg">' +
        '<img style="z-index:20" src="/images/application_wall/xbtn.png" alt="CCTV영상닫기"/></a></p>' +
        "</dt>" +
        '<p align="center"><video id="video" class="video-js" style="object-fit:fill; width=100%; height=100%;" preload="auto" width="300" height="240"></video></p>' +
        "</dl>" +
        "</div>";

    $("#cctvOverlay").html(coordHtml);
    BIS._cctvOverlay.setPosition([x, y]);
    openCCTV(STRM_RTMP_ADDR);

    $("#cctvImg").on("click", function () {
        $("#cctvOverlay").empty();
        BIS._cctvOverlay.setPosition(undefined);
        videojs("video").dispose();
        clearCctvInterval();
        videojsCheck = false;
    });

    $("#map_popup_cctv").draggable(); //팝업끌기 UI jQuery기능

    let cctvOffset = $("#map_popup_cctv").offset();
    console.log("cctvOffset = " + JSON.stringify(cctvOffset));

    if (cctvOffset.top < 164) {
        $("#map_popup_cctv").parent().css("margin-top", "-20px");
    }
    if (cctvOffset.left > 1570) {
        $("#map_popup_cctv").parent().css("margin-left", "-310px");
    }
    if (cctvOffset.top > 427) {
        $("#map_popup_cctv").parent().css("margin-top", "-250px");
    }
}
function openCCTV(cctvUrl) {
    //	    var player =
    videojs("video", {
        sources: [
            {
                src: cctvUrl,
                type: "application/x-mpegURL",
                crossorigin: "anonymous",
            },
        ],
        responsive: false,
        autoplay: true,
        muted: true,
        preload: "metadata",
    });
    showCCtvDisplayTime();
}
function showCCtvDisplayTime() {
    clearCctvInterval();
    timerInterval = setInterval(calcCCtvDisplayTime, 1000);
}
var displaySecond = 31;
var timerInterval = null;
function clearCctvInterval() {
    displaySecond = 30;
    if (timerInterval != null) {
        clearInterval(timerInterval);
    }
}
function calcCCtvDisplayTime() {
    if (displaySecond > 0) {
        displaySecond--;
        $("#restTime").text(displaySecond);
    } else {
        videojs("video").pause();
        clearCctvInterval();

        BIS._cctvOverlay.setPosition(undefined);
        videojs("video").dispose();
        clearCctvInterval();
        videojsCheck = false;

        confirmMessage("영상 시청 시간이 만료되었습니다.<br>계속 시청하시겠습니까?").done((yes) => {
            if (yes === true) {
                videojs("video").play();
                showCCtvDisplayTime();
            } else {
                BIS._cctvOverlay.setPosition(undefined);
                videojs("video").dispose();
                clearCctvInterval();
                videojsCheck = false;
            }
        });
    }
}
