/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbConnectionEventHandler;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class TbPooledConnection
implements PooledConnection,
TbConnectionEventHandler {
    protected HashMap eventMap = new HashMap();
    private TbLogicalConnection logicalConn = null;
    private TbConnection physicalConn = null;

    public TbPooledConnection(TbConnection tbConnection) {
        this.physicalConn = tbConnection;
    }

    public final void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener != null && this.physicalConn != null && this.eventMap != null) {
            this.eventMap.put(connectionEventListener, connectionEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws SQLException {
        try {
            this.physicalConn.close();
        }
        finally {
            this.reset();
        }
    }

    public final Connection getConnection() throws SQLException {
        if (this.physicalConn == null) {
            SQLException sQLException = TbError.newSQLException(-590709);
            this.notifyExceptionEvent(sQLException);
            return null;
        }
        try {
            if (this.logicalConn != null && !this.logicalConn.isClosed()) {
                this.logicalConn.close();
            }
            this.logicalConn = this.getNewLogicalConnection();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
        return this.logicalConn;
    }

    protected TbLogicalConnection getNewLogicalConnection() throws SQLException {
        return new TbLogicalConnection(this, this.getPhysicalConnection(), false);
    }

    final TbConnection getPhysicalConnection() {
        return this.physicalConn;
    }

    public final void notifyClosedEvent() {
        if (this.physicalConn != null && this.eventMap != null) {
            Iterator iterator = this.eventMap.keySet().iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.eventMap.get(iterator.next());
                connectionEventListener.connectionClosed(new ConnectionEvent(this));
            }
        }
    }

    public final void notifyExceptionEvent(SQLException sQLException) {
        if (this.physicalConn != null && this.eventMap != null) {
            Iterator iterator = this.eventMap.keySet().iterator();
            while (iterator.hasNext()) {
                ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.eventMap.get(iterator.next());
                connectionEventListener.connectionErrorOccurred(new ConnectionEvent(this, sQLException));
            }
        }
    }

    public final void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener != null && this.physicalConn != null && this.eventMap != null) {
            this.eventMap.remove(connectionEventListener);
        }
    }

    public final void reset() {
        this.eventMap = null;
        if (this.logicalConn != null) {
            try {
                this.logicalConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

