/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.messageid.MessageIdStrategy;
import org.springframework.ws.soap.addressing.version.AddressingVersion;
import org.springframework.ws.soap.server.SoapEndpointInterceptor;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;

class AddressingEndpointInterceptor
implements SoapEndpointInterceptor {
    private static final Log logger = LogFactory.getLog(AddressingEndpointInterceptor.class);
    private final AddressingVersion version;
    private final MessageIdStrategy messageIdStrategy;
    private final WebServiceMessageSender[] messageSenders;
    private URI replyAction;
    private URI faultAction;

    AddressingEndpointInterceptor(AddressingVersion version, MessageIdStrategy messageIdStrategy, WebServiceMessageSender[] messageSenders, URI replyAction, URI faultAction) {
        Assert.notNull((Object)version, (String)"version must not be null");
        Assert.notNull((Object)messageIdStrategy, (String)"messageIdStrategy must not be null");
        Assert.notNull((Object)messageSenders, (String)"'messageSenders' must not be null");
        this.version = version;
        this.messageIdStrategy = messageIdStrategy;
        this.messageSenders = messageSenders;
        this.replyAction = replyAction;
        this.faultAction = faultAction;
    }

    @Override
    public final boolean handleRequest(MessageContext messageContext, Object endpoint) throws Exception {
        Assert.isInstanceOf(SoapMessage.class, (Object)messageContext.getRequest());
        SoapMessage request = (SoapMessage)messageContext.getRequest();
        MessageAddressingProperties requestMap = this.version.getMessageAddressingProperties(request);
        if (!this.version.hasRequiredProperties(requestMap)) {
            this.version.addMessageAddressingHeaderRequiredFault((SoapMessage)messageContext.getResponse());
            return false;
        }
        if (this.messageIdStrategy.isDuplicate(requestMap.getMessageId())) {
            this.version.addInvalidAddressingHeaderFault((SoapMessage)messageContext.getResponse());
            return false;
        }
        return true;
    }

    @Override
    public final boolean handleResponse(MessageContext messageContext, Object endpoint) throws Exception {
        return this.handleResponseOrFault(messageContext, false);
    }

    @Override
    public final boolean handleFault(MessageContext messageContext, Object endpoint) throws Exception {
        return this.handleResponseOrFault(messageContext, true);
    }

    private boolean handleResponseOrFault(MessageContext messageContext, boolean isFault) throws Exception {
        EndpointReference replyEpr;
        Assert.isInstanceOf(SoapMessage.class, (Object)messageContext.getRequest());
        Assert.isInstanceOf(SoapMessage.class, (Object)messageContext.getResponse());
        MessageAddressingProperties requestMap = this.version.getMessageAddressingProperties((SoapMessage)messageContext.getRequest());
        EndpointReference endpointReference = replyEpr = !isFault ? requestMap.getReplyTo() : requestMap.getFaultTo();
        if (this.handleNoneAddress(messageContext, replyEpr)) {
            return false;
        }
        SoapMessage reply = (SoapMessage)messageContext.getResponse();
        URI replyMessageId = this.getMessageId(reply);
        URI action = isFault ? this.faultAction : this.replyAction;
        MessageAddressingProperties replyMap = requestMap.getReplyProperties(replyEpr, action, replyMessageId);
        this.version.addAddressingHeaders(reply, replyMap);
        if (this.handleAnonymousAddress(messageContext, replyEpr)) {
            return true;
        }
        this.sendOutOfBand(messageContext, replyEpr);
        return false;
    }

    private boolean handleNoneAddress(MessageContext messageContext, EndpointReference replyEpr) {
        if (replyEpr == null || this.version.hasNoneAddress(replyEpr)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request [" + messageContext.getRequest() + "] has [" + replyEpr + "] reply address; reply [" + messageContext.getResponse() + "] discarded"));
            }
            messageContext.clearResponse();
            return true;
        }
        return false;
    }

    private boolean handleAnonymousAddress(MessageContext messageContext, EndpointReference replyEpr) {
        if (this.version.hasAnonymousAddress(replyEpr)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request [" + messageContext.getRequest() + "] has [" + replyEpr + "] reply address; sending in-band reply [" + messageContext.getResponse() + "]"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOutOfBand(MessageContext messageContext, EndpointReference replyEpr) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request [" + messageContext.getRequest() + "] has [" + replyEpr + "] reply address; sending out-of-band reply [" + messageContext.getResponse() + "]"));
        }
        boolean supported = false;
        for (WebServiceMessageSender messageSender : this.messageSenders) {
            if (!messageSender.supports(replyEpr.getAddress())) continue;
            supported = true;
            WebServiceConnection connection = null;
            try {
                connection = messageSender.createConnection(replyEpr.getAddress());
                connection.send(messageContext.getResponse());
                break;
            }
            finally {
                messageContext.clearResponse();
                if (connection != null) {
                    connection.close();
                }
            }
        }
        if (!supported && logger.isWarnEnabled()) {
            logger.warn((Object)("Could not send out-of-band response to [" + replyEpr.getAddress() + "]. Configure WebServiceMessageSenders which support this uri."));
        }
    }

    private URI getMessageId(SoapMessage response) {
        URI responseMessageId = this.messageIdStrategy.newMessageId(response);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Generated reply MessageID [" + responseMessageId + "] for [" + response + "]"));
        }
        return responseMessageId;
    }

    @Override
    public void afterCompletion(MessageContext messageContext, Object endpoint, Exception ex) {
    }

    @Override
    public boolean understands(SoapHeaderElement header) {
        return this.version.understands(header);
    }
}

