/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapElement;
import org.springframework.ws.soap.saaj.SaajSoapElementException;
import org.w3c.dom.Node;

class SaajSoapElement<T extends SOAPElement>
implements SoapElement {
    private final T element;

    SaajSoapElement(T element) {
        Assert.notNull(element, (String)"element must not be null");
        this.element = element;
    }

    @Override
    public Source getSource() {
        return new DOMSource((Node)this.element);
    }

    @Override
    public QName getName() {
        return this.element.getElementQName();
    }

    @Override
    public void addAttribute(QName name, String value) {
        try {
            this.element.addAttribute(name, value);
        }
        catch (SOAPException ex) {
            throw new SaajSoapElementException(ex);
        }
    }

    @Override
    public void removeAttribute(QName name) {
        this.element.removeAttribute(name);
    }

    @Override
    public String getAttributeValue(QName name) {
        return this.element.getAttributeValue(name);
    }

    @Override
    public Iterator<QName> getAllAttributes() {
        return this.element.getAllAttributesAsQNames();
    }

    @Override
    public void addNamespaceDeclaration(String prefix, String namespaceUri) {
        try {
            this.element.addNamespaceDeclaration(prefix, namespaceUri);
        }
        catch (SOAPException ex) {
            throw new SaajSoapElementException(ex);
        }
    }

    protected final T getSaajElement() {
        return this.element;
    }
}

