/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.configuration;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.annotation.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.annotation.EncryptablePropertySources;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableEnumerablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.OriginTrackedCompositePropertySource;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.Conventions;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EncryptablePropertySourceBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(EncryptablePropertySourceBeanFactoryPostProcessor.class);
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, (String)"configurationClass");
    private ConfigurableEnvironment env;

    public EncryptablePropertySourceBeanFactoryPostProcessor(ConfigurableEnvironment env) {
        this.env = env;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultResourceLoader ac = new DefaultResourceLoader();
        MutablePropertySources propertySources = this.env.getPropertySources();
        Stream<AnnotationAttributes> encryptablePropertySourcesMetadata = this.getEncryptablePropertySourcesMetadata(beanFactory);
        EncryptablePropertyResolver propertyResolver = (EncryptablePropertyResolver)beanFactory.getBean("lazyEncryptablePropertyResolver", EncryptablePropertyResolver.class);
        EncryptablePropertyFilter propertyFilter = (EncryptablePropertyFilter)beanFactory.getBean("lazyEncryptablePropertyFilter", EncryptablePropertyFilter.class);
        List<PropertySourceLoader> loaders = this.initPropertyLoaders();
        encryptablePropertySourcesMetadata.forEach(arg_0 -> this.lambda$postProcessBeanFactory$0((ResourceLoader)ac, propertyResolver, propertyFilter, propertySources, loaders, arg_0));
    }

    private List<PropertySourceLoader> initPropertyLoaders() {
        return SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
    }

    private void loadEncryptablePropertySource(AnnotationAttributes encryptablePropertySource, ConfigurableEnvironment env, ResourceLoader resourceLoader, EncryptablePropertyResolver resolver, EncryptablePropertyFilter propertyFilter, MutablePropertySources propertySources, List<PropertySourceLoader> loaders) throws BeansException {
        try {
            log.info("Loading Encryptable Property Source '{}'", (Object)encryptablePropertySource.getString("name"));
            PropertySource ps = this.createPropertySource(encryptablePropertySource, env, resourceLoader, resolver, propertyFilter, loaders);
            propertySources.addLast(ps);
            log.info("Created Encryptable Property Source '{}' from locations: {}", (Object)ps.getName(), Arrays.asList(encryptablePropertySource.getStringArray("value")));
        }
        catch (Exception e) {
            throw new ApplicationContextException("Exception Creating PropertySource", (Throwable)e);
        }
    }

    private PropertySource createPropertySource(AnnotationAttributes attributes, ConfigurableEnvironment environment, ResourceLoader resourceLoader, EncryptablePropertyResolver resolver, EncryptablePropertyFilter propertyFilter, List<PropertySourceLoader> loaders) throws Exception {
        String name = this.generateName(attributes.getString("name"));
        String[] locations = attributes.getStringArray("value");
        boolean ignoreResourceNotFound = attributes.getBoolean("ignoreResourceNotFound");
        OriginTrackedCompositePropertySource compositePropertySource = new OriginTrackedCompositePropertySource(name);
        Assert.isTrue((locations.length > 0 ? 1 : 0) != 0, (String)"At least one @PropertySource(value) location is required");
        for (String location : locations) {
            String resolvedLocation = environment.resolveRequiredPlaceholders(location);
            Resource resource = resourceLoader.getResource(resolvedLocation);
            if (!resource.exists()) {
                if (!ignoreResourceNotFound) {
                    throw new IllegalStateException(String.format("Encryptable Property Source '%s' from location: %s Not Found", name, resolvedLocation));
                }
                log.info("Ignoring NOT FOUND Encryptable Property Source '{}' from locations: {}", (Object)name, (Object)resolvedLocation);
                continue;
            }
            String actualName = name + "#" + resolvedLocation;
            this.loadPropertySource(loaders, resource, actualName).ifPresent(psources -> psources.forEach(arg_0 -> ((CompositePropertySource)compositePropertySource).addPropertySource(arg_0)));
        }
        return new EncryptableEnumerablePropertySourceWrapper(compositePropertySource, resolver, propertyFilter);
    }

    private String generateName(String name) {
        return !StringUtils.isEmpty((Object)name) ? name : "EncryptedPropertySource#" + System.currentTimeMillis();
    }

    private Stream<AnnotationAttributes> getEncryptablePropertySourcesMetadata(ConfigurableListableBeanFactory beanFactory) {
        return this.getBeanDefinitionsForAnnotation(beanFactory, EncryptablePropertySource.class, EncryptablePropertySources.class);
    }

    private Stream<AnnotationAttributes> getBeanDefinitionsForAnnotation(ConfigurableListableBeanFactory bf, Class<? extends Annotation> annotation, Class<? extends Annotation> repeatable) {
        return Stream.concat(Arrays.stream(bf.getBeanNamesForAnnotation(annotation)), Arrays.stream(bf.getBeanNamesForAnnotation(repeatable))).distinct().map(arg_0 -> ((ConfigurableListableBeanFactory)bf).getBeanDefinition(arg_0)).filter(bd -> bd instanceof AnnotatedBeanDefinition).map(bd -> (AnnotatedBeanDefinition)bd).filter(bd -> bd.getAttribute(CONFIGURATION_CLASS_ATTRIBUTE) != null && bd instanceof AbstractBeanDefinition).map(AnnotatedBeanDefinition::getMetadata).filter(am -> am.hasAnnotation(annotation.getName()) || am.hasAnnotation(repeatable.getName())).flatMap(am -> Optional.ofNullable((AnnotationAttributes)am.getAnnotationAttributes(annotation.getName())).map(Stream::of).orElseGet(() -> Optional.ofNullable((AnnotationAttributes)am.getAnnotationAttributes(repeatable.getName())).map(ram -> Arrays.stream(ram.getAnnotationArray("value"))).orElseGet(Stream::empty)));
    }

    private Optional<List<PropertySource<?>>> loadPropertySource(List<PropertySourceLoader> loaders, Resource resource, String sourceName) throws IOException {
        return Optional.of(resource).filter(this::isFile).flatMap(res -> loaders.stream().filter(loader -> this.canLoadFileExtension((PropertySourceLoader)loader, resource)).findFirst().map(loader -> this.load((PropertySourceLoader)loader, sourceName, resource)));
    }

    private List<PropertySource<?>> load(PropertySourceLoader loader, String sourceName, Resource resource) {
        return loader.load(sourceName, resource);
    }

    private boolean canLoadFileExtension(PropertySourceLoader loader, Resource resource) {
        return Arrays.stream(loader.getFileExtensions()).anyMatch(extension -> Objects.requireNonNull(resource.getFilename()).toLowerCase().endsWith("." + extension.toLowerCase()));
    }

    private boolean isFile(Resource resource) {
        return resource != null && resource.exists() && StringUtils.hasText((String)StringUtils.getFilenameExtension((String)resource.getFilename()));
    }

    public int getOrder() {
        return 2147483547;
    }

    private /* synthetic */ void lambda$postProcessBeanFactory$0(ResourceLoader ac, EncryptablePropertyResolver propertyResolver, EncryptablePropertyFilter propertyFilter, MutablePropertySources propertySources, List loaders, AnnotationAttributes eps) {
        this.loadEncryptablePropertySource(eps, this.env, ac, propertyResolver, propertyFilter, propertySources, loaders);
    }
}

