/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.sax;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;

public abstract class SaxUtils {
    private static final Log logger = LogFactory.getLog(SaxUtils.class);

    public static InputSource createInputSource(Resource resource) throws IOException {
        InputSource inputSource = new InputSource(resource.getInputStream());
        inputSource.setSystemId(SaxUtils.getSystemId(resource));
        return inputSource;
    }

    public static String getSystemId(Resource resource) {
        try {
            return new URI(resource.getURL().toExternalForm()).toString();
        }
        catch (IOException ex) {
            logger.debug((Object)("Could not get System ID from [" + resource + "], ex"));
            return null;
        }
        catch (URISyntaxException e) {
            logger.debug((Object)("Could not get System ID from [" + resource + "], ex"));
            return null;
        }
    }
}

