let symblTable       = null;
let commonUri        = "/api/vms/manager/symbl-vmp2";
let symblData        = [];
let saveBtn          = null;
let cancleBtn        = null;
let addBtn           = null;
let delBtn           = null;
let editBtn          = null;
let imageNmText      = null;
let imageContentText = null;
let imageLinkText    = null;

//하단 버튼들
const btnArr    = [
    editBtn = {
        class        : "edit-btn", 
        box          : null, 
        option       : 80, 
        visible      : true, 
        disabled     : true, 
        selectdsb    : false, 
        click        : {
            visible  : true, 
            disabled : false, 
        }, 
        on           : {
            visible  : false, 
            disabled : false, 
        },
        addvsb       : false, 
        icon         : "edit", 
        text         : "편집", 
        method       : function(){
            editEvent();
        }
    }, 
    addBtn = {
        class        : "add-btn", 
        box          : null, 
        option       : 80, 
        visible      : true, 
        disabled     : false, 
        selectdsb    : false, 
        click        : {
            visible  : true, 
            disabled : false, 
        }, 
        on           : {
            visible  : true, 
            disabled : true, 
        },
        addvsb       : false, 
        icon         : "plus", 
        text         : "추가", 
        method       : function(){
            addEvent();
        }
    }, 
    delBtn = {
        class        : "del-btn", 
        box          : null, 
        option       : 80, 
        visible      : true, 
        disabled     : true, 
        selectdsb    : false, 
        click        : {
            visible  : true, 
            disabled : false, 
        }, 
        on           : {
            visible  : true, 
            disabled : true, 
        },
        addvsb       : false, 
        icon         : "minus", 
        text         : "삭제", 
        method       : function(){
            deleteEvent();
        }
    }, 
    cancleBtn = {
        class        : "cancle-btn", 
        box          : null, 
        option       : 80, 
        visible      : false, 
        disabled     : false, 
        selectdsb    : false, 
        click        : {
            visible  : false, 
            disabled : false, 
        }, 
        on           : {
            visible  : true, 
            disabled : false, 
        },
        addvsb       : true, 
        icon         : "close", 
        text         : "취소", 
        method       : function(){
            eventOff();
        }
    }, 
    saveBtn = {
        class        : "save-btn", 
        box          : null, 
        option       : 80, 
        disabled     : true, 
        selectdsb    : true, 
        click        : {
            visible  : true, 
            disabled : true, 
        }, 
        on           : {
            visible  : true, 
            disabled : false, 
        },
        adddsb       : false, 
        visible      : true, 
        icon         : "save", 
        text         : "저장",
        method       : function(){
            saveEvent();
        }
    }, 
   
]

//우측 버튼들
const textArr    = [
    imageNmText = {
        class       : "image-nm", 
        box         : null, 
        option      : 120, 
        disabled    : true, 
        method      : function(){
        }
    }, 
    imageContentText = {
        class       : "image-content", 
        box         : null, 
        option      : 250,
        maxLength   : 200,
        disabled    : true, 
        method      : function(){
        }
    },
    imageLinkText = {
        class       : "image-link-text", 
        box         : null, 
        option      : 200, 
        disabled    : true, 
        method      : function(){
        }
    },
]

getData(commonUri, symblData);

$(()=>{
    
    //소통 테이블
    symblTable = $(".symbl-table").width('100%').height('100%').dxDataGrid({
        dataSource              : symblData[0], 
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'symb_lib_nmbr',
        sorting  : {
            showSortIndexes : false,
            mode            : 'none',
        },
        selection: {
            mode: 'single', 
        }, 
        scrolling: {
            mode: 'virtual', 
        }, 
        columns:[
            {
                dataField    : "symb_lib_nmbr", 
                caption      : "번호", 
                alignment    : "center", 
                sortIndex    : 0, 
                sortOrder    : "asc",
                width        : 90,
            }, 
            {
                dataField    : "imag_data", 
                caption      : "이미지", 
                alignment    : "center",
                cellTemplate(c,e){
                    c.css('padding','3px')
                    const imgSrc = 'data:image/png;base64,'+ e.displayValue
                    return c.append($('<img src="'+imgSrc+'">'));
                }
            }, 
        ], 
      
        onRowClick(e){
            
            $('.image-download-link').attr('href', "data:image/png;base64," + e.data.imag_data);
            $('.image-download-link').attr('download', e.data.symb_lib_nmbr +'.bmp');
            setValue(imageNmText.box, e.data.symb_lib_nmbr);
            setValue(imageContentText.box, e.data.symb_expl);
            dsblOffBtn(imgDown);
            const image = document.querySelector('.symbl-image');
            $('.symbl-image').attr('src', "data:image/png;base64," + e.data.imag_data);
            
            let ctx = canvasInit(image);
            ctx.fillStyle = 'red';

            btnArr.map((item)=>{
                item.box.option('visible', item.click.visible);
                item.box.option('disabled', item.click.disabled);
            });

            let crdnData = [];
            getData(commonUri + '/' + encodeURIComponent(e.data.symb_lib_nmbr), crdnData);
            if(crdnData.length > 0){
                let dataSource = [];
                dataSource.push(crdnData[0].cell);
                crdnTable.option('dataSource', dataSource);
                ctx.fillFlood(crdnData[0].cell.posx, crdnData[0].cell.posy);
            }

        }
    }).dxDataGrid("instance");

    crdnTable = $(".crdn-table").width('100%').height('100%').dxDataGrid({
        dataSource              : [], 
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'cell_id',
        sorting  : {
            showSortIndexes : false,
            mode            : 'none',
        },
        scrolling: {
            mode: 'virtual', 
        }, 
        columns:[
            {
                dataField    : "posx", 
                caption      : "x좌표", 
                alignment    : "center",
                cssClass     : 'no-padding',
            }, 
            {
                dataField    : "posy", 
                caption      : "y좌표", 
                alignment    : "center",
                cssClass     : 'no-padding',
            }, 
            {
                dataField    : "cell_id", 
                caption      : "영역", 
                alignment    : "center", 
                cssClass     : 'no-padding',
                cellTemplate(c,e){
                    c.css({padding: '3px', height: '1px'});
                    return c.append($('<div>').css({width:'100%', height: '100%', backgroundColor: 'red'}))
                }
            }, 
            
        ], 
      
    }).dxDataGrid("instance");
  
    //하단 버튼 세팅
    btnArr.map((item)=>{
        item.box = $("." + item.class).dxButton({
            icon              : item.icon, 
            width             : item.option, 
            text              : item.text, 
            visible           : item.visible, 
            disabled          : item.disabled,
            focusStateEnabled : false, 
            stylingMode       : 'outlined', 
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxButton("instance")
    });

    //텍스트 상자 세팅
    textArr.map((item)=>{
        item.box = $("." + item.class).dxTextBox({
            width             : item.option, 
            disabled          : item.disabled, 
            stylingMode       : 'outlined',
            maxLength         : item.maxLength,
            heigth            : 30,
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxTextBox("instance")
    });

    //이미지 다운로드 버튼
    imgDown = $('.image-download').dxButton({
        icon        : 'download',
        text        : '이미지 파일 저장',
        stylingMode : 'outlined',
        disabled    : true,
        onClick(){
            document.querySelector('.image-download-link').click();
        }
    }).dxButton('instance');

    //이미지 업로드 버튼
    imgLink = $(".image-link").height('31px').dxButton({
        text          : '이미지 업로드',
        icon          : 'upload',
        stylingMode   : 'outlined',
        disabled      : true,
        onClick(){
            $('#image-file').val('');
            $('#image-file').click();
        }

    }).dxButton('instance');

    //이미지 파일 업로드 이벤트
    $('#image-file').on('change',function(){
        if($(this)[0].files[0] === undefined) return false;

        if($(this)[0].files[0].size > 32000){
            alertWarning('파일 사이즈는 32KBytes를 넘을 수 없습니다. 파일 용량을 줄여주세요')
            $(this).val('');
            return false;
        };
        
        let reader = new FileReader();
        
        reader.onload = function(e) {
            var arrayBuffer = e.target.result;
            arrayBufferToBase64(arrayBuffer).then( (byte8) =>{
                const image = document.querySelector('.symbl-image');
                image.setAttribute('src', "data:image/png;base64," + byte8);
                setTimeout(()=>canvasInit(image), 100);
            })
        }
        
        reader.readAsArrayBuffer($(this)[0].files[0]);
        setValue(imageLinkText.box, $(this)[0].files[0].name);
        crdnTable.option('dataSource', []);
    });

    closeBtn = $('.close-btn').dxButton({
        text        : '닫기',
        icon        : 'close',
        stylingMode : 'outlined',
        onClick(){
            window.close();
        }
    }).dxButton('instance');

    
});

//하단 편집 이벤트
function editEvent(){
    eventOn();
}

//하단 추가 이벤트
function addEvent(){
    let canvas = document.querySelector('.canvas');
    const image = document.querySelector('.symbl-image');
    canvas.getContext('2d').clearRect(0, 0, image.width, image.height);
    $('.symbl-image').attr('src', null);
    $('.image-download-link').attr('href', '');
    $('.image-download-link').attr('download', '');
    crdnTable.option('dataSource', []);

    eventOn();
    
    let newId = [];

    textArr.map((item)=>{
        setValue(item.box, ''); 
    });

    getData(commonUri + '/new-id', newId);
    
    setValue(imageNmText.box, newId[0].new_id);
    
   
   
}

//이벤트 시작
function eventOn(){

    btnArr.map((item)=>{
        item.box.option('visible', item.on.visible);
        item.box.option('disabled', item.on.disabled);
    });

    dsblOffBtn(imageContentText.box);
    dsblOnBtn(symblTable);
    dsblOnBtn(imgDown);
    dsblOffBtn(imgLink);
    
    let canvas = document.querySelector('.canvas');

    $('.canvas').on('click', function(e){
        
        if(nullChecker($('.symbl-image').attr('src')) !== ""){
            const image = document.querySelector('.symbl-image');
            let ctx = canvasInit(image);
            ctx.fillStyle = 'red';
            ctx.fillFlood(e.offsetX, e.offsetY);
            let symb_lib_nmbr = 0;
            
            if(crdnTable.option('dataSource').length > 0)symb_lib_nmbr = crdnTable.cellValue(0, symb_lib_nmbr);

            if(getValue(imageNmText.box) !== "")symb_lib_nmbr = getValue(imageNmText.box);

            crdnTable.option('dataSource',[{
                cell_id       : 1,
                posx          : e.offsetX,
                posy          : e.offsetY,
                symb_lib_nmbr : symb_lib_nmbr,
                vms_ifsc_id   : 0
            }]);
        }
        
    })

}

//이벤트 취소
function eventOff(){
    const selectedData = symblTable.getSelectedRowsData();

    dsblOnBtn(imgLink);
    dsblOffBtn(symblTable);
    dsblOnBtn(imageContentText.box);
    
    textArr.map((item)=>{
        setValue(item.box, ''); 
    });

    btnArr.map((item)=>{
        item.box.option('visible', item.visible);
        item.box.option('disabled', item.disabled);
    });

    $('.symbl-image').attr('src', null );
    $('.image-download-link').attr('href', null);
    $('.image-download-link').attr('download', null);
    $('.canvas').off('click');
    
    dsblOnBtn(imgDown);
    crdnTable.option('dataSource', []);
    const image = document.querySelector('.symbl-image');
    let ctx = canvasInit(image);

    if (selectedData.length > 0) {
       
        $('.symbl-image').attr('src', "data:image/png;base64," + selectedData[0].imag_data );
        $('.image-download-link').attr('href', "data:image/png;base64," + selectedData[0].imag_data);
        $('.image-download-link').attr('download', selectedData[0].symb_lib_nmbr +'.bmp');
        ctx = canvasInit($('.symbl-image')[0]);
        let data = [];
        getData( commonUri + '/' + encodeURIComponent(selectedData[0].symb_lib_nmbr), data);
        ctx.fillStyle = 'red';
        ctx.fillFlood(data[0].cell.posx, data[0].cell.posy);
        let dataSource = [];
        dataSource.push(data[0].cell);

        crdnTable.option('dataSource', dataSource);
        
        setValue(imageNmText.box, selectedData[0].symb_lib_nmbr);
        setValue(imageContentText.box, selectedData[0].symb_expl);
        dsblOffBtn(imgDown);

        btnArr.map((item)=>{
            item.box.option('visible', item.click.visible);
            item.box.option('disabled', item.click.disabled);
        });
    }
   
    
   
}

//삭제 이벤트 우측
function deleteEvent(){
    const selectedData = symblTable.getSelectedRowsData()[0];
    const id = selectedData.symb_lib_nmbr;
    let usageData = [];
    getData(commonUri + '/usage/' + encodeURIComponent(id), usageData);
    
    if(usageData[0] && usageData[0].count > 0){
        return alertWarning('삭제할 이미지가 VMS 폼에서 사용되고 있습니다.<br>먼저 해당 폼에서 삭제해주시기 바랍니다.');
    }
    
    const result = deleteData(commonUri, id);
    if(result > 0){
        delResultMsg('VMS 소통 이미지');
        symblData = refresh( symblTable , symblData, commonUri );
        symblTable.refresh().done(()=>{
            symblTable.option('focusedRowIndex', -1);
            symblTable.clearSelection();
            eventOff();
        });
    }
    //return alertError('VMS 소통 이미지 정보가 삭제 되지 않았습니다.')
}

//저장 이벤트
function saveEvent(){
    updateData = {};
    switch (true) {
        case nullChecker(getValue(imageNmText.box)) === "" :
            imageNmText.box.focus();
            alertWarning('이미지 번호를 입력해주세요', null, imageNmText);
            break;
        case nullChecker(getValue(imageContentText.box)) === "" :
            imageContentText.box.focus();
            alertWarning('이미지 설명을 입력해주세요', null, imageContentText);
            break;
        case getByteLength(getValue(imageContentText.box)) > imageContentText.maxLength :
            alertWarning('이미지 설명을 ' + imageContentText.maxLength + ' 바이트 이내로 입력해주세요', null, imageContentText.box);
            break;
        case nullChecker($('.symbl-image').attr('src')) === "" :
            imgLink.focus();
            alertWarning('이미지를 업로드 해주세요', imgLink);
            break;
        case crdnTable.option('dataSource').length <= 0 :
            crdnTable.focus();
            alertWarning('소통정보 이미지 좌표를 설정해주세요', null, crdnTable);
            break;
        default:
            updateData['symb_lib_nmbr'] = getValue(imageNmText.box);
            updateData['symb_expl'] = getValue(imageContentText.box);
            updateData['imag_data'] = $('.symbl-image').attr('src').substring(22, $('.symbl-image').attr('src').length);
            updateData['rgst_dt'] = getSendDate(new Date());
            updateData['cell'] = crdnTable.option('dataSource')[0];

            //편집모드일 때 수정 사항 있는지 확인
            if (symblTable.getSelectedRowsData().length > 0){
                const selectedData = symblTable.getSelectedRowsData()[0]
                
                updateData['rgst_dt'] = selectedData['rgst_dt'];
                
                let result = false;
                
                if ( selectedData.symb_lib_nmbr === updateData.symb_lib_nmbr){
                    let data =[];
                    getData(commonUri + '/' + encodeURIComponent(updateData['symb_lib_nmbr']), data);
                    for (key in selectedData) {
                        if (selectedData[key] !== updateData[key]) result = true;
                    };
                    
                    for (key in updateData['cell']){
                        if(updateData['cell'][key] !== data[0].cell[key]) result = true;
                    }
            
                    if (!result){
                        alertWarning('변경 된 소통 이미지 정보가 없습니다.');
                        break 
                    }
                }
                
            }

            
            const result = postInsertUpdate(commonUri + '/' + encodeURIComponent(getValue(imageNmText.box)) , updateData);
            if ( result > 0 ){
                insResultMsg('VMS 소통 이미지');
                symblData = [];
                getData(commonUri, symblData);
                symblTable.option('dataSource', symblData[0]);
                symblTable.refresh().done(() => {
                    const key = updateData.symb_lib_nmbr;
                    symblTable.clearSelection();
                    symblTable.selectRows(key, true);
                    symblTable.option('focusedRowKey', key);
                    symblTable.navigateToRow(key);
                    dsblOnBtn(imgLink);
                    dsblOffBtn(symblTable);
                    dsblOnBtn(imageContentText.box);
                    dsblOffBtn(imgDown);
                
                    btnArr.map((item)=>{
                        item.box.option('visible', item.click.visible);
                        item.box.option('disabled', item.click.disabled);
                    });
                });
            }

            //alertError('VMS 소통 이미지 정보가 저장되지 않았습니다.');
            break;
    }

    
}

//바이트 변환 이벤트
function arrayBufferToBase64(buffer) {
    return new Promise( (succ,fail)=>{
        try {
            var binary = '';
            const bytes = new Uint8Array(buffer);
            const len = bytes.byteLength;
            for (let i = 0; i < len; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            succ( window.btoa(binary) );	    	
        } catch(e){
            console.log('to big....');
            fail(e);
        }	
    });
}

function canvasInit(image){
    let canvas = document.querySelector('.canvas');
    canvas.width = image.width;
    canvas.height = image.height;
    $('.canvas').css('width', image.width);
    $('.canvas').css('height', image.height);
    canvas.getContext('2d').clearRect(0, 0, image.width, image.height);
    let ctx = canvas.getContext('2d');
    ctx.drawImage(image, 0, 0 , image.width, image.height);
    return ctx;
}
