let cnctIntnData     = [];
let updateData       = [];
let insertData       = [];
let mngmNmbrData     = [];
let delData          = [];
let cnctTypeData     = [];
let cnctIntnTable    = null;
let addBtn           = null;
let delBtn           = null;
let applyBtn         = null;
let searchBtn        = null;
const _pageName       = '연계기관 관리';
const _apiUri = "/api/database/cnct-intn";
getData('/api/database/cnct-intn/cnct-type', cnctTypeData);
const checkByteArr   = [
    ['cnct_intn_nm', '기관 명칭', 50, true],
    ['cnct_intn_tel', '전화번호', 128, false],
    ['cnct_intn_addr', '주소', 200, false],
    ['rmrk', '비고', 600, false],
]

//유형 정렬
if(cnctTypeData.length > 0){
    cnctTypeData[0].sort(function(a,b){
        return (Number(a.cnct_intn_type_desc.match(/(\d+)/g)[0]))-(Number(b.cnct_intn_type_desc.match(/(\d+)/g)[0]))
    })
}

$(()=>{
    //상단 조회 버튼
    searchBtn = $(".search-button").dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        height:'30px',
        width: '80px',
        onClick(){
            fetchListData();
        }
    }).dxButton("instance")
    
    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
    
    //연계기관정보 관리 테이블
    cnctIntnTable = $(".cnct-intn-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        focusedRowEnabled       : true,
        keyExpr                 : 'cnct_intn_mngm_nmbr',
        selection: {
           mode : 'none',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible : true,
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'virtual',
        },
        groupPanel:{
            visible         : true,
            emptyPanelText  : "그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export:{
            enabled : true,
            texts   : {
                exportAll :"엑셀 파일",
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName);
        },
        columns:[
            {   
                dataField    : "cnct_intn_mngm_nmbr",
                caption      : "관리 번호",
                alignment    : "center",
                allowEditing : false,
                sortIndex    : 0, 
                sortOrder    : "asc",
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField   : "cnct_intn_nm",
                caption     : "기관 명칭",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 50,
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField   : "cnct_intn_type_cd",
                caption     : "유형",
                alignment   : "center",
                lookup      :{
                    dataSource  : cnctTypeData[0],
                    displayExpr : 'cnct_intn_type_desc',
                    valueExpr   : 'cnct_intn_type_cd',
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {   
                dataField   : "cnct_intn_tel",
                caption     : "전화번호",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 128,
                },
            },
            {   
                dataField   : "cnct_intn_addr",
                caption     : "주소",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 200,
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {   
                dataField   : "rmrk",
                caption     : "비고",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 600,
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
        ],
        onRowUpdated(e){
            updateData.push(e.data);
        },
        onRowInserted(e){
            insertData.push(e.data);
        },
        onSelectionChanged(e){
            delData = e.selectedRowsData;
        }
    }).dxDataGrid("instance");
    
    //하단 편집 버튼
    editBtn = $(".edit-btn").dxButton({
        stylingMode:'outlined',
        text:'편집',
        icon:'edit',
        onClick(){
            eventOn();
        }
    }).dxButton("instance")
    
    //하단 취소 버튼
    editCancleBtn = $(".edit-cancle-btn").dxButton({
        stylingMode:'outlined',
        text:'취소',
        visible:false,
        icon:'close',
        onClick(){
                if(cnctIntnTable.hasEditData() || delData.length > 0){
                    confirmMessage("변경 하신 데이터가 있습니다. 취소 하시겠습니까?").done((yes) => {
                        if (yes === true) {
                            eventOff();
                        }
                    });
                }
                else {
                    eventOff();
                }
        }
    }).dxButton("instance")
    
    //추가 버튼
    addBtn = $(".add-btn").dxButton({
        stylingMode:'outlined',
        text:'추가',
        disabled:true,
        icon:'plus',
        onClick(){
            fetchMngmNmbr();
        }    
    }).dxButton("instance")
    
    //삭제 버튼
    delBtn = $(".del-btn").dxButton({
        stylingMode:'outlined',
        text:'삭제',
        disabled:true,
        icon:'minus',
        onClick(){
            cnctIntnTable.option("selection",{
                mode:'multiple',
            });
            dsblOnBtn(addBtn);
            dsblOnBtn(delBtn);
        }
    }).dxButton("instance")
    
    //하단 적용 버튼
    applyBtn = $(".apply-btn").dxButton({
        stylingMode:'outlined',
        text:'적용',
        disabled:true,
        icon:'save',
        onClick(){
           saveEvent();
        }
    }).dxButton("instance")
    
   fetchListData();
})

function fetchListData(){
    getDataAsync(_apiUri, (jsonData)=>{
        cnctIntnData = jsonData;
        if (cnctIntnData.length > 0) {
            mngmNmbrData = [];
            cnctIntnData.map((item) =>{
                mngmNmbrData.push(item.cnct_intn_mngm_nmbr);
            });
        }
        cnctIntnTable.option('dataSource', cnctIntnData);
    });
    
}

function eventOff(){
    showBtn(editBtn);
    hideBtn(editCancleBtn);
    dsblOnBtn(applyBtn);
    dsblOnBtn(delBtn);
    dsblOnBtn(addBtn);
    dsblOffBtn(searchBtn);
    
    cnctIntnTable.option("editing",{
        mode:"none",
        allowUpdating:false,
    });
    
    cnctIntnTable.option("selection",{
        mode : "none",
    });

    cnctIntnTable.option('toolbar.visible', true);
    
    fetchListData();
}

function eventOn(){
    showBtn(editCancleBtn);
    hideBtn(editBtn);
    dsblOffBtn(applyBtn);
    dsblOffBtn(addBtn);
    dsblOffBtn(delBtn);
    dsblOnBtn(searchBtn);
    cnctIntnTable.option("editing",{
        mode:"batch",
        allowUpdating:true,
    });

    cnctIntnTable.option('toolbar.visible', false);
}

function saveEvent(){
    if (!cnctIntnTable.hasEditData() && delData.length <= 0){
        alertWarning("변경하신 데이터가 없습니다.")   
    }
    else {
            let updateDataArr = [];
            let delCnt = 0;
            
            if (cnctIntnTable.hasEditData()) {
                cnctIntnTable.option('editing.changes').map((item)=>{
                    cnctIntnTable.byKey(item.key).done(function(obj) {
                        const data = {...obj};
                        updateDataArr.push(data);
                    });
                })
                
                if (updateDataArr.length > 0) {
                    for ( let obj of updateDataArr ) {
                        const frontContent = "관리 번호 : " + obj.cnct_intn_mngm_nmbr + "<br>";
                        for (let checkByte of checkByteArr) {
                            const value = obj[checkByte[0]];
                            const empty = nullChecker(value) === '';
                            if (empty) {
                                if (checkByte[3]) {
                                    return alertWarning(frontContent + "필수 항목을 입력해주세요. [ " + checkByte[1] +" ]");
                                }
                                obj[checkByte[0]] = null;
                            }
                            else {
                                if (getByteLength(value) > checkByte[2]) {
                                    return alertWarning( frontContent + checkByte[2]+ " 바이트 이내로 입력해주세요. [ " + checkByte[1] + " ]");
                                }
                            }
                        }
                    }

                    confirmMessage("변경하신 연계기관 정보를 적용 하시겠습니까?").done((yes) => {
                        if (yes === true) {
                            let result = postInsertUpdate( _apiUri, updateDataArr);
                            if (result > 0 ){
                                eventOff();
                                alertConfirm('변경하신 연계기관 정보가 저장되었습니다.');
                            }
                        }
                    });
                }
            }
            else if ( delData.length > 0) {
                confirmMessage("선택하신 연계기관 정보를 삭제 하시겠습니까?").done((yes) => {
                    if (yes === true) {

                        delData.map((item)=>{
                            let result = deleteData(_apiUri, item.cnct_intn_mngm_nmbr);
                            delCnt += result;
                        });

                        if (delCnt > 0) {
                            eventOff();
                            alertConfirm('선택하신 연계기관 정보 ' + delCnt + '건이 삭제되었습니다.');
                        }
                    }
                });

            }
            
    }
}

function fetchMngmNmbr(){
    cnctIntnTable.addRow();
    cnctIntnTable.option('editing.changes',[{
        key  : cnctIntnTable.option('editing.editRowKey'),  
        data :{
            cnct_intn_mngm_nmbr : Number(mngmNmbrData[mngmNmbrData.length-1])+1,
            cnct_intn_type_cd   : 0,
        },
        type:"insert",
    }]);
    mngmNmbrData.push(Number(mngmNmbrData[mngmNmbrData.length-1]+1).toString());

    dsblOnBtn(addBtn);
    dsblOnBtn(delBtn);
}