/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.util.Primitives;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

class NumberConverter
implements ConditionalConverter<Object, Number> {
    NumberConverter() {
    }

    @Override
    public Number convert(MappingContext<Object, Number> context) {
        Object source = context.getSource();
        if (source == null) {
            return null;
        }
        Class<?> destinationType = Primitives.wrapperFor(context.getDestinationType());
        if (source instanceof Number) {
            return this.numberFor((Number)source, destinationType);
        }
        if (source instanceof Boolean) {
            return this.numberFor((Boolean)source != false ? 1 : 0, destinationType);
        }
        if (source instanceof Date && Long.class.equals(destinationType)) {
            return ((Date)source).getTime();
        }
        if (source instanceof Calendar && Long.class.equals(destinationType)) {
            return ((Calendar)source).getTime().getTime();
        }
        if (source instanceof XMLGregorianCalendar && Long.class.equals(destinationType)) {
            return ((XMLGregorianCalendar)source).toGregorianCalendar().getTimeInMillis();
        }
        return this.numberFor(source.toString(), destinationType);
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        boolean destMatch = Number.class.isAssignableFrom(Primitives.wrapperFor(destinationType));
        if (destMatch) {
            return Number.class.isAssignableFrom(Primitives.wrapperFor(sourceType)) || sourceType == Boolean.class || sourceType == Boolean.TYPE || sourceType == String.class || Date.class.isAssignableFrom(sourceType) || Calendar.class.isAssignableFrom(sourceType) || XMLGregorianCalendar.class.isAssignableFrom(sourceType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.PARTIAL;
        }
        return ConditionalConverter.MatchResult.NONE;
    }

    Number numberFor(Number source, Class<?> destinationType) {
        if (destinationType.equals(source.getClass())) {
            return source;
        }
        if (destinationType.equals(Byte.class)) {
            long longValue = source.longValue();
            if (longValue > 127L) {
                throw new Errors().errorTooLarge(source, destinationType).toMappingException();
            }
            if (longValue < -128L) {
                throw new Errors().errorTooSmall(source, destinationType).toMappingException();
            }
            return source.byteValue();
        }
        if (destinationType.equals(Short.class)) {
            long longValue = source.longValue();
            if (longValue > 32767L) {
                throw new Errors().errorTooLarge(source, destinationType).toMappingException();
            }
            if (longValue < -32768L) {
                throw new Errors().errorTooSmall(source, destinationType).toMappingException();
            }
            return source.shortValue();
        }
        if (destinationType.equals(Integer.class)) {
            long longValue = source.longValue();
            if (longValue > Integer.MAX_VALUE) {
                throw new Errors().errorTooLarge(source, destinationType).toMappingException();
            }
            if (longValue < Integer.MIN_VALUE) {
                throw new Errors().errorTooSmall(source, destinationType).toMappingException();
            }
            return source.intValue();
        }
        if (destinationType.equals(Long.class)) {
            return source.longValue();
        }
        if (destinationType.equals(Float.class)) {
            if (source.doubleValue() > 3.4028234663852886E38) {
                throw new Errors().errorTooLarge(source, destinationType).toMappingException();
            }
            return Float.valueOf(source.floatValue());
        }
        if (destinationType.equals(Double.class)) {
            return source.doubleValue();
        }
        if (destinationType.equals(BigDecimal.class)) {
            if (source instanceof Float || source instanceof Double) {
                return new BigDecimal(source.toString());
            }
            if (source instanceof BigInteger) {
                return new BigDecimal((BigInteger)source);
            }
            return BigDecimal.valueOf(source.longValue());
        }
        if (destinationType.equals(BigInteger.class)) {
            if (source instanceof BigDecimal) {
                return ((BigDecimal)source).toBigInteger();
            }
            return BigInteger.valueOf(source.longValue());
        }
        throw new Errors().errorMapping(source, destinationType).toMappingException();
    }

    Number numberFor(String source, Class<?> destinationType) {
        String sourceString = source.trim();
        if (sourceString.length() == 0) {
            return null;
        }
        try {
            if (destinationType.equals(Byte.class)) {
                return Byte.valueOf(source);
            }
            if (destinationType.equals(Short.class)) {
                return Short.valueOf(source);
            }
            if (destinationType.equals(Integer.class)) {
                return Integer.valueOf(source);
            }
            if (destinationType.equals(Long.class)) {
                return Long.valueOf(source);
            }
            if (destinationType.equals(Float.class)) {
                return Float.valueOf(source);
            }
            if (destinationType.equals(Double.class)) {
                return Double.valueOf(source);
            }
            if (destinationType.equals(BigDecimal.class)) {
                return new BigDecimal(source);
            }
            if (destinationType.equals(BigInteger.class)) {
                return new BigInteger(source);
            }
        }
        catch (Exception e) {
            throw new Errors().errorMapping(source, destinationType, e).toMappingException();
        }
        throw new Errors().errorMapping(source, destinationType).toMappingException();
    }
}

