/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class TbSQLOutput
implements SQLOutput {
    private TbStructDescriptor descriptor;
    private Object[] attributes;
    private int index;
    private TbConnection conn;

    public TbSQLOutput(TbStructDescriptor tbStructDescriptor, TbConnection tbConnection) {
        this.descriptor = tbStructDescriptor;
        this.attributes = new Object[tbStructDescriptor.getNumOfFields()];
        this.conn = tbConnection;
        this.index = 0;
    }

    public TbStruct getStruct() throws SQLException {
        return new TbStruct(this.descriptor, this.conn, this.attributes);
    }

    public void writeString(String string) throws SQLException {
        this.attributes[this.index++] = string;
    }

    public void writeBoolean(boolean bl) throws SQLException {
        this.attributes[this.index++] = new Boolean(bl);
    }

    public void writeByte(byte by) throws SQLException {
        this.attributes[this.index++] = new Integer(by);
    }

    public void writeShort(short s) throws SQLException {
        this.attributes[this.index++] = new Integer(s);
    }

    public void writeInt(int n) throws SQLException {
        this.attributes[this.index++] = new Integer(n);
    }

    public void writeLong(long l) throws SQLException {
        this.attributes[this.index++] = new Long(l);
    }

    public void writeFloat(float f) throws SQLException {
        this.attributes[this.index++] = new Float(f);
    }

    public void writeDouble(double d) throws SQLException {
        this.attributes[this.index++] = new Double(d);
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.attributes[this.index++] = bigDecimal;
    }

    public void writeBytes(byte[] byArray) throws SQLException {
        this.attributes[this.index++] = byArray;
    }

    public void writeDate(Date date) throws SQLException {
        this.attributes[this.index++] = date;
    }

    public void writeTime(Time time) throws SQLException {
        this.attributes[this.index++] = time;
    }

    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.attributes[this.index++] = timestamp;
    }

    public void writeCharacterStream(Reader reader) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void writeObject(SQLData sQLData) throws SQLException {
        TbStruct tbStruct = null;
        if (sQLData != null) {
            TbStructDescriptor tbStructDescriptor = TbStructDescriptor.createDescriptor(sQLData.getSQLTypeName(), this.conn);
            SQLOutput sQLOutput = tbStructDescriptor.toSQLOutput();
            sQLData.writeSQL(sQLOutput);
            tbStruct = ((TbSQLOutput)sQLOutput).getStruct();
        }
        this.writeStruct(tbStruct);
    }

    public void writeRef(Ref ref) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void writeBlob(Blob blob) throws SQLException {
        this.attributes[this.index++] = blob;
    }

    public void writeClob(Clob clob) throws SQLException {
        this.attributes[this.index++] = clob;
    }

    public void writeStruct(Struct struct) throws SQLException {
        this.attributes[this.index++] = struct;
    }

    public void writeArray(Array array) throws SQLException {
        this.attributes[this.index++] = array;
    }

    public void writeURL(URL uRL) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void writeNString(String string) throws SQLException {
        throw TbError.newSQLException(-90201);
    }
}

