/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import java.sql.SQLException;

public class TbDirPathMetaData {
    public static final boolean NO_LOG = false;
    public static final boolean LOG = true;
    public static final boolean NO_PARALLEL = false;
    public static final boolean PARALLEL = true;
    public static final int NO_BIND = 0;
    public static final int BIND = 256;
    public static final int MANUAL = 0;
    public static final int AUTO = 16;
    public static final int COMPLETE = 0;
    public static final int PARTIAL = 1;
    public static final int INIT_BUF_SIZE = 131072;
    public static final int CHAR_BUF_SIZE = 4096;
    public static final int BYTE_BUF_SIZE = 16384;
    private String schema;
    private String table;
    private String partition;
    private int columnCnt;
    private boolean logFlag = false;
    private boolean parallelFlag = false;
    private String clientCharset = null;
    private int bufferSize = 131072;
    private String[] columnNames;
    private TbColumnDesc[] columnMetas;

    public TbDirPathMetaData() {
        this.reset();
    }

    public TbDirPathMetaData(String string, String string2, String[] stringArray, boolean bl) throws SQLException {
        this.setSchema(string);
        this.setTable(string2);
        this.partition = "";
        this.columnNames = stringArray;
        this.logFlag = bl;
        this.columnCnt = stringArray.length;
        for (int i = 0; i < this.columnCnt; ++i) {
            this.setColumn(i + 1, stringArray[i]);
        }
    }

    public void checkDirPathMetaData() throws SQLException {
        if (this.schema == null || this.schema.length() == 0) {
            throw TbError.newSQLException(-90637);
        }
        if (this.table == null || this.table.length() == 0) {
            throw TbError.newSQLException(-90638);
        }
        if (this.columnNames == null) {
            throw TbError.newSQLException(-90640);
        }
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (this.columnNames[i] != null && this.columnNames[i].length() != 0) continue;
            throw TbError.newSQLException(-90640);
        }
    }

    private void checkParameterIndex(int n) throws SQLException {
        if (n < 1 || n > this.columnCnt) {
            throw TbError.newSQLException(-90609);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getClientCharSet() {
        return this.clientCharset;
    }

    public String getColumn(int n) throws SQLException {
        if (this.columnNames == null) {
            throw TbError.newSQLException(-90640);
        }
        this.checkParameterIndex(n);
        return this.columnNames[n - 1];
    }

    public int getColumnCnt() {
        return this.columnNames.length;
    }

    public TbColumnDesc[] getColumnMetas() {
        return this.columnMetas;
    }

    public int getDataType(int n) throws SQLException {
        this.checkParameterIndex(n);
        return this.columnMetas[n - 1].dataType;
    }

    private String getDBString(String string) {
        int n = string.indexOf(34);
        int n2 = string.lastIndexOf(34);
        string = n2 > n ? string.substring(n + 1, n2) : string.toUpperCase();
        return string;
    }

    public boolean getLogFlag() {
        return this.logFlag;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public void reset() {
        this.schema = null;
        this.table = null;
        this.partition = "";
        this.columnCnt = 0;
        this.logFlag = false;
        this.parallelFlag = false;
        this.clientCharset = null;
        this.columnNames = null;
        this.columnMetas = null;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void setClientCharSet(String string) {
        this.clientCharset = string;
    }

    public void setColumn(int n, String string) throws SQLException {
        if (this.columnNames == null) {
            throw TbError.newSQLException(-90640);
        }
        this.checkParameterIndex(n);
        this.columnNames[n - 1] = this.getDBString(string);
    }

    public void setColumnCnt(int n) {
        this.columnCnt = n;
        if (this.columnNames == null) {
            this.columnNames = new String[n];
            for (int i = 0; i < n; ++i) {
                this.columnNames[i] = new String();
            }
        }
    }

    public void setColumnMetas(TbColumnDesc[] tbColumnDescArray) {
        this.columnMetas = tbColumnDescArray;
    }

    public void setLogFlag(boolean bl) {
        this.logFlag = bl;
    }

    public void setSchema(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90637);
        }
        this.schema = this.getDBString(string);
    }

    public void setTable(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90638);
        }
        this.table = this.getDBString(string);
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String string) throws SQLException {
        if (string == null) {
            throw TbError.newSQLException(-90661);
        }
        this.partition = this.getDBString(string);
    }

    public boolean getParallelFlag() {
        return this.parallelFlag;
    }

    public void setParallelFlag(boolean bl) {
        this.parallelFlag = bl;
    }
}

