/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import springfox.documentation.service.ResourceGroup;

class ResourcePathProvider {
    private final ResourceGroup resourceGroup;

    ResourcePathProvider(ResourceGroup resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public Optional<String> resourcePath() {
        return Optional.fromNullable((Object)Strings.emptyToNull((String)((String)this.controllerClass().transform(this.resourcePathExtractor()).or((Object)""))));
    }

    private Function<Class<?>, String> resourcePathExtractor() {
        return new Function<Class<?>, String>(){

            public String apply(Class<?> input) {
                String path = (String)Iterables.getFirst(Arrays.asList(ResourcePathProvider.this.paths(input)), (Object)"");
                if (Strings.isNullOrEmpty((String)path)) {
                    return "";
                }
                if (path.startsWith("/")) {
                    return path;
                }
                return "/" + path;
            }
        };
    }

    @VisibleForTesting
    String[] paths(Class<?> controller) {
        RequestMapping annotation = (RequestMapping)AnnotationUtils.findAnnotation(controller, RequestMapping.class);
        if (annotation != null) {
            return annotation.path();
        }
        return new String[0];
    }

    private Optional<? extends Class<?>> controllerClass() {
        return this.resourceGroup.getControllerClass();
    }
}

