let dataColumns = [
    "id",
    "levl",
    "sect_lngt",
    "f_node_id",
    "f_node_nm",
    "t_node_id",
    "t_node_nm",
    "road_name",
    "prcn_dt",
    "cmtr_grad_desc",
    "sect_grad_cd",
    "prcn_sorc_desc",
    "adjs_sorc_desc",
];
const _apiUri       = '/api/its/common/detail-traffic';
let url             = new URL(document.location);
let _id             = url.searchParams.get('id');
let _type           = url.searchParams.get('type');
let _traf           = null;
let _trafHs         = null;
let _textMap        = new Map();
let _listData       = null;
let _popupWin       = null;
let _sectGradCdData = null;

$(() => {
    //소통정보이력
    _trafHs = $(".traf-hs").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode : 'single',
        },
        scrolling: {
            mode : 'standard',
        },
        sorting : {
            showSortIndexes : false,
            mode            : 'none',
        },
        columns:[
            {
                dataField    : "prcn_dt",
                caption      : "가공시간",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
                dataType     : 'datetime',
                format       : 'yyyy-MM-dd HH:mm:ss',
            },
            {
                dataField    : "cmtr_grad_desc",
                caption      : "소통등급",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "trvl_hh",
                caption      : "통행시간",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "sped",
                caption      : "속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "smth_sped",
                caption      : "평활화속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "prcn_sped",
                caption      : "가공속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "adjs_sped",
                caption      : "보정속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "ptrn_sped",
                caption      : "패턴속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "miss_yn",
                caption      : "결측",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "data_num",
                caption      : "수집원수",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "prcn_sorc_desc",
                caption      : "가공소스",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "adjs_sorc_desc",
                caption      : "보정소스",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
        ],
        onRowClick(info){
            if(!info.groupIndex && info.groupIndex !== 0){
                listRowClick(info.data);
            }
        },
    }).dxDataGrid("instance");

    //현재 소통정보
    _traf = $(".traf").width('100%').height('50px').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode : 'single',
        },
        scrolling: {
            mode : 'standard',
        },
        sorting : {
            showSortIndexes : false,
            mode:'none',
        },
        columns:[
            {
                dataField    : "trvl_hh",
                caption      : "통행시간",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "sped",
                caption      : "속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "smth_sped",
                caption      : "평활화속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "prcn_sped",
                caption      : "가공속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "adjs_sped",
                caption      : "보정속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "ptrn_sped",
                caption      : "패턴속도",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "miss_yn",
                caption      : "결측",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "data_num",
                caption      : "데이터 수",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
        ],
    }).dxDataGrid("instance");

    dataColumns.forEach( (column) => {
        let textBox = $('.' + column).dxTextBox({
            value: null,
            stylingMode : "outlined",
            height      : 23,
            readOnly    : true,
        }).dxTextBox('instance');
        _textMap.set(column, textBox);
    });

    creatBtn($('.sect-grad-btn'), 'edit', '구간 소통등급변경', '구간 소통등급변경', 'outlined', sectGradPopup);

    fetchBaseData();
});

function fetchBaseData(){
    getDataAsync(_apiUri + '/' + encodeURIComponent(_type) + '/' + encodeURIComponent(_id), rcevDataFunc);
}
function rcevDataFunc(jsonData){
    if (jsonData) {
        _listData = jsonData;

        _listData.id = _listData[_type+'_id'];
        dataColumns.map((item)=>{
            _textMap.get(item).option('value', _listData[item]);
        });

        if(_listData.traf){
            let traf = _listData.traf
            _traf.option('dataSource', [traf]);
            for(let key in traf){
                if(_textMap.get(key) && key !== 'prcn_dt'){
                    setValue(_textMap.get(key), traf[key]);
                }
            }


            if (traf.cmtr_grad_cd){
                $('.cmtr_grad_desc input').addClass(traf.cmtr_grad_cd);
            }
            else {
                setValue(_textMap.get('cmtr_grad_desc'), '정보없음');
                $('.cmtr_grad_desc input').addClass('LTC0');
            }
            if( traf.prcn_dt) setValue(_textMap.get('prcn_dt'), getParseDateTime(traf.prcn_dt))
        }

        if(_listData.traf_hs.length > 0){
            _listData.traf_hs.map((item)=>{
                if (item.prcn_dt) item.prcn_dt = getParseDateTime(item.prcn_dt);
            })
            _trafHs.option('dataSource', _listData.traf_hs);
        }
    }
    getDataAsync('/api/its/common/sect-grad-cd/list', (jsonData)=>{
        _sectGradCdData = jsonData;
        if (_sectGradCdData.length > 0) {
            if (_listData) {
                let idx = _sectGradCdData.findIndex((item)=> _listData.sect_grad_cd === item.sect_grad_cd);
                _textMap.get('sect_grad_cd').option('value', _sectGradCdData[idx].sect_grad_desc);
            }
        }
    });

}

function sectGradPopup(){
    _popupWin = window.open('./sect-grad-pop-up.html?type=' + encodeURIComponent(_type), 'sectGradPopup', 'width=575, height=355,  top = 450, left = 900, resizable=no, scrollbars=no');
}

function getListData(){
    return [_listData, _sectGradCdData];
}

function updateListData(sectGradCd){
    console.log(sectGradCd);
    let idx = _sectGradCdData.findIndex((item)=> sectGradCd === item.sect_grad_cd);

    _textMap.get('sect_grad_cd').option('value', _sectGradCdData[idx].sect_grad_desc);
    _listData.sect_grad_cd = sectGradCd;
}