let selectListTable;
let selectData;
let selectListData = [];
let linkData = [];

$(() => {
    selectListTable = $('.select-list-table')
        .width('100%')
        .height('100%')
        .dxDataGrid({
            dataSource              : [],
            allowColumnReordering   : true,
            showColumnLines         : true,
            allowColumnResizing     : true,
            showBorders             : true,
            rowAlternationEnabled   : true,
            columnAutoWidth         : true,
            focusedRowEnabled       : true,
            keyExpr                 : 'link_id',
            selection: {
                mode: 'single',
            },
            filterRow: {
                visible: true,
                applyFilter: "auto",
                showOperationChooser:false,
            },
            headerFilter: {
                visible: true,
            },
            scrolling: {
                mode: 'virtual', 
            }, 
            grouping: {
                autoExpandAll: true,
            },
            groupPanel: {
                visible: true,
                emptyPanelText: '그룹 지을 항목을 여기에 끌어다 놓으세요',
            },
            columns: [
                {
                    dataField : 'link_id',
                    caption   : 'ID',
                    alignment : 'center',
                    width     : 100,
                    sortIndex : 0,
                    dataType  : 'string',
                    sortOrder : 'asc',
                },
                {
                    dataField : 'from_node',
                    caption   : '시작 노드',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        c.css('text-align', 'left');
                        return c.text(e.displayValue)
                    }
                },
                {
                    dataField : 'to_node',
                    caption   : '종료 노드',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        c.css('text-align', 'left');
                        return c.text(e.displayValue)
                    }
                },
                {
                    dataField : 'link_leng',
                    caption   : '길이',
                    alignment : 'center',
                },
                {
                    dataField : 'road_name',
                    caption   : '도로명',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        c.css('text-align', 'left');
                        return c.text(e.displayValue)
                    }
                },
                {
                    dataField : 'road_no',
                    caption   : '도로번호',
                    alignment : 'center',
                },
                {
                    dataField : 'road_rank_desc',
                    caption   : '도로등급',
                    alignment : 'center',
                },
                {
                    dataField : 'road_type_desc',
                    caption   : '도로유형',
                    alignment : 'center',
                },
                {
                    dataField : 'lanes',
                    caption   : '차로수',
                    alignment : 'center',
                },
                {
                    dataField : 'max_spd',
                    caption   : '제한최고속도',
                    alignment : 'center',
                },
            ],
            onRowDblClick(e){
                let insertData = [];
                insertData.push({
                    edit      : '신규',
                    link_id   : e.data.link_id,
                    from_node : e.data.from_node,
                    to_node   : e.data.to_node,
                    sped      : 20,
                    ocpy_rate : 0,
                    tfvl      : 0,
                    trvl_hh   : 0,
                    crtn_dt   : new Date(),
                    aply_strt_dt : new Date(),
                    aply_end_dt : new Date(new Date(new Date().setHours(new Date().getHours() + 1))),
                });
                
                window.opener.editInsertData(insertData);
            },
            onSelectionChanged(e) {
                selectData = e.selectedRowsData[0];
            },
        })
        .dxDataGrid('instance');

        $(".select-button").dxButton({
            stylingMode:'outlined',
            icon:'check',
            text:'선택',
            onClick(){
                const seletedData = selectListTable.getSelectedRowsData();
                if( seletedData.length <= 0 ){
                    alertWarning('선택된 데이터가 없습니다.')
                }else{
                    let insertData = [];
                    insertData.push({
                        edit      : '신규',
                        link_id   : seletedData[0].link_id,
                        from_node : seletedData[0].from_node,
                        to_node   : seletedData[0].to_node,
                        sped      : 20,
                        ocpy_rate : 0,
                        tfvl      : 0,
                        trvl_hh   : 0,
                        crtn_dt   : new Date(),
                        aply_strt_dt : new Date(),
                        aply_end_dt : new Date(new Date(new Date().setHours(new Date().getHours() + 1))),
                    });
                    
                    window.opener.editInsertData(insertData);
                }
            }
        });
        fetchBaseData();
});

function fetchBaseData() {
    const trafficMap = window.opener.getTraffic();
    const link = trafficMap.get('link');
    const linkFormatData = [];
    if (link.length > 0) {
        link.map((obj)=>{
            let item = {...obj};
            item.from_node = '[' + item.f_node_id + '] ' + item.from_node;
            item.to_node = '[' + item.t_node_id + '] ' + item.to_node;
            linkFormatData.push(item);
        });
    }
    selectListTable.option('dataSource', linkFormatData);
}
//
// function fetchListData(jsonData) {
//     selectListData = jsonData;
//     if (selectListData.length > 0){
//         selectListData.map((item)=>{
//             item.from_node = '[' + item.f_node_id + '] ' + item.from_node;
//             item.to_node = '[' + item.t_node_id + '] ' + item.to_node;
//         });
//     }
//     selectListTable.option('dataSource', selectListData);
// }