let editBtn          = null; 
let cancleBtn        = null;
let addBtn           = null;
let deleteBtn        = null;
let applyBtn         = null;
let locationBtn      = null;
let allChangeLinkBtn = null;
let allCancleLinkBtn = null;
let syopTable        = null;
let searchBtn        = null;
let commonUri        = '/api/manage/traffic/syop_traf';
let syopData         = [];
let linkArr          = [];


const columns        = {
    link_id      : '링크 ID', 
    sped         : '속도', 
    crtn_dt      : '생성 시각', 
    aply_strt_dt : '적용 시작 시각', 
    aply_end_dt  : '종료 예정 시각', 
    ocpy_rate    : '',
    tfvl         : '',
    trvl_hh      : ''
};

const listOption     = 'width = 800, height = 900, top = 40, left = 500, resizable=yes, scrollbars=no';
const mapOption      = 'width = 1700, height = 900, top = 40, left = 100, resizable=yes, scrollbars=no';
const _multiSelct    = true;
const _linkLevel     = 1;
let _insertData      = [];
const _pageName      = '소통정보제보 관리';

const getParam = {
    MultiSelect: _multiSelct,
    LinkLevel: _linkLevel,
};

let _listPopup = null;
let _mapPopup  = null;

$(()=>{

//추가 버튼 선택 목록 감추기
$('body').on('click',function(){
    $(".add-select-btn").css('display','none');
})

//추가 버튼 목록에서 선택
$(".add-select-btn > div:nth-child(1)").on('click',function(){
    event.stopPropagation();
    _listPopup = window.open('./syop-traf-popup-link.html','목록 구간',listOption);
    $(".add-select-btn").css('display','none');
})

//추가 버튼 맵에서 선택
$(".add-select-btn > div:nth-child(2)").on('click',function(){
    event.stopPropagation();
    _mapPopup = window.open('./syop-traf-popup-map.html', '지도 구간', mapOption);
    $(".add-select-btn").css('display','none');
})



//취소버튼
cancleBtn = $(".cancle-btn").dxButton({
    stylingMode: 'outlined',
    width: '80px',
    height:'60%',
    visible: false,
    text: '취소',
    icon:'clear',
    onClick(){
        if ( syopTable.hasEditData() ){
            confirmMessage('변경된 정보가 있습니다. 취소 하시겠습니까?' ).done((yes) => {
                if (yes) {
                    eventOff(); 
                }
            });
        } else {
            eventOff();
        }
    }
}).dxButton('instance');

//추가버튼
addBtn = $(".add-btn").dxButton({
    stylingMode: 'outlined',
    width: '80px',
    height:'60%',
    disabled: true,
    text: '추가',
    icon:'plus',
    onClick(){
        event.stopPropagation();
        let x = event.clientX+10;
        let y = event.clientY-50;
        $(".add-select-btn").css('display','flex');
        $(".add-select-btn").css('position','absolute');
        $(".add-select-btn").css('left',x);
        $(".add-select-btn").css('top',y);
    }

}).dxButton('instance');

//삭제 버튼
deleteBtn = $(".delete-btn").dxButton({
    stylingMode: 'outlined',
    width: '80px',
    height:'60%',
    disabled: true,
    text: '삭제',
    icon:'minus',
    onClick(){
        dsblOnBtn(addBtn);
        dsblOnBtn(deleteBtn);

        syopTable.clearSelection();

        syopTable.option('selection',{
            mode : 'multiple'
        })

        syopTable.option('editing',{
            mode : 'none',
            allowUpdating : false,
        })
        
        syopTable.option('toolbar',{
            visible : false
        });
        applyBtn.off('click');
        applyBtn.on('click', () => delEvent());
    }
}).dxButton('instance');

//적용 버튼
applyBtn = $(".apply-btn").dxButton({
    stylingMode: 'outlined',
    width: '80px',
    height:'60%',
    disabled: true,
    text: '적용',
    icon:'save',
}).dxButton('instance');

//위치보기 버튼
locationBtn = $(".location-btn").dxButton({
    stylingMode: 'outlined',
    width: '120px',
    height:'80%',
    text: '위치보기',
    icon:'globe',
    onClick(){
        const rowData = syopTable.getSelectedRowsData();
        if(rowData <=0) return notSelectMsg('소통정보');
        try {
            window.opener.selectLink(rowData[0].link_id);
        } catch (err) {
            console.error(err);
        }
    }
}).dxButton('instance')

//조회버튼
searchBtn = $(".search-button").dxButton({
    stylingMode: 'outlined',
    width: '80px',
    height:'80%',
    text: '조회',
    icon:'refresh',
    onClick() {
        fetchBaseData();
    }
}).dxButton('instance');

//닫기버튼
$(".cancle-button").dxButton({
    stylingMode: 'outlined',
    width: '80px',
    height:'80%',
    text: '닫기',
    icon:'clear',
    onClick(){
        window.close();
    }
}).dxButton('instance');

//소통제보관리 테이블
syopTable = $(".oper-traffic-table").width("100%").height("100%").dxDataGrid({
    dataSource            : null,
    allowColumnReordering : true,
    showColumnLines       : true,
    allowColumnResizing   : true,
    showBorders           : true,
    rowAlternationEnabled : true,
    columnAutoWidth       : true,
    keyExpr               : ['link_id', 'crtn_dt'],
    noDataText            : '표출할 정보가 없습니다.',
    paging: {
        enabled: true,
        pageSize: 1000,
    },
    scrolling: {
        mode : 'standard',
    },
    selection: {
        mode               : 'single',
        showCheckBoxesMode : "onClick"
    },
    filterRow: {
        visible: true,
        applyFilter: "auto",
        showOperationChooser:false,
    },
    headerFilter: {
        visible: true,
    },
    export:{
        enabled: true,
        texts: {
            exportAll:"엑셀 파일",
        },
    },
    editing:{
        mode          : 'cell',
        allowUpdating : false,
    },
    onExporting(e){
        gridExcellExporting(e, _pageName);
    },
    columns : [{
            dataField    : "edit",
            caption      : "편집모드",
            alignment    : "center",
            allowEditing : false,
            visible      : false,
            width        : 120,
            cellTemplate(c,e){
                let text = e.displayValue;
                if(!e.displayValue) text = '-';
                c.text(text);
            }
        },
        {
            dataField    : "link_id",
            caption      : "링크 ID",
            allowEditing : false,
            alignment    : "center",
            dataType     : 'string',
        },
        {
            dataField    : "from_node",
            caption      : "시작노드",
            allowEditing : false,
            alignment    : "center",
            cellTemplate(c,e){
                let result = nullChecker(e.displayValue);
                return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>');
            }
        },
        {
            dataField    : "to_node",
            caption      : "종료노드",
            allowEditing : false,
            alignment    : "center",
            cellTemplate(c,e){
                let result = nullChecker(e.displayValue);
                return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>');
            }
        },
        {
            dataField    : "crtn_dt",
            caption      : "생성 시각",
            allowEditing : false,
            alignment    : "center",
            dataType     : "datetime",
            format       : "yyyy-MM-dd HH:mm:ss"
        },
        {
            dataField    : "aply_strt_dt",
            caption      : "적용 시작 시각",
            alignment    : "center",
            dataType     : "datetime",
            format       : "yyyy-MM-dd HH:mm:ss"
        },
        {
            dataField    : "aply_end_dt",
            caption      : "적용 종료 시각",
            alignment    : "center",
            dataType     : "datetime",
            format       : "yyyy-MM-dd HH:mm:ss"
        },
        {
            dataField    : "sped",
            caption      : "속도",
            alignment    : "center",
            editorOptions :{
                dataType : 'number',
                max      : 999,
            }
        },
    ],
    onSelectionChanged(row){
        listSelectionChnaged(row);
    },
    onCellHoverChanged(cell){
        listCellHoverChanged(cell);
    }
}).dxDataGrid("instance");

//편집 버튼
editBtn = $(".edit-btn").dxButton({
    stylingMode: 'outlined',
    width: '80px',
    height:'60%',
    text: '편집',
    icon:'edit',
    onClick(){
        eventOn();
        applyBtn.off('click');
        applyBtn.on('click', () => editEvent());
    }
}).dxButton('instance');

fetchBaseData();

});

function fetchBaseData(){
    getDataAsync(commonUri, fetchListData);
};

function fetchListData(jsonData){
    syopData = jsonData;
    if (syopData) {
        syopData = dataFormmat(syopData);
    }
    syopTable.option('dataSource', syopData);
}

/**
 * 내용 변경 후 다른 화면으로 이동 시 수정 활성화
 * @param {*} cell 수정 될 셀
 */
function listCellHoverChanged(cell){
    const tableList = cell.component
    if(tableList.option('editing.changes').length > 0){
        let changes = tableList.option('editing.changes');
        changes.map((item)=>{
            let rowIdx = tableList.getRowIndexByKey(item.key);
            const editVal = tableList.cellValue(rowIdx,'edit');
            if(!editVal){
                tableList.cellValue(rowIdx, 'edit', '수정');
            }
        })
    }
}

/**
 * 삭제 모드 일때 클릭 시 변환 함수
 * @param {*} row 선택 로우 정보
 */
function listSelectionChnaged(row){
    const tableList = row.component;
    if (tableList.option('selection.mode') === 'multiple') {
        let deSelIdx = tableList.getRowIndexByKey(row.currentDeselectedRowKeys[0]);
        let selIdx   = tableList.getRowIndexByKey(row.currentSelectedRowKeys[0]);
        if (deSelIdx !== -1 || selIdx !== -1) {
            tableList.cancelEditData();
            if (row.selectedRowKeys.length > 0 ) {
                row.selectedRowKeys.map((item)=>{
                    const selectedRow = tableList.getRowIndexByKey(item)
                    tableList.cellValue(selectedRow, 'edit', '삭제');
                })
            }
        }
    }
}

//링크 정보
function getLinkArr(){
    return linkArr;
}

/**
 * 날짜 데이터 스트링에서 데이트 객체로 형변환
 * @param {*} data 변경 할 소통정보 제보 관리 데이터 
 * @returns 
 */
function dataFormmat(data){
    if (data) {
        data.map((item)=>{
            if(item.crtn_dt) item.crtn_dt = new Date(getParseDateTime(item.crtn_dt));
            if(item.aply_strt_dt) item.aply_strt_dt = new Date(getParseDateTime(item.aply_strt_dt));
            if(item.aply_end_dt) item.aply_end_dt = new Date(getParseDateTime(item.aply_end_dt));
        });
    }
    return data;
}

/**
 * 날짜 데이터 데이트 객체에서 스트링으로 형변환
 * @param {*} data 변경 할 소통정보 제보 관리 데이터
 * @returns 
 */
function updateFormmat(data){
        if(data.crtn_dt) data.crtn_dt = getSendDate(data.crtn_dt);
        if(data.aply_strt_dt) data.aply_strt_dt = getSendDate(data.aply_strt_dt);
        if(data.aply_end_dt) data.aply_end_dt = getSendDate(data.aply_end_dt);
    return data;
}

//수정만 했을 경우
function editEvent(){
    const changeArr = syopTable.option('editing.changes');
        let updateData  = [];
        if(!syopTable.hasEditData()) return alertWarning('변경된 소통 정보가 없습니다.');
        for(let idx in changeArr){
            const change     = changeArr[idx];
            const keys       = change.key;
            const editIndex  = syopTable.getRowIndexByKey(keys);
            let   setData    = {};
            const dataSource = syopTable.option('dataSource');
            //날짜 값 가져오기
            for ( let key in columns ){
                setData[key] = dataSource[editIndex][key];
                if (changeArr[idx].data[key]) setData[key] = changeArr[idx].data[key];
                if (nullChecker(setData[key]) === "" || changeArr[idx].data[key] === null) {
                    return alertWarning('소통정보 제보 링크 ID : ' + setData.link_id + '<br>' + columns[key] + '를 입력해주세요');
                }
            }
            setData = updateFormmat(setData);
            const frontContent = '소통정보 제보 링크 ID : ' + setData.link_id + '<br>';

            if (setData.sped.toString().length > 3) return alertWarning(frontContent + '속도는 3자리수까지만 입력이 가능합니다.');
            else if (setData.crtn_dt > setData.aply_strt_dt) return alertWarning(frontContent + '생성 일시가 적용 시작 일시 보다 큽니다.');
            else if (setData.aply_strt_dt > setData.aply_end_dt) return alertWarning(frontContent + '적용 시작 일시가 적용 종료 일시 보다 큽니다.');
            else updateData.push(setData);
        }
        const result = postInsertUpdate(commonUri, updateData);
        if (result > 0) {
            insResultMsg('소통정보');
            syopTable.saveEditData();
            eventOff();
        }
}

//삭제 버튼 클릭 이벤트
function delEvent(){
    if(syopTable.getSelectedRowsData().length <= 0) return notSelectMsg('소통정보');
    
    const selectedData = syopTable.getSelectedRowsData();
    
    let delData = [];
    
    for (idx in selectedData) {
        let crtn_dt = getSendDate(selectedData[idx].crtn_dt);
        let link_id = selectedData[idx].link_id;
        delData.push({
            crtn_dt : crtn_dt,
            link_id : link_id,
        })
    }
    confirmMessage('소통정보제보 목록을 삭제 하시겠습니까?').done((yes) => {
        if (yes) {
            const result =  deleteDataIds(commonUri, delData);
            if (result > 0) {
                delResultMsg('소통');
                eventOff();
            }
        }
    });
}

//편집 모드 활성화 
function eventOn(){
    hideBtn(editBtn);
    showBtn(cancleBtn);
    dsblOffBtn(deleteBtn);
    dsblOffBtn(addBtn);
    dsblOffBtn(applyBtn);
    dsblOnBtn(searchBtn);
    showColumn( syopTable, 'edit' );

    syopTable.option('editing',{
        mode          : 'batch',
        allowUpdating : true,
    });
    
    syopTable.option('toolbar',{
        visible:false
    });

    syopTable.refresh();
}

//편집 모드 비활성화
function eventOff(){
    showBtn(editBtn);
    dsblOnBtn(deleteBtn);
    dsblOnBtn(applyBtn);
    dsblOnBtn(addBtn);
    dsblOffBtn(searchBtn);
    hideBtn(cancleBtn);
    hideColumn( syopTable, 'edit' );
    
    syopTable.option('editing',{
        mode : 'none',
        allowUpdating : false,
    });
    
    syopTable.option('selection',{
        mode :'single'
    });

    syopTable.option('toolbar',{
        visible : true
    });

    fetchBaseData();
    
    syopTable.refresh();

    syopTable.clearSelection();
}

//지도 관련 파라미터
function getParams(){
    return getParam;
}

/**
 * 편집 추가 시 발생 이벤트
 * @param data 추가 된 데이터
 */
function editInsertData(data){
    dsblOnBtn(deleteBtn);
    const dataSource = [];
    if (syopTable.hasEditData()){
        syopTable.option('editing.changes').map((item)=>{
            syopTable.byKey(item.key).done((obj)=>{
                dataSource.push({...obj});
            })
        })
    }
    for(let idx in data){
        dataSource.push(data[idx]);
    }
    const beforeDataSource = syopTable.option('dataSource');
    let sameData = new Map();
    dataSource.map((obj)=>{
        sameData.set(obj.link_id, obj);
    });

    beforeDataSource.map((obj, idx)=>{
        let editData = sameData.get(obj.link_id);
        if (editData && editData.crtn_dt === obj.crtn_dt){
            beforeDataSource[idx] = editData;
            sameData.delete(obj.link_id);
        }
    })
    sameData.forEach((obj)=>{
        beforeDataSource.push(obj);
    })
    syopTable.option('dataSource', beforeDataSource);
    syopTable.refresh().then(()=>{
        for(let idx in dataSource){
            for(let key in dataSource[idx]){
                const keys = {link_id: dataSource[idx].link_id, crtn_dt:dataSource[idx].crtn_dt};
                const rowIdx = syopTable.getRowIndexByKey(keys);
                if (key !== 'link_id' || key !== 'crtn_dt') {
                    syopTable.cellValue(rowIdx, key, dataSource[idx][key]);
                }
            }
        }
        if(_listPopup) _listPopup.close();
        if(_mapPopup) _mapPopup.close();
    });

}

function getTraffic() {
    return _trafficMap;
}
