//우측 섹션 관련
let sttsData           = [];
let sttsTable          = null;

//좌측 섹션 관련
let sttsListTable      = null;
let sttsListData       = [];
let sttsStartDate      = null;
let sttsEndDate        = null;
let sttsStartTime      = null;
let sttsEndTime        = null;
let sttsSearchBtn      = null;

//공통
let commonUri        = '/api/vds/history/stts';
const _pageName       = 'VDS-제어기 상태 이력';
const pageMsg        = 'VDS-제어기'


//기본 날짜 세팅
getData('/api/vds/common/vds-list', sttsListData);
$(()=>{
    
    //검색시작일시 년월일
    sttsStartDate =  $('.strt-date').dxDateBox({
        type                : 'date',
        value               : new Date().setDate(new Date().getDate()-1),
        width               : 130,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox('instance');

    //검색 시작일시 시간
    sttsStartTime =  $('.strt-time').dxDateBox({
        type                : 'time',
        value               : firstSettingTime,
        width               : 75,
        interval            : 10,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');
    
    //검색종료일시 년월일
    sttsEndDate =  $('.end-date').dxDateBox({
        type                : 'date',
        value               : new Date().setDate(new Date().getDate()-1),
        width               : 130,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox('instance');
    
    //검색종료일시 시간
    sttsEndTime =  $('.end-time').dxDateBox({
        type                : 'time',
        value               : endSettingTime,
        width               : 75,
        interval            : 10,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');
    

    //상단 조회 버튼
    sttsSearchBtn = $('.traf-stts-search-btn').dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        width: '80px',
        onClick(){
            hsEvent();
        }
    }).dxButton("instance")
   


    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
 
    
     //소통정보 이력분석 테이블
     sttsListTable = $(".stts-list-talbe").width('100%').height('100%').dxDataGrid({
        dataSource              : sttsListData[0],
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        headerFilter: {
            visible: true,
        },
        selection: {
            mode: 'multiple',
            showCheckBoxesMode:"onClick"
        },
        keyExpr : 'ctlr_mngm_nmbr',
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
                    {
                        dataField    : "ctlr_mngm_nmbr",
                        caption      : "관리번호",
                        alignment    : "center",
                        sortIndex    : 0, 
                        sortOrder    : "asc",
                    },
                    {
                        dataField    : "lctn",
                        caption      : "위치",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
        ],
      
        
    }).dxDataGrid("instance");

    sttsTable = $('.stts-table').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'vds_ctlr_id',
        scrolling               : {
            mode : 'virtual',
        },
        headerFilter: {
            visible: true,
        },
        export:{
            enabled : true,
            texts   : {
                exportAll:"엑셀 파일",
            },
        },
        columns:[
                    {
                        dataField    : "vds_ctlr_id",
                        caption      : "제어기ID",
                        alignment    : "center",
                        sortIndex    : 0, 
                        sortOrder    : "asc",
                    },
                    
                    {
                        dataField    : "vds_nm",
                        caption      : "설치 위치",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
                    {
                        dataField    : "ocrr_dt",
                        caption      : "수집시각",
                        alignment    : "center",
                    },
                    {
                        dataField    : "cmnc_stts_desc",
                        caption      : "통신",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('padding', '3px');
                            c.css('height', '1px');
                            const div = $('<span class="tdBox '+e.data.cmnc_stts_cd+'">').text(e.displayValue);
                            c.append(div)
                            return c
                        }
                    },
                    {
                        dataField    : "prnt_pwer_stts_desc",
                        caption      : "전원",
                        alignment    : "center",
                        visible      : false,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.prnt_pwer_stts_cd;
                            if (!e.data.prnt_pwer_stts_cd) {
                                classNm = 'gray'
                            }
                            const div = $('<div class="tdBox '+classNm+'">')
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "cbox_door_stts_desc",
                        caption      : "함체문",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.cbox_door_stts_cd;
                            if(!e.data.cbox_door_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class="tdBox '+classNm+'">');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "fan_stts_desc",
                        caption      : "팬",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.fan_stts_cd;
                            if(!e.data.fan_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class="tdBox '+classNm+'">');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "hetr_stts_desc",
                        caption      : "히터",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.hetr_stts_cd;
                            if(!e.data.hetr_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class="tdBox '+classNm+'">');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "cbox_tmpr",
                        caption      : "함체온도",
                        alignment    : "center",
                        cellTemplate(c, e) {
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = '';
                            let text = e.data.cbox_tmpr;
                            if(text === null || text === 255){
                                classNm = 'gray'
                                text = '-'
                            }
                            const div = $('<div class="tdBox '+classNm+'">');
                            div.text(text);
                            return c.append(div);
                        }
                    },
                    
                ],
                onExporting(e){
                    gridExcellExporting(e, _pageName);
                },
    }).dxDataGrid('instance');
})

 //구간별 데이터 세팅
 function hsEvent() {
     let TO_DT        = null;
     let FROM_DT      = null;
     let id           = "";
     const selectData = sttsListTable.getSelectedRowsData();
     let updateData = {};
     switch (true) {

         case selectData <= 0 :
            alertWarning( pageMsg + '가 선택 되지 않았습니다.<br>' + pageMsg + ' 목록에서 ' + pageMsg + '를 선택해주세요');
            return false;

         case !validationCheck( sttsStartDate, sttsEndDate, sttsStartTime, sttsEndTime ) :
            return false;

         case getDate( sttsStartDate.option('value'), sttsStartTime.option('value') ) > getDate( sttsEndDate.option('value'), sttsEndTime.option('value') ):
            sttsStartDate.focus();
            alertWarning('검색 시작 시각이 검색 종료 시각보다 큽니다.', null, sttsStartDate);
            return false;

         default:

            FROM_DT = getDate( sttsStartDate.option('value'), sttsStartTime.option('value') );
            TO_DT = getDate( sttsEndDate.option('value'), sttsEndTime.option('value') );
            for( idx in selectData){
                id += selectData[idx].ctlr_mngm_nmbr + ",";
            }
            break;
     }
    
    updateData[ 'FROM_DT' ] = FROM_DT;
    updateData[ 'TO_DT' ]   = TO_DT;
    updateData[ 'id' ]      = id.slice(0,-1)
    sttsData = [];
    getDataAsync( commonUri, (jsonData)=>{
        sttsData = jsonData;
        if ( sttsData.length > 0) {
            sttsData.map((item)=>{
                if(nullChecker(item.ocrr_dt) !== ""){
                    item.ocrr_dt = getParseDateTime(item.ocrr_dt)
                }
           });
        }

        sttsTable.option( 'dataSource', sttsData );
        selResultMsg(sttsData);
    }, null, updateData );
    
 }
