import { _mapManager, doMap, updateUnitStts, _itsData, _bisData, _fcltData, updateFcltStts } from "./main-func.js";
import * as BIS from "./main-bis.js";


//TODO
//ITS: CCTV 영상
//     VMS 표출 메시지
export let _errorSwitch = false;
/**
 * 어플리케이션 최초 기동시 함수(최초 1회 수행)
 */
 export function startApp() {
    doMap();
    registerUiEvent();
}

// 메뉴 이벤트 등록
function registerUiEvent() {
    mapToggle();
    facilityMenuToggles();
}

//맵토글
function mapToggle() {
    _mapManager.toggleBaseMap();
    $(".mapBtn").on("click", function (e) {
        if ($(".mapBtn").attr("src") == "/images/application_wall/header/mapOffBtn.png") {
            $(".mapBtn").attr("src", "/images/application_wall/header/mapOnBtn.png");
            $(".satalBtn").attr("src", "/images/application_wall/header/satalOffBtn.png");
             _mapManager.toggleBaseMap();
        }
            
    });
        
    $(".satalBtn").on("click", function (e) {
        if ($(".satalBtn").attr("src") == "/images/application_wall/header/satalOffBtn.png") {
            $(".mapBtn").attr("src", "/images/application_wall/header/mapOffBtn.png");
            $(".satalBtn").attr("src", "/images/application_wall/header/satalOnBtn.png");
            _mapManager.toggleBaseMap();
            //_mapManager.toggleTrafficPolyBackColor();
        } 
    });
}


function facilityMenuToggles() {
    facilityMenuToggle("VDS");
    facilityMenuToggle("VMS");
    facilityMenuToggle("CCTV");
    facilityMenuToggle("BIT");
    // facilityMenuToggle("RSE");
}

// its 우측상단 현장시설물 토글 온오프
function facilityMenuToggle(ALayerName) {
    const attr = ".its" + ALayerName;
    const onImage = "/images/application_wall/header/btn" + ALayerName + "On.png";
    const offImage = "/images/application_wall/header/btn" + ALayerName + "Off.png";

    $(attr).on("click", function () {
        const onOffAttrChecker = $(attr).attr("src");

        if (onOffAttrChecker == onImage) {
            $(attr).attr("src", offImage);
            _mapManager.showFacilityLayer(ALayerName, false);
        } else {
            $(attr).attr("src", onImage);
            _mapManager.showFacilityLayer(ALayerName, true);
        }
    });
}

/**
 * UI Interface
 */
// 상단 ITS 메뉴 클릭
$(".itsBtn").on("click", function (e) {
    $(".itsBtn").attr("src", "/images/application_wall/header/itsOnBtn.png");
    $(".bisBtn").attr("src", "/images/application_wall/header/bisOffBtn.png");
    $(".bottom_bis").hide();
    $(".bottom_its").show();
    $(".busListBar").hide();
    $(".busInfoBar").hide();
    $(".busListBarHide").hide();
    $(".busListBarShow").hide();
    $(".busStationInfo").hide();
    $(".busStationInfoLeft").hide();
    $(".bitBtn").attr("src", "/images/application_wall/header/bitOffBtn.png");

    // 소통정보 레이어 보이기
    _mapManager.showTrafficLayer(true);
    // BIS 레이어 감추기
    BIS.hideBisMap();
});

$('.headerImg').on("dblclick", ()=>{
    if (!_errorSwitch) {
        _errorSwitch = true;
        $("#windowPop").css("visibility", "hidden");
    }
    else {
        _errorSwitch = false;
        $('#windowPopList').empty();
    }
    
    updateFcltStts(_fcltData[0]);
    updateFcltStts(_fcltData[1]);
    updateUnitStts(_itsData);
    updateUnitStts(_bisData);
    
});

export function getErrorColor(value){
   return value > 0 ? 'red' : 'white';
}

// 상단 BIS 메뉴 클릭
$(".bisBtn").on("click", function (e) {
    $(".itsBtn").attr("src", "/images/application_wall/header/itsOffBtn.png");
    $(".bisBtn").attr("src", "/images/application_wall/header/bisOnBtn.png");
    $(".bottom_its").hide();
    $(".bottom_bis").show();
    $(".busListBar").show();
    $(".busInfoBar").show();
    $(".busListBarHide").show();
    $(".busStationInfo").show();
    $(".busStationInfoLeft").show();
    $(".bitBtn").attr("src", "/images/application_wall/header/bitOffBtn.png");

    // 소통정보 레이어 숨기기
    _mapManager.showTrafficLayer(false);

    leftMenuClickCommon(0);
    BIS.showBisMap();
    BIS.leftBitMenuClick();
});
// 좌측 리스트 메뉴 클릭시 공통 처리 함수
function leftMenuClickCommon(AMenuId) {
    $("#busList").empty();
    $("#busSearch").val(null);

    switch (AMenuId) {
        case 0: // BIT
            $(".leftBitOff").attr("src", "/images/application_wall/bis/leftBitOn.png");
            $(".leftBusOff").attr("src", "/images/application_wall/bis/leftBusOff.png");
            $(".leftLineOff").attr("src", "/images/application_wall/bis/leftLineOff.png");
            break;
        case 1: // BUS클릭
            $(".leftBitOff").attr("src", "/images/application_wall/bis/leftBitOff.png");
            $(".leftBusOff").attr("src", "/images/application_wall/bis/leftBusOn.png");
            $(".leftLineOff").attr("src", "/images/application_wall/bis/leftLineOff.png");
            break;
        case 2: // LINE
            $(".leftBitOff").attr("src", "/images/application_wall/bis/leftBitOff.png");
            $(".leftBusOff").attr("src", "/images/application_wall/bis/leftBusOff.png");
            $(".leftLineOff").attr("src", "/images/application_wall/bis/leftLineOn.png");
            break;
    }
}

$(".leftBitOff").on("click", function () {
    leftMenuClickCommon(0);
    BIS.initLeftMenuClick();
    BIS.leftBitMenuClick();
});
// 좌측 BUS 메뉴 클릭
$(".leftBusOff").on("click", function () {
    leftMenuClickCommon(1);
    BIS.initLeftMenuClick();
    BIS.leftBusMenuClick();
});
// 죄측 노선 메뉴 클릭
$(".leftLineOff").on("click", function () {
    leftMenuClickCommon(2);
    BIS.initLeftMenuClick();
    BIS.leftLineMenuClick();
});
// 좌측 리스트(BIT/BUS/LINE) 검색 클릭
$(".busSearchBtn").on("click", function () {
    BIS.leftMenuSearchClick();
});

// 좌측 리스트 메뉴 숨기기
$(".busListBarHide").on("click", function (e) {
    $(".busListBar").hide();
    $(".busListBarHide").hide();
    $(".busListBarShow").show();
});
// 좌측 리스트 메뉴 보이기
$(".busListBarShow").on("click", function (e) {
    $(".busListBar").show();
    $(".busListBarShow").hide();
    $(".busListBarHide").show();
});
// 하단 리스트 목록 숨기기/보이기
let frmHide = true;
$(".bottomHide").on("click", function () {
    if (frmHide == true) {
        $(".bottomHide").animate({ bottom: "-=275" }, 200);
    } else $(".bottomHide").animate({ bottom: "+=275" }, 200);

    $(".bottom_Frm").toggle("slide", { direction: "down", easing: "linear" }, 200, function () {
        if (frmHide == true) {
            //$('.map_container').attr('style','height: 100% !important');
            $(".bottomHide").attr("src", "/images/application_wall/bottomShow.png");

            $(".bottom_Frm").hide();
            $(".bottom_toggle").hide();
            frmHide = false;
        } else {
            // $('.map_container').attr('style','height: 80% !important');
            $(".bottomHide").attr("src", "/images/application_wall/bottomHide.png");

            $(".bottom_Frm").show();
            $(".bottom_toggle").show();
            frmHide = true;
        }
    });
});
