/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.AttachmentException;
import org.springframework.ws.soap.AbstractSoapMessage;
import org.springframework.ws.soap.SoapEnvelope;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.saaj.SaajAttachment;
import org.springframework.ws.soap.saaj.SaajSoapEnvelope;
import org.springframework.ws.soap.saaj.SaajSoapEnvelopeException;
import org.springframework.ws.soap.saaj.SaajSoapMessageException;
import org.springframework.ws.soap.saaj.support.SaajUtils;
import org.springframework.ws.soap.support.SoapUtils;
import org.springframework.ws.transport.TransportOutputStream;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class SaajSoapMessage
extends AbstractSoapMessage {
    private static final String CONTENT_TYPE_XOP = "application/xop+xml";
    private final MessageFactory messageFactory;
    private SOAPMessage saajMessage;
    private SoapEnvelope envelope;
    private final boolean langAttributeOnSoap11FaultString;

    public SaajSoapMessage(SOAPMessage soapMessage) {
        this(soapMessage, true, null);
    }

    public SaajSoapMessage(SOAPMessage soapMessage, MessageFactory messageFactory) {
        this(soapMessage, true, messageFactory);
    }

    public SaajSoapMessage(SOAPMessage soapMessage, boolean langAttributeOnSoap11FaultString) {
        this(soapMessage, langAttributeOnSoap11FaultString, null);
    }

    public SaajSoapMessage(SOAPMessage soapMessage, boolean langAttributeOnSoap11FaultString, MessageFactory messageFactory) {
        Assert.notNull((Object)soapMessage, (String)"soapMessage must not be null");
        this.saajMessage = soapMessage;
        this.langAttributeOnSoap11FaultString = langAttributeOnSoap11FaultString;
        this.messageFactory = messageFactory;
    }

    public SOAPMessage getSaajMessage() {
        return this.saajMessage;
    }

    public void setSaajMessage(SOAPMessage soapMessage) {
        Assert.notNull((Object)soapMessage, (String)"soapMessage must not be null");
        this.saajMessage = soapMessage;
        this.envelope = null;
    }

    @Override
    public SoapEnvelope getEnvelope() {
        if (this.envelope == null) {
            try {
                SOAPEnvelope saajEnvelope = this.getSaajMessage().getSOAPPart().getEnvelope();
                this.envelope = new SaajSoapEnvelope(saajEnvelope, this.langAttributeOnSoap11FaultString);
            }
            catch (SOAPException ex) {
                throw new SaajSoapEnvelopeException(ex);
            }
        }
        return this.envelope;
    }

    @Override
    public String getSoapAction() {
        MimeHeaders mimeHeaders = this.getSaajMessage().getMimeHeaders();
        if (SoapVersion.SOAP_11 == this.getVersion()) {
            Object[] actions = mimeHeaders.getHeader("SOAPAction");
            return ObjectUtils.isEmpty((Object[])actions) ? "\"\"" : actions[0];
        }
        if (SoapVersion.SOAP_12 == this.getVersion()) {
            Object[] contentTypes = mimeHeaders.getHeader("Content-Type");
            return !ObjectUtils.isEmpty((Object[])contentTypes) ? SoapUtils.extractActionFromContentType((String)contentTypes[0]) : "\"\"";
        }
        throw new IllegalStateException("Unsupported SOAP version: " + this.getVersion());
    }

    @Override
    public void setSoapAction(String soapAction) {
        MimeHeaders mimeHeaders = this.getSaajMessage().getMimeHeaders();
        soapAction = SoapUtils.escapeAction(soapAction);
        if (SoapVersion.SOAP_11 == this.getVersion()) {
            mimeHeaders.setHeader("SOAPAction", soapAction);
        } else if (SoapVersion.SOAP_12 == this.getVersion()) {
            try {
                this.saajMessage.saveChanges();
            }
            catch (SOAPException ex) {
                throw new SaajSoapMessageException("Could not save message", ex);
            }
            Object[] contentTypes = mimeHeaders.getHeader("Content-Type");
            Object contentType = !ObjectUtils.isEmpty((Object[])contentTypes) ? contentTypes[0] : this.getVersion().getContentType();
            contentType = SoapUtils.setActionInContentType((String)contentType, soapAction);
            mimeHeaders.setHeader("Content-Type", (String)contentType);
            mimeHeaders.removeHeader("SOAPAction");
        } else {
            throw new IllegalStateException("Unsupported SOAP version: " + this.getVersion());
        }
    }

    @Override
    public Document getDocument() {
        Assert.state((this.messageFactory != null ? 1 : 0) != 0, (String)"Could find message factory to use");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.getSaajMessage().writeTo((OutputStream)bos);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            SOAPMessage saajMessage = this.messageFactory.createMessage(this.getSaajMessage().getMimeHeaders(), (InputStream)bis);
            this.setSaajMessage(saajMessage);
            return saajMessage.getSOAPPart();
        }
        catch (SOAPException ex) {
            throw new SaajSoapMessageException("Could not save changes", ex);
        }
        catch (IOException ex) {
            throw new SaajSoapMessageException("Could not save changes", ex);
        }
    }

    @Override
    public void setDocument(Document document) {
        if (this.saajMessage.getSOAPPart() != document) {
            Assert.state((this.messageFactory != null ? 1 : 0) != 0, (String)"Could find message factory to use");
            try {
                DOMImplementation implementation = document.getImplementation();
                Assert.isInstanceOf(DOMImplementationLS.class, (Object)implementation);
                DOMImplementationLS loadSaveImplementation = (DOMImplementationLS)((Object)implementation);
                LSOutput output = loadSaveImplementation.createLSOutput();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                output.setByteStream(bos);
                LSSerializer serializer = loadSaveImplementation.createLSSerializer();
                serializer.write(document, output);
                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                this.saajMessage = this.messageFactory.createMessage(this.saajMessage.getMimeHeaders(), (InputStream)bis);
            }
            catch (SOAPException ex) {
                throw new SaajSoapMessageException("Could not read input stream", ex);
            }
            catch (IOException ex) {
                throw new SaajSoapMessageException("Could not read input stream", ex);
            }
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        MimeHeaders mimeHeaders = this.getSaajMessage().getMimeHeaders();
        if (ObjectUtils.isEmpty((Object[])mimeHeaders.getHeader("Accept"))) {
            mimeHeaders.setHeader("Accept", this.getVersion().getContentType());
        }
        try {
            SOAPMessage message = this.getSaajMessage();
            message.saveChanges();
            if (outputStream instanceof TransportOutputStream) {
                TransportOutputStream transportOutputStream = (TransportOutputStream)outputStream;
                MimeHeaders headers = message.getMimeHeaders();
                if (ObjectUtils.isEmpty((Object[])headers.getHeader("Content-Type"))) {
                    SOAPEnvelope envelope1 = message.getSOAPPart().getEnvelope();
                    if (envelope1.getElementQName().getNamespaceURI().equals(SoapVersion.SOAP_11.getEnvelopeNamespaceUri())) {
                        headers.addHeader("Content-Type", SoapVersion.SOAP_11.getContentType());
                    } else {
                        headers.addHeader("Content-Type", SoapVersion.SOAP_12.getContentType());
                    }
                    message.saveChanges();
                }
                Iterator iterator = headers.getAllHeaders();
                while (iterator.hasNext()) {
                    MimeHeader mimeHeader = (MimeHeader)iterator.next();
                    transportOutputStream.addHeader(mimeHeader.getName(), mimeHeader.getValue());
                }
            }
            message.writeTo(outputStream);
            outputStream.flush();
        }
        catch (SOAPException ex) {
            throw new SaajSoapMessageException("Could not write message to OutputStream: " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isXopPackage() {
        String[] contentTypes;
        SOAPPart saajPart = this.saajMessage.getSOAPPart();
        for (String contentType : contentTypes = saajPart.getMimeHeader("Content-Type")) {
            if (!contentType.contains(CONTENT_TYPE_XOP)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean convertToXopPackage() {
        this.convertMessageToXop();
        this.convertPartToXop();
        return true;
    }

    private void convertMessageToXop() {
        MimeHeaders mimeHeaders = this.saajMessage.getMimeHeaders();
        Object[] oldContentTypes = mimeHeaders.getHeader("Content-Type");
        Object oldContentType = !ObjectUtils.isEmpty((Object[])oldContentTypes) ? oldContentTypes[0] : this.getVersion().getContentType();
        mimeHeaders.setHeader("Content-Type", "application/xop+xml;type=\"" + (String)oldContentType + '\"');
    }

    private void convertPartToXop() {
        SOAPPart saajPart = this.saajMessage.getSOAPPart();
        Object[] oldContentTypes = saajPart.getMimeHeader("Content-Type");
        Object oldContentType = !ObjectUtils.isEmpty((Object[])oldContentTypes) ? oldContentTypes[0] : this.getVersion().getContentType();
        saajPart.setMimeHeader("Content-Type", "application/xop+xml;type=\"" + (String)oldContentType + '\"');
    }

    @Override
    public Iterator<Attachment> getAttachments() throws AttachmentException {
        Iterator iterator = this.getSaajMessage().getAttachments();
        return new SaajAttachmentIterator(iterator);
    }

    @Override
    public Attachment getAttachment(String contentId) {
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.setHeader("Content-Id", contentId);
        Iterator iterator = this.getSaajMessage().getAttachments(mimeHeaders);
        if (!iterator.hasNext()) {
            return null;
        }
        AttachmentPart saajAttachment = (AttachmentPart)iterator.next();
        return new SaajAttachment(saajAttachment);
    }

    @Override
    public Attachment addAttachment(String contentId, DataHandler dataHandler) {
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        Assert.notNull((Object)dataHandler, (String)"dataHandler must not be null");
        SOAPMessage message = this.getSaajMessage();
        AttachmentPart attachmentPart = message.createAttachmentPart(dataHandler);
        message.addAttachmentPart(attachmentPart);
        attachmentPart.setContentId(contentId);
        attachmentPart.setMimeHeader("Content-Transfer-Encoding", "binary");
        return new SaajAttachment(attachmentPart);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SaajSoapMessage");
        try {
            SOAPElement bodyElement;
            SOAPBody body;
            SOAPEnvelope envelope = this.saajMessage.getSOAPPart().getEnvelope();
            if (envelope != null && (body = envelope.getBody()) != null && (bodyElement = SaajUtils.getFirstBodyElement(body)) != null) {
                builder.append(' ');
                builder.append(bodyElement.getElementQName());
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return builder.toString();
    }

    private static class SaajAttachmentIterator
    implements Iterator<Attachment> {
        private final Iterator<AttachmentPart> saajIterator;

        private SaajAttachmentIterator(Iterator<AttachmentPart> saajIterator) {
            this.saajIterator = saajIterator;
        }

        @Override
        public boolean hasNext() {
            return this.saajIterator.hasNext();
        }

        @Override
        public Attachment next() {
            AttachmentPart saajAttachment = this.saajIterator.next();
            return new SaajAttachment(saajAttachment);
        }

        @Override
        public void remove() {
            this.saajIterator.remove();
        }
    }
}

