/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;

public class DefaultStrategiesHelper {
    private Properties defaultStrategies;

    public DefaultStrategiesHelper(Properties defaultStrategies) {
        Assert.notNull((Object)defaultStrategies, (String)"defaultStrategies must not be null");
        this.defaultStrategies = defaultStrategies;
    }

    public DefaultStrategiesHelper(Resource resource) throws IllegalStateException {
        try {
            this.defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load '" + resource + "': " + ex.getMessage());
        }
    }

    public DefaultStrategiesHelper(Class<?> type) {
        this((Resource)new ClassPathResource(ClassUtils.getShortName(type) + ".properties", type));
    }

    public <T> List<T> getDefaultStrategies(Class<T> strategyInterface) throws BeanInitializationException {
        return this.getDefaultStrategies(strategyInterface, null);
    }

    public <T> List<T> getDefaultStrategies(Class<T> strategyInterface, ApplicationContext applicationContext) throws BeanInitializationException {
        String key = strategyInterface.getName();
        try {
            List result;
            String value = this.defaultStrategies.getProperty(key);
            if (value != null) {
                String[] classNames = StringUtils.commaDelimitedListToStringArray((String)value);
                result = new ArrayList(classNames.length);
                ClassLoader classLoader = null;
                if (applicationContext != null) {
                    classLoader = applicationContext.getClassLoader();
                }
                if (classLoader == null) {
                    classLoader = DefaultStrategiesHelper.class.getClassLoader();
                }
                for (String className : classNames) {
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)classLoader);
                    Assert.isTrue((boolean)strategyInterface.isAssignableFrom(clazz), (String)(clazz.getName() + " is not a " + strategyInterface.getName()));
                    T strategy = this.instantiateBean(clazz, applicationContext);
                    result.add(strategy);
                }
            } else {
                result = Collections.emptyList();
            }
            Collections.sort(result, new OrderComparator());
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new BeanInitializationException("Could not find default strategy class for interface [" + key + "]", (Throwable)ex);
        }
    }

    private <T> T instantiateBean(Class<T> clazz, ApplicationContext applicationContext) {
        Object strategy = BeanUtils.instantiateClass(clazz);
        if (strategy instanceof BeanNameAware) {
            BeanNameAware beanNameAware = (BeanNameAware)strategy;
            beanNameAware.setBeanName(clazz.getName());
        }
        if (applicationContext != null) {
            if (strategy instanceof BeanClassLoaderAware) {
                ((BeanClassLoaderAware)strategy).setBeanClassLoader(applicationContext.getClassLoader());
            }
            if (strategy instanceof BeanFactoryAware) {
                ((BeanFactoryAware)strategy).setBeanFactory((BeanFactory)applicationContext);
            }
            if (strategy instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)strategy).setResourceLoader((ResourceLoader)applicationContext);
            }
            if (strategy instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)strategy).setApplicationEventPublisher((ApplicationEventPublisher)applicationContext);
            }
            if (strategy instanceof MessageSourceAware) {
                ((MessageSourceAware)strategy).setMessageSource((MessageSource)applicationContext);
            }
            if (strategy instanceof ApplicationContextAware) {
                ApplicationContextAware applicationContextAware = (ApplicationContextAware)strategy;
                applicationContextAware.setApplicationContext(applicationContext);
            }
            if (applicationContext instanceof WebApplicationContext && strategy instanceof ServletContextAware) {
                ServletContext servletContext = ((WebApplicationContext)applicationContext).getServletContext();
                ((ServletContextAware)strategy).setServletContext(servletContext);
            }
        }
        if (strategy instanceof InitializingBean) {
            InitializingBean initializingBean = (InitializingBean)strategy;
            try {
                initializingBean.afterPropertiesSet();
            }
            catch (Throwable ex) {
                throw new BeanCreationException("Invocation of init method failed", ex);
            }
        }
        return (T)strategy;
    }

    public <T> T getDefaultStrategy(Class<T> strategyInterface) throws BeanInitializationException {
        return this.getDefaultStrategy(strategyInterface, null);
    }

    public <T> T getDefaultStrategy(Class<T> strategyInterface, ApplicationContext applicationContext) throws BeanInitializationException {
        List<T> result = this.getDefaultStrategies(strategyInterface, applicationContext);
        if (result.size() != 1) {
            throw new BeanInitializationException("Could not find exactly 1 strategy for interface [" + strategyInterface.getName() + "]");
        }
        return result.get(0);
    }
}

