/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class BindData {
    protected BindItem[] bindItems = null;
    protected int deferredParamCnt = 0;

    public BindData() {
    }

    public BindData(int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-590731);
        }
        if (this.bindItems == null) {
            this.initialize(n);
        }
    }

    private void checkParameterIndex(int n) throws SQLException {
        if (this.bindItems == null || n < 0 || n >= this.bindItems.length) {
            throw TbError.newSQLException(-90609);
        }
    }

    public void clearDFRParameter() throws SQLException {
        this.deferredParamCnt = 0;
    }

    public void clone(BindData bindData) throws SQLException {
        int n = this.bindItems.length;
        bindData.initialize(n);
        for (int i = 0; i < n; ++i) {
            this.bindItems[i].clone(bindData.bindItems[i]);
        }
        bindData.deferredParamCnt = this.deferredParamCnt;
    }

    public BindItem[] getBindItems() {
        return this.bindItems;
    }

    public BindItem getBindItem(int n) throws SQLException {
        this.checkParameterIndex(n);
        return this.bindItems[n];
    }

    public int getDFRParameterCnt() {
        return this.deferredParamCnt;
    }

    public int getInOutParameterCnt() {
        int n = 0;
        for (int i = 0; i < this.bindItems.length; ++i) {
            if (!this.bindItems[i].isOUTParameter() || !this.bindItems[i].isINParameter()) continue;
            ++n;
        }
        return n;
    }

    public int getInParameterCnt() {
        int n = 0;
        for (int i = 0; i < this.bindItems.length; ++i) {
            if (!this.bindItems[i].isINParameter()) continue;
            ++n;
        }
        return n;
    }

    public int getOutParameterCnt() {
        int n = 0;
        for (int i = 0; i < this.bindItems.length; ++i) {
            if (!this.bindItems[i].isOUTParameter()) continue;
            ++n;
        }
        return n;
    }

    public int getParameterCnt() {
        return this.bindItems.length;
    }

    private void initialize(int n) {
        this.bindItems = new BindItem[n];
        for (int i = 0; i < n; ++i) {
            this.bindItems[i] = new BindItem();
        }
    }

    public void insertDFRLiteral(int n, int n2, int n3) throws SQLException {
        int n4 = this.bindItems.length;
        for (int i = n4 - 1; i > n; --i) {
            this.bindItems[i] = this.bindItems[i - 1];
        }
        this.bindItems[n] = new BindItem();
        this.bindItems[n].set(8, n2, n3);
        ++this.deferredParamCnt;
    }

    public boolean isInParameterOn(int n) throws SQLException {
        this.checkParameterIndex(n);
        return this.bindItems[n].isINParameter();
    }

    public boolean isOutParameterOn(int n) throws SQLException {
        this.checkParameterIndex(n);
        return this.bindItems[n].isOUTParameter();
    }

    public String getOutParameterTypeName(int n) throws SQLException {
        this.checkParameterIndex(n);
        return this.bindItems[n].getTypeName();
    }

    public void removeDFRLiteral(int[] nArray) {
        int n = 0;
        int n2 = this.bindItems.length - nArray.length;
        BindItem[] bindItemArray = this.bindItems;
        this.bindItems = new BindItem[n2];
        for (int i = 0; i < bindItemArray.length; ++i) {
            int n3;
            for (n3 = 0; n3 < nArray.length && i != nArray[n3]; ++n3) {
            }
            if (n3 != nArray.length) continue;
            this.bindItems[n++] = bindItemArray[i];
        }
    }

    public void reset() {
        if (this.bindItems == null) {
            return;
        }
        for (int i = 0; i < this.bindItems.length; ++i) {
            this.bindItems[i].reset();
            this.bindItems[i] = null;
        }
        this.bindItems = null;
    }

    public void resize(int n) {
        if (this.bindItems == null) {
            this.initialize(n);
        } else if (n > this.bindItems.length) {
            BindItem[] bindItemArray = this.bindItems;
            this.bindItems = new BindItem[n];
            System.arraycopy(bindItemArray, 0, this.bindItems, 0, bindItemArray.length);
            for (int i = bindItemArray.length; i < n; ++i) {
                this.bindItems[i] = new BindItem();
            }
        } else if (n < this.bindItems.length) {
            BindItem[] bindItemArray = this.bindItems;
            this.bindItems = new BindItem[n];
            System.arraycopy(bindItemArray, 0, this.bindItems, 0, n);
        }
    }

    public void reuse() {
        if (this.bindItems == null) {
            return;
        }
        for (int i = 0; i < this.bindItems.length; ++i) {
            this.bindItems[i].reuse();
        }
        this.deferredParamCnt = 0;
    }

    public void set(BindData bindData) throws SQLException {
        int n = bindData.getParameterCnt();
        if (this.bindItems == null) {
            this.initialize(n);
        } else {
            this.reuse();
        }
        System.arraycopy(bindData.bindItems, 0, this.bindItems, 0, n);
        this.deferredParamCnt = bindData.getDFRParameterCnt();
    }

    public void setDFRParam(int n, int n2, int n3) throws SQLException {
        this.checkParameterIndex(n);
        this.bindItems[n].set(8, n2, n3);
        ++this.deferredParamCnt;
    }

    public void setINParam(int n, int n2, int n3) throws SQLException {
        this.checkParameterIndex(n);
        this.bindItems[n].set(1, n2, n3);
    }

    public void setOUTParam(int n, int n2) throws SQLException {
        this.checkParameterIndex(n);
        this.bindItems[n].set(2, n2);
    }

    public void setOUTParam(int n, int n2, String string) throws SQLException {
        this.checkParameterIndex(n);
        this.bindItems[n].set(2, n2);
        this.bindItems[n].setTypeName(string);
    }

    public void setOUTParam(int n, int n2, String string, TbConnection tbConnection) throws SQLException {
        this.checkParameterIndex(n);
        this.bindItems[n].set(2, n2);
        this.bindItems[n].setTypeName(string);
        this.bindItems[n].requestUdtMeta(n2, tbConnection);
    }
}

