/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class CharToByteSingleByte {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    protected short[] index1;
    protected String index2;
    protected int mask1;
    protected int mask2;
    protected int shift;

    public CharToByteSingleByte() {
    }

    public CharToByteSingleByte(short[] sArray, String string, int n, int n2, int n3) {
        this.index1 = sArray;
        this.index2 = string;
        this.mask1 = n;
        this.mask2 = n2;
        this.shift = n3;
    }

    public CharToByteSingleByte(short[] sArray, String string, int n, int n2, int n3, boolean bl, byte[] byArray) {
        this.index1 = sArray;
        this.index2 = string;
        this.mask1 = n;
        this.mask2 = n2;
        this.shift = n3;
        this.subMode = bl;
        this.subBytes = byArray;
    }

    public boolean canConvert(char c) {
        if (this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2)) != '\u0000') {
            return true;
        }
        return c == '\u0000';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5;
        int n6 = 0;
        int n7 = 0;
        char c = '\u0000';
        byte[] byArray2 = new byte[1];
        n7 = n3;
        if (c != '\u0000') {
            c = '\u0000';
            if (cArray[n] < '\udc00' || cArray[n] > '\udfff') throw TbError.newSQLException(-590743, (int)cArray[n]);
            throw TbError.newSQLException(-590742, (int)cArray[n]);
        }
        for (n6 = n; n6 < n2; n6 += n5) {
            byte[] byArray3 = byArray2;
            char c2 = cArray[n6];
            int n8 = 1;
            n5 = 1;
            if (c2 >= '\ud800' && c2 <= '\udbff') {
                if (n6 + 1 >= n2) {
                    c = c2;
                    return n7 - n3;
                }
                c2 = cArray[n6 + 1];
                if (c2 < '\udc00' || c2 > '\udfff') throw TbError.newSQLException(-590743, (int)c2);
                if (!this.subMode) throw TbError.newSQLException(-590742, (int)c2);
                byArray3 = this.subBytes;
                n8 = this.subBytes.length;
                n5 = 2;
            } else {
                if (c2 >= '\udc00' && c2 <= '\udfff') {
                    throw TbError.newSQLException(-590743, (int)c2);
                }
                byArray3[0] = this.getNative(c2);
                if (byArray3[0] == 0 && cArray[n6] != '\u0000') {
                    if (!this.subMode) throw TbError.newSQLException(-590742, (int)byArray3[0]);
                    byArray3 = this.subBytes;
                    n8 = this.subBytes.length;
                }
            }
            if (n7 + n8 > n4) {
                throw TbError.newSQLException(-590714, "Conversion buffer overflow");
            }
            for (int i = 0; i < n8; ++i) {
                byArray[n7++] = byArray3[i];
            }
        }
        return n7 - n3;
    }

    public short[] getIndex1() {
        return this.index1;
    }

    public String getIndex2() {
        return this.index2;
    }

    public int getMaxBytesPerChar() {
        return 1;
    }

    public byte getNative(char c) {
        return (byte)this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
    }
}

