/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLParser;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public abstract class TbRowSet
implements RowSet {
    protected String url;
    protected String dataSourceName;
    protected String username;
    protected String password;
    protected int isolation;
    protected String command;
    protected boolean isClosed;
    protected boolean readOnly;
    protected boolean showDeleted;
    protected int maxFieldSize;
    protected int maxRows;
    protected boolean escapeProcessing;
    protected int queryTimeout;
    protected int rowsetType;
    protected int concurrency;
    protected int fetchDirection;
    protected int fetchSize;
    protected Vector listeners;
    protected Map typeMap;
    private Vector matchColumnIndexes;
    private Vector matchColumnNames;
    protected Vector params;
    protected SQLWarning warnings;
    protected String[] paramNames;
    protected RowSetEvent rowsetEvent;
    static final int PARAM_NSTRING = 0;
    static final int PARAM_ASCII = 1;
    static final int PARAM_BINARY = 2;
    static final int PARAM_CHARACTER = 3;
    static final int PARAM_NCHARACTER = 4;
    static final int PARAM_BLOB = 5;
    static final int PARAM_CLOB = 6;
    static final int PARAM_NCLOB = 7;

    public TbRowSet() {
        this.initialize();
        this.listeners = new Vector();
        this.matchColumnIndexes = new Vector(10);
        this.matchColumnNames = new Vector(10);
        this.rowsetEvent = new RowSetEvent(this);
        this.isClosed = false;
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        this.listeners.add(rowSetListener);
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
        } else {
            this.warnings = sQLWarning;
        }
    }

    protected void checkMatchColumnIndexesExist() throws SQLException {
        if (this.matchColumnIndexes.size() == 0) {
            throw TbError.newSQLException(-90860);
        }
    }

    protected void checkMatchColumnNamesExist() throws SQLException {
        if (this.matchColumnNames.size() == 0) {
            throw TbError.newSQLException(-90861);
        }
    }

    private void checkParameterIndex(int n) throws SQLException {
        if (n < 1) {
            throw TbError.newSQLException(-90844, Integer.toString(n));
        }
    }

    public synchronized void clearParameters() throws SQLException {
        this.params = null;
        this.params = new Vector();
    }

    public synchronized void clearWarnings() {
        this.warnings = null;
    }

    public abstract void execute() throws SQLException;

    int findParam(String string) throws SQLException {
        int n = 0;
        for (n = 0; n < this.paramNames.length && !this.paramNames[n].equals(string); ++n) {
        }
        if (n == this.paramNames.length) {
            throw TbError.newSQLException(-90845, string);
        }
        return n + 1;
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean getEscapeProcessing() {
        return this.escapeProcessing;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Object[] getParams() {
        if (this.params == null) {
            return new Object[0];
        }
        return this.params.toArray();
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public int getType() {
        return this.rowsetType;
    }

    public Map getTypeMap() {
        return this.typeMap;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    protected void initialize() {
        this.command = null;
        this.dataSourceName = null;
        this.dataSourceName = null;
        this.escapeProcessing = true;
        this.fetchSize = 0;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.queryTimeout = 0;
        this.readOnly = true;
        this.showDeleted = false;
        this.username = null;
        this.password = null;
        this.url = null;
        this.fetchDirection = 1002;
        this.rowsetType = 1005;
        this.concurrency = 1007;
        this.isolation = 2;
        this.params = new Vector();
        this.typeMap = new HashMap();
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isShowDeleted() {
        return this.showDeleted;
    }

    protected void notifyCursorMoved() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((RowSetListener)iterator.next()).cursorMoved(this.rowsetEvent);
        }
    }

    protected void notifyRowChanged() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((RowSetListener)iterator.next()).rowChanged(this.rowsetEvent);
        }
    }

    protected void notifyRowSetChanged() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((RowSetListener)iterator.next()).rowSetChanged(this.rowsetEvent);
        }
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.listeners.remove(rowSetListener);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, array);
    }

    public void setArray(String string, Array array) throws SQLException {
        this.setArray(this.findParam(string), array);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(1)};
        this.params.add(n - 1, objectArray);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParam(string), inputStream, n);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, bigDecimal);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParam(string), bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{inputStream, new Integer(n2), new Integer(2)};
        this.params.add(n - 1, objectArray);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParam(string), inputStream, n);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, blob);
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        this.setBlob(this.findParam(string), blob);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParam(string), bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Byte(by));
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParam(string), by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, byArray);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParam(string), byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{reader, new Integer(n2), new Integer(3)};
        this.params.add(n - 1, objectArray);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParam(string), reader, n);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, clob);
    }

    public void setClob(String string, Clob clob) throws SQLException {
        this.setClob(this.findParam(string), clob);
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
        this.paramNames = TbSQLParser.getParamNames(this.command);
    }

    public void setConcurrency(int n) throws SQLException {
        switch (n) {
            case 1007: 
            case 1008: {
                this.concurrency = n;
                return;
            }
        }
        throw TbError.newSQLException(-90608);
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{date, calendar};
        this.params.add(n - 1, objectArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParam(string), date);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParam(string), date, calendar);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Double(d));
    }

    public void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.findParam(string), d);
    }

    public void setEscapeProcessing(boolean bl) {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Float(f));
    }

    public void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.findParam(string), f);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Integer(n2));
    }

    public void setInt(String string, int n) throws SQLException {
        this.setInt(this.findParam(string), n);
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Long(l));
    }

    public void setLong(String string, long l) throws SQLException {
        this.setLong(this.findParam(string), l);
    }

    public void setMaxFieldSize(int n) {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{new Integer(n2), string};
        this.params.add(n - 1, objectArray);
    }

    public void setNull(String string, int n) throws SQLException {
        this.setNull(this.findParam(string), n);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.findParam(string), n, string2);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2)};
        this.params.add(n - 1, objectArray);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{object, new Integer(n2), new Integer(n3)};
        this.params.add(n - 1, objectArray);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParam(string), object);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.findParam(string), object, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParam(string), object, n, n2);
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, ref);
    }

    public void setRef(String string, Ref ref) throws SQLException {
        this.setRef(this.findParam(string), ref);
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, new Short(s));
    }

    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParam(string), s);
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    public void setString(int n, String string) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, string);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setString(this.findParam(string), string2);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{time, calendar};
        this.params.add(n - 1, objectArray);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParam(string), time);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParam(string), time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkParameterIndex(n);
        this.params.add(n - 1, timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParameterIndex(n);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.params.add(n - 1, objectArray);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParam(string), timestamp);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParam(string), timestamp, calendar);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        switch (n) {
            case 2: 
            case 8: {
                this.isolation = n;
                break;
            }
            default: {
                throw TbError.newSQLException(-90608);
            }
        }
    }

    public void setType(int n) throws SQLException {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.rowsetType = n;
                break;
            }
            default: {
                throw TbError.newSQLException(-90608);
            }
        }
    }

    public void setTypeMap(Map map) {
        this.typeMap = map;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.setURL(this.findParam(string), uRL);
    }

    public void setUsername(String string) {
        this.username = string;
    }
}

