/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import org.modelmapper.spi.NamingConvention;
import org.modelmapper.spi.PropertyType;

public class NamingConventions {
    public static final NamingConvention JAVABEANS_ACCESSOR = new NamingConvention(){

        @Override
        public boolean applies(String propertyName, PropertyType propertyType) {
            return PropertyType.FIELD.equals((Object)propertyType) || propertyName.startsWith("get") && propertyName.length() > 3 || propertyName.startsWith("is") && propertyName.length() > 2;
        }

        public String toString() {
            return "Javabeans Accessor";
        }
    };
    public static final NamingConvention JAVABEANS_MUTATOR = new NamingConvention(){

        @Override
        public boolean applies(String propertyName, PropertyType propertyType) {
            return PropertyType.FIELD.equals((Object)propertyType) || propertyName.startsWith("set") && propertyName.length() > 3;
        }

        public String toString() {
            return "Javabeans Mutator";
        }
    };
    public static final NamingConvention NONE = new NamingConvention(){

        @Override
        public boolean applies(String propertyName, PropertyType propertyType) {
            return true;
        }

        public String toString() {
            return "None";
        }
    };

    public static NamingConvention builder() {
        return NamingConventions.builder("");
    }

    public static NamingConvention builder(String prefix) {
        return new BuilderNamingConventions(prefix);
    }

    private static class BuilderNamingConventions
    implements NamingConvention {
        private String prefix;

        private BuilderNamingConventions(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean applies(String propertyName, PropertyType propertyType) {
            return PropertyType.METHOD.equals((Object)propertyType) && propertyName.startsWith(this.prefix);
        }

        public String toString() {
            return "Builder(prefix=" + this.prefix + ")";
        }
    }
}

