/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.ArrayList;
import java.util.List;
import org.modelmapper.Condition;
import org.modelmapper.Converter;
import org.modelmapper.Provider;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.InternalMapping;
import org.modelmapper.internal.util.Strings;
import org.modelmapper.spi.PropertyInfo;

abstract class MappingImpl
implements InternalMapping,
Comparable<MappingImpl> {
    private final List<PropertyInfo> destinationMutators;
    private final boolean explicit;
    private final String path;
    private int skipType;
    private Condition<?, ?> condition;
    protected Provider<?> provider;
    protected Converter<?, ?> converter;

    MappingImpl(List<? extends PropertyInfo> destinationMutators) {
        this.destinationMutators = new ArrayList<PropertyInfo>(destinationMutators);
        this.path = Strings.join(destinationMutators);
        this.explicit = false;
    }

    MappingImpl(List<? extends PropertyInfo> destinationMutators, ExplicitMappingBuilder.MappingOptions options) {
        this.destinationMutators = new ArrayList<PropertyInfo>(destinationMutators);
        this.path = Strings.join(destinationMutators);
        this.skipType = options.skipType;
        this.condition = options.condition;
        this.provider = options.provider;
        this.converter = options.converter;
        this.explicit = true;
    }

    MappingImpl(MappingImpl copy, List<? extends PropertyInfo> mergedMutators) {
        this.destinationMutators = new ArrayList<PropertyInfo>(copy.destinationMutators.size() + mergedMutators.size());
        this.destinationMutators.addAll(mergedMutators);
        this.destinationMutators.addAll(copy.destinationMutators);
        this.path = Strings.join(this.destinationMutators);
        this.skipType = copy.skipType;
        this.condition = copy.condition;
        this.provider = copy.provider;
        this.converter = copy.converter;
        this.explicit = copy.explicit;
    }

    @Override
    public int compareTo(MappingImpl mapping) {
        return this.path.compareToIgnoreCase(mapping.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MappingImpl)) {
            return false;
        }
        MappingImpl other = (MappingImpl)obj;
        return this.path.equals(other.path);
    }

    @Override
    public Condition<?, ?> getCondition() {
        return this.condition;
    }

    @Override
    public Converter<?, ?> getConverter() {
        return this.converter;
    }

    @Override
    public List<? extends PropertyInfo> getDestinationProperties() {
        return this.destinationMutators;
    }

    @Override
    public PropertyInfo getLastDestinationProperty() {
        return this.destinationMutators.get(this.destinationMutators.size() - 1);
    }

    @Override
    public Provider<?> getProvider() {
        return this.provider;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public boolean isSkipped() {
        return this.skipType != 0;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isExplicit() {
        return this.explicit;
    }

    ExplicitMappingBuilder.MappingOptions getOptions() {
        ExplicitMappingBuilder.MappingOptions options = new ExplicitMappingBuilder.MappingOptions();
        options.skipType = this.skipType;
        options.condition = this.condition;
        options.converter = this.converter;
        options.provider = this.provider;
        return options;
    }
}

