/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.util;

import java.lang.reflect.Constructor;
import org.modelmapper.internal.util.Callable;

public class Objects {
    private Objects() {
    }

    public static <T> T firstNonNull(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static <T> T firstNonNull(Callable<T> ... callables) {
        for (Callable<T> callable : callables) {
            T obj = callable.call();
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static <T> Callable<T> callable(final T obj) {
        return new Callable<T>(){

            @Override
            public T call() {
                return obj;
            }
        };
    }

    public static <T> T instantiate(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

