/*
 * Decompiled with CFR 0.152.
 */
package org.qlrm.generator;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ClassGenerator {
    @Deprecated
    public void generateFromTables(String path, String pkg, String suffix, boolean publicFields, Connection con, String ... tables) throws SQLException, FileNotFoundException {
        this.generateFromTables(path, pkg, suffix, publicFields, null, con, tables);
    }

    public void generateFromTables(String path, String pkg, String suffix, boolean publicFields, String schema, Connection con, String ... tables) throws SQLException, FileNotFoundException {
        DatabaseMetaData metadata = con.getMetaData();
        for (String table : tables) {
            String className = this.generateClassName(table, suffix);
            PrintWriter outputStream = new PrintWriter(new FileOutputStream(this.createFileName(path, pkg, className)));
            this.createClassHeader(outputStream, pkg, className);
            ResultSet colResults = metadata.getColumns(null, schema, table, null);
            this.createClassBody(colResults, outputStream, className, publicFields);
            outputStream.close();
            colResults.close();
        }
    }

    public void generateFromResultSet(String path, String pkg, String className, boolean publicFields, ResultSet resultSet) throws SQLException, FileNotFoundException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        try (PrintWriter outputStream = new PrintWriter(new FileOutputStream(this.createFileName(path, pkg, className)));){
            this.createClassHeader(outputStream, pkg, className);
            this.createClassBody(metaData, outputStream, className, publicFields);
        }
    }

    private void createClassHeader(PrintWriter outputStream, String pkg, String className) {
        if (pkg != null) {
            outputStream.println("package " + pkg + ";\n");
        }
        outputStream.println("import java.io.Serializable;");
        outputStream.println("import java.sql.Date;");
        outputStream.println("import java.sql.Time;");
        outputStream.println("import java.sql.Timestamp;");
        outputStream.println("import java.math.BigDecimal;");
        outputStream.println("import java.math.BigInteger;");
        outputStream.println("import java.sql.Blob;");
        outputStream.println("\n");
        outputStream.println("public class " + className + " implements Serializable {\n");
        outputStream.println("\n");
        outputStream.println("  private static final long serialVersionUID = 1L;");
    }

    private String createFileName(String path, String pkg, String className) {
        if (pkg == null) {
            return path + "/" + className + ".java";
        }
        return path + "/" + pkg.replaceAll("\\.", "/") + "/" + className + ".java";
    }

    private void createClassBody(ResultSet colResults, PrintWriter outputStream, String className, boolean publicFields) throws SQLException {
        StringBuilder ctrArgs = new StringBuilder();
        StringBuilder ctrBody = new StringBuilder();
        StringBuilder getters = new StringBuilder();
        boolean first = true;
        while (colResults.next()) {
            if (!first) {
                ctrArgs.append(", ");
            }
            String name = colResults.getString("COLUMN_NAME").toLowerCase();
            short colType = colResults.getShort("DATA_TYPE");
            this.generateCtrAndGetters(colType, outputStream, publicFields, name, ctrArgs, ctrBody, getters);
            first = false;
        }
        this.writeCtrAndGetters(outputStream, className, ctrArgs, ctrBody, getters);
    }

    private void createClassBody(ResultSetMetaData metaData, PrintWriter outputStream, String className, boolean publicFields) throws SQLException {
        StringBuilder ctrArgs = new StringBuilder();
        StringBuilder ctrBody = new StringBuilder();
        StringBuilder getters = new StringBuilder();
        boolean first = true;
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            if (!first) {
                ctrArgs.append(", ");
            }
            String name = metaData.getColumnName(i).toLowerCase();
            int colType = metaData.getColumnType(i);
            this.generateCtrAndGetters(colType, outputStream, publicFields, name, ctrArgs, ctrBody, getters);
            first = false;
        }
        this.writeCtrAndGetters(outputStream, className, ctrArgs, ctrBody, getters);
    }

    private String sqlTypeToJavaTypeString(int dataType) {
        String typeString;
        switch (dataType) {
            case -6: {
                typeString = "byte";
                break;
            }
            case -5: {
                typeString = "BigInteger";
                break;
            }
            case 4: {
                typeString = "Integer";
                break;
            }
            case 5: {
                typeString = "Short";
                break;
            }
            case 1: {
                typeString = "Character";
                break;
            }
            case -9: 
            case -1: 
            case 12: {
                typeString = "String";
                break;
            }
            case 6: 
            case 8: {
                typeString = "Double";
                break;
            }
            case 7: {
                typeString = "Float";
                break;
            }
            case 2: 
            case 3: {
                typeString = "BigDecimal";
                break;
            }
            case 91: {
                typeString = "Date";
                break;
            }
            case -7: {
                typeString = "boolean";
                break;
            }
            case 1111: {
                typeString = "Object";
                break;
            }
            case 93: {
                typeString = "Timestamp";
                break;
            }
            case 92: {
                typeString = "Time";
                break;
            }
            case 2004: {
                typeString = "Blob";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                typeString = "byte[]";
                break;
            }
            default: {
                typeString = "Object";
            }
        }
        return typeString;
    }

    private String generateClassName(String table, String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        return table.substring(0, 1).toUpperCase() + table.substring(1).toLowerCase() + suffix;
    }

    private void generateCtrAndGetters(int colType, PrintWriter outputStream, boolean publicFields, String name, StringBuilder ctrArgs, StringBuilder ctrBody, StringBuilder getters) {
        String type = this.sqlTypeToJavaTypeString(colType);
        outputStream.println(publicFields ? "  public " : "  private " + type + " " + name + ";");
        ctrArgs.append(type).append(" ").append(name);
        ctrBody.append("    this.").append(name).append(" = ").append(name).append(";\n");
        if (!publicFields) {
            getters.append("  public ").append(type).append(" get").append(name.substring(0, 1).toUpperCase()).append(name.substring(1)).append("() {\n");
            getters.append("    return ").append(name).append(";\n }\n");
        }
    }

    private void writeCtrAndGetters(PrintWriter outputStream, String className, StringBuilder ctrArgs, StringBuilder ctrBody, StringBuilder getters) {
        outputStream.println("\n");
        outputStream.println("  public " + className + " (" + ctrArgs.toString() + ") {\n");
        outputStream.println(ctrBody.toString());
        outputStream.println("  }\n");
        outputStream.println(getters.toString());
        outputStream.println("}");
    }
}

