/*
 * Decompiled with CFR 0.152.
 */
package org.qlrm.mapper;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.qlrm.mapper.ResultMapper;

public class JpaResultMapper
extends ResultMapper {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_BOX_TYPE_MAP = new HashMap();

    public <T> List<T> list(Query q, Class<T> clazz) throws IllegalArgumentException {
        ArrayList result = new ArrayList();
        List<Object[]> list = this.postProcessResultList(q.getResultList());
        Constructor<?> ctor = null;
        if (list != null && !list.isEmpty()) {
            ctor = this.findConstructor(clazz, list.get(0));
        }
        for (Object[] obj : list) {
            result.add(this.createInstance(ctor, obj));
        }
        return result;
    }

    private List<Object[]> postProcessResultList(List<?> rawResults) {
        ArrayList<Object[]> result = new ArrayList();
        if (rawResults.size() == 1) {
            for (Object rawResult : rawResults) {
                result.add(this.postProcessSingleResult(rawResult));
            }
        } else {
            result = rawResults;
        }
        return result;
    }

    private Object[] postProcessSingleResult(Object rawResult) {
        Object[] objectArray;
        if (rawResult instanceof Object[]) {
            objectArray = (Object[])rawResult;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = rawResult;
        }
        return objectArray;
    }

    public <T> T uniqueResult(Query q, Class<T> clazz) {
        Object[] rec = this.postProcessSingleResult(q.getSingleResult());
        Constructor<?> ctor = this.findConstructor(clazz, rec);
        return this.createInstance(ctor, rec);
    }

    private Constructor<?> findConstructor(Class<?> clazz, Object ... args) {
        Constructor<?> result = null;
        Constructor<?>[] ctors = clazz.getDeclaredConstructors();
        if (ctors.length == 1 && ctors[0].getParameterTypes().length == args.length) {
            result = ctors[0];
        }
        if (ctors.length > 1) {
            block0: for (Constructor<?> ctor : ctors) {
                Class<?>[] parameterTypes = this.postProcessConstructorParameterTypes(ctor.getParameterTypes());
                if (parameterTypes.length != args.length) continue;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> argType;
                    if (args[i] != null && !parameterTypes[i].isAssignableFrom(argType = this.convertToBoxTypeIfPrimitive(args[i].getClass()))) continue block0;
                }
                result = ctor;
                break;
            }
        }
        if (null == result) {
            StringBuilder sb = new StringBuilder("No constructor taking:\n");
            for (Object object : args) {
                if (object == null) continue;
                sb.append("\t").append(object.getClass().getName()).append("\n");
            }
            throw new RuntimeException(sb.toString());
        }
        return result;
    }

    private Class<?>[] postProcessConstructorParameterTypes(Class<?>[] rawParameterTypes) {
        Class[] result = new Class[rawParameterTypes.length];
        for (int i = 0; i < rawParameterTypes.length; ++i) {
            Class<?> currentType = rawParameterTypes[i];
            result[i] = this.convertToBoxTypeIfPrimitive(currentType);
        }
        return result;
    }

    private Class<?> convertToBoxTypeIfPrimitive(Class<?> primitiveType) {
        return PRIMITIVE_TO_BOX_TYPE_MAP.getOrDefault(primitiveType, primitiveType);
    }

    static {
        PRIMITIVE_TO_BOX_TYPE_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_BOX_TYPE_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_BOX_TYPE_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_BOX_TYPE_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_BOX_TYPE_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_BOX_TYPE_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_BOX_TYPE_MAP.put(Double.TYPE, Double.class);
    }
}

