/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.pivot;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.data.TbNumber;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.pivot.TbPivotMeta;
import com.tmax.tibero.pivot.TbPivotValHdrItem;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class TbPivotValReader {
    Blob blobData;
    byte[] byteData;
    int itemCnt;
    int offsetIdx;
    Vector hdr;
    HashMap newIdxMap;

    private byte[] getNextRpcolData() throws Exception {
        byte[] byArray;
        int n;
        int n2;
        int n3;
        if (this.offsetIdx >= this.itemCnt) {
            throw new Exception("offset index out of bound (itemCnt: " + this.itemCnt + ", offsetIdx: " + this.offsetIdx);
        }
        int n4 = ((TbPivotValHdrItem)this.hdr.elementAt(this.offsetIdx)).getOffset();
        if (this.byteData != null) {
            n3 = 0xFF & this.byteData[n4];
        } else {
            byte[] byArray2 = this.blobData.getBytes(n4 + 1, 1);
            n3 = 0xFF & byArray2[0];
        }
        if (0 <= n3 && n3 <= 250) {
            n2 = n3;
            n = 1;
        } else if (n3 == 254) {
            int n5;
            int n6;
            if (this.byteData != null) {
                n6 = 0xFF & this.byteData[n4 + 1];
                n5 = 0xFF & this.byteData[n4 + 2];
            } else {
                byte[] byArray3 = this.blobData.getBytes(n4 + 2, 2);
                n6 = 0xFF & byArray3[0];
                n5 = 0xFF & byArray3[1];
            }
            n2 = 0xFF & n6 << 8;
            n2 &= 0xFF & n5;
            n = 3;
        } else {
            throw new Exception("invalid rpcol first length byte: " + n3);
        }
        if (n2 == 0) {
            ++this.offsetIdx;
            return null;
        }
        if (n2 < 0) {
            throw new Exception("invalid rpcol length: " + n2);
        }
        if (this.byteData != null) {
            byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = this.byteData[n4 + n + i];
            }
        } else {
            byArray = this.blobData.getBytes(n4 + n + 1, n2);
        }
        ++this.offsetIdx;
        return byArray;
    }

    private byte[] getNextRpcolForNumber() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        if (byArray.length > 250) {
            throw new Exception("invalid rpcol length for number: " + byArray.length);
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i + 1] = byArray[i];
        }
        return byArray2;
    }

    private int getNextIntForHdr(InputStream inputStream) throws Exception {
        int n = 0;
        int n2 = 24;
        for (int i = 0; i < 4; ++i) {
            int n3 = inputStream.read();
            n += n3 << n2;
            n2 -= 8;
        }
        return n;
    }

    private int getNextIntFrom4ByteArr(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 24;
        while (n3 < 4) {
            int n5 = 0xFF & this.byteData[n + n3];
            n2 += n5 << n4;
            ++n3;
            n4 -= 8;
        }
        return n2;
    }

    private int getNextIntFrom2ByteArr(int n) {
        int n2 = ((0xFF & this.byteData[n]) << 8) + (0xFF & this.byteData[n + 1]);
        return n2;
    }

    private int getNewIdx(int n) {
        return (Integer)this.newIdxMap.get(new Integer(n));
    }

    public TbPivotValReader(Blob blob, int n, TbPivotMeta tbPivotMeta) throws Exception {
        this.blobData = blob;
        this.offsetIdx = 0;
        this.byteData = ((TbBlob)blob).getLobData();
        this.hdr = new Vector();
        this.newIdxMap = tbPivotMeta.getNewIdxMap(n);
        if (this.byteData == null) {
            InputStream inputStream = blob.getBinaryStream();
            this.itemCnt = this.getNextIntForHdr(inputStream);
            for (int i = 0; i < this.itemCnt; ++i) {
                int n2 = this.getNewIdx(this.getNextIntForHdr(inputStream));
                int n3 = this.getNextIntForHdr(inputStream);
                this.hdr.add(new TbPivotValHdrItem(n2, n3));
            }
            inputStream.close();
        } else {
            int n4 = 0;
            this.itemCnt = this.getNextIntFrom4ByteArr(n4);
            n4 += 4;
            for (int i = 0; i < this.itemCnt; ++i) {
                int n5 = this.getNewIdx(this.getNextIntFrom4ByteArr(n4));
                int n6 = this.getNextIntFrom2ByteArr(n4 + 4);
                this.hdr.add(new TbPivotValHdrItem(n5, n6));
                n4 += 6;
            }
        }
        Collections.sort(this.hdr);
    }

    public int getColNameIdx(int n) throws Exception {
        return ((TbPivotValHdrItem)this.hdr.elementAt(n)).getNameIdx();
    }

    public int getCnt() {
        return this.itemCnt;
    }

    public Long getNextLong() throws Exception {
        byte[] byArray = this.getNextRpcolForNumber();
        if (byArray == null) {
            return null;
        }
        return new Long(TbNumber.toLong(byArray, 0, byArray.length));
    }

    public Integer getNextInt() throws Exception {
        byte[] byArray = this.getNextRpcolForNumber();
        if (byArray == null) {
            return null;
        }
        return new Integer(TbNumber.toInteger(byArray, 0, byArray.length));
    }

    public Double getNextDouble() throws Exception {
        byte[] byArray = this.getNextRpcolForNumber();
        if (byArray == null) {
            return null;
        }
        return new Double(TbNumber.toDouble(byArray, 0, byArray.length));
    }

    public BigDecimal getNextBigDecimal() throws Exception {
        byte[] byArray = this.getNextRpcolForNumber();
        if (byArray == null) {
            return null;
        }
        return TbNumber.toBigDecimal(byArray, 0, byArray.length);
    }

    public String getNextString() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public Date getNextDate() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        if (byArray.length != 8) {
            throw new Exception("invalid rpcol length for date: " + byArray.length);
        }
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = 0xFF & byArray[2];
        int n4 = 0xFF & byArray[3];
        int n5 = 0xFF & byArray[4];
        int n6 = 0xFF & byArray[5];
        int n7 = 0xFF & byArray[6];
        int n8 = (n - 100) * 100 + (n2 - 100);
        int n9 = n3 - 1;
        Calendar calendar = Calendar.getInstance();
        calendar.set(n8, n9, n4, n5, n6, n7);
        return new Date(calendar.getTime().getTime());
    }

    public Timestamp getNextTimestamp() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        if (byArray.length != 12) {
            throw new Exception("invalid rpcol length for timestamp: " + byArray.length);
        }
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = 0xFF & byArray[2];
        int n4 = 0xFF & byArray[3];
        int n5 = 0xFF & byArray[4];
        int n6 = 0xFF & byArray[5];
        int n7 = 0xFF & byArray[6];
        int n8 = (n - 100) * 100 + (n2 - 100);
        int n9 = n3 - 1;
        int n10 = TbCommon.bytes2Int(byArray, 8, 4);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n8, n9, n4, n5, n6, n7);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(n10);
        return timestamp;
    }

    public Time getNextTime() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        if (byArray.length != 8) {
            throw new Exception("invalid rpcol length for time: " + byArray.length);
        }
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = 0xFF & byArray[2];
        int n4 = TbCommon.bytes2Int(byArray, 4, 4);
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(n4);
        return new Time(timestamp.getTime());
    }
}

