/*
 Highcharts JS v10.1.0 (2022-04-29)

 (c) 2016-2021 Highsoft AS
 Authors: Jon Arild Nygard

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/sunburst",["highcharts"],function(w){a(w);a.Highcharts=w;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function w(a,k,d,r){a.hasOwnProperty(k)||(a[k]=r.apply(null,d),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:k,module:a[k]}})))}a=a?a._modules:{};w(a,
"Series/ColorMapMixin.js",[a["Core/Globals.js"],a["Core/Series/Point.js"],a["Core/Utilities.js"]],function(a,k,d){var r=a.noop;a=a.seriesTypes;var l=d.defined;d=d.addEvent;d(k,"afterSetState",function(a){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:a&&"hover"===a.state?1:0})});return{PointMixin:{dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value}},SeriesMixin:{pointArrayMap:["value"],axisTypes:["xAxis",
"yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:r,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:a.column.prototype.pointAttribs,colorAttribs:function(a){var t={};!l(a.color)||a.state&&"normal"!==a.state||(t[this.colorProp||"fill"]=a.color);return t}}}});w(a,"Series/Treemap/TreemapAlgorithmGroup.js",[],function(){return function(){function a(a,d,r,l){this.height=a;this.width=d;this.plot=l;this.startDirection=this.direction=r;this.lH=this.nH=this.lW=
this.nW=this.total=0;this.elArr=[];this.lP={total:0,lH:0,nH:0,lW:0,nW:0,nR:0,lR:0,aspectRatio:function(a,e){return Math.max(a/e,e/a)}}}a.prototype.addElement=function(a){this.lP.total=this.elArr[this.elArr.length-1];this.total+=a;0===this.direction?(this.lW=this.nW,this.lP.lH=this.lP.total/this.lW,this.lP.lR=this.lP.aspectRatio(this.lW,this.lP.lH),this.nW=this.total/this.height,this.lP.nH=this.lP.total/this.nW,this.lP.nR=this.lP.aspectRatio(this.nW,this.lP.nH)):(this.lH=this.nH,this.lP.lW=this.lP.total/
this.lH,this.lP.lR=this.lP.aspectRatio(this.lP.lW,this.lH),this.nH=this.total/this.width,this.lP.nW=this.lP.total/this.nH,this.lP.nR=this.lP.aspectRatio(this.lP.nW,this.nH));this.elArr.push(a)};a.prototype.reset=function(){this.lW=this.nW=0;this.elArr=[];this.total=0};return a}()});w(a,"Series/DrawPointComposition.js",[],function(){var a;(function(a){function d(a){var e=this,g=a.animatableAttribs,d=a.onComplete,c=a.css,b=a.renderer,A=this.series&&this.series.chart.hasRendered?void 0:this.series&&
this.series.options.animation,y=this.graphic;a.attribs=a.attribs||{};a.attribs["class"]=this.getClassName();if(this.shouldDraw())y||(this.graphic=y="text"===a.shapeType?b.text():b[a.shapeType](a.shapeArgs||{}),y.add(a.group)),c&&y.css(c),y.attr(a.attribs).animate(g,a.isNew?!1:A,d);else if(y){var p=function(){e.graphic=y=y&&y.destroy();"function"===typeof d&&d()};Object.keys(g).length?y.animate(g,void 0,function(){p()}):p()}}function k(){return!this.isNull}var l=[];a.compose=function(a){if(-1===l.indexOf(a)){l.push(a);
var e=a.prototype;e.draw=d;e.shouldDraw||(e.shouldDraw=k)}return a}})(a||(a={}));return a});w(a,"Series/Treemap/TreemapPoint.js",[a["Series/DrawPointComposition.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k,d){var r=this&&this.__extends||function(){var a=function(c,A){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,A)};return function(c,A){function b(){this.constructor=
c}a(c,A);c.prototype=null===A?Object.create(A):(b.prototype=A.prototype,new b)}}(),l=k.series.prototype.pointClass,t=k.seriesTypes;k=t.pie.prototype.pointClass;var e=d.extend,g=d.isNumber,u=d.pick;d=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.name=void 0;c.node=void 0;c.options=void 0;c.series=void 0;c.value=void 0;return c}r(c,a);c.prototype.getClassName=function(){var a=l.prototype.getClassName.call(this),c=this.series,b=c.options;this.node.level<=c.nodeMap[c.rootNode].level?
a+=" highcharts-above-level":this.node.isLeaf||u(b.interactByLeaf,!b.allowTraversingTree)?this.node.isLeaf||(a+=" highcharts-internal-node"):a+=" highcharts-internal-node-interactive";return a};c.prototype.isValid=function(){return!(!this.id&&!g(this.value))};c.prototype.setState=function(a){l.prototype.setState.call(this,a);this.graphic&&this.graphic.attr({zIndex:"hover"===a?1:0})};c.prototype.shouldDraw=function(){return g(this.plotY)&&null!==this.y};return c}(t.scatter.prototype.pointClass);e(d.prototype,
{setVisible:k.prototype.setVisible});a.compose(d);return d});w(a,"Series/Treemap/TreemapUtilities.js",[a["Core/Utilities.js"]],function(a){var k=a.objectEach,d;(function(a){function d(a,e,g){void 0===g&&(g=this);a=e.call(g,a);!1!==a&&d(a,e,g)}a.AXIS_MAX=100;a.isBoolean=function(a){return"boolean"===typeof a};a.eachObject=function(a,d,g){g=g||this;k(a,function(e,c){d.call(g,e,c,a)})};a.recursive=d})(d||(d={}));return d});w(a,"Series/TreeUtilities.js",[a["Core/Color/Color.js"],a["Core/Utilities.js"]],
function(a,k){function d(a,b){var c=b.before,e=b.idRoot,p=b.mapIdToNode[e],v=b.points[a.i],x=v&&v.options||{},C=[],n=0;a.levelDynamic=a.level-(!1!==b.levelIsConstant?0:p.level);a.name=u(v&&v.name,"");a.visible=e===a.id||!0===b.visible;"function"===typeof c&&(a=c(a,b));a.children.forEach(function(c,v){var x=r({},b);r(x,{index:v,siblings:a.children.length,visible:a.visible});c=d(c,x);C.push(c);c.visible&&(n+=c.val)});c=u(x.value,n);a.visible=0<=c&&(0<n||a.visible);a.children=C;a.childrenTotal=n;a.isLeaf=
a.visible&&!n;a.val=c;return a}var r=k.extend,l=k.isArray,t=k.isNumber,e=k.isObject,g=k.merge,u=k.pick;return{getColor:function(c,b){var d=b.index,e=b.mapOptionsToLevel,p=b.parentColor,v=b.parentColorIndex,x=b.series,C=b.colors,n=b.siblings,g=x.points,k=x.chart.options.chart,l;if(c){g=g[c.i];c=e[c.level]||{};if(e=g&&c.colorByPoint){var r=g.index%(C?C.length:k.colorCount);var t=C&&C[r]}if(!x.chart.styledMode){C=g&&g.options.color;k=c&&c.color;if(l=p)l=(l=c&&c.colorVariation)&&"brightness"===l.key&&
d&&n?a.parse(p).brighten(d/n*l.to).get():p;l=u(C,k,t,l,x.color)}var K=u(g&&g.options.colorIndex,c&&c.colorIndex,r,v,b.colorIndex)}return{color:l,colorIndex:K}},getLevelOptions:function(a){var c=null;if(e(a)){c={};var d=t(a.from)?a.from:1;var k=a.levels;var p={};var v=e(a.defaults)?a.defaults:{};l(k)&&(p=k.reduce(function(a,c){if(e(c)&&t(c.level)){var b=g({},c);var p=u(b.levelIsConstant,v.levelIsConstant);delete b.levelIsConstant;delete b.level;c=c.level+(p?0:d-1);e(a[c])?g(!0,a[c],b):a[c]=b}return a},
{}));k=t(a.to)?a.to:1;for(a=0;a<=k;a++)c[a]=g({},v,e(p[a])?p[a]:{})}return c},setTreeValues:d,updateRootId:function(a){if(e(a)){var c=e(a.options)?a.options:{};c=u(a.rootNode,c.rootId,"");e(a.userOptions)&&(a.userOptions.rootId=c);a.rootNode=c}return c}}});w(a,"Extensions/Breadcrumbs.js",[a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/DefaultOptions.js"],a["Core/Utilities.js"],a["Core/FormatUtilities.js"]],function(a,k,d,r,l){var t=l.format;l=r.addEvent;var e=r.objectEach,g=r.extend,u=r.fireEvent,
c=r.merge,b=r.pick,A=r.defined,y=r.isString;g(d.defaultOptions.lang,{mainBreadcrumb:"Main"});d=function(){function a(b,x){this.group=void 0;this.list=[];this.elementList={};this.isDirty=!0;this.level=0;this.options=void 0;x=c(b.options.drilldown&&b.options.drilldown.drillUpButton,a.defaultBreadcrumbsOptions,b.options.navigation&&b.options.navigation.breadcrumbs,x);this.chart=b;this.options=x||{}}a.prototype.updateProperties=function(a){this.setList(a);this.setLevel();this.isDirty=!0};a.prototype.setList=
function(a){this.list=a};a.prototype.setLevel=function(){this.level=this.list.length&&this.list.length-1};a.prototype.getLevel=function(){return this.level};a.prototype.getButtonText=function(a){var c=this.chart,d=this.options,n=c.options.lang,v=b(d.format,d.showFullPath?"{level.name}":"\u2190 {level.name}");n=n&&b(n.drillUpText,n.mainBreadcrumb);a=d.formatter&&d.formatter(a)||t(v,{level:a.levelOptions},c)||"";(y(a)&&!a.length||"\u2190 "===a)&&A(n)&&(a=d.showFullPath?n:"\u2190 "+n);return a};a.prototype.redraw=
function(){this.isDirty&&this.render();this.group&&this.group.align();this.isDirty=!1};a.prototype.render=function(){var a=this.chart,c=this.options;!this.group&&c&&(this.group=a.renderer.g("breadcrumbs-group").addClass("highcharts-no-tooltip highcharts-breadcrumbs").attr({zIndex:c.zIndex}).add());c.showFullPath?this.renderFullPathButtons():this.renderSingleButton();this.alignBreadcrumbsGroup()};a.prototype.renderFullPathButtons=function(){this.destroySingleButton();this.resetElementListState();this.updateListElements();
this.destroyListElements()};a.prototype.renderSingleButton=function(){var a=this.chart,c=this.list,b=this.options.buttonSpacing;this.destroyListElements();var d=this.group?this.group.getBBox().width:b;c=c[c.length-2];!a.drillUpButton&&0<this.level?a.drillUpButton=this.renderButton(c,d,b):a.drillUpButton&&(0<this.level?this.updateSingleButton():this.destroySingleButton())};a.prototype.alignBreadcrumbsGroup=function(a){if(this.group){var d=this.options,g=d.buttonTheme,n=d.position,e="chart"===d.relativeTo||
"spacingBox"===d.relativeTo?void 0:"scrollablePlotBox",v=this.group.getBBox();d=2*(g.padding||0)+d.buttonSpacing;n.width=v.width+d;n.height=v.height+d;n=c(n);a&&(n.x+=a);n.y=b(n.y,this.yOffset,0);this.group.align(n,!0,e)}};a.prototype.renderButton=function(a,b,d){var n=this,g=this.chart,e=n.options,v=c(e.buttonTheme);b=g.renderer.button(n.getButtonText(a),b,d,function(c){var b=e.events&&e.events.click,d;b&&(d=b.call(n,c,a));!1!==d&&(c.newLevel=e.showFullPath?a.level:n.level-1,u(n,"up",c))},v).addClass("highcharts-breadcrumbs-button").add(n.group);
g.styledMode||b.attr(e.style);return b};a.prototype.renderSeparator=function(a,c){var b=this.chart,d=this.options.separator;a=b.renderer.label(d.text,a,c,void 0,void 0,void 0,!1).addClass("highcharts-breadcrumbs-separator").add(this.group);b.styledMode||a.css(d.style);return a};a.prototype.update=function(a){c(!0,this.options,a);this.destroy();this.isDirty=!0};a.prototype.updateSingleButton=function(){var a=this.chart,c=this.list[this.level-1];a.drillUpButton&&a.drillUpButton.attr({text:this.getButtonText(c)})};
a.prototype.destroy=function(){this.destroySingleButton();this.destroyListElements(!0);this.group&&this.group.destroy();this.group=void 0};a.prototype.destroyListElements=function(a){var c=this.elementList;e(c,function(b,d){if(a||!c[d].updated)b=c[d],b.button&&b.button.destroy(),b.separator&&b.separator.destroy(),delete b.button,delete b.separator,delete c[d]});a&&(this.elementList={})};a.prototype.destroySingleButton=function(){this.chart.drillUpButton&&(this.chart.drillUpButton.destroy(),this.chart.drillUpButton=
void 0)};a.prototype.resetElementListState=function(){e(this.elementList,function(a){a.updated=!1})};a.prototype.updateListElements=function(){var a=function(a,c){return a.getBBox().width+c},c=this,b=c.elementList,d=c.options.buttonSpacing,e=c.list,g=c.group?a(c.group,d):d,p;e.forEach(function(k,n){n=n===e.length-1;if(b[k.level]){p=b[k.level];var l=p.button;p.separator||n?p.separator&&n&&(p.separator.destroy(),delete p.separator):(g+=d,p.separator=c.renderSeparator(g,d),g+=a(p.separator,d));b[k.level].updated=
!0}else{l=c.renderButton(k,g,d);g+=a(l,d);if(!n){var u=c.renderSeparator(g,d);g+=a(u,d)}b[k.level]={button:l,separator:u,updated:!0}}l&&l.setState(n?2:0)})};a.defaultBreadcrumbsOptions={buttonTheme:{fill:"none",height:18,padding:2,"stroke-width":0,zIndex:7,states:{select:{fill:"none"}},style:{color:"#335cad"}},buttonSpacing:5,floating:!1,format:void 0,relativeTo:"plotBox",position:{align:"left",verticalAlign:"top",x:0,y:void 0},separator:{text:"/",style:{color:"#666666"}},showFullPath:!0,style:{},
useHTML:!1,zIndex:7};return a}();k.Breadcrumbs||(k.Breadcrumbs=d,l(a,"getMargins",function(){var a=this.breadcrumbs;if(a&&!a.options.floating&&a.level){var c=a.options,b=c.buttonTheme;b=(b.height||0)+2*(b.padding||0)+c.buttonSpacing;c=c.position.verticalAlign;"bottom"===c?(this.marginBottom=(this.marginBottom||0)+b,a.yOffset=b):"middle"!==c?(this.plotTop+=b,a.yOffset=-b):a.yOffset=void 0}}),l(a,"redraw",function(){this.breadcrumbs&&this.breadcrumbs.redraw()}),l(a,"destroy",function(){this.breadcrumbs&&
(this.breadcrumbs.destroy(),this.breadcrumbs=void 0)}),l(a,"afterShowResetZoom",function(){if(this.breadcrumbs){var a=this.resetZoomButton&&this.resetZoomButton.getBBox(),c=this.breadcrumbs.options;a&&"right"===c.position.align&&"plotBox"===c.relativeTo&&this.breadcrumbs.alignBreadcrumbsGroup(-a.width-c.buttonSpacing)}}),l(a,"selection",function(a){!0===a.resetSelection&&this.breadcrumbs&&this.breadcrumbs.alignBreadcrumbsGroup()}));"";return d});w(a,"Series/Treemap/TreemapComposition.js",[a["Core/Series/SeriesRegistry.js"],
a["Series/Treemap/TreemapUtilities.js"],a["Core/Utilities.js"]],function(a,k,d){var r=d.addEvent,l=d.extend,t=!1;r(a.series,"afterBindAxes",function(){var a=this.xAxis,d=this.yAxis;if(a&&d)if(this.is("treemap")){var u={endOnTick:!1,gridLineWidth:0,lineWidth:0,min:0,minPadding:0,max:k.AXIS_MAX,maxPadding:0,startOnTick:!1,title:void 0,tickPositions:[]};l(d.options,u);l(a.options,u);t=!0}else t&&(d.setOptions(d.userOptions),a.setOptions(a.userOptions),t=!1)})});w(a,"Series/Treemap/TreemapSeries.js",
[a["Core/Color/Color.js"],a["Series/ColorMapMixin.js"],a["Core/Globals.js"],a["Core/Legend/LegendSymbol.js"],a["Core/Series/SeriesRegistry.js"],a["Series/Treemap/TreemapAlgorithmGroup.js"],a["Series/Treemap/TreemapPoint.js"],a["Series/Treemap/TreemapUtilities.js"],a["Series/TreeUtilities.js"],a["Extensions/Breadcrumbs.js"],a["Core/Utilities.js"]],function(a,k,d,r,l,t,e,g,u,c,b){var A=this&&this.__extends||function(){var a=function(c,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,
f){a.__proto__=f}||function(a,f){for(var c in f)f.hasOwnProperty(c)&&(a[c]=f[c])};return a(c,f)};return function(c,f){function m(){this.constructor=c}a(c,f);c.prototype=null===f?Object.create(f):(m.prototype=f.prototype,new m)}}(),y=a.parse;a=d.noop;var p=l.series;d=l.seriesTypes;var v=d.column,x=d.heatmap,w=d.scatter,n=u.getColor,R=u.getLevelOptions,K=u.updateRootId,D=b.addEvent,H=b.correctFloat,G=b.defined,I=b.error,J=b.extend,N=b.fireEvent,O=b.isArray,T=b.isObject,h=b.isString,E=b.merge,B=b.pick,
U=b.stableSort;u=function(a){function b(){var f=null!==a&&a.apply(this,arguments)||this;f.axisRatio=void 0;f.data=void 0;f.mapOptionsToLevel=void 0;f.nodeMap=void 0;f.options=void 0;f.points=void 0;f.rootNode=void 0;f.tree=void 0;f.level=void 0;return f}A(b,a);b.prototype.algorithmCalcPoints=function(a,c,b,d){var f,m,q,h,M=b.lW,g=b.lH,e=b.plot,k=0,n=b.elArr.length-1;if(c)M=b.nW,g=b.nH;else var l=b.elArr[b.elArr.length-1];b.elArr.forEach(function(a){if(c||k<n)0===b.direction?(f=e.x,m=e.y,q=M,h=a/q):
(f=e.x,m=e.y,h=g,q=a/h),d.push({x:f,y:m,width:q,height:H(h)}),0===b.direction?e.y+=h:e.x+=q;k+=1});b.reset();0===b.direction?b.width-=M:b.height-=g;e.y=e.parent.y+(e.parent.height-b.height);e.x=e.parent.x+(e.parent.width-b.width);a&&(b.direction=1-b.direction);c||b.addElement(l)};b.prototype.algorithmFill=function(a,b,c){var f=[],m,d=b.direction,q=b.x,h=b.y,e=b.width,g=b.height,k,n,l,p;c.forEach(function(c){m=c.val/b.val*b.height*b.width;k=q;n=h;0===d?(p=g,l=m/p,e-=l,q+=l):(l=e,p=m/l,g-=p,h+=p);f.push({x:k,
y:n,width:l,height:p});a&&(d=1-d)});return f};b.prototype.algorithmLowAspectRatio=function(a,b,c){var f=[],m=this,d,q={x:b.x,y:b.y,parent:b},h=0,e=c.length-1,g=new t(b.height,b.width,b.direction,q);c.forEach(function(c){d=c.val/b.val*b.height*b.width;g.addElement(d);g.lP.nR>g.lP.lR&&m.algorithmCalcPoints(a,!1,g,f,q);h===e&&m.algorithmCalcPoints(a,!0,g,f,q);h+=1});return f};b.prototype.alignDataLabel=function(a,b,c){var f=c.style;f&&!G(f.textOverflow)&&b.text&&b.getBBox().width>b.text.textWidth&&b.css({textOverflow:"ellipsis",
width:f.width+="px"});v.prototype.alignDataLabel.apply(this,arguments);a.dataLabel&&a.dataLabel.attr({zIndex:(a.node.zIndex||0)+1})};b.prototype.buildNode=function(a,b,c,d,h){var f=this,m=[],q=f.points[b],F=0,e;(d[a]||[]).forEach(function(b){e=f.buildNode(f.points[b].id,b,c+1,d,a);F=Math.max(e.height+1,F);m.push(e)});b={id:a,i:b,children:m,height:F,level:c,parent:h,visible:!1};f.nodeMap[b.id]=b;q&&(q.node=b);return b};b.prototype.calculateChildrenAreas=function(a,b){var f=this,c=f.options,d=f.mapOptionsToLevel[a.level+
1],m=B(f[d&&d.layoutAlgorithm]&&d.layoutAlgorithm,c.layoutAlgorithm),h=c.alternateStartingDirection,e=[];a=a.children.filter(function(a){return!a.ignore});d&&d.layoutStartingDirection&&(b.direction="vertical"===d.layoutStartingDirection?0:1);e=f[m](b,a);a.forEach(function(a,c){c=e[c];a.values=E(c,{val:a.childrenTotal,direction:h?1-b.direction:b.direction});a.pointValues=E(c,{x:c.x/f.axisRatio,y:g.AXIS_MAX-c.y-c.height,width:c.width/f.axisRatio});a.children.length&&f.calculateChildrenAreas(a,a.values)})};
b.prototype.createList=function(a){var f=this.chart,b=[];if(f.breadcrumbs){var c=0;b.push({level:c,levelOptions:f.series[0]});f=a.target.nodeMap[a.newRootId];for(var d=[];f.parent||""===f.parent;)d.push(f),f=a.target.nodeMap[f.parent];d.reverse().forEach(function(a){b.push({level:++c,levelOptions:a})});1>=b.length&&(b.length=0)}return b};b.prototype.drawDataLabels=function(){var a=this,b=a.mapOptionsToLevel,c,d;a.points.filter(function(a){return a.node.visible}).forEach(function(f){d=b[f.node.level];
c={style:{}};f.node.isLeaf||(c.enabled=!1);d&&d.dataLabels&&(c=E(c,d.dataLabels),a._hasPointLabels=!0);f.shapeArgs&&(c.style.width=f.shapeArgs.width,f.dataLabel&&f.dataLabel.css({width:f.shapeArgs.width+"px"}));f.dlOptions=E(c,f.options.dataLabels)});p.prototype.drawDataLabels.call(this)};b.prototype.drawPoints=function(){var a=this,b=a.chart,c=b.renderer,d=b.styledMode,h=a.options,e=d?{}:h.shadow,g=h.borderRadius,k=b.pointCount<h.animationLimit,n=h.allowTraversingTree;a.points.forEach(function(b){var f=
b.node.levelDynamic,m={},q={},P={},F="level-group-"+b.node.level,Q=!!b.graphic,l=k&&Q,p=b.shapeArgs;b.shouldDraw()&&(b.isInside=!0,g&&(q.r=g),E(!0,l?m:q,Q?p:{},d?{}:a.pointAttribs(b,b.selected?"select":void 0)),a.colorAttribs&&d&&J(P,a.colorAttribs(b)),a[F]||(a[F]=c.g(F).attr({zIndex:1E3-(f||0)}).add(a.group),a[F].survive=!0));b.draw({animatableAttribs:m,attribs:q,css:P,group:a[F],renderer:c,shadow:e,shapeArgs:p,shapeType:"rect"});n&&b.graphic&&(b.drillId=h.interactByLeaf?a.drillToByLeaf(b):a.drillToByGroup(b))})};
b.prototype.drillToByGroup=function(a){var b=!1;1!==a.node.level-this.nodeMap[this.rootNode].level||a.node.isLeaf||(b=a.id);return b};b.prototype.drillToByLeaf=function(a){var b=!1;if(a.node.parent!==this.rootNode&&a.node.isLeaf)for(a=a.node;!b;)a=this.nodeMap[a.parent],a.parent===this.rootNode&&(b=a.id);return b};b.prototype.drillToNode=function(a,b){I(32,!1,void 0,{"treemap.drillToNode":"use treemap.setRootNode"});this.setRootNode(a,b)};b.prototype.drillUp=function(){var a=this.nodeMap[this.rootNode];
a&&h(a.parent)&&this.setRootNode(a.parent,!0,{trigger:"traverseUpButton"})};b.prototype.getExtremes=function(){var a=p.prototype.getExtremes.call(this,this.colorValueData),b=a.dataMax;this.valueMin=a.dataMin;this.valueMax=b;return p.prototype.getExtremes.call(this)};b.prototype.getListOfParents=function(a,b){a=O(a)?a:[];var c=O(b)?b:[];b=a.reduce(function(a,b,c){b=B(b.parent,"");"undefined"===typeof a[b]&&(a[b]=[]);a[b].push(c);return a},{"":[]});g.eachObject(b,function(a,b,f){""!==b&&-1===c.indexOf(b)&&
(a.forEach(function(a){f[""].push(a)}),delete f[b])});return b};b.prototype.getTree=function(){var a=this.data.map(function(a){return a.id});a=this.getListOfParents(this.data,a);this.nodeMap={};return this.buildNode("",-1,0,a)};b.prototype.hasData=function(){return!!this.processedXData.length};b.prototype.init=function(a,b){var f=this,d=E(b.drillUpButton,b.breadcrumbs);this.colorAttribs=k.SeriesMixin.colorAttribs;var h=D(f,"setOptions",function(a){a=a.userOptions;G(a.allowDrillToNode)&&!G(a.allowTraversingTree)&&
(a.allowTraversingTree=a.allowDrillToNode,delete a.allowDrillToNode);G(a.drillUpButton)&&!G(a.traverseUpButton)&&(a.traverseUpButton=a.drillUpButton,delete a.drillUpButton)});p.prototype.init.call(f,a,b);delete f.opacity;f.eventsToUnbind.push(h);f.options.allowTraversingTree&&(f.eventsToUnbind.push(D(f,"click",f.onClickDrillToNode)),f.eventsToUnbind.push(D(f,"setRootNode",function(a){var b=f.chart;b.breadcrumbs&&b.breadcrumbs.updateProperties(f.createList(a))})),f.eventsToUnbind.push(D(f,"update",
function(a,b){(b=this.chart.breadcrumbs)&&a.options.breadcrumbs&&b.update(a.options.breadcrumbs)})),f.eventsToUnbind.push(D(f,"destroy",function(a){var b=this.chart;b.breadcrumbs&&(b.breadcrumbs.destroy(),a.keepEventsForUpdate||(b.breadcrumbs=void 0))})));a.breadcrumbs||(a.breadcrumbs=new c(a,d));f.eventsToUnbind.push(D(a.breadcrumbs,"up",function(a){a=this.level-a.newLevel;for(var b=0;b<a;b++)f.drillUp()}))};b.prototype.onClickDrillToNode=function(a){var b=(a=a.point)&&a.drillId;h(b)&&(a.setState(""),
this.setRootNode(b,!0,{trigger:"click"}))};b.prototype.pointAttribs=function(a,b){var c=T(this.mapOptionsToLevel)?this.mapOptionsToLevel:{},f=a&&c[a.node.level]||{};c=this.options;var d=b&&c.states[b]||{},h=a&&a.getClassName()||"";a={stroke:a&&a.borderColor||f.borderColor||d.borderColor||c.borderColor,"stroke-width":B(a&&a.borderWidth,f.borderWidth,d.borderWidth,c.borderWidth),dashstyle:a&&a.borderDashStyle||f.borderDashStyle||d.borderDashStyle||c.borderDashStyle,fill:a&&a.color||this.color};-1!==
h.indexOf("highcharts-above-level")?(a.fill="none",a["stroke-width"]=0):-1!==h.indexOf("highcharts-internal-node-interactive")?(b=B(d.opacity,c.opacity),a.fill=y(a.fill).setOpacity(b).get(),a.cursor="pointer"):-1!==h.indexOf("highcharts-internal-node")?a.fill="none":b&&(a.fill=y(a.fill).brighten(d.brightness).get());return a};b.prototype.setColorRecursive=function(a,b,c,d,h){var f=this,e=f&&f.chart;e=e&&e.options&&e.options.colors;if(a){var g=n(a,{colors:e,index:d,mapOptionsToLevel:f.mapOptionsToLevel,
parentColor:b,parentColorIndex:c,series:f,siblings:h});if(b=f.points[a.i])b.color=g.color,b.colorIndex=g.colorIndex;(a.children||[]).forEach(function(b,c){f.setColorRecursive(b,g.color,g.colorIndex,c,a.children.length)})}};b.prototype.setPointValues=function(){var a=this,b=a.xAxis,c=a.yAxis,d=a.chart.styledMode;a.points.forEach(function(f){var h=f.node,e=h.pointValues;h=h.visible;if(e&&h){h=e.height;var g=e.width,m=e.x,k=e.y,n=d?0:(a.pointAttribs(f)["stroke-width"]||0)%2/2;e=Math.round(b.toPixels(m,
!0))-n;g=Math.round(b.toPixels(m+g,!0))-n;m=Math.round(c.toPixels(k,!0))-n;h=Math.round(c.toPixels(k+h,!0))-n;h={x:Math.min(e,g),y:Math.min(m,h),width:Math.abs(g-e),height:Math.abs(h-m)};f.plotX=h.x+h.width/2;f.plotY=h.y+h.height/2;f.shapeArgs=h}else delete f.plotX,delete f.plotY})};b.prototype.setRootNode=function(a,b,c){a=J({newRootId:a,previousRootId:this.rootNode,redraw:B(b,!0),series:this},c);N(this,"setRootNode",a,function(a){var b=a.series;b.idPreviousRoot=a.previousRootId;b.rootNode=a.newRootId;
b.isDirty=!0;a.redraw&&b.chart.redraw()})};b.prototype.setState=function(a){this.options.inactiveOtherPoints=!0;p.prototype.setState.call(this,a,!1);this.options.inactiveOtherPoints=!1};b.prototype.setTreeValues=function(a){var b=this,c=b.options,f=b.nodeMap[b.rootNode];c=g.isBoolean(c.levelIsConstant)?c.levelIsConstant:!0;var d=0,h=[],e=b.points[a.i];a.children.forEach(function(a){a=b.setTreeValues(a);h.push(a);a.ignore||(d+=a.val)});U(h,function(a,b){return(a.sortIndex||0)-(b.sortIndex||0)});var k=
B(e&&e.options.value,d);e&&(e.value=k);J(a,{children:h,childrenTotal:d,ignore:!(B(e&&e.visible,!0)&&0<k),isLeaf:a.visible&&!d,levelDynamic:a.level-(c?0:f.level),name:B(e&&e.name,""),sortIndex:B(e&&e.sortIndex,-k),val:k});return a};b.prototype.sliceAndDice=function(a,b){return this.algorithmFill(!0,a,b)};b.prototype.squarified=function(a,b){return this.algorithmLowAspectRatio(!0,a,b)};b.prototype.strip=function(a,b){return this.algorithmLowAspectRatio(!1,a,b)};b.prototype.stripes=function(a,b){return this.algorithmFill(!1,
a,b)};b.prototype.translate=function(){var a=this,b=a.options,c=K(a);p.prototype.translate.call(a);var d=a.tree=a.getTree();var h=a.nodeMap[c];""===c||h&&h.children.length||(a.setRootNode("",!1),c=a.rootNode,h=a.nodeMap[c]);a.mapOptionsToLevel=R({from:h.level+1,levels:b.levels,to:d.height,defaults:{levelIsConstant:a.options.levelIsConstant,colorByPoint:b.colorByPoint}});g.recursive(a.nodeMap[a.rootNode],function(b){var c=!1,d=b.parent;b.visible=!0;if(d||""===d)c=a.nodeMap[d];return c});g.recursive(a.nodeMap[a.rootNode].children,
function(a){var b=!1;a.forEach(function(a){a.visible=!0;a.children.length&&(b=(b||[]).concat(a.children))});return b});a.setTreeValues(d);a.axisRatio=a.xAxis.len/a.yAxis.len;a.nodeMap[""].pointValues=c={x:0,y:0,width:g.AXIS_MAX,height:g.AXIS_MAX};a.nodeMap[""].values=c=E(c,{width:c.width*a.axisRatio,direction:"vertical"===b.layoutStartingDirection?0:1,val:d.val});a.calculateChildrenAreas(d,c);a.colorAxis||b.colorByPoint||a.setColorRecursive(a.tree);b.allowTraversingTree&&(b=h.pointValues,a.xAxis.setExtremes(b.x,
b.x+b.width,!1),a.yAxis.setExtremes(b.y,b.y+b.height,!1),a.xAxis.setScale(),a.yAxis.setScale());a.setPointValues()};b.defaultOptions=E(w.defaultOptions,{allowTraversingTree:!1,animationLimit:250,borderRadius:0,showInLegend:!1,marker:void 0,colorByPoint:!1,dataLabels:{defer:!1,enabled:!0,formatter:function(){var a=this&&this.point?this.point:{};return h(a.name)?a.name:""},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:"",pointFormat:"<b>{point.name}</b>: {point.value}<br/>"},ignoreHiddenPoint:!0,
layoutAlgorithm:"sliceAndDice",layoutStartingDirection:"vertical",alternateStartingDirection:!1,levelIsConstant:!0,traverseUpButton:{position:{align:"right",x:-10,y:10}},borderColor:"#e6e6e6",borderWidth:1,colorKey:"colorValue",opacity:.15,states:{hover:{borderColor:"#999999",brightness:x?0:.1,halo:!1,opacity:.75,shadow:!1}}});return b}(w);J(u.prototype,{buildKDTree:a,colorKey:"colorValue",directTouch:!0,drawLegendSymbol:r.drawRectangle,getExtremesFromAll:!0,getSymbol:a,optionalAxis:"colorAxis",parallelArrays:["x",
"y","value","colorValue"],pointArrayMap:["value"],pointClass:e,trackerGroups:["group","dataLabelsGroup"],utils:{recursive:g.recursive}});l.registerSeriesType("treemap",u);"";return u});w(a,"Series/Sunburst/SunburstPoint.js",[a["Series/DrawPointComposition.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k,d){var r=this&&this.__extends||function(){var a=function(d,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&
(a[c]=b[c])};return a(d,e)};return function(d,e){function c(){this.constructor=d}a(d,e);d.prototype=null===e?Object.create(e):(c.prototype=e.prototype,new c)}}(),l=k.series.prototype.pointClass,t=d.correctFloat;d=d.extend;k=function(a){function d(){var d=null!==a&&a.apply(this,arguments)||this;d.node=void 0;d.options=void 0;d.series=void 0;d.shapeExisting=void 0;return d}r(d,a);d.prototype.getDataLabelPath=function(a){var c=this.series.chart.renderer,b=this.shapeExisting,d=b.start,e=b.end,g=d+(e-
d)/2;g=0>g&&g>-Math.PI||g>Math.PI;var k=b.r+(a.options.distance||0);d===-Math.PI/2&&t(e)===t(1.5*Math.PI)&&(d=-Math.PI+Math.PI/360,e=-Math.PI/360,g=!0);if(e-d>Math.PI){g=!1;var l=!0}this.dataLabelPath&&(this.dataLabelPath=this.dataLabelPath.destroy());this.dataLabelPath=c.arc({open:!0,longArc:l?1:0}).add(a);this.dataLabelPath.attr({start:g?d:e,end:g?e:d,clockwise:+g,x:b.x,y:b.y,r:(k+b.innerR)/2});return this.dataLabelPath};d.prototype.isValid=function(){return!0};return d}(k.seriesTypes.treemap.prototype.pointClass);
d(k.prototype,{getClassName:l.prototype.getClassName,haloPath:l.prototype.haloPath,setState:l.prototype.setState});a.compose(k);return k});w(a,"Series/Sunburst/SunburstUtilities.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,k){var d=a.seriesTypes.treemap,r=k.isNumber,l=k.isObject,t=k.merge,e;(function(a){function e(a,b){var c=[];if(r(a)&&r(b)&&a<=b)for(;a<=b;a++)c.push(a);return c}a.recursive=d.prototype.utils.recursive;a.calculateLevelSizes=function(a,b){b=l(b)?b:{};
var c=0,d;if(l(a)){var g=t({},a);a=r(b.from)?b.from:0;var k=r(b.to)?b.to:0;var u=e(a,k);a=Object.keys(g).filter(function(a){return-1===u.indexOf(+a)});var w=d=r(b.diffRadius)?b.diffRadius:0;u.forEach(function(a){a=g[a];var b=a.levelSize.unit,e=a.levelSize.value;"weight"===b?c+=e:"percentage"===b?(a.levelSize={unit:"pixels",value:e/100*w},d-=a.levelSize.value):"pixels"===b&&(d-=e)});u.forEach(function(a){var b=g[a];"weight"===b.levelSize.unit&&(b=b.levelSize.value,g[a].levelSize={unit:"pixels",value:b/
c*d})});a.forEach(function(a){g[a].levelSize={value:0,unit:"pixels"}})}return g};a.getLevelFromAndTo=function(a){var b=a.level;return{from:0<b?b:1,to:b+a.height}};a.range=e})(e||(e={}));return e});w(a,"Series/Sunburst/SunburstSeries.js",[a["Series/CenteredUtilities.js"],a["Core/Globals.js"],a["Core/Series/SeriesRegistry.js"],a["Series/Sunburst/SunburstPoint.js"],a["Series/Sunburst/SunburstUtilities.js"],a["Series/TreeUtilities.js"],a["Core/Utilities.js"]],function(a,k,d,r,l,t,e){function g(a,b){var c=
b.mapIdToNode[a.parent],d=b.series,e=d.chart,g=d.points[a.i];c=v(a,{colors:d.options.colors||e&&e.options.colors,colorIndex:d.colorIndex,index:b.index,mapOptionsToLevel:b.mapOptionsToLevel,parentColor:c&&c.color,parentColorIndex:c&&c.colorIndex,series:b.series,siblings:b.siblings});a.color=c.color;a.colorIndex=c.colorIndex;g&&(g.color=a.color,g.colorIndex=a.colorIndex,a.sliced=a.id!==b.idRoot?g.sliced:!1);return a}var u=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),c=a.getCenter,b=a.getStartAndEndRadians;a=k.noop;var w=d.series,y=d.seriesTypes;k=y.column;var p=y.treemap,v=t.getColor,x=t.getLevelOptions,C=t.setTreeValues,n=t.updateRootId,K=e.error,L=e.extend,D=e.isNumber,H=e.isObject,G=e.isString,
I=e.merge,J=e.splat,N=180/Math.PI;t=function(a){function d(){var b=null!==a&&a.apply(this,arguments)||this;b.center=void 0;b.data=void 0;b.mapOptionsToLevel=void 0;b.nodeMap=void 0;b.options=void 0;b.points=void 0;b.shapeRoot=void 0;b.startAndEndRadians=void 0;b.tree=void 0;return b}u(d,a);d.prototype.alignDataLabel=function(b,c,d){if(!d.textPath||!d.textPath.enabled)return a.prototype.alignDataLabel.apply(this,arguments)};d.prototype.animate=function(a){var b=this.chart,c=[b.plotWidth/2,b.plotHeight/
2],d=b.plotLeft,e=b.plotTop;b=this.group;a?(a={translateX:c[0]+d,translateY:c[1]+e,scaleX:.001,scaleY:.001,rotation:10,opacity:.01},b.attr(a)):(a={translateX:d,translateY:e,scaleX:1,scaleY:1,rotation:0,opacity:1},b.animate(a,this.options.animation))};d.prototype.drawPoints=function(){var a=this,b=a.mapOptionsToLevel,c=a.shapeRoot,d=a.group,e=a.hasRendered,g=a.rootNode,f=a.idPreviousRoot,k=a.nodeMap,l=k[f],n=l&&l.shapeArgs;l=a.points;var p=a.startAndEndRadians,r=a.chart,t=r&&r.options&&r.options.chart||
{},u="boolean"===typeof t.animation?t.animation:!0,v=a.center[3]/2,y=a.chart.renderer,x=!1,A=!1;if(t=!!(u&&e&&g!==f&&a.dataLabelsGroup)){a.dataLabelsGroup.attr({opacity:0});var C=function(){x=!0;a.dataLabelsGroup&&a.dataLabelsGroup.animate({opacity:1,visibility:"inherit"})}}l.forEach(function(h){var l=h.node,m=b[l.level];var t=h.shapeExisting||{};var q=l.shapeArgs||{},w=!(!l.visible||!l.shapeArgs);if(e&&u){var B={};var E={end:q.end,start:q.start,innerR:q.innerR,r:q.r,x:q.x,y:q.y};w?!h.graphic&&n&&
(B=g===h.id?{start:p.start,end:p.end}:n.end<=q.start?{start:p.end,end:p.end}:{start:p.start,end:p.start},B.innerR=B.r=v):h.graphic&&(f===h.id?E={innerR:v,r:v}:c&&(E=c.end<=t.start?{innerR:v,r:v,start:p.end,end:p.end}:{innerR:v,r:v,start:p.start,end:p.start}));t=B}else E=q,t={};B=[q.plotX,q.plotY];if(!h.node.isLeaf)if(g===h.id){var z=k[g];z=z.parent}else z=h.id;L(h,{shapeExisting:q,tooltipPos:B,drillId:z,name:""+(h.name||h.id||h.index),plotX:q.plotX,plotY:q.plotY,value:l.val,isInside:w,isNull:!w});
z=h.options;l=H(q)?q:{};z=H(z)?z.dataLabels:{};m=J(H(m)?m.dataLabels:{})[0];m=I({style:{}},m,z);z=m.rotationMode;if(!D(m.rotation)){if("auto"===z||"circular"===z)if(1>h.innerArcLength&&h.outerArcLength>l.radius){var x=0;h.dataLabelPath&&"circular"===z&&(m.textPath={enabled:!0})}else 1<h.innerArcLength&&h.outerArcLength>1.5*l.radius?"circular"===z?m.textPath={enabled:!0,attributes:{dy:5}}:z="parallel":(h.dataLabel&&h.dataLabel.textPathWrapper&&"circular"===z&&(m.textPath={enabled:!1}),z="perpendicular");
"auto"!==z&&"circular"!==z&&(x=l.end-(l.end-l.start)/2);m.style.width="parallel"===z?Math.min(2.5*l.radius,(h.outerArcLength+h.innerArcLength)/2):l.radius;"perpendicular"===z&&h.series.chart.renderer.fontMetrics(m.style.fontSize).h>h.outerArcLength&&(m.style.width=1);m.style.width=Math.max(m.style.width-2*(m.padding||0),1);x=x*N%180;"parallel"===z&&(x-=90);90<x?x-=180:-90>x&&(x+=180);m.rotation=x}m.textPath&&(0===h.shapeExisting.innerR&&m.textPath.enabled?(m.rotation=0,m.textPath.enabled=!1,m.style.width=
Math.max(2*h.shapeExisting.r-2*(m.padding||0),1)):h.dlOptions&&h.dlOptions.textPath&&!h.dlOptions.textPath.enabled&&"circular"===z&&(m.textPath.enabled=!0),m.textPath.enabled&&(m.rotation=0,m.style.width=Math.max((h.outerArcLength+h.innerArcLength)/2-2*(m.padding||0),1)));0===m.rotation&&(m.rotation=.001);h.dlOptions=m;if(!A&&w){A=!0;var S=C}h.draw({animatableAttribs:E,attribs:L(t,!r.styledMode&&a.pointAttribs(h,h.selected&&"select")),onComplete:S,group:d,renderer:y,shapeType:"arc",shapeArgs:q})});
t&&A?(a.hasRendered=!1,a.options.dataLabels.defer=!0,w.prototype.drawDataLabels.call(a),a.hasRendered=!0,x&&C()):w.prototype.drawDataLabels.call(a)};d.prototype.layoutAlgorithm=function(a,b,c){var d=a.start,e=a.end-d,h=a.val,f=a.x,g=a.y,l=c&&H(c.levelSize)&&D(c.levelSize.value)?c.levelSize.value:0,k=a.r,n=k+l,p=c&&D(c.slicedOffset)?c.slicedOffset:0;return(b||[]).reduce(function(a,b){var c=1/h*b.val*e,m=d+c/2,q=f+Math.cos(m)*p;m=g+Math.sin(m)*p;b={x:b.sliced?q:f,y:b.sliced?m:g,innerR:k,r:n,radius:l,
start:d,end:d+c};a.push(b);d=b.end;return a},[])};d.prototype.setShapeArgs=function(a,b,c){var d=[],e=c[a.level+1];a=a.children.filter(function(a){return a.visible});d=this.layoutAlgorithm(b,a,e);a.forEach(function(a,b){b=d[b];var e=b.start+(b.end-b.start)/2,f=b.innerR+(b.r-b.innerR)/2,h=b.end-b.start;f=0===b.innerR&&6.28<h?{x:b.x,y:b.y}:{x:b.x+Math.cos(e)*f,y:b.y+Math.sin(e)*f};var g=a.val?a.childrenTotal>a.val?a.childrenTotal:a.val:a.childrenTotal;this.points[a.i]&&(this.points[a.i].innerArcLength=
h*b.innerR,this.points[a.i].outerArcLength=h*b.r);a.shapeArgs=I(b,{plotX:f.x,plotY:f.y+4*Math.abs(Math.cos(e))});a.values=I(b,{val:g});a.children.length&&this.setShapeArgs(a,a.values,c)},this)};d.prototype.translate=function(){var a=this,d=a.options,e=a.center=c.call(a),k=a.startAndEndRadians=b(d.startAngle,d.endAngle),p=e[3]/2,t=e[2]/2-p,f=n(a),m=a.nodeMap,q=m&&m[f],r={};a.shapeRoot=q&&q.shapeArgs;w.prototype.translate.call(a);var u=a.tree=a.getTree();m=a.nodeMap;q=m[f];var v=G(q.parent)?q.parent:
"";v=m[v];var y=l.getLevelFromAndTo(q);var A=y.from,D=y.to;y=x({from:A,levels:a.options.levels,to:D,defaults:{colorByPoint:d.colorByPoint,dataLabels:d.dataLabels,levelIsConstant:d.levelIsConstant,levelSize:d.levelSize,slicedOffset:d.slicedOffset}});y=l.calculateLevelSizes(y,{diffRadius:t,from:A,to:D});C(u,{before:g,idRoot:f,levelIsConstant:d.levelIsConstant,mapOptionsToLevel:y,mapIdToNode:m,points:a.points,series:a});d=m[""].shapeArgs={end:k.end,r:p,start:k.start,val:q.val,x:e[0],y:e[1]};this.setShapeArgs(v,
d,y);a.mapOptionsToLevel=y;a.data.forEach(function(b){r[b.id]&&K(31,!1,a.chart);r[b.id]=!0});r={}};d.defaultOptions=I(p.defaultOptions,{center:["50%","50%"],colorByPoint:!1,opacity:1,dataLabels:{allowOverlap:!0,defer:!0,rotationMode:"auto",style:{textOverflow:"ellipsis"}},rootId:void 0,levelIsConstant:!0,levelSize:{value:1,unit:"weight"},slicedOffset:10});return d}(p);L(t.prototype,{drawDataLabels:a,pointAttribs:k.prototype.pointAttribs,pointClass:r,utils:l});d.registerSeriesType("sunburst",t);"";
return t});w(a,"masters/modules/sunburst.src.js",[],function(){})});
//# sourceMappingURL=sunburst.js.map