import { websocketConnect, fetchFcltStts, fetchUnitStts, fetchDbmsStts, setInnerText, _fcltData,  updateFcltStts, updateUnitStts, _unitData } from "./main-func.js";
import { requestGet, apiGet } from "/js/utils/restApi.js";

let _selectFcltType       = "";       // 시설물 통신 정보 조회 유형
let _fetchFcltCommInfoArr = []; // 시설물 통신 정보 조회 저장 버퍼
export let _errorSwitch   = false;
let _fcltExcelTitle       = null;
const _fcltArr            = ["VMS","CCTV","VDS","BIT"];
const _commonColWidth     = [{wpx: 80},{wpx: 80},{wpx: 300},{wpx: 80},{wpx: 80},{wpx: 100}];
const _vdsColWidth        = [{wpx: 80},{wpx: 80},{wpx: 300},{wpx: 80},{wpx: 80},{wpx: 80},{wpx: 100}];
let   _colWidth           = null;

/**
 * 화면 이벤트 핸들러
 */
$(".header >:nth-child(2)").on("click", function(){
    // 새로고침 클릭
    _selectFcltType = "";
    fetchSystemStts();
    hideAll()
    showElement(".centerPsSttsInfo");
});

$(".xToggle").on("click", function(){       
    // 화면 아래 리스트 감추기 X 버튼 클릭
    hideAll()
    showElement(".centerPsSttsInfo");
});

$(".footer_excel").on("click",()=>{
    // 엑셀 저장 클릭

    confirmMessage("엑셀 파일로 저장 하시겠습니까?").done((yes)=>{
        if (yes === true) {
            exportExcel();
        }
    })

    // confirmMessage("Excel file로 저장 하시겠습니까?").done((yes) => {
    //     if (yes === true) {
    //         exportExcel();
    //     }
    // });
});

/**
 * 파라미터로 받은 선택자에 대해서 토글 이벤트 등록
 */
const _pagePerData = 9;
function registerEventFunc(facilityType) {
    $("#"+facilityType+"Toggle, #"+facilityType+"Refresh").on("click",()=>{
        _selectFcltType = facilityType;   // 화면하단 표출되는 시설물 유형
        hideAll();
        _fetchFcltCommInfoArr = new Array();
        fetchFcltCommInfo(facilityType);
        showElement("." + facilityType + "DisabilityStautsList");
    });             
}

/**
 * 어플리케이션 실행후 최초 1회만 실행됨
 */
function initOnce() {

    displayCurrentTime();
    for (let fclt of _fcltArr) {
        registerEventFunc(fclt);
    }
    // registerEventFunc("VMS");
    // registerEventFunc("CCTV");
    // registerEventFunc("VDS");
    // registerEventFunc("RSE");
    // registerEventFunc("BIT");
    websocketConnect("fclt");
}

/**
 * 화면 로딩시에 제일 처음으로 실행될때 수행되는 함수
 * 최초 기동후 1회만 호출됨
 */
export function startApp() {
    initOnce();
    fetchSystemStts();
    fetchdrawGraph();
}

/**
 * 상태정보 일괄 조회(새로고침일 때도 호출 됨)
 */
function fetchSystemStts() {
    fetchFcltStts();
    fetchUnitStts();
    fetchDbmsStts();
}

/**
 * 화면 하단에 표출할 시설물 정보를 조회한다.
 */
function fetchFcltCommInfo(facilityType) {
    //통신상태 장애현황리스트
    if (facilityType === "VMS") {
        requestGet("/api/common/stts/vms/error", updateFcltCommInfo, facilityType);
    } else if (facilityType === "CCTV") {
        requestGet("/api/common/stts/cctv/error", updateFcltCommInfo, facilityType);
    } else if (facilityType === "VDS") {
        requestGet("/api/common/stts/vds/error", updateFcltCommInfo, facilityType);
    } else if (facilityType === "RSE") {
        requestGet("/api/utis/stts/rse/error", updateFcltCommInfo, facilityType);
    } else if (facilityType === "BIT") {
        requestGet("/api/bis/stts/bit/error", updateFcltCommInfo, facilityType);
    } else {
        console.error(`fetchFcltCommInfo: Unknown FcltType, ${facilityType}`);
        _selectFcltType = "";
    }
}
function updateFcltCommInfo(jsonData, facilityType) {
    if (_selectFcltType !== facilityType) {
        console.error(`FcltCommInfo type mismatched: ${_selectFcltType},,,${facilityType}`);
        return;
    }
    _fetchFcltCommInfoArr = jsonData;
    
    let totalCnt = jsonData.length;
    let commErrCnt = 0;
    jsonData.forEach((obj, idx) => {
        if (obj.comm_cd.slice(-1) !== "0") {
            commErrCnt++;
        }
    });

    const currentPage = 1;
    const totalPage = Math.ceil(totalCnt/_pagePerData);
    $(".footer_disNumBox").html(commErrCnt);
    // $(".fotter_page").html(currentPage + '&nbsp; / &nbsp;'+ totalPage);

    displayFcltCommInfo(facilityType, 0, 1, totalPage);
}

function displayFcltCommInfo(facilityType, firstIdx, currentPage, totalPage) {
    if (_fetchFcltCommInfoArr.length < firstIdx) {
        console.error(`displayFcltCommInfo: FcltCommArr length error, ${_fetchFcltCommInfoArr.length}, ${firstIdx}`);
        return;     
    }
    $(".fotter_page").html(currentPage + '&nbsp; / &nbsp;'+ totalPage);
    const valueInsertTag = "."+facilityType+"DisabilityListValuesInsert";

    // 이전 내용을 지운다.
    $(valueInsertTag).empty();

    // 현재 페이지 표출 내용
    const lastIdx = Math.min(firstIdx + _pagePerData, _fetchFcltCommInfoArr.length);
    if (facilityType === "VDS") {
        for (let ii = firstIdx; ii < lastIdx; ii++) {
            if (_fetchFcltCommInfoArr[ii] != null) {
                $(valueInsertTag).append(
                    '<tr>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].ctlr_id+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].ctlr_nmbr+'</td>'+
                    '    <td class="valueColor" width="500" style="text-align: left;">&nbsp;&nbsp;' + _fetchFcltCommInfoArr[ii].ctlr_nm+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].comm_desc+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].col_desc+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].comm_err_cnt+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].updt_dt+'</td>'+
                    '</tr>'
                );
            }
        }
    } else if (facilityType === "RSE") {
        for (let ii = firstIdx; ii < lastIdx; ii++) {
            if (_fetchFcltCommInfoArr[ii] != null) {
                $(valueInsertTag).append(
                    '<tr>'+
                    '    <td class="valueColor" width="400">'+_fetchFcltCommInfoArr[ii].ctlr_id+'</td>'+
                    '    <td class="valueColor" width="500" style="text-align: left;">&nbsp;&nbsp;' + _fetchFcltCommInfoArr[ii].ctlr_nm+'</td>'+
                    '    <td class="valueColor" width="300">'+_fetchFcltCommInfoArr[ii].comm_desc+'</td>'+
                    '    <td class="valueColor" width="300">'+_fetchFcltCommInfoArr[ii].updt_dt+'</td>'+
                    '</tr>'
                );
            }
        }
    } else if (facilityType === "BIT") {
        for (let ii = firstIdx; ii < lastIdx; ii++) {
            if (_fetchFcltCommInfoArr[ii] != null) {
                $(valueInsertTag).append(
                    '<tr>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].ctlr_id+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].localno+'</td>'+
                    '    <td class="valueColor" width="500" style="text-align: left;">&nbsp;&nbsp;' + _fetchFcltCommInfoArr[ii].ctlr_nm+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].comm_desc+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].comm_err_cnt+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].updt_dt+'</td>'+
                    '</tr>'
                );
            }
        }
    } else {
        for (let ii = firstIdx; ii < lastIdx; ii++) {
            if (_fetchFcltCommInfoArr[ii] != null) {
                $(valueInsertTag).append(
                    '<tr>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].ctlr_id+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].ctlr_nmbr+'</td>'+
                    '    <td class="valueColor" width="500" style="text-align: left;">&nbsp;&nbsp;' + _fetchFcltCommInfoArr[ii].ctlr_nm+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].comm_desc+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].comm_err_cnt+'</td>'+
                    '    <td class="valueColor" width="200">'+_fetchFcltCommInfoArr[ii].updt_dt+'</td>'+
                    '</tr>'
                );
            }
        }
    }

    if (currentPage == 1 || totalPage == 0) {
        $(".footer_previous").css("visibility","hidden"); 
    } else {
        $(".footer_previous").css("visibility","visible");
    }
    
    if (currentPage == totalPage || totalPage == 0) {
        $(".footer_next").css("visibility","hidden"); 
    } else {
        $(".footer_next").css("visibility","visible");
    }

    $(".footer_next").off().on('click', function() { 
    })
    $(".footer_next").on("click",function(){
        displayFcltCommInfo(facilityType, firstIdx+_pagePerData, currentPage+1, totalPage);
    });

    $(".footer_previous").off().on('click', function() { 
    })
    $(".footer_previous").on("click",function(){
        displayFcltCommInfo(facilityType, firstIdx-_pagePerData, currentPage-1, totalPage);
    });
    
    // if (currentPage < totalPage) {
    //     $(".footer_previous10").css("visibility","hidden"); 
    // } else{
    //     $(".footer_previous10").css("visibility","visible");
    // }
    // if (currentPage >= totalPage - _pagePerData || totalPage == 0){
    //     $(".footer_next10").css("visibility","hidden"); 
    // } else {
    //     $(".footer_next10").css("visibility","visible");
    // }
    // $(".footer_next10").off().on('click', function() { 
    // })
    // $(".footer_next10").on("click",function(){
    //     displayFcltCommInfo(_firstIdx+90,_lastIdx+90,_currentPage+10)
    // });
    // $(".footer_previous10").off().on('click', function() { 
    // })
    // $(".footer_previous10").on("click",function(){
    //     displayFcltCommInfo(_firstIdx-90,_lastIdx-90,_currentPage-10)
    // });
}

function fetchFcltDataToExcelTemp(facilityType) {
    const valueInsertTag = "."+facilityType+"DisabilityListValuesInsertHidden";
    _fcltExcelTitle = facilityType;
    // 이전 내용을 지운다.
    $(valueInsertTag).empty();
    _colWidth = _commonColWidth;
    // 현재 페이지 표출 내용
    const firstIdx = 0;
    const lastIdx = _fetchFcltCommInfoArr.length;
    if (facilityType === "VDS") {
        _colWidth = _vdsColWidth;
        for (let ii = firstIdx; ii < lastIdx; ii++) {
            if (_fetchFcltCommInfoArr[ii] != null) {
                $(valueInsertTag).append(
                    '<tr>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].ctlr_id+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].ctlr_nmbr+'</td>'+
                    '    <td width="500">'+_fetchFcltCommInfoArr[ii].ctlr_nm+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].comm_desc+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].col_desc+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].comm_err_cnt+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].updt_dt+'</td>'+
                    '</tr>'
                );
            }
        }
    } else if (facilityType === "RSE") {
        for (let ii = firstIdx; ii < lastIdx; ii++) {
            if (_fetchFcltCommInfoArr[ii] != null) {
                $(valueInsertTag).append(
                    '<tr>'+
                    '    <td width="400">'+_fetchFcltCommInfoArr[ii].ctlr_id+'</td>'+
                    '    <td width="500">'+_fetchFcltCommInfoArr[ii].ctlr_nm+'</td>'+
                    '    <td width="300">'+_fetchFcltCommInfoArr[ii].comm_desc+'</td>'+
                    '    <td width="300">'+_fetchFcltCommInfoArr[ii].updt_dt+'</td>'+
                    '</tr>'
                );
            }
        }
    } else if (facilityType === "BIT") {
        for (let ii = firstIdx; ii < lastIdx; ii++) {
            if (_fetchFcltCommInfoArr[ii] != null) {
                $(valueInsertTag).append(
                    '<tr>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].ctlr_id+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].localno+'</td>'+
                    '    <td width="500">'+_fetchFcltCommInfoArr[ii].ctlr_nm+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].comm_desc+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].comm_err_cnt+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].updt_dt+'</td>'+
                    '</tr>'
                );
            }
        }
    } else {
        for (let ii = firstIdx; ii < lastIdx; ii++) {
            if (_fetchFcltCommInfoArr[ii] != null) {
                $(valueInsertTag).append(
                    '<tr>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].ctlr_id+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].ctlr_nmbr+'</td>'+
                    '    <td width="500">'+_fetchFcltCommInfoArr[ii].ctlr_nm+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].comm_desc+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].comm_err_cnt+'</td>'+
                    '    <td width="200">'+_fetchFcltCommInfoArr[ii].updt_dt+'</td>'+
                    '</tr>'
                );
            }
        }
    }
}

const excelHandler = {
    getExcelFileName : function() {
        return _fcltExcelTitle + ' 통신상태 장애현황 리스트.xlsx'
        //return 'table.xlsx'; // 테이블이름
    },
    getSheetName : function() {
        return _fcltExcelTitle + ' 통신상태 장애현황'; // 엑셀 하단 시트 이름
    },
    getExcelData : function() { // EXCEL로 변환하고자 하는 테이블 선택
        if($(".VMSDisabilityStautsList").css("display") === "flex") {
            return document.getElementById('VMSTable');
        }
        if($(".CCTVDisabilityStautsList").css("display") === "flex") {
            return document.getElementById('CCTVTable');
        }
        if($(".VDSDisabilityStautsList").css("display") === "flex") {
            return document.getElementById('VDSTable');
        }
        if($(".RSEDisabilityStautsList").css("display") === "flex") {
            return document.getElementById('RSETable');
        }
        if($(".BITDisabilityStautsList").css("display") === "flex") {
            return document.getElementById('BITTable');
        }
    },
    getWorksheet : function() {
        return XLSX.utils.table_to_sheet(this.getExcelData(), {sheet : _fcltExcelTitle + ' 통신상태 장애현황', raw : true});
    }
}

function s2ab(s) { 
    let buf = new ArrayBuffer(s.length); //convert s to arrayBuffer
    let view = new Uint8Array(buf);  //create uint8array as viewer
    for (let i=0; i<s.length; i++) view[i] = s.charCodeAt(i) & 0xFF; //convert to octet
    return buf;    
}

function exportExcel() {
    fetchFcltDataToExcelTemp(_selectFcltType);

    // step 1. workbook 생성
    let wb = XLSX.utils.book_new();

    // step 2. 시트 만들기 
    let newWorksheet = excelHandler.getWorksheet();

    newWorksheet["!cols"] = _colWidth;
    // step 3. workbook에 새로만든 워크시트에 이름을 주고 붙인다.  
    XLSX.utils.book_append_sheet(wb, newWorksheet, excelHandler.getSheetName());

    // step 4. 엑셀 파일 만들기 
    let wbout = XLSX.write(wb, {bookType:'xlsx',  type: 'binary'});

    // step 5. 엑셀 파일 내보내기 
    saveAs(new Blob([s2ab(wbout)],{type:"application/octet-stream"}), excelHandler.getExcelFileName());
}

/**
 * 화면 상단 우측 현재시간 표출(매 1초 단위)
 */let _timerPollCurrentTime = null; // 시설물 상태정보 요청 타이머
const pollCurrentTime = () => {
    if (_timerPollCurrentTime) window.clearTimeout(_timerPollCurrentTime);
    _timerPollCurrentTime = window.setTimeout(() => displayCurrentTime(), 1000);
};

function displayCurrentTime() {
    const weekDesc = ['일요일', '월요일', '화요일', '수요일', '목요일', '금요일', '토요일'];
    const date = new Date();
    const year = date.getYear() + 1900;
    const month = date.getMonth() + 1;
    const day = date.getDate();
    const week = date.getDay();
    const hours = date.getHours();
    const minutes = date.getMinutes();
    const seconds = date.getSeconds();
    const currDt = `${year}년 ${month}월 ${day}일 ${weekDesc[week]} ${hours < 10 ? `0${hours}` : hours}:${minutes < 10 ? `0${minutes}`  : minutes }:${seconds < 10 ? `0${seconds }`  : seconds }`;

    setInnerText("clock", currDt);

    pollCurrentTime();
}

function hideElement(tagId) {
    $(tagId).css("display", "none");
}
function showElement(tagId) {
    $(tagId).css("display", "flex");
}

function hideAll(){
    hideElement(".centerPsSttsInfo");
    hideElement(".VMSDisabilityStautsList");
    hideElement(".CCTVDisabilityStautsList");
    hideElement(".VDSDisabilityStautsList");
    hideElement(".RSEDisabilityStautsList");
    hideElement(".BITDisabilityStautsList");
}

export function fetchdrawGraph() {
    //console.time("***** fetchdrawGraph: ");
    const graphUrl = apiGet('/api/common/dashboard/cmtr-grad-count-stts/ifsc');

    Promise.all([graphUrl])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            drawGraph(values[0]); //ITS 프로세스
        })
        .catch((err) => {
             //console.error(`Error in tUnitStts ${err}`);
        })
        .finally(() => {
             //console.timeEnd("***** fetchdrawGraph: ")
        });
        
    setTimeout(() => {
        fetchdrawGraph()
    }, 1000 * 60 * 5 );
}

function drawGraph(res) {
    const prcn_cd = []
    const prcn_cd_full = []
    const ltc0 = []
    const ltc1 = []
    const ltc2 = []
    const ltc3 = []
    const rate_ltc0 = []
    const rate_ltc1 = []
    const rate_ltc2 = []
    const rate_ltc3 = []
    const ltc = []
    const ltcRate = []

    res.forEach((ii) => {
        let tempYear = ii.prcn_cd.substring(0,4)
        let tempMonth = ii.prcn_cd.substring(4,6)
        let tempDay = ii.prcn_cd.substring(6,8)
        let tempHour = ii.prcn_cd.substring(8,10);
        let tempMinu = ii.prcn_cd.substring(10,12);
        let tempSec = ii.prcn_cd.substring(12,14);
        prcn_cd.push(tempHour+":"+tempMinu+":"+tempSec)
        prcn_cd_full.push(tempYear+"년 "+tempMonth+"월 "+tempDay+"일 "+ tempHour+":"+tempMinu+":"+tempSec)
        ltc0.push(ii.ltc0)
        ltc1.push(ii.ltc1)
        ltc2.push(ii.ltc2)
        ltc3.push(ii.ltc3)
        rate_ltc0.push(ii.rate_ltc0)
        rate_ltc1.push(ii.rate_ltc1)
        rate_ltc2.push(ii.rate_ltc2)
        rate_ltc3.push(ii.rate_ltc3)
    })
   
    const rt1_lastNum = rate_ltc1[rate_ltc1.length - 1];
    const rt2_lastNum = rate_ltc2[rate_ltc2.length - 1];
    const rt3_lastNum = rate_ltc3[rate_ltc3.length - 1];
    const prcn_cd_lastNum = prcn_cd_full[prcn_cd_full.length - 1];

    ltc.push(
        {
            name: '원활',
            color:'#15B337',
            data: ltc1
        }, 
        {
            name: '지체',
            color:'#FFAA00',
            data: ltc2
        }, 
        {
            name: '정체',
            color:'#FF0000',
            data: ltc3
        }
    )

    ltcRate.push(
        {
            name: '원활',
            color:'#15B337',
            y: rt1_lastNum,
        }, {
            name: '지체',
            color:'#FFAA00',
            y:rt2_lastNum
        }, {
            name: '정체',
            color:'#FF0000',
            y: rt3_lastNum
        })
   
        hiCht_Bline(prcn_cd, ltc)
        hiCht_pie(prcn_cd_lastNum, ltcRate)
    
    // setTimeout(function() {
    //     drawGraph(url)
    //     }, 1000);    

  
}

function hiCht_Bline(xAxisVal , yAxisVal) {
    Highcharts.chart('linkTraffic', {
        credits: {
            enabled: false
        },
        chart: {
            backgroundColor: '#2d2d33',
            animation: Highcharts.svg,
        },        
        title: {
            text: '정보제공 구간 지정체 상황 (건수)',
            style: {
                color: 'rgb(139 138 139)',
                //fontSize: 15,
                fontWeight: 'bold'
            }
        },
        legend: {
            itemStyle:{
                color: "rgb(139 138 139)",
             },
             itemHoverStyle: {
                color: 'black'
             },
             itemHiddenStyle: {
                color: 'rgb(55 55 65)'
             },
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'middle'
        },
        // tooltip: {
        //     pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        // },
        xAxis: {
            //시작 값
            startOntick: false,
            //끝 값
            endOntick: false,
            //x축 값
            categories: xAxisVal, 
            //x축 보여주는 설정 
            labels: {
                style: {
                    color: '#eeeeee',
                    fontSize: '10px'
                },
                // formatter: function() {
                //     return this.value
                // }
            }
        },
        yAxis: {
            startOntick: false,
            endOntick: false,
            title: '',
            tickInterval: 100,
            labels: {
                style: {
                color: '#eeeeee'
            },
            format: ''//y축 표출이름
            
            },
        },
        series: yAxisVal,
        responsive: {
            rules: [{
                condition: {
                    maxWidth: 500
                },
                chartOptions: {
                    legend: {
                        layout: 'horizontal',
                        align: 'center',
                        verticalAlign: 'bottom'
                    }
                }
            }]
        }
    });
}

function hiCht_pie(curTime, yAxisVal) {
    Highcharts.chart('linkTrafficRate', {
        credits: {
            enabled: false
        },

        chart: {
            backgroundColor: '#2d2d33',
            animation: Highcharts.svg,
            plotBackgroundColor: null,
            plotBorderWidth: null,
            plotShadow: false,
            type: 'pie',
            //width: 100,
			// height: '80%',
            marginTop: 35,
            // marginBottom:25,
        },
        title: {
            text: curTime,
            style: {
                color: 'rgb(139 138 139)',
                fontSize: 13.9,
                fontWeight: 'bold',
                left:100,
            }
        },
        tooltip: {
            pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
        },
        legend: {
            enabled:false,
            itemStyle:{
                color: "rgb(139 138 139)",
                
            },
            itemHoverStyle: {
                color: 'black'
            },
            itemHiddenStyle: {
                color: 'rgb(55 55 65)'
            },
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'middle'
        },
        accessibility: {
            point: {
                valueSuffix: '%'
            }
        },
        plotOptions: {
            pie: {
                size: '110%',
                allowPointSelect: true,
                cursor: 'pointer',
                dataLabels: {
                    enabled: true,
                    format: "<strong>{point.name}</strong><br>{point.percentage:.1f}",
                    distance: -30,
                    color: "white",
                    filter: {
                        property: 'percentage',
                        operator: '>',
                        value: 4
                      }
                },
            }
        },
        series: [{
            name: 'rate',
            colorByPoint: true,
            data: yAxisVal
        }]
    });
}

$('.logo-img').on('dblclick', ()=>{
    if (!_errorSwitch) {
        _errorSwitch = true;
        for (let fclt of _fcltArr) {
            $("#"+fclt+"Toggle, #"+fclt+"Refresh").off('click');
        }
        hideAll();
        showElement(".centerPsSttsInfo");
    }
    else {
        _errorSwitch = false;
        for (let fclt of _fcltArr) {
            registerEventFunc(fclt);
        }
    }
    updateFcltStts(_fcltData[0]);
    updateFcltStts(_fcltData[1]);
    updateUnitStts(_unitData[0]);
    updateUnitStts(_unitData[1]);
})