$(() => {
    let selectData;
    let selectListData = opener.getIfscData();
    $('.select-list-table')
        .width('100%')
        .height('100%')
        .dxDataGrid({
            dataSource              : selectListData,
            allowColumnReordering   : true,
            showColumnLines         : true,
            allowColumnResizing     : true,
            showBorders             : true,
            rowAlternationEnabled   : true,
            columnAutoWidth         : true,
            focusedRowEnabled       : true,
            keyExpr                 : 'ifsc_id',
            selection: {
                mode: 'single',
            },
            filterRow: {
                visible: true,
                applyFilter: "auto",
                showOperationChooser:false,
            },
            headerFilter: {
                visible: true,
            },
            scrolling: {
                mode: 'virtual',
            },
            grouping: {
                autoExpandAll: true,
            },
            groupPanel: {
                visible: true,
                emptyPanelText: '그룹 지을 항목을 여기에 끌어다 놓으세요',
            },
            columns: [
                {
                    dataField : 'ifsc_id',
                    caption   : 'ID',
                    dataType  : 'string',
                    alignment : 'center',
                    width     : 100,
                    sortIndex : 0,
                    sortOrder : 'asc',
                },
                {
                    dataField : 'ifsc_nm',
                    caption   : '명칭',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + '</div>');
                    },
                },
                {
                    dataField : 'drct_desc',
                    caption   : '방향',
                    alignment : 'center',
                },
                {
                    dataField : 'f_node_id',
                    caption   : '시작 노드 ID',
                    alignment : 'center',
                },
                {
                    dataField : 't_node_id',
                    caption   : '종료 노드 ID',
                    alignment : 'center',
                },
                {
                    dataField : 'strt_nm',
                    caption   : '시점명',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + '</div>');
                    },
                },
                {
                    dataField : 'end_nm',
                    caption   : '종점명',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + '</div>');
                    },
                },
                {
                    dataField : 'sect_lngt',
                    caption   : '길이',
                    alignment : 'center',
                },
                {
                    dataField : 'sect_grad_desc',
                    caption   : '구간등급코드',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        let result = nullChecker(e.displayValue);
                        return $('<div style="text-align: left;">' + result + '</div>');
                    },
                },
                {
                    dataField : 'rmrk',
                    caption   : '비고',
                    alignment : 'center',
                },
                {
                    dataField : 'extr_cnct_sect_yn',
                    caption   : '외부연계',
                    alignment : 'center',
                },
            ],
            onRowDblClick(e){
                window.opener.$('.ifsc_id').dxNumberBox('instance').option('value', e.data.ifsc_id)
                window.close();
            },
            onSelectionChanged(e) {
                selectData = e.selectedRowsData[0];
            },
        })
        .dxDataGrid('instance');

    $('.select-button').dxButton({
        stylingMode : 'outlined',
        width       : '100px',
        icon        : 'check',
        text        : '선택',
        onClick() {
            if (selectData === undefined) {
                alertWarning('선택된 데이터가 없습니다.');
            }
            else {
                window.opener.$('.ifsc_id').dxNumberBox('instance').option('value', selectData.ifsc_id)
                window.close();
            }
        },
    });
});

