let managerData       = [];
let updatedData       = [];
let delData           = [];
let managerTable      = null;
let addBtn            = null;
let delBtn            = null;
let applyBtn          = null;
let searchBtn         = null;
let unregData         = [];
let unregTable        = [];
const commonUri       = '/api/facility/manager/info';
const _pageName       = '시설물정보 관리';
const _userId         = window.opener.$userId;
const checkByteArr   = [
    ['istl_lctn_addr', '설치위치주소', 200],
    ['mdl_nm', '모델명', 30],
    ['takt_resn', '반출사유', 100],
]
$(()=>{
    //상단 조회 버튼
    searchBtn = $('.search-button').dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        height:'30px',
        width: '80px',
        onClick(){
            fetchBaseData();
        }
    }).dxButton('instance')
    
    //상단 닫기 버튼
    $('.cancle-button').dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton('instance')
    
    //등록 시설물 테이블
    managerTable = $('.user-infr-table').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'fclt_id',
        selection: {
           mode : 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible : true,
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'virtual',
        },
        groupPanel:{
            visible         : true,
            emptyPanelText  : '그룹 지을 항목을 여기에 끌어다 놓으세요'
        },
        export:{
            enabled : true,
            texts   : {
                exportAll :'엑셀 파일',
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName + '_등록 시설물');
        },
        columns:[
            {   
                dataField    : 'fclt_type',
                caption      : '시설물유형',
                allowEditing : false,
                alignment    : 'center',
            },
            {
                dataField    : 'fclt_id',
                caption      : '시설물 ID',
                alignment    : 'center',
                allowEditing : false,
                sortOrder    : 'asc',
                sortIndex    : 0, 
            },
            {
                dataField    : 'fclt_lctn',
                caption      : '시설물 위치',
                alignment    : 'center',
                allowEditing : false,
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    return  c.text(nullChecker(e.displayValue));
                }
            },
            {   
                dataField   : 'istl_lctn_addr',
                caption     : '설치위치주소',
                alignment   : 'center',
                editorOptions: {
                    dataType : 'string',
                    maxLength : 200,
                },
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    return  c.text(nullChecker(e.displayValue));
                }
            },
            {   
                dataField   : 'mdl_nm',
                caption     : '모델명',
                alignment   : 'center',
                editorOptions: {
                    dataType : 'string',
                    maxLength : 30,
                },
            },
            {   
                dataField   : 'use_year',
                caption     : '사용년수',
                editorOptions: {
                    dataType : 'number',
                    max      : 999,
                    min      : 0,
                    format   : "#",
                },
                alignment   : 'center',
            },
            {   
                dataField   : 'inwr_dt',
                caption     : '입고일시',
                alignment   : 'center',
                dataType    : 'datetime',
                format      : 'yyyy-MM-dd',
            },
            {   
                dataField   : 'otwr_dt',
                caption     : '출고일시',
                alignment   : 'center',
                dataType    : 'datetime',
                format      : 'yyyy-MM-dd'
            },
            {   
                dataField   : 'istl_dt',
                caption     : '설치일시',
                alignment   : 'center',
                dataType    : 'datetime',
                format      : 'yyyy-MM-dd'
            },
            {   
                dataField   : 'takt_dt',
                caption     : '반출일시',
                alignment   : 'center',
                dataType    : 'datetime',
                format      : 'yyyy-MM-dd'
            },
            {   
                dataField   : 'takt_resn',
                caption     : '반출사유',
                alignment   : 'center',
                editorOptions: {
                    dataType : 'string',
                    maxLength : 100,
                },
            },
            {   
                dataField   : 'takn_dt',
                caption     : '반입일시',
                dataType    : 'datetime',
                format      : 'yyyy-MM-dd',
                alignment   : 'center',
            },
            {   
                dataField   : 'abdn_dt',
                caption     : '폐기일시',
                dataType    : 'datetime',
                format      : 'yyyy-MM-dd',
                alignment   : 'center',
            },
            {   
                dataField   : 'istl_cmpy_id',
                caption     : '설치업체',
                alignment   : 'center',
                lookup      : {
                    dataSource  : null,
                    valueExpr   : 'istl_cmpy_id',
                    displayExpr : 'istl_cmpy_nm',
                }
            },
            {   
                dataField   : 'mnfc_cmpy_id',
                caption     : '제조업체',
                alignment   : 'center',
                lookup      : {
                    dataSource  : null,
                    valueExpr   : 'mnfc_cmpy_id',
                    displayExpr : 'mnfc_cmpy_nm',
                }
            },
        ],
        onRowUpdated(e){
            updatedData.push(e.data)
        },
        onSelectionChanged(e){
            if(e.component.option('selection.mode') === 'multiple'){
                delData = e.selectedRowsData;
            }
        },
    }).dxDataGrid('instance');

    //미등록 시설물
    unregTable = $('.unreg-table').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'fclt_id',
        selection: {
           mode                 : 'multiple',
           showCheckBoxesMode   : 'onClick'
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible : true,
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'virtual',
        },
        groupPanel:{
            visible         : true,
            emptyPanelText  : '그룹 지을 항목을 여기에 끌어다 놓으세요'
        },
        export:{
            enabled : true,
            texts   : {
                exportAll :'엑셀 파일',
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName + '_미등록 시설물');
        },
        columns:[
            {   
                dataField    : 'fclt_type',
                caption      : '유형',
                alignment    : 'center',
                width        : 90,
            },
            {
                dataField   : 'fclt_id',
                caption     : '시설물 ID',
                alignment   : 'center',
                allowEditing : false,
                sortOrder    : 'asc',
                sortIndex    : 0, 
                
            },
            {
                dataField   : 'fclt_lctn',
                caption     : '시설물 명칭/위치',
                alignment   : 'center',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    return  c.text(nullChecker(e.displayValue));
                }
            },
        ]
    }).dxDataGrid('instance');

    //하단 편집 버튼
    editBtn = $('.edit-btn').dxButton({
        stylingMode:'outlined',
        text:'편집',
        icon:'edit',
        onClick(){
            eventOn();
        }
    }).dxButton('instance');
    
    //하단 취소 버튼
    editCancleBtn = $('.edit-cancle-btn').dxButton({
        stylingMode:'outlined',
        text:'취소',
        visible:false,
        icon:'close',
        onClick(){
                if (managerTable.hasEditData() || delData.length > 0){
                    confirmMessage('변경 하신 데이터가 있습니다. 취소 하시겠습니까?').done((yes)=>{
                        if (yes) {
                            eventCancle();
                            managerTable.clearSelection();
                        }
                    })
                }
                else {
                    eventCancle();
                }
        }
    }).dxButton('instance');
    
    //추가 버튼
    addBtn = $('.add-btn').dxButton({
        stylingMode:'outlined',
        text:'추가 등록',
        icon:'plus',
        onClick(){
            addBtnClick();
        }
    }).dxButton('instance');
    
    //삭제 버튼
    delBtn = $('.del-btn').dxButton({
        stylingMode:'outlined',
        text:'삭제',
        disabled:true,
        icon:'minus',
        onClick(){
            delBtnClick();
        }
    }).dxButton('instance');
    
    //하단 적용 버튼
    applyBtn = $('.apply-btn').dxButton({
        stylingMode:'outlined',
        text:'적용',
        disabled:true,
        icon:'save',
        onClick(){
            saveEvent();
        }
    }).dxButton('instance');

    fetchBaseData();
    fetchLookupData();
})

//기본 데이터 수신
function fetchBaseData(){
    getDataAsync(commonUri + '/unreg', (jsonData) => fetchListData(jsonData, unregTable));
    getDataAsync(commonUri, (jsonData) => fetchListData(jsonData, managerTable));
}

function fetchLookupData(){
    getDataAsync('/api/facility/company', (jsonData)=>{
        if (jsonData.length > 0) {
            let lookupDataSource = [];
            jsonData.map((item)=>{
                lookupDataSource.push({
                    istl_cmpy_id : item.cmpy_id,
                    istl_cmpy_nm : '['+item.cmpy_id+'] ' + item.cmpy_nm,
                    mnfc_cmpy_id : item.cmpy_id,
                    mnfc_cmpy_nm : '['+item.cmpy_id+'] ' + item.cmpy_nm,
                });
            });
            managerTable.option('columns[13].lookup.dataSource',  lookupDataSource);
            managerTable.option('columns[14].lookup.dataSource',  lookupDataSource);
        }
    })
}

//리스트 테이블 데이터 수신
function fetchListData(jsonData, table){
    let listData = jsonData;
    if (listData.length > 0) {
        listData.map((obj)=>{
            tableDateFormmat(obj);
        });
    }
    table.option('dataSource', listData);
    if (table === unregTable) {
        visibleUnleg(listData);
    }
}

//삭제 버튼 클릭 함수
function delBtnClick(){
    updatedData = [];

    managerTable.option('selection',{
        mode                : 'multiple',
        showCheckBoxesMode  : 'onClick'
    });

    managerTable.option('editing',{
        mode:'none'
    });
}

//추가등록 버튼 클릭 함수
function addBtnClick(){
    if (unregTable.getSelectedRowsData().length <= 0) {
        return alertWarning('미등록 시설물을 선택해주세요');
    }
    else {
        confirmMessage('선택하신 미등록 시설물을 시설물 정보에 추가하여 저장 하시겠습니까?').done((yes)=>{
            if (yes){
                result = postInsertUpdate(commonUri + '/reg', unregTable.getSelectedRowsData());
                if (result > 0) {
                    alertConfirm('선택하신 미등록 시설물을 시선물 정보에 정상적으로 저장하였습니다.')
                    fetchBaseData();
                }
            }
        })
    }
}
//이벤트 활성화
function eventOn(){
    showBtn(editCancleBtn);
    hideBtn(editBtn);
    dsblOffBtn(applyBtn);
    dsblOffBtn(delBtn);
    dsblOnBtn(searchBtn);

    managerTable.option('editing',{
        mode                    : 'batch',
        allowUpdating           : true,
        selectTextOnEditStart   : true,
    });
    managerTable.option('toolbar.visible', false);
}

//이벤트 비활성화
function eventCancle(){
    showBtn(editBtn);
    hideBtn(editCancleBtn);
    dsblOnBtn(applyBtn);
    dsblOnBtn(delBtn);
    dsblOffBtn(searchBtn);

    managerTable.option('editing',{
        allowUpdating : false,
    });
    
    managerTable.option('selection',{
        mode : 'single'
    });

    managerTable.option('toolbar.visible', true);;
}

//미등록 시설물 활성화 유무
function visibleUnleg(data){
    if (data.length > 0) {
        $('.body-box').children().eq(0).removeClass('non-unreg');
        $('.body-box').children().eq(0).addClass('unreg');
        $('.body-box').children().eq(1).removeClass('dsp-none');
    }
    else {
        $('.body-box').children().eq(0).addClass('non-unreg');
        $('.body-box').children().eq(0).removeClass('unreg');
        $('.body-box').children().eq(1).addClass('dsp-none');
    }
}

//데이터 수정 시 date type 데이터를 string 타입으로 형변환
function updateDateFormmat(data){

    if (data.inwr_dt) data.inwr_dt = getDate(new Date(data.inwr_dt), new Date(data.inwr_dt).getTime());
    if (data.otwr_dt) data.otwr_dt = getDate(new Date(data.otwr_dt), new Date(data.otwr_dt).getTime());
    if (data.istl_dt) data.istl_dt = getDate(new Date(data.istl_dt), new Date(data.istl_dt).getTime());
    if (data.takt_dt) data.takt_dt = getDate(new Date(data.takt_dt), new Date(data.takt_dt).getTime());
    if (data.takn_dt) data.takn_dt = getDate(new Date(data.takn_dt), new Date(data.takn_dt).getTime());
    if (data.abdn_dt) data.abdn_dt = getDate(new Date(data.abdn_dt), new Date(data.abdn_dt).getTime());
}

//테이블 세팅 시 날짜 데이터를 날짜 포맷 변환
function tableDateFormmat(data){
    if (data.inwr_dt) data.inwr_dt = getParseDateTime(data.inwr_dt);
    if (data.otwr_dt) data.otwr_dt = getParseDateTime(data.otwr_dt);
    if (data.istl_dt) data.istl_dt = getParseDateTime(data.istl_dt);
    if (data.takt_dt) data.takt_dt = getParseDateTime(data.takt_dt);
    if (data.takn_dt) data.takn_dt = getParseDateTime(data.takn_dt);
    if (data.abdn_dt) data.abdn_dt = getParseDateTime(data.abdn_dt);
}

//데이터 수신 및 테이블 세팅 함수
function tableSettings(){
    getDataAsync(commonUri, (jsonData)=>fetchListData(jsonData, managerTable));
}

function saveEvent(){
    let result = 0;
    switch (true) {
        //수정 이벤트
        case managerTable.hasEditData() === true :
            const changeArr  = managerTable.option('editing.changes');
            const updateData = [];
            const chng_dt    = excellTime();
            changeArr.map((item)=>{
                managerTable.byKey(item.key).done((obj)=>{
                    updateDateFormmat(obj);
                    obj.chng_nm = _userId;
                    obj.chng_dt = chng_dt;
                    updateData.push(obj);
                });
            });
            for(let obj of updateData) {
                const frontContent = "시설물 ID : " + obj.fclt_id + "<br>"
                for (let checkByte of checkByteArr) {
                    const value = obj[checkByte[0]];
                    const empty = nullChecker(value) === '';
                    if (!empty && getByteLength(value) > checkByte[2]) {
                        return alertWarning( frontContent + checkByte[2]+ " 바이트 이내로 입력해주세요. [ " + checkByte[1] + " ]");
                    }
                }
            }
            result =  postInsertUpdate(commonUri, updateData);

            if (result > 0) {
                insResultMsg(_pageName);
                eventCancle();
                tableSettings();
            }

            break;
        //삭제 이벤트
        case delData.length > 0:
            let ids = [];
            for(idx in delData){
                ids.push(delData[idx].fclt_id);
            }
            result = deleteDataIds(commonUri, ids)
            if ( result > 0){
                delResultMsg(_pageName);
                eventCancle();
                delData   = [];
                fetchBaseData();
            }
            break;
        default:
            alertWarning('변경하신 데이터가 없습니다.');
            break;
    }
}