let selectBox     = null;
let searchButton  = null;
let textBox       = null;
let failHsPopupTb = null;
let btnArr        = [];
let strtDt        = null;
let endDt         = null;
let endTime       = null;
let strtTime      = null;

btnArr = [
    strtDt  ={
        box      : null,
        value    : new Date().setDate(new Date().getDate()-1),
        type     : 'date',
        format   : 'yyyy-MM-dd',
        class    : 'strt-dt',
        invalid  : 'ex)0000-00-00'
    },
    endDt   ={
        box      : null,
        value    : new Date().setDate(new Date().getDate()-1),
        type     : 'date',
        format   : 'yyyy-MM-dd',
        class    : 'end-dt',
        invalid  : 'ex)0000-00-00'
    },
    endTime ={
        box      : null,
        value    : endSettingTime,
        type     : 'time',
        interval : '10',
        format   : 'HH시 mm분',
        class    : 'end-time',
        invalid  : 'ex)00시 00분'
    },
    strtTime={
        box      : null,
        value    : firstSettingTime,
        type     : 'time',
        interval : '10',
        format   : 'HH시 mm분',
        class    : 'strt-time',
        invalid  : 'ex)00시 00분',
    },
]
const selectDataSource = [
    {
        name : '전체',
        uri  : null,
    }, 
    {
        name : 'CCTV',
        uri  : '/api/cctv/history/stts-hs/fail',
    }, 
    {
        name : 'VMS',
        uri  : '/api/vms/history/stts/fail'
    },
    { 
        name : 'VDS',
        uri  : '/api/vds/history/stts/fail'
    },
];
$(()=>{

    //시설물 구분 코드
    //시설물 구분에 따른 데이터 조회
    selectBox = $(".select-box").dxSelectBox({
        dataSource  : null,
        value       : null,
        width       : 150,
        height      : 30,
        displayExpr : 'fclt_nm',
        valueExpr   : 'fclt_cd',
        stylingMode : 'outlined',
        
    }).dxSelectBox("instance");

    btnArr.map((item)=>{
        item.box = $('.' + item.class).dxDateBox({
            value                 : item.value,
            type                  : item.type,
            displayFormat         : item.format,
            width                 : 100,
            height                : 30,
            stylingMode           : 'outlined',
            invalidDateMessage    : '형식에 맞게 입력해주세요. ' + item.invalid,
        }).dxDateBox('instance');

        if(item.interval){
            item.box.option('interval', item.interval);
        }
    })

    textBox = $(".text-box").dxTextBox({
        width       : 220,
        height      : 30,
        stylingMode : 'outlined'
    }).dxTextBox("instance");

    searchButton = $(".search-btn").dxButton({
        width       : 80,
        height      : 31,
        stylingMode : 'outlined',
        icon        : 'refresh',
        text        : '조회',
        onClick(){
            fetchlistData();
        }
    }).dxButton("instance");

    failHsPopupTb = $(".FrmGisSearch").width('100%').height("100%").dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        allowColumnResizing     : true,
        showBorders             : true,
        showColumnLines         : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : ['fclt_type', 'fclt_id', 'crtn_dt'],
        noDataText              : '표출할 정보가 없습니다.',
        filterRow               : {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        scrolling               : {
            mode : 'standard',
        },
        paging                  : {
            pageSize : 1000,
        },
        headerFilter            : {
            visible: true,
        },
        sorting                 : {
            showSortIndexes: false,
        },
        columns                 : [
            {
                dataField : 'fclt_type',
                alignment : 'center',
                caption   : '구분',
                groupIndex : 0,
            },
            {
                dataField : 'fclt_id',
                alignment : 'center',
                width     : 140,
                caption   : '시설물 ID',
                sortIndex : 1,
                sortOrder : 'asc'
            },
            {
                dataField : 'fclt_nm',
                alignment : 'center',
                caption   : '시설물 명칭',
                cellTemplate(c,e){
                    c.css('text-align','left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField : 'crtn_dt',
                alignment : 'center',
                caption   : '발생시각',
                dataType  : 'datetime',
                format    : 'yyyy-MM-dd HH:mm:ss',
                sortIndex : 2,
                sortOrder : 'asc'
            },
            
            {
                dataField : 'comm_stts_desc',
                alignment : 'center',
                caption   : '통신',
                width     : 120,
                cellTemplate(c,e){
                    c.css('height','1px');
                    c.css('padding','1px');
                    const div = $("<div>");
                    div.addClass(e.data.comm_stts_cd);
                    div.text(e.displayValue);
                    c.append(div);
                }
            },
            {
                dataField : 'door_stts_desc',
                alignment : 'center',
                caption   : '함체문',
                width     : 120,
                cellTemplate(c,e){
                    c.css('height','1px');
                    c.css('padding','1px');
                    const div = $("<div>");
                    div.addClass(e.data.door_stts_cd);
                    div.text(e.displayValue);
                    c.append(div);
                }
            },
            {
                dataField : 'cbox_tmpr',
                alignment : 'center',
                caption   : '함체온도',
                width     : 120,
                cellTemplate(c,e){
                    c.css('height','1px');
                    c.css('padding','1px');
                    
                    const div = $("<div>");
                    if (e.displayValue === 255 || e.displayValue === null) {
                        div.addClass('gray');
                        div.text('-');
                    }
                    else {
                        div.text(e.displayValue);
                    }
                    c.append(div);
                }
            },
        
        ],
    }).dxDataGrid('instance');
    
    fetchSelectData();
})

function fetchSelectData(){
    data = [];
    getDataAsync('/api/facility/stts-error/fclt-type', (jsonData)=>{
        selectBox.option('dataSource', jsonData);
        if ( jsonData.length > 0) {
            setValue(selectBox, jsonData[0].fclt_cd);
        }
    });
    
}

function fetchlistData(){
    const type = getValue(selectBox);
    if (type) {
        const result = validationCheck(strtDt.box, endDt.box, strtTime.box, endTime.box);
        if (!result) return false;
        const strtDtVal = getValue(strtDt.box);
        const endDtVal = getValue(endDt.box);
        const strtTimeVal = getValue(strtTime.box);
        const endTimeVal = getValue(endTime.box);
        const fromDt = getDate(strtDtVal, strtTimeVal);
        const toDt = getDate(endDtVal, endTimeVal);
        getDataAsync('/api/facility/stts-error/list/' + encodeURIComponent(type) + '/' + encodeURIComponent(fromDt) + '/' + encodeURIComponent(toDt), (jsonData)=>{
            const listData = jsonData
            if ( listData.length > 0 ) {
                listData.map((obj) => {
                    if (obj.crtn_dt) obj.crtn_dt = new Date(getParseDateTime(obj.crtn_dt));
                });
            }
            failHsPopupTb.option('dataSource', listData);
            alertConfirm('데이터 조회가 완료되었습니다. [' + listData.length + '건]');
        });
        
    }
}