import { TMapMngr, TFclt } from "/js/vworld/map-mngr.js";
import { LayerType, LayerIndex } from "/js/vworld/map-const.js";

let _mapManager = null;
let _selectFcltNmbr = null;
const _lyrIdx = LayerIndex.Park;
const _pageName = '주차장 관리';
//우측 섹션 관련
let _managerData      = [];
let managerNumArr    = [];
let _managerTable     = null;
let _map             = null;
let _view            = null;
let pkId             = null;
let pkNm             = null;
let coordx           = null;
let coordy           = null;
let address          = null;
let eAddr            = null;
let eLctn            = null;
let lctnNm           = null;
let lctn             = null;
let pkCnt            = null;
let pkEnm            = null;
let phone            = null;
let saveBtn          = null;
let cancleBtn        = null;
let addBtn           = null;
let delBtn           = null;
let editBtn          = null;
let idArr            = [];
let modalSelectBtn   = null;
let modalText        = null;
let modalCancelBtn   = null;
let modalCancleIcon  = null;

const updateDataColumns = {
    address      : null,
    coordx       : null,
    coordy       : null,
    eaddress     : null,
    elocation    : null,
    location     : null,
    parkingcnt   : null,
    parkingename : null,
    parkingid    : null,
    parkingname  : null,
    phone        : null

}

let ctrlIpNum       = null;
let linkSearchBtn   = null;

//공통
let commonUri        = '/api/parking/manager/info';
const pageName       = '주차장 관리';
const pageMsg        = '주차장'
const inputArr = [
    pkId = {
        box      : null,
        option   : 150,
        disabled : true,
        column   : "parkingid",
        max      : 10,
        no       : false,
    },
    pkNm = {
        box      : null,
        option   : 210,
        disabled : false,
        column   : "parkingname",
        max      : 50,
        no       : false,
    },
    coordx = {
        box      : null,
        option   : 100,
        disabled : false,
        value    : '0.0000000',
        method   : function(e){
            crdnChanges(e,3)
        },
        column   : "coordx",
        max      : 11,
        no       : false,
    },
    coordy = {
        box      : null,
        option   : 100,
        disabled : false,
        value    : '0.0000000',
        method   : function(e){
            crdnChanges(e,2);
        },
        column   : "coordy",
        max      : 10,
        no       : false,
    },
    address = {
        box      : null,
        option   : 210,
        disabled : false,
        column   : "address",
        max      : 100,
        no       : false,
    },
    eAddr = {
        box      : null,
        option   : 210,
        disabled : false,
        column   : "eaddress",
        max      : 100,
        no       : false,
    },
    eLctn = {
        box      : null,
        option   : 210,
        disabled : false,
        column   : "elocation",
        max      : 120,
    },
    lctn = {
        box      : null,
        option   : 210,
        disabled : false,
        column   : "location",
        max      : 120,
        no       : false,
    },
    pkCnt = {
        box      : null,
        option   : 210,
        disabled : false,
        column   : "parkingcnt",
        max      : 200,
        no       : true,
    },
    pkEnm = {
        class    : "out-rstp",
        box      : null,
        option   : 210,
        disabled : false,
        column   : "parkingename",
        max      : 30,
        no       : false,
    },
    phone = {
        box      : null,
        option   : 210,
        disabled : false,
        column   : "phone",
        max      : 20,
        no       : false,
    },

]

const btnArr    = [
    editBtn = {
        class       : "edit-btn",
        box         : null,
        option      : 80,
        visible     : true,
        disabled    : true,
        dbdsb       : false,
        edit        : {
            click   : {
                visible  : false,
                disabled : false,
            },
            cancle : {
                visible  : true,
                disabled : false,
            }
        },
        add         : {
            click   : {
                visible  : false,
                disabled : false,
            },
            selected : {
                visible  : true,
                disabled : false,
            }
            ,
            unSelected : {
                visible  : true,
                disabled : true,
            },
        }
        ,
        addvsb      : false,
        icon        : "edit",
        text        : "편집",
        method      : function(){
            editEvent();
        }
    },
    cancleBtn = {
        class       : "cancle-btn",
        box         : null,
        option      : 80,
        visible     : false,
        disabled    : false,
        dbdsb       : false,
        edit        : {
            click   : {
                visible  : true,
                disabled : false,
            },
            cancle : {
                visible  : false,
                disabled : false,
            }
        },
        add         : {
            click   : {
                visible  : true,
                disabled : false,
            },
            selected : {
                visible  : false,
                disabled : false,
            }
            ,
            unSelected : {
                visible  : false,
                disabled : false,
            },
        },
        addvsb      : true,
        icon        : "close",
        text        : "취소",
    },
    addBtn = {
        class       : "add-btn",
        box         : null,
        option      : 80,
        disabled    : false,
        visible     : true,
        edit        : {
            click   : {
                visible  : true,
                disabled : true,
            },
            cancle : {
                visible  : true,
                disabled : false,
            }
        },
        add         : {
            click   : {
                visible  : true,
                disabled : true,
            },
            selected : {
                visible  : true,
                disabled : false,
            }
            ,
            unSelected : {
                visible  : true,
                disabled : false,
            },
        },
        dbdsb       : false,
        adddsb      : true,
        icon        : "plus",
        text        : "추가",
        method      : function(){
            modalText.option('value','');
            $(".modal-background").css("display",'flex');
            modalText.focus();
        }
    },
    delBtn = {
        class       : "del-btn",
        box         : null,
        option      : 80,
        disabled    : true,
        visible     : true,
        edit        : {
            click   : {
                visible  : true,
                disabled : true,
            },
            cancle : {
                visible  : true,
                disabled : false,
            }
        },
        add         : {
            click   : {
                visible  : true,
                disabled : true,
            },
            selected : {
                visible  : true,
                disabled : false,
            }
            ,
            unSelected : {
                visible  : true,
                disabled : true,
            },
        },
        dbdsb       : false,
        adddsb      : true,
        icon        : "minus",
        text        : "삭제",
        method      : function(){
            confirmMessage(pageMsg+ " ID : " + _managerTable.getSelectedRowsData()[0].parkingid
                + "<br>선택하신 " + pageMsg + " 정보를 삭제하시겠습니까?").done((yes)=>{
                if (yes) {
                    const result = deleteData(commonUri, _managerTable.getSelectedRowsData()[0].parkingid)
                    if (result > 0) {
                        delResultMsg(pageMsg);
                        boxInit();
                        buttonReset('add','unSelected');
                        deleteFcltObject(_managerTable.getSelectedRowsData()[0].parkingid);
                        _managerTable.option('focusedRowKey', null);
                        _managerData = refresh( _managerTable, _managerData, commonUri);
                        idArr = [];
                        idArr = getIdArray(idArr);
                    }
                }
            })
        }
    },
    saveBtn = {
        class       : "save-btn",
        box         : null,
        option      : 80,
        disabled    : true,
        dbdsb       : true,
        edit        : {
            click   : {
                visible  : true,
                disabled : false,
            },
            cancle : {
                visible  : true,
                disabled : true,
            }
        },
        add         : {
            click   : {
                visible  : true,
                disabled : false,
            },
            selected : {
                visible  : true,
                disabled : true,
            }
            ,
            unSelected : {
                visible  : true,
                disabled : true,
            },
        },
        adddsb      : false,
        visible     : true,
        icon        : "save",
        text        : "저장",
    },

]

$(()=>{
    //주차장 ID 추가 하기 위한 div 생성
    $("body").append(modalDiv);
    $(".modal-title").prepend($("<div>주차장ID</div>"));
    $(".modal-background").css("display",'none');
    $(".modal-content").append($("<div class='modal-content-title'>")
        .html("신규 주차장 ID를 입력하세요(10Byte)."),$("<div class='modal-text'>"));

    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")

    //화면에 텍스트 상자 세팅
    inputArr.map((item)=>{
        if(item.no){
            item.box = $("." + item.column).dxNumberBox({
                width           : 100,
                stylingMode     : 'outlined',
                disabled        : true,
                showSpinButtons : true,
                min             : 0,
                max             : 999,

            }).dxNumberBox('instance');
            return false;
        }

        item.box = $("." + item.column).dxTextBox({
            width       : item.option,
            stylingMode : 'outlined',
            disabled    : true,
            maxLength   : item.max,
            height      : 27,
        }).dxTextBox("instance");
        if(item.value){
            item.box.option("value", item.value);
        }
        if(item.method){
            item.box.on("valueChanged", item.method);
        }

    })

    //화면에 버튼 세팅
    btnArr.map((item)=>{
        item.box = $("." + item.class).dxButton({
            icon              : item.icon,
            width             : item.option,
            text              : item.text,
            visible           : item.visible,
            disabled          : item.disabled,
            focusStateEnabled : false,
            stylingMode       : 'outlined',
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxButton("instance");
    })

    //맵 세팅
    doMap();

    //주차장 목록 데이터 수신
    getData( commonUri, _managerData);
    idArr = getIdArray(idArr);
    //맵 icon 정보 업데이트
    updateIcon();

    //주차장 목록 테이블
    _managerTable = $(".manager-table").width('100%').height('100%').dxDataGrid({
        dataSource              : _managerData[0],
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        focusedRowEnabled       : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        keyExpr :'parkingid',

        headerFilter: {
            visible: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        columns:[
            {
                dataField    : "parkingid",
                caption      : "주차장 ID",
                width        : 120,
                alignment    : "center",
            },
            {
                dataField    : "parkingname",
                caption      : "주차장명",
                alignment    : "center",
                cellTemplate(c,e){
                    c.css('text-align','left')
                    return c.text(e.displayValue);
                }
            },

        ],
        onRowDblClick(e){
            _selectFcltNmbr = e.data.parkingid;

            inputArr.map((item)=>{
                item.box.option('value', e.data[item.column])
            });

            btnArr.map((item) =>{
                item.box.option("disabled",item.dbdsb)
            });

            selectFcltObject(_selectFcltNmbr);
        }
    }).dxDataGrid("instance");

    //모달 선택 버튼
    modalSelectBtn = $(".modal-save-Btn").dxButton({
        stylingMode:'outlined',
        text:'선택',
        icon:'check',
        onClick(){
            idValCheck();
        },
    }).dxButton("instance")

    //모달 텍스트
    modalText = $(".modal-text").dxTextBox({
        width       : 250,
        maxLength   : 10,
        stylingMode : 'outlined',
        onEnterKey(){
            idValCheck();
        }

    }).dxTextBox("instance");

    //모달 취소 버튼
    modalCancelBtn = $(".modal-cancle-Btn").dxButton({
        stylingMode:'outlined',
        text:'취소',
        icon:'close',
        onClick(){
            $(".modal-background").css("display",'none');
        }
    }).dxButton("instance")

    //모달 x 버튼
    modalCancleIcon = $(".modal-cancle").dxButton({
        stylingMode:'text',
        icon:'close',
        onClick(){
            $(".modal-background").css("display",'none');
        }
    }).dxButton("instance")
})

//편집 모드 활성화
function editEvent(){
    cancleBtn.box.off('click');
    cancleBtn.box.on('click', () => editCancle());
    editFcltObject(_selectFcltNmbr, true);
    eventOn();

    btnArr.map((item)=>{
        item.box.option( 'visible', item.edit.click.visible   );
        item.box.option( 'disabled', item.edit.click.disabled );
    });

    saveBtn.box.off('click');
    saveBtn.box.on('click', () => saveEvent('edit'));
}

//저장 이벤트(type = 수정, 추가)
function saveEvent(type){
    switch (true) {
        case nullChecker(pkNm.box.option("value")) === "":
            alertWarning('주차장 명을 입력해주세요', null, pkNm.box);
            return false;
        case pkCnt.box.option("value") === 0:
            alertWarning('주차 면수를 입력해주세요', null, pkCnt.box);
            return false;
        case Number(coordx.box.option('value')) === 0:
            alertWarning('x좌표를 입력해주세요', null, coordx.box);
            return false;
        case Number(coordy.box.option('value')) === 0:
            alertWarning('x좌표를 입력해주세요', null, coordy.box);
            return false;
        case getValue(phone.box) && !/^0([0-9]{1,2})[-]{1}([0-9]{3,4})[-]{1}([0-9]{4})$/.test(getValue(phone.box)):
            alertWarning('전화번호 형식에 맞게 입력해주세요', null, phone.box);
            return false;
        default:

            let updateData = {...updateDataColumns};

            if (type === 'edit') {
                // 수정모드일 경우에는....
                const rowData = _managerTable.getSelectedRowsData()[0];
                for (let key in updateData) {
                    updateData[key] = rowData[key];
                }
                console.log('edit mode...')
            }

            inputArr.map((item)=>{
                if (item.column && nullChecker(item.box.option("value")) !== "") {
                    updateData[item.column] = item.box.option("value");
                }
            });

            //ctrlIpNum
            let result = postInsertUpdate(commonUri + "/" + encodeURIComponent(updateData.parkingid), updateData);

            if (result > 0) {
                insResultMsg(pageMsg)
                _managerData = refresh(_managerTable, _managerData, commonUri);
                eventCancle();
                _managerTable.clearSelection();
                _managerTable.refresh().done(function(){
                    _managerTable.selectRows(updateData.parkingid, true).done(function(){
                        _managerTable.option('focusedRowKey', updateData.parkingid);
                        boxPull();
                        buttonReset('add','selected');
                        idArr = [];
                        idArr = getIdArray(idArr);
                    })

                });
            }

            break;
    }

}

//편집 모드 취소
function editCancle(){
    eventCancle();
    boxPull();
    buttonReset( 'edit', 'cancle' );
}

//추가 모드 취소
function addCancle(){

    eventCancle();

    if(_managerTable.getSelectedRowsData().length > 0){
        boxPull();
        buttonReset('add','selected')
        return
    }

    boxInit();
    buttonReset('add','unSelected');

}

//추가 모드
function addEvent(){
    $(".modal-background").css("display",'flex');
    eventOn();
    boxInit();
    //const center = _view.getCenter()
    cancleBtn.box.off('click');
    cancleBtn.box.on('click', () => addCancle());
    //coordx.box.option('value', center[0])
    //coordy.box.option('value', center[1])
    btnArr.map((item)=>{
        item.box.option( 'visible', item.add.click.visible   );
        item.box.option( 'disabled', item.add.click.disabled );
    });

    saveBtn.box.off('click');
    saveBtn.box.on('click', () => saveEvent());
}

//주차장 목록 선택 된 값 우측 텍스트 상자 세팅
function boxPull(){
    let selectedRow = _managerTable.getSelectedRowsData()[0];
    inputArr.map((item)=>{
        item.box.option('value', selectedRow[item.column]);
    });
}

//우측 텍스트 상자 비우기
function boxInit(){
    inputArr.map((item)=>{
        if(item.value) return item.box.option('value', item.value);
        if(item.no) return item.box.option('value','0');
        item.box.option("value", null);
    });
}

//버튼 비활성화
function buttonReset(eventName, option){
    btnArr.map((item)=>{
        item.box.option( 'visible', item[eventName][option].visible   );
        item.box.option( 'disabled', item[eventName][option].disabled );
    });
}

//이벤트 비활성화
function eventCancle(){
    updateIcon();
    dsblOffBtn(_managerTable);

    inputArr.map((item)=>{
        item.box.option("disabled", true);
    });

    if(_managerTable.getSelectedRowsData().length > 0){
        _selectFcltNmbr = _managerTable.getSelectedRowsData()[0].parkingid;
    };
}

//이벤트 활성화
function eventOn(){
    dsblOnBtn(_managerTable);

    inputArr.map((item)=>{
        item.box.option("disabled", item.disabled);
    })
}

//기존 아이디 값들 배열로 돌려받는 함수
function getIdArray(array){
    if(_managerData.length > 0){
        _managerData[0].map((item)=>{
            array.push(item.parkingid);
        })
    }
    return array;
}

//아이디값 유효성 검사
function idValCheck(){
    let pkIdVal = $.trim(modalText.option('value'));

    let strLen = pkIdVal.length;
    let strByte = 0;
    let oneChar = "";

    for(let ii=0; ii < strLen; ii++){
        oneChar = pkIdVal.charAt(ii);
        if(escape(oneChar).length > 4) {
            strByte += 2;
        } else {
            strByte++;
        }
    }

    switch (true) {
        case pkIdVal ==='' || pkIdVal === null:
            alertWarning(pageMsg + ' ID가 입력되지 않았습니다.', null, modalText)
            break;
        case idArr.includes(pkIdVal):
            alertWarning(pageMsg + ' ID가 중복 되었습니다.', null, modalText)
            break;
        case strByte > 10 :
            alertWarning(pageMsg + ' ID는 10byte까지 입력이 가능합니다.', null, modalText)
            break;
        default:
            addEvent();
            let center = _mapManager.getCenter();
            coordx.box.option('value', center[0]);
            coordy.box.option('value', center[1]);
            pkId.box.option('value', pkIdVal);
            _selectFcltNmbr = pkIdVal;
            addFcltObject(pkIdVal);
            $(".modal-background").css('display','none');
            break;
    }

}


/**
 * 지도 인터페이스 함수........
 */
function doMap() {
    _mapManager = new TMapMngr("traf-hs-map", "tooltip");
    _mapManager.setEditMode(_lyrIdx, true);
    _mapManager.showLayer(_lyrIdx, true);
    _mapManager.showFcltObjectText(_lyrIdx, true);
    _mapManager.onFcltDragEndFunc = onFcltDragEndFunc; // 객체(시설물) 편집시 객체 이동후 좌표 반환
    _mapManager.onMouseClickFunc = onMouseClickFunc; // 객체 마우스 클릭 이벤트 반환
    fetchMapIconBar($('.map-bar'), _mapManager, _lyrIdx, _pageName);
    _mapManager.toggleBaseMap(true);

}
function onFcltDragEndFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY) {
    if (ALyrIdx != _lyrIdx) {
        return;
    }
    if (ANmbr === _selectFcltNmbr) {
        coordx.box.option("value", ACoordX.toFixed(7));
        coordy.box.option("value", ACoordY.toFixed(7));
    }
    console.log(`onFcltDragEndFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}`);
}
function onMouseClickFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY, X, Y) {
    if (ALyrIdx != _lyrIdx) {
        return;
    }
    console.log(`onMouseClickFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}, ${X}, ${Y}`);
    const obj = _mapManager.findLayerObject(ALyrIdx, ANmbr);
    if (!obj) {
        return;
    }
}

/**
 * 지도에 시설물 객체 정보를 그린다.
 */
function updateIcon() {
    // 기존 객체를 모두 삭제한다.
    _mapManager.removeLayerObject(_lyrIdx);

    // 시설물 객체를 지도에 그린다.
    const objs = new Array();
    console.log(_managerData);
    _managerData[0].forEach((obj) => {
        const item = new TFclt(obj.parkingid, obj.parkingname, obj.coordx, obj.coordy);
        objs.push(item);
    });

    _mapManager.initFcltObject(_lyrIdx, objs);
}
function selectFcltObject(ANmbr) {
    _mapManager.selectLayerObject(_lyrIdx, ANmbr);
}
function editFcltObject(ANmbr, AIsEdit) {
    _mapManager.editFcltObject(_lyrIdx, ANmbr, AIsEdit, AIsEdit ? "1" : "0");
}
function deleteFcltObject(ANmbr) {
    _mapManager.deleteFcltObject(_lyrIdx, ANmbr);
    _selectFcltNmbr = null;
}
function addFcltObject(ANmbr) {
    _mapManager.createFcltObject(_lyrIdx, ANmbr, "New", "New", "1" /*아이콘색결정,시설물유형_N.png*/ /*, x_crdn, y_crdn*/);
}

//x,y 좌표 변경 시 유효성 맞춰주는 이벤트
function crdnChanges(text, num){
    let value = text.value;
    const textBox = text.component
    if(!value || isNaN(value)) return setValue(textBox, '0.0000000');

    value = value.toString();

    if(value.length <= num) return setValue(textBox, value + ".0000000");

    if (!value.includes(".")){
        let front = value.substr(0, num);
        let end = value.substr(num, value.length);
        let zero = "";
        if (end.length < 7) {
            for (let ii = 0; ii < 7 - end.length; ii++) {
                zero += "0";
            }
        }
        if (end.length > 7) end = end.substring(0, 7);
        setValue(textBox, front + "." + end + zero);
    }
    else{
        switch (true) {
            case value.substring(0, value.indexOf(".")) === "":
                setValue(textBox, "0" + value);
                break;
            case value.substring(value.indexOf("."), value.length) === "":
                setValue(textBox, value + "0000000");
                break;
            case value.substring(value.indexOf("."), value.length).length < 7:
                let zero = "";
                for (let ii = 0; ii < 7 - value.substring(value.indexOf(".") + 1, value.length).length; ii++) {
                    zero += "0";
                }
                setValue(textBox, value.substring(0, value.indexOf(".")) + value.substring(value.indexOf("."), value.length) + zero);
                break;

            default:
                break;
        }
    }

}
