let userCnnsHsData  = [];
let userCnnsHsTable = null;
let searchBtn       = null;
let userCnnsHsUri   = '/api/history/user-cnns-hs';
let strtDateBox     = null;
let strtTimeBox     = null;
let endDateBox      = null;
let endTimeBox      = null;
let endDate         = new Date().setDate(new Date().getDate()-1);
let startDate       = new Date().setDate(new Date().getDate()-30);
const _pageName       = '운영자접속 이력';


$(()=>{

    //시작일시 년월일
    strtDateBox = $(".strt-date").dxDateBox({
        type                : 'date',
        value               : startDate,
        width               : '120px',
        height              : '25px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox("instance");
    
    //시작일시 시간
    strtTimeBox = $(".strt-time").dxDateBox({
        type                : 'time',
        value               : 1645110000000,
        width               : '90px',
        height              : '25px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox("instance");
    //종료일시 년월일
    endDateBox  = $(".end-date").dxDateBox({
        type                : 'date',
        value               : endDate,
        width               : '120px',
        height              : '25px',
        stylingMode         :'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox("instance");
    //종료일시 시간
    endTimeBox  = $(".end-time").dxDateBox({
        type                : 'time',
        width               : '90px',
        value               : 1645196399000,
        height              : '25px',
        stylingMode         :'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox("instance");

    //상단 조회 버튼
    searchBtn = $(".search-button").dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        fontSize:'16px',
        height:'80%',
        width: '80px',
        onClick(){
            
            let FROM_DT  = getDate(strtDateBox.option("value"), strtTimeBox.option("value"))
            let TO_DT    = getDate(endDateBox.option("value"), endTimeBox.option("value"))
            
            if(!validationCheck( strtDateBox, endDateBox, strtTimeBox, endTimeBox)) return false;
            
            if( FROM_DT > TO_DT ){
                alertWarning('검색 시작 시각이 검색 종료 시각보다 큽니다.', null, strtDateBox)
                return false;
            }
            
            let updateData = {
                FROM_DT: FROM_DT,
                TO_DT: TO_DT,
            }
            
            userCnnsHsData = [];
            //getData(userCnnsHsUri, userCnnsHsData, updateData);
            getDataAsync(userCnnsHsUri, (jsonData) => {
                userCnnsHsData = jsonData;
                userCnnsHsData.map((item)=>{
                    if(item.login_hms){
                        item.login_hms = getParseDateTime(item.login_hms);
                    }
                    if(item.logout_hms){
                        
                        item.logout_hms = getParseDateTime(item.logout_hms);
                    }
                })
                userCnnsHsTable.option("dataSource",userCnnsHsData);
                alertConfirm('데이터 조회가 완료 되었습니다. [' + userCnnsHsData.length + '건]')
            }, null, updateData);
        }
    }).dxButton("instance")
    
    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
    
    //운영자접속이력 테이블
    userCnnsHsTable = $(".user-cnns-hs-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : ['id','login_hms'],
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
           mode: 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'standard',
        },
        paging:{
            pageSize: 1000,
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export:{
            enabled: true,
            texts: {
                exportAll:"엑셀 파일",
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName);
        },
        columns:[
            {   
                dataField:"user_id",
                caption:"ID",
                alignment:"center",
                allowEditing: false,
                sortIndex: 0, 
                sortOrder: "asc",
            },
            {
                dataField:"login_hms",
                caption:"로그인 시각",
                alignment:"center",
            },
            {
                dataField:"logout_hms",
                caption:"로그아웃 시각",
                alignment:"center",
                cellTemplate(c,e){
                    if (!e.displayValue) {
                        c.text('-');
                    }
                    else {
                        c.text(e.displayValue);
                    }
                }
            },
            
        ],
    }).dxDataGrid("instance");
    
    
})