const _apiUri       = '/api/cctv/pset';
let _listTable      = null;
let _selectedVideo  = null;
let _listData       = null;
let _listMap        = new Map();
let _wcamIp         = null;
let _wcamCtrlBtn    = null;
let _presetMap      = new Map();
let _presetList     = null;
let _presetNmChange = null;
let _presetMove     = null;
let _presetDel      = null;
let _presetEdit     = null;
let _applyBtn       = null;
let _cancelBtn      = null;
let _cctvSped       = 40;
let _psetNmbr       = null;
let _cctvMngmNmbr   = null;
let _psetNm         = null;
let _modalText      = null;
let _defaultSped    = 40;
let _selectedList   = null;
const _userId       = window.opener.$userId;
let ctrlData = {
    action: null,
    command: null,
    speed: 0,
    user_id: _userId
};

let ctrlBtnColumns = [
    {
        position : 'zoom-in',
        command   : 'zoom-in',
    },
    {
        position : 'zoom-out',
        command   : 'zoom-out',
    },
    {
        position : 'focus-in',
        command   : 'focus-in',
    },
    {
        position : 'focus-out',
        command   : 'focus-out',
    },
    {
        position : 'left-btn',
        command   : 'pan-left',
    },
    {
        position : 'right-btn',
        command   : 'pan-right',
    },
    {
        position : 'up-btn',
        command   : 'tilt-up',
    },
    {
        position : 'down-btn',
        command   : 'tilt-down',
    },
]

btnArr = [
    cancleBtn = {
        class  : 'close-btn',
        box    : null,
        text   : '닫기',
        icon   : 'close',
        method : function(){
            window.close();
        }
    },

]

$(()=>{
    //모달 화면 설정
    $("body").append(modalDiv);
    $(".modal-title").prepend($("<div>프리셋 명칭</div>"));
    $(".modal-background").css("display",'none');
    $(".modal-content").append($("<div class='modal-content-title'>")
        .html("프리셋 명칭을 입력하십시오."),$("<div class='modal-text'>"));
    creatBtn($('.close-btn'), 'close', '닫기', '닫기', 'outlined', ()=>window.close())

    //CCTV 상태 전체조회 테이블
    _listTable = $(".stts-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        headerFilter: {
            visible: true,
        },
        selection  : {
            mode :'single'
        },
        keyExpr : 'cctv_mngm_nmbr',
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        selection : {
            mode  : 'single',
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
            {
                caption   : '제어기 정보',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "cctv_ctlr_id",
                        caption      : "CCTV ID",
                        alignment    : "center",
                        cssClass     : 'padding-ctrl',
                        sortIndex    : 0,
                        sortOrder    : "asc",
                    },
                    {
                        dataField    : "istl_lctn_nm",
                        caption      : "CCTV 명칭",
                        alignment    : "center",
                        cssClass     : 'padding-ctrl',
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
                ]
            },

            {
                caption   : '상태',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "cmnc_stts_desc",
                        cssClass     : 'padding-ctrl',
                        caption      : "통신",
                        alignment    : "center",
                    },
                ]
            },

        ],
        onRowClick(info){
            listTableClick(info);
        },
    }).dxDataGrid("instance");

    //프리셋 리스트
    _presetList = $('.preset-list').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        headerFilter: {
            visible: true,
        },
        selection  : {
            mode :'single'
        },
        keyExpr : ['pset_nmbr', 'cctv_mngm_nmbr'],
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        selection : {
            mode  : 'single',
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
            {
                caption   : '번호',
                alignment : 'center',
                dataField : 'pset_nmbr',
                cssClass  : 'padding-ctrl',
            },

            {
                caption   : '프리셋명칭',
                alignment : 'center',
                dataField : 'pset_nm',
                cssClass  : 'padding-ctrl',
                cellTemplate(c,e){
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },

        ],
        onRowClick(info){
            presetListClick(info);
        }
    }).dxDataGrid("instance");

    fetchBaseData();

    //CCTV 관리번호 텍스트 상자
    _cctvMngmNmbr = $('.cctv_mngm_nmbr').dxNumberBox({
        readOnly    : true,
        stylingMode : 'outlined',
        height      : 25,
        width       : 100,
        value       : null,
    }).dxNumberBox('instance');

    //프리셋 번호 텍스트 상자
    _psetNmbr = $('.pset_nmbr').dxNumberBox({
        stylingMode     : 'outlined',
        height          : 27,
        width           : 70,
        maxLength       : 100,
        showSpinButtons : true,
        readOnly        : true,
    }).dxNumberBox('instance');

    //프리셋명 텍스트 상자
    _psetNm  = $('.pset_nm').dxTextBox({
        stylingMode : 'outlined',
        height      : 27,
        width       : 140,
        readOnly    : true,
    }).dxTextBox('instance');

    //버튼 생성
    _presetNmChange = creatBtn($('.preset-nm-change'), null, '프리셋명 변경', '프리셋명 변경', 'outlined', presetNmChangeEvent, null, true, true);
    _presetMove     = creatBtn($('.preset-move'), null, '프리셋 이동', '프리셋 이동', 'outlined', presetMoveEvent, null, false, true);
    _presetEdit     = creatBtn($('.preset-edit'), null, '프리셋 설정', '프리셋 설정', 'outlined', presetEditEvent, null, false, true);
    _presetDel      = creatBtn($('.preset-del'), null, '프리셋 삭제', '프리셋 삭제', 'outlined', presetDelEvent, null, false, true);
    _applyBtn       = creatBtn($('.apply-btn'), null, '변경 확인', '변경 확인', 'outlined', presetNmChangeApplyEvent, null, false, false);
    _cancelBtn      = creatBtn($('.cancel-btn'), null, '변경 취소', '변경 취소', 'outlined', cancelEvent, null, false, false);
    _zoomInBtn      = creatBtn($('.zoom-in'), 'plus', 'z', 'zoom-in', 'outlined', null, 75, false, true, 40);
    _zoomOutBtn     = creatBtn($('.zoom-out'), 'minus', 'z', 'zoom-out', 'outlined', null, 75, false, true, 40);
    _focusInBtn     = creatBtn($('.focus-in'), 'plus', 'f', 'focus-in', 'outlined', null, 75, false, true, 40);
    _focusOutBtn    = creatBtn($('.focus-out'), 'minus', 'f', 'focus-out', 'outlined', null, 75, false, true, 40);
    creatBtn($('.modal-save-Btn'), 'check', '적용', '적용', 'outlined', modalSaveEvent, null, false, true);
    creatBtn($('.modal-cancle-Btn'), 'close', '취소', '취소', 'outlined', modalCancelEvent, null, false, true);
    creatBtn($('.modal-cancle'), 'close', null, '닫기', 'text', modalCancelEvent, null, false, true);

    //모달 텍스트 상자
    _modalText = $(".modal-text").dxTextBox({
        width       : 250,
        maxLength   : 100,
        stylingMode : 'outlined',
        onEnterKey(){
            modalSaveEvent();
        }
    }).dxTextBox("instance");


    //호버 색상 변경 막기
    _zoomInBtn.option('hoverStateEnabled',false);
    _zoomOutBtn.option('hoverStateEnabled',false);
    _focusInBtn.option('hoverStateEnabled',false);
    _focusOutBtn.option('hoverStateEnabled',false);
    _zoomInBtn.option('focusStateEnabled',false);
    _zoomOutBtn.option('focusStateEnabled',false);
    _focusInBtn.option('focusStateEnabled',false);
    _focusOutBtn.option('focusStateEnabled',false);

    $('.bar').on('mousedown', function(e){
        barMouseDown(e, this);
    });

    $('.bar').on('mouseup',function(){
        $(this).off('mousemove');
    });

    ctrlBtnColumns.map((item)=>{
        $('.' + item.position).on('mousedown',function(e){
            e.preventDefault();
            controlMouseDn(this, item.command);
        })
        $('.' + item.position).on('mouseup',function(e){
            e.preventDefault();
            controlMouseUp(this, item.command);
        })
    })

});

/**
 * 속도 바 mousedown 함수
 * @param {*} target : this 객체
 * @param {*} e : event 객체
 * @returns
 */
function barMouseDown(e, target){
    let children = $(target).children();
    let left0 = children.eq(0)[0].getBoundingClientRect().left;
    let left1 = children.eq(1)[0].getBoundingClientRect().left;
    let left2 = children.eq(2)[0].getBoundingClientRect().left;
    let left3 = children.eq(3)[0].getBoundingClientRect().left;
    let left4 = children.eq(4)[0].getBoundingClientRect().left;
    let left5 = children.eq(5)[0].getBoundingClientRect().left;
    let left6 = children.eq(6)[0].getBoundingClientRect().left;

    progressBarEvent(e, target);

    $(target).on('mousemove',function(e){
        let x = e.clientX;
        if ( left0 < x && x < left1){
            speedControl(target, 0);
        }
        else if ( left1 < x && x < left2 ){
            speedControl(target, 1);
        }
        else if( left2 < x && x < left3){
            speedControl(target, 2);
        }
        else if( left3 < x && x < left4){
            speedControl(target, 3);
        }
        else if( left4 < x && x < left5){
            speedControl(target, 4);
        }
        else if( left5 < x && x < left6){
            speedControl(target, 5);
        }
        else if( left6 < x ){
            speedControl(target, 6);
        }
    })
}

/**
 * 속도 바 css변경 함수
 * @param {*} target : this 객체
 * @param {*} index : children Index
 * @returns
 */
function speedControl(target, index){
    if ($(target).children().eq(index).css('background-color') === 'rgb(3, 169, 244)' && $(target).children().eq(index + 1).css('background-color') !== 'rgb(3, 169, 244)') return false;
    for (let ii = 0; ii < 7; ii++){
        if (  ii <= index ){
            $(target).children().eq(ii).css('background-color', 'rgb(3, 169, 244)');
        }
        else {
            $(target).children().eq(ii).css('background-color', '#363640');
        }
    }
    _cctvSped = index * 10;
}
/**
 * CCTV 정보 및 프리셋 정보 데이터 세팅 함수
 * @returns
 */
function fetchBaseData(){
    let listData   = [];
    let sttsData   = [];
    let presetData = [];
    getData('/api/cctv/common/cctv-list', listData);
    getData('/api/cctv/monitoring/stts', sttsData);
    getData('/api/cctv/pset', presetData);

    if(listData.length > 0 && sttsData.length > 0 && presetData.length > 0){

        listData[0].map((item)=>{
            if(item.last_crct_dt)item.last_crct_dt = getParseDateTime(item.last_crct_dt);
            _listMap.set(item.cctv_mngm_nmbr, item);
        });

        sttsData[0].map((item)=>{
            let data = {..._listMap.get(item.cctv_mngm_nmbr)};
            data.cbox_door_stts_cd   = item.cbox_door_stts_cd
            data.cbox_door_stts_desc = item.cbox_door_stts_desc
            data.cbox_hmdt           = item.cbox_hmdt
            data.cbox_tmpr           = item.cbox_tmpr
            data.cmnc_stts_cd        = item.cmnc_stts_cd
            data.cmnc_stts_desc      = item.cmnc_stts_desc
            data.coll_cnt            = item.coll_cnt
            data.fan_stts_cd         = item.fan_stts_cd
            data.fan_stts_desc       = item.fan_stts_desc
            data.hetr_stts_cd        = item.hetr_stts_cd
            data.hetr_stts_desc      = item.hetr_stts_desc
            data.istl_lctn_nm        = item.istl_lctn_nm
            data.miss_stts_yn        = item.miss_stts_yn
            data.nmbr                = item.nmbr
            _listMap.set(item.cctv_mngm_nmbr, data);
        });

        presetData[0].map((item)=>{
            if(!_presetMap.get(item.cctv_mngm_nmbr)){
                _presetMap.set(item.cctv_mngm_nmbr, new Array());
            }
            _presetMap.get(item.cctv_mngm_nmbr).push(item);
        });
        _listTable.option('dataSource', Array.from(_listMap.values()));
    }


};

/**
 * CCTV 목록 클릭 함수
 * @returns
 */
function listTableClick(info){
    let selectedData = info.data;

    $('.cctv-name').text('['+selectedData.cctv_ctlr_id+'] - '+selectedData.istl_lctn_nm);

    if (!_selectedList) {
        _selectedList = selectedData;
    }
    else if (_selectedList === selectedData) {
        return;
    }
    else {
        _selectedList = selectedData
    }

    _presetList.option('dataSource', _presetMap.get(selectedData.cctv_mngm_nmbr));
    if (!_selectedVideo){
        _selectedVideo = videojs('video', {
                sources  : [
                    { src : selectedData.strm_http_addr, type : "application/x-mpegURL"}
                ],
                controls : true,
                playsinline : true,
                muted : true,
                autoplay: true,
                preload : "none",
                controlBar: {
                    'liveDisplay': false,
                    'pictureInPictureToggle': false
                }
            }
        );
    }

    _selectedVideo.src([
        {
            src: selectedData.strm_http_addr,
        }
    ]);
    _selectedVideo.play();

    _presetList.option('focusedRowIndex', -1);
    _presetList.clearSelection();
    setValue(_psetNm, null);
    setValue(_psetNmbr, null);
    dsblOnBtn(_presetNmChange);
    setValue(_cctvMngmNmbr, selectedData.cctv_mngm_nmbr);
}

/**
 * 프리셋 목록 클릭 함수
 * @returns
 */
function presetListClick(info){
    let selectedData = info.data;
    setValue(_psetNm, selectedData.pset_nm);
    setValue(_psetNmbr, selectedData.pset_nmbr);
    dsblOffBtn(_presetNmChange);
}

/**
 * 프리셋명 변경 저장 함수
 * @returns
 */
function presetNmChangeApplyEvent(){
    let pset_nm         = getValue(_psetNm);
    let pset_nmbr       = getValue(_psetNmbr);
    let cctv_mngm_nmbr  = getValue(_cctvMngmNmbr);
    if (!pset_nm) {
        return alertWarning('프리셋명을 입력해주세요.', null, _psetNm);
    }
    else if (getByteLength(pset_nm) > 100) {
        return alertWarning('프리셋명을 100 바이트 이내로 입력해주세요.', null, _psetNm);
    }

    let presetData = [..._presetMap.get(cctv_mngm_nmbr)];
    let updateData = null;
    _listMap.get(cctv_mngm_nmbr)

    presetData.map((item)=>{
        if(item.pset_nmbr === pset_nmbr) {
            item.pset_nm = pset_nm;
            updateData = item;
            if (!item.dflt_yn) {
                item.dflt_yn = 'N';
            }
        }
    });

    let result = putUpdate(_apiUri + '/' + encodeURIComponent(cctv_mngm_nmbr), updateData);
    if (result > 0){
        insResultMsg('프리셋명');
        _presetMap.set(cctv_mngm_nmbr, presetData);
        _presetList.option('dataSource', _presetMap.get(cctv_mngm_nmbr));
        cancelEvent();
        return;
    }
}

/**
 * 프리셋 이동 함수
 * @returns
 */
function presetMoveEvent(){
    let pset_nm         = getValue(_psetNm);
    let pset_nmbr       = getValue(_psetNmbr);
    let cctv_mngm_nmbr  = getValue(_cctvMngmNmbr);
    if(!pset_nm){
        alertWarning('프리셋을 선택해주세요. 삭제된 프리셋은 선택할 수 없습니다.');
        return;
    }

    let ctrlPsetData = getCtrlPsetData('call', 'call', pset_nm, pset_nmbr, _cctvSped);
    getPostDataAsync('/api/cctv/control/preset/' + cctv_mngm_nmbr, (jsonData)=>{
        if (jsonData) {
            if (jsonData.error) {
                alertWarning(jsonData.message);
            }
            else {
                alertConfirm(jsonData.message);
            }
        }
    }, ctrlPsetData);
}

/**
 * 프리셋 설정 시 모달 저장 함수
 * @returns
 */
function modalSaveEvent(){
    let pset_nm         = getValue(_modalText);
    let pset_nmbr       = getValue(_psetNmbr);
    let cctv_mngm_nmbr  = getValue(_cctvMngmNmbr);

    if (!pset_nm){
        return alertWarning('프리셋 명칭을 입력해주세요.', null, _modalText);
    }
    else if (getByteLength(pset_nm) > 100) {
        return alertWarning('프리셋 명칭을 100 바이트 이내로 입력해주세요.', null, _modalText);
    }

    confirmMessage('프리셋을 설정하시겠습니까?').done((yes)=>{
        if (yes === true) {
            let ctrlPsetData = getCtrlPsetData('save', 'save', pset_nm, pset_nmbr, _defaultSped);
            modalCancelEvent();
            getPostDataAsync('/api/cctv/control/preset/' + cctv_mngm_nmbr, (jsonData)=>{
                if (jsonData) {
                    if (jsonData.error) {
                        alertWarning(jsonData.message);
                    }
                    else {
                        alertConfirm(jsonData.message);
                        let presetData = [..._presetMap.get(cctv_mngm_nmbr)];
                        let updateData = null;
                        _listMap.get(cctv_mngm_nmbr)

                        presetData.map((item)=>{
                            if (item.pset_nmbr === pset_nmbr) {
                                item.pset_nm = pset_nm;
                                item.dflt_yn = 'N';
                                updateData = item;
                            }
                        });

                        let result = putUpdate(_apiUri + '/' + encodeURIComponent(cctv_mngm_nmbr), updateData);
                        if (result > 0){
                            _presetMap.set(cctv_mngm_nmbr, presetData);
                            _presetList.option('dataSource', _presetMap.get(cctv_mngm_nmbr));
                            cancelEvent();
                        }
                    }
                }
            }, ctrlPsetData);
        }
    })
}

/**
 * 프리셋 설정 시 모달 취소 함수
 * @returns
 */
function modalCancelEvent(){
    $(".modal-background").css("display",'none');
}

/**
 * 프리셋 설정 함수
 * @returns
 */
function presetEditEvent(){
    let selectedData = _presetList.getSelectedRowsData();
    if (selectedData.length <= 0) return alertWarning('프리셋을 설정할 CCTV를 선택하십시오.');
    setValue(_modalText, '');
    $(".modal-background").css("display",'flex');
    _modalText.focus();
}

/**
 * 프리셋 이름 변경 함수
 * @returns
 */
function presetNmChangeEvent(){
    showBtn(_applyBtn);
    showBtn(_cancelBtn);
    hideBtn(_presetNmChange);
    hideBtn(_presetMove    );
    hideBtn(_presetEdit    );
    hideBtn(_presetDel     );
    _psetNm.option('readOnly', false);
}

/**
 * 프리셋 변경 취소 함수
 * @returns
 */
function cancelEvent(){
    hideBtn(_applyBtn);
    hideBtn(_cancelBtn);
    showBtn(_presetNmChange);
    showBtn(_presetMove    );
    showBtn(_presetEdit    );
    showBtn(_presetDel     );
    _psetNm.option('readOnly', true);
    setValue(_psetNm, _presetList.getSelectedRowsData()[0].pset_nm);
}

/**
 * 프리셋 삭제 함수
 * @returns
 */
function presetDelEvent(){
    let selectedData = _presetList.getSelectedRowsData();
    if(selectedData.length <= 0) return alertWarning('프리셋을 삭제할 CCTV를 선택하십시오.');

    let pset_nm         = getValue(_psetNm);
    let pset_nmbr       = getValue(_psetNmbr);
    let cctv_mngm_nmbr  = getValue(_cctvMngmNmbr);

    let ctrlPsetData = getCtrlPsetData('delete', 'delete', pset_nm, pset_nmbr, _defaultSped);
    getPostDataAsync('/api/cctv/control/preset/' + cctv_mngm_nmbr, (jsonData)=>{
        if (jsonData.error) {
            alertWarning(jsonData.message);
        }
        else {
            alertConfirm(jsonData.message);
            let cctvMngmNmbr = selectedData[0].cctv_mngm_nmbr;
            let psetNmbr     = selectedData[0].pset_nmbr;
            let result = deleteData(_apiUri, cctvMngmNmbr + '/' + psetNmbr);

            if (result > 0) {
                let presetData = _presetMap.get(selectedData[0].cctv_mngm_nmbr);
                presetData.map(obj => {
                    if (obj.pset_nmbr === pset_nmbr){
                        obj.dflt_yn   = "N";
                        obj.focs_val  = 0;
                        obj.pan_val   = 0;
                        obj.tilt_val  = 0;
                        obj.zoom_val  = 0;
                        obj.pset_nm   = null;
                    }
                });
                _presetMap.set(selectedData[0].cctv_mngm_nmbr, presetData);
                _presetList.option('dataSource', _presetMap.get(selectedData[0].cctv_mngm_nmbr));
            }
        }
    }, ctrlPsetData);
}

/**
 * 속도 바 변경 함수
 * @param {*} e : 이벤트 객체
 * @param {*} bar : bar 객체
 * @returns
 */
function progressBarEvent(e, bar){
    let x = e.clientX;
    let paintDiv = null;
    let paintIdx = null;

    for(let ii = 0 ; ii < $(bar).children().length ; ii++){
        let children = $(bar).children().eq(ii);
        if( $(children).css('background-color') === 'rgb(3, 169, 244)' ){
            paintDiv = $(children);
            paintIdx = ii;
        }
    }

    if (paintIdx === 6) {
        if(paintDiv[0].getBoundingClientRect().left > x){
            paintDiv.css('background-color', '#363640');
            _cctvSped = $(bar).children().eq(paintIdx - 1).text();
        }
    }
    else {
        if (paintDiv[0].getBoundingClientRect().right < x){
            $(bar).children().eq(paintIdx + 1).css('background-color','rgb(3, 169, 244)');
            _cctvSped = $(bar).children().eq(paintIdx + 1).text();
        }
        else if( paintIdx > 0 && paintDiv[0].getBoundingClientRect().left > x){
            paintDiv.css('background-color', '#363640');
            _cctvSped = $(bar).children().eq(paintIdx - 1).text();
        }
    }
};

/**
 * CCTV 제어 명령 함수(공통)
 * @param {*} upBtn : 클릭 다운 버튼
 * @param {*} command : 제어 명령
 * @returns
 */
function controlMouseUp(upBtn, command){
    let cctv_mngm_nmbr = getValue(_cctvMngmNmbr);
    if(!cctv_mngm_nmbr && cctv_mngm_nmbr !== 0) return alertWarning('제어하실 CCTV를 선택해주세요', null, _cctvMngmNmbr);
    mouseUpCss($(upBtn));
    stopCommand(command, _cctvSped, cctv_mngm_nmbr);
}

/**
 * CCTV 제어 명령 함수(공통)
 * @param {*} downBtn : 클릭 다운 버튼
 * @param {*} command : 제어 명령
 * @returns
 */
function controlMouseDn(downBtn, command){
    let cctv_mngm_nmbr = getValue(_cctvMngmNmbr);
    if(!cctv_mngm_nmbr && cctv_mngm_nmbr !== 0) return alertWarning('제어하실 CCTV를 선택해주세요', null, _cctvMngmNmbr);
    mouseDnCss($(downBtn));
    startCommand(command, _cctvSped, cctv_mngm_nmbr);
}

/**
 * CCTV 제어 마우스다운 css 함수(공통)
 * @param {*} position : 버튼 위치
 * @returns
 */
function mouseDnCss(position){
    position.css('box-shadow','0px 0px rgba(0,0,0,0.2)');
    position.css('background-color','#424247');
}

/**
 * CCTV 제어 마우스업 css 함수(공통)
 * @param {*} position : 버튼 위치
 * @returns
 */
function mouseUpCss(position){
    position.css('box-shadow','2px 5px rgba(0,0,0,0.2)')
    position.css('background-color','#363640')
}

/**
 * CCTV 제어 마우스다운 함수(공통)
 * @param {*} command : 제어 명령
 * @param {*} speed : CCTV 이동 속도
 * @param {*} cctv_mngm_nmbr : CCTV 관리 번호
 * @returns
 */
function startCommand(command, speed, cctv_mngm_nmbr){
    ctrlData.action = "start";
    ctrlData.command = command;
    ctrlData.speed = speed;
    ctrlData.user_id = _userId;
    getPostDataAsync('/api/cctv/control/ptz/'+ cctv_mngm_nmbr, (rec)=>{
        console.log(rec);
    }, ctrlData, true);
}

/**
 * CCTV 제어 마우스업 함수(공통)
 * @param {*} command : 제어 명령
 * @param {*} speed : CCTV 이동 속도
 * @param {*} cctv_mngm_nmbr : CCTV 관리 번호
 * @returns
 */
function stopCommand(command, speed, cctv_mngm_nmbr){
    ctrlData.action = 'stop';
    ctrlData.command = command;
    ctrlData.speed = speed;
    ctrlData.user_id = _userId;
    getPostDataAsync('/api/cctv/control/ptz/'+ cctv_mngm_nmbr, (rec) => {
        console.log(rec);
    }, ctrlData, true);
}

/**
 *
 *
 */
function getCtrlPsetData(action, command, name, no, speed){
    let presetData = {
        action  : action,
        command : command,
        name    : name,
        no      : no,
        speed   : speed,
        time    : 0,
        user_id : _userId,
    };
    return presetData;
}