const _apiUri      = '/api/vms/control';
let _listTable     = null;
let _selectedVideo = null;
let _listData      = null;
let _listMap       = new Map();
let _wcamIp        = null;
let _wcamCtrlBtn   = null;
const _userId      = window.opener.$userId;
let _selectedId    = null;

$(()=>{

    creatBtn($('.close-btn'), null, '닫기', '닫기', 'outlined', () => window.close());
    //VMS 전체조회 테이블
    _listTable = $(".stts-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        // headerFilter: {
        //     visible: true,
        // },
        keyExpr : 'vms_ctlr_nmbr',
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        selection : {
            mode                : 'multiple',
            showCheckBoxesMode  : "onClick"
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
            {
                caption   : 'VMS 정보',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "vms_ctlr_nmbr",
                        caption      : "VMS 번호",
                        alignment    : "center",
                        visible      : false,
                        sortIndex    : 0,
                        sortOrder    : "asc",
                        width        : 130,
                    },
                    {
                        dataField    : "vms_ctlr_id",
                        caption      : "VMS ID",
                        alignment    : "center",
                    },
                    {
                        dataField    : "vms_nm",
                        caption      : "VMS 명칭",
                        alignment    : "center",
                        width        : 130,
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
                    {
                        dataField    : "vms_usag_type_desc",
                        caption      : "유형",
                        alignment    : "center",
                        width        : 90,
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
                    {
                        dataField    : "oper_mode_desc",
                        caption      : "운영모드",
                        alignment    : "center",
                        width        : 80,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let val = e.displayValue;
                            let classNm = '';
                            if ( val === '자동' ){
                                classNm = 'green';
                            }
                            else if (val === '고정'){
                                classNm = 'red';
                            }
                            else {
                                classNm = 'yellow';
                            }
                            const div = $('<div class='+classNm+'>')
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                ]
            },

            {
                caption   : '통신',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "cmnc_stts_desc",
                        caption      : "통신",
                        alignment    : "center",
                        width        : 80,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.cmnc_stts_cd;
                            if (!e.data.cmnc_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+e.data.cmnc_stts_cd+'>')
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                ]
            },
            {
                caption   : '모듈',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "modl_stts_desc",
                        caption      : "모듈상태",
                        alignment    : "center",
                        width        : 80,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.modl_stts_cd;
                            if(!e.data.modl_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "pwer_stts_desc",
                        caption      : "전원상태",
                        alignment    : "center",
                        width        : 80,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.pwer_stts_cd;
                            if(!e.data.pwer_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>')
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "brgh_val",
                        caption      : "화면휘도",
                        alignment    : "center",
                        width        : 80,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let val = e.displayValue;
                            let classNm = '';
                            if (!e.displayValue) {
                                val = '-';
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>')
                            div.text(val);
                            return c.append(div);
                        }
                    },
                ]
            },
            {
                caption   : '함체',
                alignment : 'center',
                cssClass     : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "cbox_door_stts_desc",
                        caption      : "도어",
                        alignment    : "center",
                        width        : 80,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.cbox_door_stts_cd;
                            if(!e.data.cbox_door_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "fan_stts_desc",
                        caption      : "팬상태",
                        alignment    : "center",
                        width        : 80,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.fan_stts_cd;
                            if(!e.data.fan_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "hetr_stts_desc",
                        caption      : "히터상태",
                        alignment    : "center",
                        width        : 80,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = e.data.hetr_stts_cd;
                            if(!e.data.hetr_stts_cd){
                                classNm = 'gray'
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                    {
                        dataField    : "cbox_tmpr",
                        caption      : "온도",
                        alignment    : "center",
                        width        : 80,
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            let classNm = '';
                            let text = e.data.cbox_tmpr;
                            if(text === null || text === 255){
                                classNm = 'gray'
                                text = '-'
                            }
                            const div = $('<div class='+classNm+'>');
                            div.text(text);
                            return c.append(div);
                        }
                    },
                ]
            },
            {
                caption   : '함체환경설정정보',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "vms_cmnc_err_bass_val",
                        caption      : "모듈정지온도",
                        width        : 80,
                        alignment    : "center",
                    },
                    {
                        dataField    : "fan_mtns_tmpr",
                        caption      : "팬동작온도",
                        width        : 80,
                        alignment    : "center",
                    },
                    {
                        dataField    : "hetr_mtns_tmpr",
                        caption      : "히터동작온도",
                        width        : 80,
                        alignment    : "center",
                    },
                    {
                        dataField    : "vms_modl_err_rate",
                        caption      : "모듈장애율",
                        width        : 80,
                        alignment    : "center",
                    },
                ]
            },
            {
                caption   : '젠광판',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "panl_on_time",
                        caption      : "ON",
                        width        : 80,
                        alignment    : "center",
                    },
                    {
                        dataField    : "panl_off_time",
                        caption      : "OFF",
                        width        : 80,
                        alignment    : "center",
                    },
                ]
            },

        ],
        onRowClick(info){
            listTableDblClick(info);
        },
        // onRowDblClick(info){
        //    listTableDblClick(info);
        // },
    }).dxDataGrid("instance");

    _tabs = $(".tabs").width('100%').height('100%').dxTabPanel({
        dataSource       : null,
        selectIndex      : 0,
        loop             : false,
        animationEnabled : true,
        swipeEnabled     : false,
        noDataText       : '표출할 정보가 없습니다.',
        itemTitleTemplate: function(e){
            return $('<div style="height:29px; line-height:29px;">'+e.name+'</div>')
        },
        itemTemplate: function(e, idx, c){
            c.css('display', 'flex');
            c.append(e.div);
            return c;
        },
        onSelectionChanged(e){
            //이전 탭
            const removeTab = e.removedItems[0];
            //현재 탭
            const selectedTab = e.addedItems[0];

        },
    }).dxTabPanel('instance');

    fetchBaseData();
    _wcamCtrlBtn = creatBtn($('.wcam_ctrl_btn'), 'preferences', '웹카메라 제어', '웹카메라 제어', 'outlined', wcamCtlrClick, null, true, true);
});

function fetchBaseData(){
    let data = [];
    let baseData = [];
    getData('/api/vms/monitoring/stts', data);
    getData('/api/vms/manager/info', baseData);
    if(data.length > 0){

        data[0].map((item)=>{
            if(item.updt_dt)item.updt_dt = getParseDateTime(item.updt_dt);
            item.auto = item.auto_used + '/' + item.auto_total;
            item.basic = item.basic_used + '/' + item.basic_total;
            item.fixed = item.fixed_used + '/' + item.fixed_total;
            _listMap.set(item.vms_ctlr_nmbr, item);
        });

        baseData[0].map((item)=>{
            if(_listMap.get(item.vms_ctlr_nmbr)){
                let listData = {..._listMap.get(item.vms_ctlr_nmbr)}
                listData.web_cmra_ip =  item.web_cmra_ip;
                listData.web_cmra_port =  item.web_cmra_port;
                _listMap.set(item.vms_ctlr_nmbr, listData);
            }
        });
        let listData = Array.from(_listMap.values());
        _listTable.option('dataSource', listData);
    }

    let controlArr = controlDiv();
    let operArr    = operDiv();
    let doorArr    = cBoxDiv();
    let onOffArr   = onOffDiv();
    let dataSource = [];
    dataSource.push(controlArr);
    dataSource.push(operArr);
    dataSource.push(doorArr);
    dataSource.push(onOffArr);
    _tabs.option('dataSource', dataSource);
};

function controlDiv(){
    const div = $('<div class="control-div">');
    div.html(`
        <div>
            <div>
            </div>
        </div>
        <div>
            <div>
            </div>
        </div>
        <div>
            <div>
            </div>
        </div>
        <div>
            <div>
                <div></div>
            </div>
            <div>
                <div></div>
            </div>
            <div>( 0-자동,&nbsp; 1-주간,&nbsp; 2-야간,&nbsp; 3 ~ 100-수동 )</div>
        </div>
        <div>
            <div></div>
        </div>
    `);

    const onCheck     = div.children().eq(0).children().eq(0);
    const offCheck    = div.children().eq(1).children().eq(0);
    const resetCheck  = div.children().eq(2).children().eq(0);
    const brightCheck = div.children().eq(3).children().eq(0).children().eq(0);
    const brightNum   = div.children().eq(3).children().eq(1).children().eq(0);
    const ctlrBtn     = div.children().eq(4).children().eq(0);
    //체크박스 상자 옵션
    const checkColumns = [
        {
            position : onCheck,
            text     : '전광판 ON',
            alert    : 'VMS 전광판 전원 ON',
            uri      : '/power/',
            val      : '0',
            box      : null,
        },
        {
            position : offCheck,
            text     : '전광판 OFF',
            alert    : 'VMS 전광판 전원 OFF',
            uri      : '/power/',
            val      : '1',
            box      : null,

        },
        {
            position : resetCheck,
            text     : '제어기 리셋',
            alert    : 'VMS 제어기 리셋',
            uri      : '/reset/',
            val      : '0',
            box      :  null,
        },
        {
            position : brightCheck,
            text     : '휘도 제어',
            alert    : 'VMS 휘도값 제어',
            uri      : '/luminance/',
            val      : null,
            box      :  null,
        },
    ];

    checkColumns.map((item)=>{
        item.box = item.position.dxCheckBox({
            stylingMode : 'outlined',
            text        : item.text,
            width       : 100,
        }).dxCheckBox('instance');
    });

    let numberBox = brightNum.dxNumberBox({
        stylingMode     : 'outlined',
        value           : 0,
        min             : 0,
        max             : 100,
        width           : 80,
        readOnly        : true,
        showSpinButtons : true,
    }).dxNumberBox('instance');

    numberBox.on('valueChanged',(e)=>{
        if(!e.value) setValue(e.component, 0);
    })
    //체크 박스 꺼짐 방지 이벤트
    $(onCheck).on('click',()=>{
        if(!getValue(checkColumns[0].box)) setValue(checkColumns[0].box, true);
    });
    $(offCheck).on('click',()=>{
        if(!getValue(checkColumns[1].box))setValue(checkColumns[1].box, true);
    });
    $(resetCheck ).on('click',()=>{
        if(!getValue(checkColumns[2].box))setValue(checkColumns[2].box, true);
    });
    $(brightCheck ).on('click',()=>{
        if(!getValue(checkColumns[3].box))setValue(checkColumns[3].box, true);
    });

    //체크박스 처음 값 세팅
    setValue(checkColumns[0].box, true);

    //체크박스 선택시 나머지 체크 박스 값 초기화
    checkColumns[0].box.on('valueChanged',(e)=>{
        if (getValue(checkColumns[1].box)) setValue(checkColumns[1].box, !e.value);
        if (getValue(checkColumns[2].box)) setValue(checkColumns[2].box, !e.value);
        if (getValue(checkColumns[3].box)) setValue(checkColumns[3].box, !e.value);
        if (!numberBox.option('readOnly'))numberBox.option('readOnly',true);
    });
    checkColumns[1].box.on('valueChanged',(e)=>{
        if (getValue(checkColumns[0].box)) setValue(checkColumns[0].box, !e.value);
        if (getValue(checkColumns[2].box)) setValue(checkColumns[2].box, !e.value);
        if (getValue(checkColumns[3].box)) setValue(checkColumns[3].box, !e.value);
        if (!numberBox.option('readOnly'))numberBox.option('readOnly',true);
    });
    checkColumns[2].box.on('valueChanged',(e)=>{
        if (getValue(checkColumns[0].box)) setValue(checkColumns[0].box, !e.value);
        if (getValue(checkColumns[1].box)) setValue(checkColumns[1].box, !e.value);
        if (getValue(checkColumns[3].box)) setValue(checkColumns[3].box, !e.value);
        if (!numberBox.option('readOnly'))numberBox.option('readOnly',true);
    });
    checkColumns[3].box.on('valueChanged',(e)=>{
        if (getValue(checkColumns[0].box)) setValue(checkColumns[0].box, !e.value);
        if (getValue(checkColumns[1].box)) setValue(checkColumns[1].box, !e.value);
        if (getValue(checkColumns[2].box)) setValue(checkColumns[2].box, !e.value);
        numberBox.option('readOnly', false);
    });

    let btn = creatBtn(ctlrBtn, 'preferences', '제어기명령전송', '제어기명령전송', 'outlined', crlrBtnClick, null, false, true);

    let dataSource = {
        name      : '전광판/제어기 제어',
        div       : div,
        check     : checkColumns,
        btn       : btn,
        num       : numberBox,
    }
    return dataSource;
};

function operDiv(){
    const div = $('<div class="oper-div">');
    div.html(`
        <div>
            <div>
            </div>
        </div>
        <div>
            <div>
            </div>
        </div>
        <div>
            <div>
            </div>
        </div>
        <div>
            <div></div>
        </div>
    `);

    const autoOper      = div.children().eq(0).children().eq(0);
    const fixedOper     = div.children().eq(1).children().eq(0);
    const defaultOper   = div.children().eq(2).children().eq(0);
    const operChangeBtn = div.children().eq(3).children().eq(0);
    //체크박스 상자 옵션
    const checkColumns = [
        {
            position        : autoOper,
            text            : '자동 운영모드 (자동 스케줄에 등록되어 있는 메시지를 표출 합니다.)',
            box             : null,
            uri             : '/opr-mode/',
            val             : 'A',
            oper_mode_desc  : '자동',
        },
        {
            position        : fixedOper,
            text            : '고정 운영모드 (고정 스케줄에 등록되어 있는 메시지를 표출 합니다.)',
            box             : null,
            uri             : '/opr-mode/',
            val             : 'F',
            oper_mode_desc  : '고정',
        },
        {
            position        : defaultOper,
            text            : '기본 운영모드 (기본 스케줄에 등록되어 있는 메시지를 표출 합니다.)',
            box             :  null,
            uri             : '/opr-mode/',
            val             : 'B',
            oper_mode_desc  : '기본',
        },
    ];

    checkColumns.map((item)=>{
        item.box = item.position.dxCheckBox({
            stylingMode : 'outlined',
            text        : item.text,
        }).dxCheckBox('instance');
    });

    //체크 박스 꺼짐 방지 이벤트
    $(autoOper).on('click',()=>{
        if(!getValue(checkColumns[0].box)) setValue(checkColumns[0].box, true);
    });
    $(fixedOper).on('click',()=>{
        if(!getValue(checkColumns[1].box))setValue(checkColumns[1].box, true);
    });
    $(defaultOper ).on('click',()=>{
        if(!getValue(checkColumns[2].box))setValue(checkColumns[2].box, true);
    });

    //체크박스 처음 값 세팅
    setValue(checkColumns[0].box, true);

    //체크박스 선택시 나머지 체크 박스 값 초기화
    checkColumns[0].box.on('valueChanged',(e)=>{
        if (getValue(checkColumns[1].box)) setValue(checkColumns[1].box, !e.value);
        if (getValue(checkColumns[2].box)) setValue(checkColumns[2].box, !e.value);
    });
    checkColumns[1].box.on('valueChanged',(e)=>{
        if (getValue(checkColumns[0].box)) setValue(checkColumns[0].box, !e.value);
        if (getValue(checkColumns[2].box)) setValue(checkColumns[2].box, !e.value);
    });
    checkColumns[2].box.on('valueChanged',(e)=>{
        if (getValue(checkColumns[0].box)) setValue(checkColumns[0].box, !e.value);
        if (getValue(checkColumns[1].box)) setValue(checkColumns[1].box, !e.value);
    });

    let btn = creatBtn(operChangeBtn, 'preferences', '운영모드변경', '운영모드변경', 'outlined', operChangeBtnClick, null, false, true);
    let dataSource = {
        name      : '운영모드 변경',
        div       : div,
        check     : checkColumns,
        btn       : btn,
    };

    return dataSource;
};

function cBoxDiv(){
    const div = $('<div class="cbox-div">');
    div.html(`
        <div>
            <div class='label'>모듈정지온도</div>
            <div>
                <div></div>
            </div>
            <div>(모듈전원Off 온도)</div>
        </div>
        <div>
            <div class='label'>팬동작온도</div>
            <div>
                <div></div>
            </div>
            <div>(Fan동작 기준온도)</div>
        </div>
        <div>
            <div class='label'>히터동작온도</div>
            <div>
                <div></div>
            </div>
            <div>(Heartr동작 기준온도)</div>
        </div>
        <div>
            <div class='label'>모듈장애율</div>
            <div>
                <div></div>
            </div>
            <div>(모듈장애판단울 - %)</div>
        </div>
        <div>
            <div></div>
        </div>
    `);

    const moduelStopTemp = div.children().eq(0).children().eq(1).children().eq(0);
    const fanTemp        = div.children().eq(1).children().eq(1).children().eq(0);
    const hearterTemp    = div.children().eq(2).children().eq(1).children().eq(0);
    const moduleError    = div.children().eq(3).children().eq(1).children().eq(0);
    const doorEditBtn    = div.children().eq(4).children().eq(0);
    //체크박스 상자 옵션
    const numberColumns = [
        {
            position     : moduelStopTemp,
            column       : 'vms_cmnc_err_bass_val',
            updateColumn : 'module_temp',
            text         : '모듈정지온도',
            box          : null,
            max          : 255,
            value        : 127,
        },
        {
            position     : fanTemp,
            column       : 'fan_mtns_tmpr',
            updateColumn : 'fan_temp',
            text         : '팬동작온도',
            box          : null,
            max          : 255,
            value        : 35,
        },
        {
            position     : hearterTemp,
            column       : 'hetr_mtns_tmpr',
            updateColumn : 'heater_temp',
            text         : '히터동작온도',
            box          : null,
            max          : 255,
            value        : 0,
        },
        {
            position     : moduleError,
            column       : 'vms_modl_err_rate',
            updateColumn : 'module_fail',
            text         : '모듈장애율',
            box          : null,
            max          : 100,
            value        : 10,
        },
    ];

    numberColumns.map((item)=>{
        item.box = item.position.dxNumberBox({
            stylingMode     : 'outlined',
            value           : 0,
            min             : 0,
            max             : item.max,
            width           : 80,
            showSpinButtons : true,
        }).dxNumberBox('instance');
        item.box.on('valueChanged',(e)=>{
            if(!e.value) setValue(item.box, 0);
        })
    });

    let btn = creatBtn(doorEditBtn, 'preferences', '함체환경설정', '함체환경설정', 'outlined', cBoxEditBtnClick, null, false, true);
    let dataSource = {
        name      : 'VMS 함체환경 설정',
        div       : div,
        num       : numberColumns,
        btn       : btn,
    }

    return dataSource;
};

function onOffDiv(){
    const div = $('<div class="on-off-div">');
    div.html(`
        <div>
            <div class='label'>전원 ON 시각</div>
            <div>
                <div></div>
            </div>
        </div>
        <div>
            <div class='label'>전원 OFF 시각</div>
            <div>
                <div></div>
            </div>
        </div>
        <div>
            <div></div>
        </div>
    `);

    const onTime        = div.children().eq(0).children().eq(1).children().eq(0);
    const offTime       = div.children().eq(1).children().eq(1).children().eq(0);
    const onOffEditBtn  = div.children().eq(2).children().eq(0)
    //체크박스 상자 옵션
    const timeBoxColumns = [
        {
            position     : onTime,
            column       : 'panl_on_time',
            updateColumn : 'on_time',
            box          : null,
        },
        {
            position     : offTime,
            column       : 'panl_off_time',
            updateColumn : 'off_time',
            box          : null,
        },
    ];

    timeBoxColumns.map((item)=>{
        item.box = item.position.dxDateBox({
            stylingMode         : 'outlined',
            displayFormat       : 'HH:mm',
            type                : 'time',
            showSpinButtons     : true,
            width               : 80,
            invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
        }).dxDateBox('instance');
    });

    let btn = creatBtn(onOffEditBtn, 'preferences', 'ON/OFF 시각설정', 'ON/OFF 시각설정', 'outlined', onOffEditBtnClick, null, false, true);
    let dataSource = {
        name      : '전광판 ON/OFF 시각 설정',
        div       : div,
        time      : timeBoxColumns,
        btn       : btn,
    }

    return dataSource;
};

function crlrBtnClick(){
    const selectedData =_listTable.getSelectedRowsData();
    if(selectedData.length <= 0 || selectedData[0].cmnc_stts_desc === '통신두절') {
        return alertWarning('VMS가 선택되지 않았습니다.<br>VMS 목록에서 VMS를 선택하십시오.<br>현재 통신이 비정상적인 VMS는 선택하실 수 없습니다.');
    }
    let dataSource = _tabs.option('dataSource');
    let text = "";
    let num  = "";
    let uri  = "";
    let val  = "";

    updateData = {
        user_id : _userId,
        value   : '',
    }

    //전광판/제어기 제어 체크 되어 있는 값세팅
    dataSource[0].check.map((item, idx)=>{
        if (getValue(item.box)) {
            text = item.alert;
            uri  = item.uri;
            num  = idx;
            val  = item.val;
        }
    });

    if(num === 3){
        val = getValue(dataSource[0].num);
        if (nullChecker(val) === "") {
            dataSource[0].num.focus();
            return alertWarning('휘도 제어 값을 입력해주세요', null, dataSource[0].num);
        }
    }

    updateData.value = val;

    confirmMessage("선택하신 VMS에 " + text + " 명령을 전송하시겠습니까?<br>(통신상태에 따라 명령이 실행되지 않을 수 있습니다.)").done((yes) => {
        if (yes === true) {
            let successCnt = 0;
            for(let data of selectedData){
                successCnt += postInsertUpdate(_apiUri + uri + encodeURIComponent(data.vms_ctlr_nmbr), updateData);
            }
            return alertConfirm(selectedData.length + ' 개의 선택 VMS 중에 ' + successCnt +' 개의 VMS로 전광판/제어기 제어 명령을 요청하였습니다.');
            //let listData = _listTable.option('dataSource');
        }
    });

};

function operChangeBtnClick(){
    const selectedData =_listTable.getSelectedRowsData();
    if(selectedData.length <= 0 || selectedData[0].cmnc_stts_desc === '통신두절') {
        return alertWarning('VMS가 선택되지 않았습니다.<br>VMS 목록에서 VMS를 선택하십시오.<br>현재 통신이 비정상적인 VMS는 선택하실 수 없습니다.');
    }
    let dataSource     = _tabs.option('dataSource');
    let uri            = '';
    let oper_mode_desc = "";
    updateData = {
        opr_mode: "",
        user_id: _userId,
    };

    dataSource[1].check.map((item)=>{
        if(getValue(item.box)){
            updateData.opr_mode = item.val;
            uri = item.uri;
            oper_mode_desc = item.oper_mode_desc;
        }
    });

    confirmMessage("선택하신 VMS의 운영모드를 변경 하시겠습니까?").done((yes) => {
        if (yes === true) {
            let successCnt = 0;
            for(let data of selectedData){
                let result = postInsertUpdate(_apiUri + uri + encodeURIComponent(data.vms_ctlr_nmbr), updateData);
                successCnt += result;
                if(result > 0) {
                    let listData = {..._listMap.get(data.vms_ctlr_nmbr)};
                    listData.oper_mode = updateData.opr_mode;
                    listData.oper_mode_desc = oper_mode_desc;
                    _listMap.set(data.vms_ctlr_nmbr, listData);
                }
            }

            _listTable.option('dataSource', Array.from(_listMap.values()));
            return alertConfirm(selectedData.length + ' 개의 선택 VMS 중에 ' + successCnt +' 개의 VMS 운영모드를 변경하였습니다.');
        }
    });
};

function cBoxEditBtnClick(){
    const selectedData =_listTable.getSelectedRowsData();
    if(selectedData.length <= 0 || selectedData[0].cmnc_stts_desc === '통신두절') {
        return alertWarning('VMS가 선택되지 않았습니다.<br>VMS 목록에서 VMS를 선택하십시오.<br>현재 통신이 비정상적인 VMS는 선택하실 수 없습니다.');
    }
    let dataSource = _tabs.option('dataSource');
    let uri = '/param/';
    let updateData = {
        fan_temp: 0,
        heater_temp: 0,
        module_fail: 0,
        module_temp: 0,
        retry_count: 0,
        sch_msg_time: 0,
        timeout: 0,
        user_id: _userId,
    }

    for(let numBox of dataSource[2].num){
        if(!getValue(numBox.box) && getValue(numBox.box) !== 0){
            numBox.box.focus();
            return alertWarning( numBox.text + ' 값을 입력해주세요');
        }
        updateData[numBox.updateColumn] = getValue(numBox.box);
    }

    confirmMessage("선택하신 VMS에 함체환경 설정 명령을 전송 하시겠습니까?<br>(통신상태에 따라 명령이 실행되지 않을 수 있습니다.)").done((yes) => {
        if (yes === true) {
            let successCnt = 0;
            for(let data of selectedData){
                let result = postInsertUpdate(_apiUri + uri + encodeURIComponent(data.vms_ctlr_nmbr), updateData);
                successCnt += result
                if(result > 0) {
                    let listData = {..._listMap.get(data.vms_ctlr_nmbr)};
                    listData.vms_cmnc_err_bass_val = updateData.module_temp;
                    listData.fan_mtns_tmpr = updateData.fan_temp;
                    listData.hetr_mtns_tmpr = updateData.heater_temp;
                    listData.vms_modl_err_rate = updateData.module_fail;
                    _listMap.set(data.vms_ctlr_nmbr, listData);
                }
            }
            _listTable.option('dataSource', Array.from(_listMap.values()));
            return alertConfirm(selectedData.length + ' 개의 선택 VMS 중에 ' + successCnt +' 개의 VMS 함체환경 설정 명령을 요청하였습니다.');
        }
    });

};

function onOffEditBtnClick(){
    const selectedData =_listTable.getSelectedRowsData();
    if(selectedData.length <= 0 || selectedData[0].cmnc_stts_desc === '통신두절') {
        return alertWarning('VMS가 선택되지 않았습니다.<br>VMS 목록에서 VMS를 선택하십시오.<br>현재 통신이 비정상적인 VMS는 선택하실 수 없습니다.');
    }
    let dataSource = _tabs.option('dataSource');
    let uri = '/on-off-time/';
    let updateData = {
        off_time: "",
        on_time: "",
        user_id: _userId,
    }

    for(let timeBox of dataSource[3].time){
        if (timeBox.box.option('validationError')){
            timeBox.box.focus();
            return alertWarning('전광판 On/Off 시각을 바르게 입력해주세요');
        }
        else if (!getValue(timeBox.box)){
            timeBox.box.focus();
            return alertWarning('전광판 On/Off 시각을 입력해주세요');
        }
        updateData[timeBox.updateColumn] = getSendTime(getValue(timeBox.box));
    }

    confirmMessage("선택하신 VMS의 전광판 ON/OFF 시각을 설정 하시겠습니까?").done((yes) => {
        if (yes === true) {
            let successCnt = 0;
            for(let data of selectedData) {
                let result = postInsertUpdate(_apiUri + uri + encodeURIComponent(data.vms_ctlr_nmbr), updateData);
                successCnt += result;
                if(result > 0) {
                    let listData = {..._listMap.get(data.vms_ctlr_nmbr)};
                    listData.panl_on_time = updateData.on_time;
                    listData.panl_off_time = updateData.off_time;
                    _listMap.set(data.vms_ctlr_nmbr, listData);
                };
            }
            _listTable.option('dataSource', Array.from(_listMap.values()));
            return alertConfirm(selectedData.length + ' 개의 선택 VMS 중에 ' + successCnt +' 개의 전광판 ON/OFF 시각 설정을 요청하였습니다.');
        }
    });

};

function wcamCtlrClick(){
    window.open('http://'+ _wcamIp);
};

function listTableDblClick(info){
    let selectedData = info.data;
    if ( _selectedId === null || _selectedId !== selectedData.vms_ctlr_nmbr) {
        _selectedId = selectedData.vms_ctlr_nmbr;
        let dataSource = _tabs.option('dataSource');
        dsblOffBtn(_wcamCtrlBtn)
        _wcamIp = selectedData.web_cmra_ip;


        if (!_selectedVideo) {
            _selectedVideo = videojs('video', {
                sources  : [
                    { src : selectedData.strm_http_addr, type : "application/x-mpegURL"}
                ],
                controls : true,
                playsinline : true,
                muted : true,
                preload : "none",
                controlBar: {
                    'liveDisplay': false,
                    'pictureInPictureToggle': false
                }
            });
        }

        _selectedVideo.src([
            {
                src: selectedData.strm_http_addr,
            }
        ]);
        _selectedVideo.play();

        setValue(dataSource[0].check[0].box, true);
        dataSource[1].check.map((item)=>{
            if(item.val === selectedData.oper_mode) setValue(item.box, true);
        })

        dataSource[2].num.map((item)=>{
            setValue(item.box, selectedData[item.column])
        });

        dataSource[3].time.map((item)=>{
            let timeVal = selectedData[item.column];
            let now = nowTime();
            timeVal =  now.substring(0,10) +' '+ timeVal.substring(0,2) + ':' + timeVal.substring(2,4)+ ':00';
            timeVal = new Date(timeVal).getTime();
            setValue(item.box, timeVal);
        });

        $('.title-text').text('[' + selectedData.vms_ctlr_id + '] - '+selectedData.vms_nm);
    }
}